/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.logger;

import java.io.File;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/stackhawk/hste/logger/LoggerUtils;", "", "()V", "REDACTED", "", "REDACTED_HEADER", "ctx", "Lorg/apache/logging/log4j/core/LoggerContext;", "getCtx", "()Lorg/apache/logging/log4j/core/LoggerContext;", "redactTokens", "Lkotlinx/atomicfu/AtomicRef;", "", "getRedactTokens", "()Lkotlinx/atomicfu/AtomicRef;", "enableVerboseLogging", "", "getHawkScanLogLevel", "Lorg/apache/logging/log4j/Level;", "redact", "text", "tokens", "redaction", "saveTokens", "file", "Ljava/io/File;", "setHawkScanLogLevel", "level", "talon-logger"})
@SourceDebugExtension(value={"SMAP\nLoggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggerUtils.kt\ncom/stackhawk/hste/logger/LoggerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1819#2,8:48\n*S KotlinDebug\n*F\n+ 1 LoggerUtils.kt\ncom/stackhawk/hste/logger/LoggerUtils\n*L\n38#1:48,8\n*E\n"})
public final class LoggerUtils {
    @NotNull
    public static final LoggerUtils INSTANCE = new LoggerUtils();
    @NotNull
    public static final String REDACTED = "[REDACTED]";
    @NotNull
    public static final String REDACTED_HEADER = "X-REDACTED: true";
    @NotNull
    private static final AtomicRef<List<String>> redactTokens = AtomicFU.atomic((Object)CollectionsKt.emptyList());
    @NotNull
    private static final LoggerContext ctx;

    private LoggerUtils() {
    }

    @NotNull
    public final AtomicRef<List<String>> getRedactTokens() {
        return redactTokens;
    }

    @NotNull
    public final LoggerContext getCtx() {
        return ctx;
    }

    public final void saveTokens(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            file.delete();
        }
        Iterable iterable = (Iterable)redactTokens.getValue();
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    public final void setHawkScanLogLevel(@NotNull String level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        String string = level.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        System.setProperty("hawkscan.loglevel", string);
        ctx.reconfigure();
    }

    public final void enableVerboseLogging() {
        System.setProperty("verbose.loglevel", this.getHawkScanLogLevel().name());
        ctx.reconfigure();
    }

    @NotNull
    public final Level getHawkScanLogLevel() {
        String string = System.getProperty("hawkscan.loglevel", "INFO");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        Level level = Level.getLevel((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        return level;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String redact(@NotNull String text, @NotNull List<String> tokens, @NotNull String redaction) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)redaction, (String)"redaction");
        List<String> $this$foldRight$iv = tokens;
        boolean $i$f$foldRight = false;
        String accumulator$iv = text;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator<String> iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                String string = accumulator$iv;
                String token = iterator$iv.previous();
                boolean bl = false;
                String string2 = acc.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                CharSequence charSequence = string2;
                String string3 = token.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                accumulator$iv = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null) ? StringsKt.replace$default((String)acc, (String)token, (String)redaction, (boolean)false, (int)4, null) : acc;
            }
        }
        return accumulator$iv;
    }

    public static /* synthetic */ String redact$default(LoggerUtils loggerUtils, String string, List list, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = REDACTED;
        }
        return loggerUtils.redact(string, list, string2);
    }

    static {
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        Intrinsics.checkNotNull((Object)loggerContext, (String)"null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
        ctx = (LoggerContext)loggerContext;
    }
}

