/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.cli;

import com.stackhawk.cli.CliKtInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0010J(\u0010\u0011\u001a\u00020\u0012*\u00060\u0013j\u0002`\u00142\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J0\u0010\u0017\u001a\u00020\u0018*\u00060\u0013j\u0002`\u00142\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J;\u0010\u001b\u001a\u00020\u0018*\u00020\u00062\n\u0010\u001c\u001a\u00060\u0013j\u0002`\u00142\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/stackhawk/cli/CliKtInternal;", "", "()V", "LINE_BREAK_REGEX", "Lkotlin/text/Regex;", "NEL", "", "PLAIN_P_END_REGEX", "PRE_P_CONTENTS_REGEX", "PRE_P_END_REGEX", "TEXT_START_REGEX", "WHITESPACE_OR_NEL_REGEX", "WORD_OR_NEL_REGEX", "splitParagraphs", "", "text", "splitParagraphs$talon_bootstrap", "tryPreformat", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "initialIndent", "subsequentIndent", "wrapParagraph", "", "width", "", "wrapText", "sb", "wrapText$talon_bootstrap", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nCliKtInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliKtInternal.kt\ncom/stackhawk/cli/CliKtInternal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class CliKtInternal {
    @NotNull
    public static final CliKtInternal INSTANCE = new CliKtInternal();
    @NotNull
    public static final String NEL = "\u0085";
    @NotNull
    private static final Regex TEXT_START_REGEX = new Regex("\\S");
    @NotNull
    private static final Regex PRE_P_END_REGEX = new Regex("```[ \\t]*(?:\\n\\s*|[ \\t]*$)");
    @NotNull
    private static final Regex PLAIN_P_END_REGEX = new Regex("[ \\t]*\\n(?:\\s*```|[ \\t]*\\n\\s*)|\u0085?\\s*$");
    @NotNull
    private static final Regex LINE_BREAK_REGEX = new Regex("\r?\n");
    @NotNull
    private static final Regex WHITESPACE_OR_NEL_REGEX = new Regex("\\s+|\u0085");
    @NotNull
    private static final Regex WORD_OR_NEL_REGEX = new Regex("[^\\s\u0085]+|\u0085");
    @NotNull
    private static final Regex PRE_P_CONTENTS_REGEX = new Regex("```([\\s\\S]*?)```");

    private CliKtInternal() {
    }

    public final void wrapText$talon_bootstrap(@NotNull String $this$wrapText, @NotNull StringBuilder sb, int width, @NotNull String initialIndent, @NotNull String subsequentIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$wrapText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter((Object)initialIndent, (String)"initialIndent");
        Intrinsics.checkNotNullParameter((Object)subsequentIndent, (String)"subsequentIndent");
        if (!(initialIndent.length() < width)) {
            boolean $i$a$-require-CliKtInternal$wrapText$32 = false;
            String $i$a$-require-CliKtInternal$wrapText$32 = "initialIndent >= width: " + initialIndent.length() + " >= " + width;
            throw new IllegalArgumentException($i$a$-require-CliKtInternal$wrapText$32.toString());
        }
        if (!(subsequentIndent.length() < width)) {
            boolean bl = false;
            String string = "subsequentIndent >= width: " + subsequentIndent.length() + " >= " + width;
            throw new IllegalArgumentException(string.toString());
        }
        Iterator<String> iterator = this.splitParagraphs$talon_bootstrap($this$wrapText).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String paragraph = iterator.next();
            if (i > 0) {
                sb.append("\n\n");
            }
            this.wrapParagraph(sb, paragraph, width, i == 0 ? initialIndent : subsequentIndent, subsequentIndent);
        }
    }

    public static /* synthetic */ void wrapText$talon_bootstrap$default(CliKtInternal cliKtInternal, String string, StringBuilder stringBuilder, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 78;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        cliKtInternal.wrapText$talon_bootstrap(string, stringBuilder, n, string2, string3);
    }

    @NotNull
    public final List<String> splitParagraphs$talon_bootstrap(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List paragraphs = new ArrayList();
        MatchResult matchResult = Regex.find$default((Regex)TEXT_START_REGEX, (CharSequence)text, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getRange()) == null) {
            return CollectionsKt.emptyList();
        }
        int i = matchResult.getFirst();
        while (i < text.length()) {
            IntRange intRange;
            IntRange intRange2;
            if (StringsKt.startsWith$default((String)text, (String)"```", (int)i, (boolean)false, (int)4, null)) {
                if (PRE_P_END_REGEX.find((CharSequence)text, i + 3) != null) {
                    boolean bl = false;
                    intRange2 = new IntRange(it.getRange().getFirst() + 3, it.getRange().getLast());
                } else {
                    intRange2 = null;
                }
            } else if (PLAIN_P_END_REGEX.find((CharSequence)text, i) != null) {
                boolean bl = false;
                intRange2 = StringsKt.startsWith$default((String)it.getValue(), (String)NEL, (boolean)false, (int)2, null) ? new IntRange(it.getRange().getFirst() + 1, it.getRange().getFirst() + 1) : (StringsKt.endsWith$default((String)it.getValue(), (String)"```", (boolean)false, (int)2, null) ? new IntRange(it.getRange().getFirst(), it.getRange().getLast() - 3) : it.getRange());
            } else {
                intRange2 = intRange = null;
            }
            if (intRange2 == null) {
                intRange = new IntRange(text.length(), text.length());
            }
            IntRange range = intRange;
            Collection collection = paragraphs;
            String string = text.substring(i, range.getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
            i = range.getLast() + 1;
        }
        return paragraphs;
    }

    private final boolean tryPreformat(StringBuilder $this$tryPreformat, String text, String initialIndent, String subsequentIndent) {
        MatchResult matchResult = PRE_P_CONTENTS_REGEX.matchEntire((CharSequence)text);
        String value = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
        String string = value;
        if (string == null || (string = StringsKt.replaceIndent((String)string, (String)subsequentIndent)) == null || (string = StringsKt.removePrefix((String)string, (CharSequence)subsequentIndent)) == null) {
            return false;
        }
        String pre = string;
        CharSequence charSequence = pre;
        Regex regex = LINE_BREAK_REGEX;
        int n = 0;
        Iterator iterator = regex.split(charSequence, n).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int i = n2++;
            String line = (String)iterator.next();
            if (i == 0) {
                $this$tryPreformat.append(initialIndent);
            } else {
                $this$tryPreformat.append("\n");
            }
            $this$tryPreformat.append(((Object)StringsKt.trimEnd((CharSequence)line)).toString());
        }
        return true;
    }

    private final void wrapParagraph(StringBuilder $this$wrapParagraph, String text, int width, String initialIndent, String subsequentIndent) {
        if (this.tryPreformat($this$wrapParagraph, text, initialIndent, subsequentIndent)) {
            return;
        }
        String breakLine = "\n" + subsequentIndent;
        if (initialIndent.length() + text.length() <= width) {
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)text)).toString();
            Regex regex = WHITESPACE_OR_NEL_REGEX;
            Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(breakLine){
                final /* synthetic */ String $breakLine;
                {
                    this.$breakLine = $breakLine;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull MatchResult it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getValue(), (Object)"\u0085") ? (CharSequence)this.$breakLine : (CharSequence)" ";
                }
            };
            String newText2 = regex.replace(charSequence, function1);
            $this$wrapParagraph.append(initialIndent).append(newText2);
            return;
        }
        List words2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)WORD_OR_NEL_REGEX, (CharSequence)text, (int)0, (int)2, null), (Function1)wrapParagraph.words.1.INSTANCE));
        $this$wrapParagraph.append(initialIndent);
        int currentWidth = initialIndent.length();
        boolean prevWasNel = false;
        Iterator iterator = words2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String word = (String)iterator.next();
            if (Intrinsics.areEqual((Object)word, (Object)NEL)) {
                $this$wrapParagraph.append(breakLine);
                currentWidth = subsequentIndent.length();
                prevWasNel = true;
                continue;
            }
            if (i > 0 && !prevWasNel) {
                if (currentWidth + word.length() + 1 > width) {
                    $this$wrapParagraph.append(breakLine);
                    currentWidth = subsequentIndent.length();
                } else {
                    $this$wrapParagraph.append(" ");
                    ++currentWidth;
                }
            }
            prevWasNel = false;
            $this$wrapParagraph.append(word);
            currentWidth += word.length();
        }
    }
}

