/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.daemon;

import com.stackhawk.cli.options.AdvancedScanOptions;
import com.stackhawk.daemon.Hallux;
import com.stackhawk.hste.CliConfig;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.nest.TalonMessages;
import com.stackhawk.perch.hallux.PerchGrpcClient;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stackhawk/daemon/HalluxRunner;", "Ljava/lang/Runnable;", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "cliConfig", "Lcom/stackhawk/hste/CliConfig;", "advancedScanOptions", "Lcom/stackhawk/cli/options/AdvancedScanOptions;", "(Lcom/stackhawk/hste/ConsolePrinter;Lcom/stackhawk/hste/CliConfig;Lcom/stackhawk/cli/options/AdvancedScanOptions;)V", "hallux", "Lcom/stackhawk/daemon/Hallux;", "running", "", "run", "", "shutdown", "talon-bootstrap"})
public final class HalluxRunner
implements Runnable {
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final CliConfig cliConfig;
    @NotNull
    private final AdvancedScanOptions advancedScanOptions;
    private boolean running;
    private Hallux hallux;

    public HalluxRunner(@NotNull ConsolePrinter consolePrinter, @NotNull CliConfig cliConfig, @NotNull AdvancedScanOptions advancedScanOptions) {
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter((Object)cliConfig, (String)"cliConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)advancedScanOptions), (String)"advancedScanOptions");
        this.consolePrinter = consolePrinter;
        this.cliConfig = cliConfig;
        this.advancedScanOptions = advancedScanOptions;
        this.running = true;
    }

    @Override
    public void run() {
        System.out.println((Object)"Daemon is starting");
        this.hallux = new Hallux();
        Hallux hallux = this.hallux;
        if (hallux == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hallux");
            hallux = null;
        }
        hallux.start(this.consolePrinter, this.cliConfig, this.advancedScanOptions);
        while (this.running) {
            System.out.println((Object)"Daemon is running...");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.out.println("Daemon thread interrupted.");
                this.running = false;
            }
        }
        System.out.println((Object)"Shutting down...");
        if (!Hallux.Companion.getCompleted().getValue()) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ HalluxRunner this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ HalluxRunner this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Hallux hallux = HalluxRunner.access$getHallux$p(this.this$0);
                                            if (hallux == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"hallux");
                                                hallux = null;
                                            }
                                            PerchGrpcClient perchGrpcClient = hallux.getClient();
                                            Hallux hallux2 = HalluxRunner.access$getHallux$p(this.this$0);
                                            if (hallux2 == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"hallux");
                                                hallux2 = null;
                                            }
                                            TalonMessages.TalonHawkScanConf talonHawkScanConf = hallux2.getTalonConfig();
                                            Hallux hallux3 = HalluxRunner.access$getHallux$p(this.this$0);
                                            if (hallux3 == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException((String)"hallux");
                                                hallux3 = null;
                                            }
                                            this.label = 1;
                                            Object object3 = Hallux.Companion.handleInterrupt(perchGrpcClient, talonHawkScanConf, hallux3.getCommandExecutor(), "Scan timed out", (Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        System.out.println((Object)"Sent hallux shutdown handler...");
    }

    public final void shutdown() {
        this.running = false;
    }

    public static final /* synthetic */ Hallux access$getHallux$p(HalluxRunner $this) {
        return $this.hallux;
    }
}

