/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.grpc;

import com.stackhawk.hste.ConsolePrinter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\nJ\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010'\u001a\u00020\u0006J\f\u0010'\u001a\u00020\u0016*\u00020(H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lcom/stackhawk/grpc/CommandWatchService;", "", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "block", "Lkotlin/Function0;", "", "(Lcom/stackhawk/hste/ConsolePrinter;Lkotlin/jvm/functions/Function0;)V", "fileNames", "", "", "getFileNames", "()Ljava/util/List;", "setFileNames", "(Ljava/util/List;)V", "isWatching", "", "()Z", "setWatching", "(Z)V", "watchKeys", "", "Ljava/nio/file/WatchKey;", "getWatchKeys", "()Ljava/util/Map;", "setWatchKeys", "(Ljava/util/Map;)V", "watchService", "Ljava/nio/file/WatchService;", "getWatchService", "()Ljava/nio/file/WatchService;", "setWatchService", "(Ljava/nio/file/WatchService;)V", "addFile", "fileName", "addPath", "directory", "removeWatches", "stopWatch", "watch", "Ljava/nio/file/Path;", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nCommandWatchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandWatchService.kt\ncom/stackhawk/grpc/CommandWatchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1863#2,2:106\n1863#2,2:108\n*S KotlinDebug\n*F\n+ 1 CommandWatchService.kt\ncom/stackhawk/grpc/CommandWatchService\n*L\n32#1:106,2\n69#1:108,2\n*E\n"})
public final class CommandWatchService {
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final Function0<Unit> block;
    @NotNull
    private Map<WatchKey, String> watchKeys;
    @NotNull
    private List<String> fileNames;
    private boolean isWatching;
    @NotNull
    private WatchService watchService;

    public CommandWatchService(@NotNull ConsolePrinter consolePrinter, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.consolePrinter = consolePrinter;
        this.block = block;
        this.watchKeys = new LinkedHashMap();
        this.fileNames = new ArrayList();
        WatchService watchService = FileSystems.getDefault().newWatchService();
        Intrinsics.checkNotNullExpressionValue((Object)watchService, (String)"newWatchService(...)");
        this.watchService = watchService;
    }

    @NotNull
    public final Map<WatchKey, String> getWatchKeys() {
        return this.watchKeys;
    }

    public final void setWatchKeys(@NotNull Map<WatchKey, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.watchKeys = map;
    }

    @NotNull
    public final List<String> getFileNames() {
        return this.fileNames;
    }

    public final void setFileNames(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.fileNames = list;
    }

    public final boolean isWatching() {
        return this.isWatching;
    }

    public final void setWatching(boolean bl) {
        this.isWatching = bl;
    }

    @NotNull
    public final WatchService getWatchService() {
        return this.watchService;
    }

    public final void setWatchService(@NotNull WatchService watchService) {
        Intrinsics.checkNotNullParameter((Object)watchService, (String)"<set-?>");
        this.watchService = watchService;
    }

    private final WatchKey watch(Path $this$watch) {
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_DELETE};
        WatchKey watchKey = $this$watch.register(this.watchService, kindArray);
        Intrinsics.checkNotNullExpressionValue((Object)watchKey, (String)"register(...)");
        return watchKey;
    }

    public final void removeWatches() {
        this.fileNames.clear();
        Iterable $this$forEach$iv = this.watchKeys.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchKey it = (WatchKey)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.watchKeys.clear();
    }

    public final void stopWatch() {
        this.isWatching = false;
    }

    public final void addPath(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Path path = Paths.get(directory, new String[0]);
        Intrinsics.checkNotNull((Object)path);
        WatchKey key = this.watch(path);
        if (!this.watchKeys.values().contains(directory)) {
            this.watchKeys.put(key, directory);
        }
    }

    public final void addFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.fileNames.contains(fileName)) {
            this.fileNames.add(fileName);
        }
    }

    public final void watch() {
        this.isWatching = true;
        this.consolePrinter.println("Press ctrl+c to exit");
        this.consolePrinter.println("watching files: " + CollectionsKt.joinToString$default((Iterable)this.fileNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        this.block.invoke();
        while (this.isWatching) {
            WatchKey key = this.watchService.take();
            String dir = this.watchKeys.get(key);
            if (dir == null) {
                System.err.println("WatchKey not recognized!!");
                continue;
            }
            List<WatchEvent<?>> list = key.pollEvents();
            Intrinsics.checkNotNullExpressionValue(list, (String)"pollEvents(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WatchEvent event = (WatchEvent)element$iv;
                boolean bl = false;
                String string = event.kind().name();
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 1312269314: {
                        if (string.equals("OVERFLOW")) {
                            n = 1;
                        }
                        break;
                    }
                    case 1279648137: {
                        if (string.equals("ENTRY_CREATE")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1563146567: {
                        if (string.equals("ENTRY_MODIFY")) {
                            n = 3;
                        }
                        break;
                    }
                    case 1296483896: {
                        if (string.equals("ENTRY_DELETE")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        this.consolePrinter.println(event.context() + " was created");
                        break;
                    }
                    case 3: {
                        if (!this.fileNames.contains(event.context().toString())) break;
                        this.consolePrinter.println(event.context() + " was modified");
                        this.block.invoke();
                        break;
                    }
                    case 1: {
                        this.consolePrinter.println(event.context() + " overflow");
                        break;
                    }
                    case 4: {
                        this.consolePrinter.println(event.context() + " was deleted");
                        this.fileNames.remove(event.context().toString());
                        if (!this.fileNames.isEmpty()) break;
                        key.cancel();
                        this.isWatching = false;
                    }
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.watchKeys.remove(key);
            if (!this.watchKeys.isEmpty()) continue;
            this.consolePrinter.println("Breaking");
            break;
        }
    }
}

