/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.grpc;

import com.stackhawk.hste.BootstrapUtils;
import com.stackhawk.hste.CliConfig;
import com.stackhawk.hste.CommandExecutor;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.HawkValuesSource;
import com.stackhawk.hste.HsteCommand;
import com.stackhawk.hste.config.HsteLoggingOptions;
import com.stackhawk.hste.config.HsteStarterOptions;
import com.stackhawk.nest.TalonMessages;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.software.os.OSProcess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\r\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/stackhawk/grpc/GrpcStarter;", "", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "commandExecutor", "Lcom/stackhawk/hste/CommandExecutor;", "cliConfig", "Lcom/stackhawk/hste/CliConfig;", "printConsole", "", "(Lcom/stackhawk/hste/ConsolePrinter;Lcom/stackhawk/hste/CommandExecutor;Lcom/stackhawk/hste/CliConfig;Z)V", "bounce", "Ljava/lang/Process;", "hsteLoggingOptions", "Lcom/stackhawk/hste/config/HsteLoggingOptions;", "config", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "getHawkPid", "", "()Ljava/lang/Integer;", "process", "Loshi/software/os/OSProcess;", "start", "status", "Loshi/software/os/OSProcess$State;", "stop", "", "pid", "", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nGrpcStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcStarter.kt\ncom/stackhawk/grpc/GrpcStarter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class GrpcStarter {
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final CommandExecutor commandExecutor;
    @NotNull
    private final CliConfig cliConfig;
    private final boolean printConsole;

    public GrpcStarter(@NotNull ConsolePrinter consolePrinter, @NotNull CommandExecutor commandExecutor, @NotNull CliConfig cliConfig, boolean printConsole) {
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)cliConfig, (String)"cliConfig");
        this.consolePrinter = consolePrinter;
        this.commandExecutor = commandExecutor;
        this.cliConfig = cliConfig;
        this.printConsole = printConsole;
    }

    @NotNull
    public final Process start(@NotNull HsteLoggingOptions hsteLoggingOptions) {
        Intrinsics.checkNotNullParameter((Object)hsteLoggingOptions, (String)"hsteLoggingOptions");
        String sessionDir = String.valueOf(HawkValuesSource.INSTANCE.getDaemonSession());
        if (new File(sessionDir).exists()) {
            FileUtils.deleteDirectory((File)new File(sessionDir));
        }
        Path path = Path.of(sessionDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        BootstrapUtils.createScanSessionDirectory$default(BootstrapUtils.INSTANCE, path, null, 0, 6, null);
        List list = CollectionsKt.emptyList();
        boolean bl = this.cliConfig.getHsteUI();
        boolean bl2 = this.cliConfig.getJvmDebugServer();
        String string = BootstrapUtils.INSTANCE.getInstallDir();
        Path path2 = Path.of(sessionDir, new String[0]);
        Intrinsics.checkNotNull((Object)path2);
        HsteCommand hsteCommand = this.commandExecutor.createHsteCommand(new HsteStarterOptions(hsteLoggingOptions, list, bl, bl2, path2, null, string, true, null, 288, null));
        if (hsteLoggingOptions.getVerbose()) {
            this.consolePrinter.progressPrintLn("HSTE cmd: " + ArraysKt.joinToString$default((Object[])hsteCommand.getCommandArgs(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
        String[] stringArray = hsteCommand.getCommandArgs();
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(Arrays.copyOf(stringArray, stringArray.length));
        pb.environment().putAll(new LinkedHashMap());
        Process proc = pb.start();
        long pid = proc.pid();
        HawkValuesSource.INSTANCE.storeDaemonProperty("pid", pid);
        HawkValuesSource.INSTANCE.storeDaemonProperty("debug", hsteLoggingOptions.getDebug());
        HawkValuesSource.INSTANCE.storeDaemonProperty("verbose", hsteLoggingOptions.getVerbose());
        HawkValuesSource.INSTANCE.storeDaemonProperty("trace", hsteLoggingOptions.getTrace());
        Intrinsics.checkNotNull((Object)proc);
        return proc;
    }

    @NotNull
    public final Process bounce(@NotNull HsteLoggingOptions hsteLoggingOptions, @Nullable TalonMessages.TalonHawkScanConf config2) {
        block6: {
            Unit unit;
            Object v1;
            List<Integer> hawkProcessMap;
            block5: {
                Intrinsics.checkNotNullParameter((Object)hsteLoggingOptions, (String)"hsteLoggingOptions");
                hawkProcessMap = BootstrapUtils.INSTANCE.getPids();
                Iterable iterable = hawkProcessMap;
                for (Object t : iterable) {
                    int it = ((Number)t).intValue();
                    boolean bl = false;
                    Integer n = this.getHawkPid();
                    if (!(n != null && it == n)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            Integer n = v1;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                this.stop(String.valueOf(it));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                GrpcStarter $this$bounce_u24lambda_u242 = this;
                boolean bl = false;
                if (hawkProcessMap.size() == 1) {
                    $this$bounce_u24lambda_u242.consolePrinter.progressPrintLn("Process Ids don't match");
                    $this$bounce_u24lambda_u242.stop(String.valueOf(((Number)CollectionsKt.first(hawkProcessMap)).intValue()));
                }
            }
            TalonMessages.TalonHawkScanConf talonHawkScanConf = config2;
            if (talonHawkScanConf == null) break block6;
            TalonMessages.TalonHawkScanConf it = talonHawkScanConf;
            boolean bl = false;
            TalonMessages.TalonHawkScanConf talonConfig = it.toBuilder().setCommand(TalonMessages.TalonHawkScanConf.TalonCommand.PERCH).build();
            Intrinsics.checkNotNull((Object)talonConfig);
            this.commandExecutor.setTalonConfig(talonConfig);
        }
        return this.start(hsteLoggingOptions);
    }

    public static /* synthetic */ Process bounce$default(GrpcStarter grpcStarter, HsteLoggingOptions hsteLoggingOptions, TalonMessages.TalonHawkScanConf talonHawkScanConf, int n, Object object) {
        if ((n & 1) != 0) {
            hsteLoggingOptions = HsteLoggingOptions.Companion.getDAEMON_SOURCED();
        }
        if ((n & 2) != 0) {
            talonHawkScanConf = null;
        }
        return grpcStarter.bounce(hsteLoggingOptions, talonHawkScanConf);
    }

    public final void stop(@NotNull String pid) {
        Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
        if (this.printConsole) {
            this.consolePrinter.println("Killing this process " + pid);
        }
        BootstrapUtils.INSTANCE.stopProcess(Integer.parseInt(pid));
        HawkValuesSource.INSTANCE.removeDaemonProperty("pid");
    }

    @Nullable
    public final OSProcess.State status() {
        OSProcess oSProcess;
        block3: {
            block2: {
                oSProcess = this.process();
                if (oSProcess == null) break block2;
                OSProcess it = oSProcess;
                boolean bl = false;
                this.consolePrinter.progressPrintLn("The Hawk Perch process " + it.getProcessID() + " is " + it.getState());
                this.consolePrinter.progressPrintLn("It has been up for " + it.getUpTime() + " millisecond");
                OSProcess.State state = it.getState();
                oSProcess = state;
                if (state != null) break block3;
            }
            GrpcStarter $this$status_u24lambda_u245 = this;
            boolean bl = false;
            $this$status_u24lambda_u245.consolePrinter.progressPrintLn("The Hawk Perch process is not running");
            $this$status_u24lambda_u245.consolePrinter.progressPrintLn("Run `hawk perch start` to start the process");
            oSProcess = null;
        }
        return oSProcess;
    }

    @Nullable
    public final OSProcess process() {
        OSProcess oSProcess;
        Integer n = this.getHawkPid();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            oSProcess = BootstrapUtils.INSTANCE.daemonProcess(it);
        } else {
            oSProcess = null;
        }
        return oSProcess;
    }

    @Nullable
    public final Integer getHawkPid() {
        String string = HawkValuesSource.INSTANCE.daemonPropValues().get("pid");
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }
}

