/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.util.JsonFormat;
import com.stackhawk.cli.options.AdvancedScanOptions;
import com.stackhawk.cli.options.AdvancedScanOptionsDefault;
import com.stackhawk.cli.options.AdvancedScanOptionsKt;
import com.stackhawk.cli.options.BasicScanOptions;
import com.stackhawk.cli.options.ProxyConfigOptions;
import com.stackhawk.hawk.BrowserUtils;
import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.Bootstrap;
import com.stackhawk.hste.BootstrapKt;
import com.stackhawk.hste.BootstrapUtils;
import com.stackhawk.hste.BootstrapUtilsKt;
import com.stackhawk.hste.CliConfig;
import com.stackhawk.hste.CommandExecutor;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.ErrorUtils;
import com.stackhawk.hste.HawkValuesSource;
import com.stackhawk.hste.MainKt;
import com.stackhawk.hste.ShutdownHandler;
import com.stackhawk.hste.TerminalUtils;
import com.stackhawk.hste.extension.talon.HawkConfExtensions;
import com.stackhawk.hste.extension.talon.HawkConfExtensionsKt;
import com.stackhawk.hste.extension.talon.ScanPolicyResolverOptions;
import com.stackhawk.hste.extension.talon.TalonHawkScanConfExtensions;
import com.stackhawk.hste.extension.talon.client.AssetManagerClient;
import com.stackhawk.hste.extension.talon.client.BasicHttpClient;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.config.Config;
import com.stackhawk.hste.extension.talon.config.ConfigUtils;
import com.stackhawk.hste.extension.talon.hawkscan.HostedOASDownloader;
import com.stackhawk.hste.extension.talon.hawkscan.TalonScanResponseServer;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InstalledEnvironmentException;
import com.stackhawk.hste.extension.talon.hawkscan.api.OverThresholdException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScannerConfigException;
import com.stackhawk.hste.extension.talon.hawkscan.api.UnexpectedError;
import com.stackhawk.hste.handlers.ScanResponseOutputHandler;
import com.stackhawk.hste.logger.LoggerUtils;
import com.stackhawk.nest.ApplicationService;
import com.stackhawk.nest.Auth;
import com.stackhawk.nest.HawkScanMessages;
import com.stackhawk.nest.ScanPolicyMessages;
import com.stackhawk.nest.ScanResultMessages;
import com.stackhawk.nest.TalonMessages;
import com.stackhawk.nest.UserMessages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\f\b&\u0018\u0000 \u0095\u00012\u00020\u0001:\u0002\u0095\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ4\u0010p\u001a\b\u0012\u0004\u0012\u00020!082\n\b\u0002\u0010q\u001a\u0004\u0018\u00010!2\n\b\u0002\u0010r\u001a\u0004\u0018\u00010!2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020!08H\u0002J\u001e\u0010t\u001a\u00020u2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020w082\u0006\u0010x\u001a\u00020wH\u0002J\u0014\u0010y\u001a\u00020u2\n\b\u0002\u0010J\u001a\u0004\u0018\u00010KH&J\b\u0010z\u001a\u00020uH&JN\u0010{\u001a\u00020u2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020!082\u0006\u0010}\u001a\u00020~2\u0006\u0010^\u001a\u00020_2\b\u0010\u007f\u001a\u0004\u0018\u00010!2\u000b\b\u0002\u0010\u0080\u0001\u001a\u0004\u0018\u00010E2\u000b\b\u0002\u0010\u0081\u0001\u001a\u0004\u0018\u00010!\u00a2\u0006\u0003\u0010\u0082\u0001J\"\u0010\u0083\u0001\u001a\u00020u2\u0007\u0010\u0084\u0001\u001a\u00020~2\u0007\u0010\u0085\u0001\u001a\u00020~2\u0007\u0010\u0086\u0001\u001a\u00020~J$\u0010\u0087\u0001\u001a\u000b \u0088\u0001*\u0004\u0018\u00010~0~2\u0006\u0010}\u001a\u00020~2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0002J'\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020!082\r\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020!082\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010_J\t\u0010\u008e\u0001\u001a\u00020uH\u0002J\u000b\u0010\u008f\u0001\u001a\u0004\u0018\u00010!H\u0002J\u0016\u0010\u0090\u0001\u001a\u00020u2\r\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020!08J\t\u0010\u0091\u0001\u001a\u00020uH\u0002J(\u0010\u0092\u0001\u001a\u00020u2\u0006\u0010(\u001a\u00020)2\u0006\u0010d\u001a\u00020e2\u0006\u0010}\u001a\u00020~2\u0007\u0010\u008d\u0001\u001a\u00020_J\u001b\u0010\u0093\u0001\u001a\u00020~2\u0006\u0010}\u001a\u00020~2\b\u0010\u0094\u0001\u001a\u00030\u008a\u0001H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001d\"\u0004\b0\u0010\u001fR\u001a\u00101\u001a\u000202X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010#\"\u0004\b<\u0010%R\u001c\u0010=\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010#\"\u0004\b?\u0010%R\"\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010A0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0011\"\u0004\bC\u0010\u0013R\u001a\u0010D\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001c\u0010J\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001c\u0010P\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010#\"\u0004\bR\u0010%R\u001a\u0010S\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010#\"\u0004\bU\u0010%R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u0014\u0010X\u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010#R\"\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010[0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u0011\"\u0004\b]\u0010\u0013R\u001a\u0010^\u001a\u00020_X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001a\u0010d\u001a\u00020eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u001a\u0010j\u001a\u00020kX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010o\u00a8\u0006\u0096\u0001"}, d2={"Lcom/stackhawk/hste/BaseScanCommand;", "", "cliConfig", "Lcom/stackhawk/hste/CliConfig;", "advancedOptions", "Lcom/stackhawk/cli/options/AdvancedScanOptions;", "basicOptions", "Lcom/stackhawk/cli/options/BasicScanOptions;", "proxyConfigOptions", "Lcom/stackhawk/cli/options/ProxyConfigOptions;", "(Lcom/stackhawk/hste/CliConfig;Lcom/stackhawk/cli/options/AdvancedScanOptions;Lcom/stackhawk/cli/options/BasicScanOptions;Lcom/stackhawk/cli/options/ProxyConfigOptions;)V", "getAdvancedOptions", "()Lcom/stackhawk/cli/options/AdvancedScanOptions;", "applicationRef", "Lkotlinx/atomicfu/AtomicRef;", "Lcom/stackhawk/nest/ApplicationService$Application;", "getApplicationRef", "()Lkotlinx/atomicfu/AtomicRef;", "setApplicationRef", "(Lkotlinx/atomicfu/AtomicRef;)V", "getBasicOptions", "()Lcom/stackhawk/cli/options/BasicScanOptions;", "beforeScanRef", "Lcom/stackhawk/nest/ScanResultMessages$BeforeScan;", "getBeforeScanRef", "setBeforeScanRef", "beforeScanStartedRef", "Lkotlinx/atomicfu/AtomicBoolean;", "getBeforeScanStartedRef", "()Lkotlinx/atomicfu/AtomicBoolean;", "setBeforeScanStartedRef", "(Lkotlinx/atomicfu/AtomicBoolean;)V", "cicdPlatform", "", "getCicdPlatform", "()Ljava/lang/String;", "setCicdPlatform", "(Ljava/lang/String;)V", "getCliConfig", "()Lcom/stackhawk/hste/CliConfig;", "commandExecutor", "Lcom/stackhawk/hste/CommandExecutor;", "getCommandExecutor", "()Lcom/stackhawk/hste/CommandExecutor;", "setCommandExecutor", "(Lcom/stackhawk/hste/CommandExecutor;)V", "completed", "getCompleted", "setCompleted", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "getConsolePrinter", "()Lcom/stackhawk/hste/ConsolePrinter;", "setConsolePrinter", "(Lcom/stackhawk/hste/ConsolePrinter;)V", "displayBrowsers", "", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf$Spider$AjaxBrowser;", "gitRev", "getGitRev", "setGitRev", "gitUrl", "getGitUrl", "setGitUrl", "hsteProcessRef", "Ljava/lang/Process;", "getHsteProcessRef", "setHsteProcessRef", "newKey", "", "getNewKey", "()Z", "setNewKey", "(Z)V", "organization", "Lcom/stackhawk/nest/UserMessages$UserOrganization;", "getOrganization", "()Lcom/stackhawk/nest/UserMessages$UserOrganization;", "setOrganization", "(Lcom/stackhawk/nest/UserMessages$UserOrganization;)V", "parentScanId", "getParentScanId", "setParentScanId", "projectRepoDir", "getProjectRepoDir", "setProjectRepoDir", "getProxyConfigOptions", "()Lcom/stackhawk/cli/options/ProxyConfigOptions;", "scanLogFilename", "getScanLogFilename", "scanResponseOutputHandlerRef", "Lcom/stackhawk/hste/handlers/ScanResponseOutputHandler;", "getScanResponseOutputHandlerRef", "setScanResponseOutputHandlerRef", "stackhawkApiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "getStackhawkApiClient", "()Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "setStackhawkApiClient", "(Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;)V", "talonConfig", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "getTalonConfig", "()Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "setTalonConfig", "(Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;)V", "terminalUtils", "Lcom/stackhawk/hste/TerminalUtils;", "getTerminalUtils", "()Lcom/stackhawk/hste/TerminalUtils;", "setTerminalUtils", "(Lcom/stackhawk/hste/TerminalUtils;)V", "buildSslJvmOptions", "trustStorePath", "trustStoreType", "hawkJvmOpts", "concatenateFiles", "", "filesToConcat", "Ljava/io/File;", "outputFile", "customValidation", "customizeConfiguration", "downloadHostedOASFiles", "hostedOASIds", "sessionDir", "Ljava/nio/file/Path;", "orgId", "usePlatform", "appId", "(Ljava/util/List;Ljava/nio/file/Path;Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)V", "mergeLogFiles", "hawkLog", "scanLog", "uploadLog", "nextRolledLogFile", "kotlin.jvm.PlatformType", "nextFileNumber", "", "parseConfigFiles", "confFiles", "stackHawkApiClient", "promptForAPIKey", "promptForBrowser", "scan", "setUpAjaxBrowser", "uploadHawkScanLog", "writeRolledHawkScanLogFile", "logRollCount", "Companion", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nBaseScanCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseScanCommand.kt\ncom/stackhawk/hste/BaseScanCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AtomicFU.common.kt\nkotlinx/atomicfu/AtomicFU_commonKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,793:1\n1#2:794\n112#3,4:795\n1557#4:799\n1628#4,3:800\n1863#4,2:803\n*S KotlinDebug\n*F\n+ 1 BaseScanCommand.kt\ncom/stackhawk/hste/BaseScanCommand\n*L\n260#1:795,4\n540#1:799\n540#1:800,3\n579#1:803,2\n*E\n"})
public abstract class BaseScanCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CliConfig cliConfig;
    @NotNull
    private final AdvancedScanOptions advancedOptions;
    @NotNull
    private final BasicScanOptions basicOptions;
    @NotNull
    private final ProxyConfigOptions proxyConfigOptions;
    @NotNull
    private final List<HawkScanMessages.HawkConf.Spider.AjaxBrowser> displayBrowsers;
    @Nullable
    private String cicdPlatform;
    @Nullable
    private String gitUrl;
    @Nullable
    private String gitRev;
    @NotNull
    private String projectRepoDir;
    @Nullable
    private String parentScanId;
    private boolean newKey;
    @Nullable
    private UserMessages.UserOrganization organization;
    @NotNull
    private final String scanLogFilename;
    public AtomicBoolean completed;
    public AtomicRef<ApplicationService.Application> applicationRef;
    public AtomicRef<ScanResultMessages.BeforeScan> beforeScanRef;
    public AtomicBoolean beforeScanStartedRef;
    public AtomicRef<ScanResponseOutputHandler> scanResponseOutputHandlerRef;
    public AtomicRef<Process> hsteProcessRef;
    public TalonMessages.TalonHawkScanConf talonConfig;
    public ConsolePrinter consolePrinter;
    public StackHawkApiClient stackhawkApiClient;
    public CommandExecutor commandExecutor;
    public TerminalUtils terminalUtils;
    @NotNull
    private static final Logger LOG;

    public BaseScanCommand(@NotNull CliConfig cliConfig, @NotNull AdvancedScanOptions advancedOptions, @NotNull BasicScanOptions basicOptions, @NotNull ProxyConfigOptions proxyConfigOptions) {
        Intrinsics.checkNotNullParameter((Object)cliConfig, (String)"cliConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)advancedOptions), (String)"advancedOptions");
        Intrinsics.checkNotNullParameter((Object)((Object)basicOptions), (String)"basicOptions");
        Intrinsics.checkNotNullParameter((Object)((Object)proxyConfigOptions), (String)"proxyConfigOptions");
        this.cliConfig = cliConfig;
        this.advancedOptions = advancedOptions;
        this.basicOptions = basicOptions;
        this.proxyConfigOptions = proxyConfigOptions;
        Object[] objectArray = new HawkScanMessages.HawkConf.Spider.AjaxBrowser[]{HawkScanMessages.HawkConf.Spider.AjaxBrowser.FIREFOX, HawkScanMessages.HawkConf.Spider.AjaxBrowser.CHROME};
        this.displayBrowsers = CollectionsKt.listOf((Object[])objectArray);
        this.projectRepoDir = "";
        this.scanLogFilename = "scan.log";
    }

    @NotNull
    public final CliConfig getCliConfig() {
        return this.cliConfig;
    }

    @NotNull
    public final AdvancedScanOptions getAdvancedOptions() {
        return this.advancedOptions;
    }

    @NotNull
    public final BasicScanOptions getBasicOptions() {
        return this.basicOptions;
    }

    @NotNull
    public final ProxyConfigOptions getProxyConfigOptions() {
        return this.proxyConfigOptions;
    }

    @Nullable
    public final String getCicdPlatform() {
        return this.cicdPlatform;
    }

    public final void setCicdPlatform(@Nullable String string) {
        this.cicdPlatform = string;
    }

    @Nullable
    public final String getGitUrl() {
        return this.gitUrl;
    }

    public final void setGitUrl(@Nullable String string) {
        this.gitUrl = string;
    }

    @Nullable
    public final String getGitRev() {
        return this.gitRev;
    }

    public final void setGitRev(@Nullable String string) {
        this.gitRev = string;
    }

    @NotNull
    public final String getProjectRepoDir() {
        return this.projectRepoDir;
    }

    public final void setProjectRepoDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.projectRepoDir = string;
    }

    @Nullable
    public final String getParentScanId() {
        return this.parentScanId;
    }

    public final void setParentScanId(@Nullable String string) {
        this.parentScanId = string;
    }

    public final boolean getNewKey() {
        return this.newKey;
    }

    public final void setNewKey(boolean bl) {
        this.newKey = bl;
    }

    @Nullable
    public final UserMessages.UserOrganization getOrganization() {
        return this.organization;
    }

    public final void setOrganization(@Nullable UserMessages.UserOrganization userOrganization) {
        this.organization = userOrganization;
    }

    @NotNull
    public final String getScanLogFilename() {
        return this.scanLogFilename;
    }

    @NotNull
    public final AtomicBoolean getCompleted() {
        AtomicBoolean atomicBoolean = this.completed;
        if (atomicBoolean != null) {
            return atomicBoolean;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"completed");
        return null;
    }

    public final void setCompleted(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.completed = atomicBoolean;
    }

    @NotNull
    public final AtomicRef<ApplicationService.Application> getApplicationRef() {
        AtomicRef<ApplicationService.Application> atomicRef = this.applicationRef;
        if (atomicRef != null) {
            return atomicRef;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"applicationRef");
        return null;
    }

    public final void setApplicationRef(@NotNull AtomicRef<ApplicationService.Application> atomicRef) {
        Intrinsics.checkNotNullParameter(atomicRef, (String)"<set-?>");
        this.applicationRef = atomicRef;
    }

    @NotNull
    public final AtomicRef<ScanResultMessages.BeforeScan> getBeforeScanRef() {
        AtomicRef<ScanResultMessages.BeforeScan> atomicRef = this.beforeScanRef;
        if (atomicRef != null) {
            return atomicRef;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"beforeScanRef");
        return null;
    }

    public final void setBeforeScanRef(@NotNull AtomicRef<ScanResultMessages.BeforeScan> atomicRef) {
        Intrinsics.checkNotNullParameter(atomicRef, (String)"<set-?>");
        this.beforeScanRef = atomicRef;
    }

    @NotNull
    public final AtomicBoolean getBeforeScanStartedRef() {
        AtomicBoolean atomicBoolean = this.beforeScanStartedRef;
        if (atomicBoolean != null) {
            return atomicBoolean;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"beforeScanStartedRef");
        return null;
    }

    public final void setBeforeScanStartedRef(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        this.beforeScanStartedRef = atomicBoolean;
    }

    @NotNull
    public final AtomicRef<ScanResponseOutputHandler> getScanResponseOutputHandlerRef() {
        AtomicRef<ScanResponseOutputHandler> atomicRef = this.scanResponseOutputHandlerRef;
        if (atomicRef != null) {
            return atomicRef;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scanResponseOutputHandlerRef");
        return null;
    }

    public final void setScanResponseOutputHandlerRef(@NotNull AtomicRef<ScanResponseOutputHandler> atomicRef) {
        Intrinsics.checkNotNullParameter(atomicRef, (String)"<set-?>");
        this.scanResponseOutputHandlerRef = atomicRef;
    }

    @NotNull
    public final AtomicRef<Process> getHsteProcessRef() {
        AtomicRef<Process> atomicRef = this.hsteProcessRef;
        if (atomicRef != null) {
            return atomicRef;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"hsteProcessRef");
        return null;
    }

    public final void setHsteProcessRef(@NotNull AtomicRef<Process> atomicRef) {
        Intrinsics.checkNotNullParameter(atomicRef, (String)"<set-?>");
        this.hsteProcessRef = atomicRef;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf getTalonConfig() {
        TalonMessages.TalonHawkScanConf talonHawkScanConf = this.talonConfig;
        if (talonHawkScanConf != null) {
            return talonHawkScanConf;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"talonConfig");
        return null;
    }

    public final void setTalonConfig(@NotNull TalonMessages.TalonHawkScanConf talonHawkScanConf) {
        Intrinsics.checkNotNullParameter((Object)talonHawkScanConf, (String)"<set-?>");
        this.talonConfig = talonHawkScanConf;
    }

    @NotNull
    public final ConsolePrinter getConsolePrinter() {
        ConsolePrinter consolePrinter = this.consolePrinter;
        if (consolePrinter != null) {
            return consolePrinter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"consolePrinter");
        return null;
    }

    public final void setConsolePrinter(@NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"<set-?>");
        this.consolePrinter = consolePrinter;
    }

    @NotNull
    public final StackHawkApiClient getStackhawkApiClient() {
        StackHawkApiClient stackHawkApiClient = this.stackhawkApiClient;
        if (stackHawkApiClient != null) {
            return stackHawkApiClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stackhawkApiClient");
        return null;
    }

    public final void setStackhawkApiClient(@NotNull StackHawkApiClient stackHawkApiClient) {
        Intrinsics.checkNotNullParameter((Object)stackHawkApiClient, (String)"<set-?>");
        this.stackhawkApiClient = stackHawkApiClient;
    }

    @NotNull
    public final CommandExecutor getCommandExecutor() {
        CommandExecutor commandExecutor = this.commandExecutor;
        if (commandExecutor != null) {
            return commandExecutor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandExecutor");
        return null;
    }

    public final void setCommandExecutor(@NotNull CommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"<set-?>");
        this.commandExecutor = commandExecutor;
    }

    @NotNull
    public final TerminalUtils getTerminalUtils() {
        TerminalUtils terminalUtils = this.terminalUtils;
        if (terminalUtils != null) {
            return terminalUtils;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"terminalUtils");
        return null;
    }

    public final void setTerminalUtils(@NotNull TerminalUtils terminalUtils) {
        Intrinsics.checkNotNullParameter((Object)terminalUtils, (String)"<set-?>");
        this.terminalUtils = terminalUtils;
    }

    /*
     * WARNING - void declaration
     */
    public final void scan(@NotNull List<String> confFiles) {
        Pair<String, String> pair;
        String string;
        block49: {
            block48: {
                void it;
                Intrinsics.checkNotNullParameter(confFiles, (String)"confFiles");
                if (this.advancedOptions.getDebug()) {
                    LoggerUtils.INSTANCE.setHawkScanLogLevel("DEBUG");
                    LOG.debug("Debug mode enabled");
                }
                if (this.advancedOptions.getVerbose()) {
                    LoggerUtils.INSTANCE.enableVerboseLogging();
                }
                this.cicdPlatform = this.advancedOptions.getCicdPlatform();
                this.gitUrl = this.advancedOptions instanceof AdvancedScanOptionsDefault ? ((AdvancedScanOptionsDefault)this.advancedOptions).getGitUrl() : null;
                this.gitRev = this.advancedOptions instanceof AdvancedScanOptionsDefault ? ((AdvancedScanOptionsDefault)this.advancedOptions).getGitRev() : null;
                TalonMessages.TalonHawkScanConf talonHawkScanConf = BootstrapKt.setAdvancedOptions(TalonHawkScanConfExtensions.INSTANCE.generateScanId(this.cliConfig.getTalonConfig()), this.advancedOptions);
                HawkScanMessages.Proxy proxy = HawkScanMessages.Proxy.getDefaultInstance();
                Intrinsics.checkNotNullExpressionValue((Object)proxy, (String)"getDefaultInstance(...)");
                HawkScanMessages.Proxy proxy2 = BootstrapUtilsKt.fromConfigOptions(proxy, this.proxyConfigOptions);
                Intrinsics.checkNotNullExpressionValue((Object)proxy2, (String)"fromConfigOptions(...)");
                TalonMessages.TalonHawkScanConf talonHawkScanConf2 = TalonHawkScanConfExtensions.INSTANCE.setOutBoundProxy(talonHawkScanConf, proxy2).toBuilder().setCommand(TalonMessages.TalonHawkScanConf.TalonCommand.SCAN).build();
                Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf2, (String)"build(...)");
                this.setTalonConfig(talonHawkScanConf2);
                this.setCompleted(AtomicFU.atomic((boolean)false));
                this.setApplicationRef((AtomicRef<ApplicationService.Application>)AtomicFU.atomic(null));
                this.setBeforeScanRef((AtomicRef<ScanResultMessages.BeforeScan>)AtomicFU.atomic(null));
                this.setBeforeScanStartedRef(AtomicFU.atomic((boolean)false));
                this.setScanResponseOutputHandlerRef((AtomicRef<ScanResponseOutputHandler>)AtomicFU.atomic(null));
                this.setHsteProcessRef((AtomicRef<Process>)AtomicFU.atomic(null));
                boolean bl = !this.cliConfig.getNoColor();
                boolean bl2 = !this.advancedOptions.getNoProgress() && !this.advancedOptions.getVerbose();
                boolean bl3 = this.advancedOptions.getDebug();
                boolean bl4 = this.advancedOptions.getVerbose();
                this.setConsolePrinter(new ConsolePrinter(null, bl, bl3, bl4, bl2, null, 33, null));
                this.setTerminalUtils(new TerminalUtils(Bootstrap.INSTANCE.getAsyncScope(), this.getConsolePrinter(), 0L, 4, null));
                BaseScanCommand baseScanCommand = this;
                string = this.gitUrl;
                if (string == null) break block48;
                String string2 = string;
                BaseScanCommand baseScanCommand2 = baseScanCommand;
                boolean bl5 = false;
                String string3 = BootstrapUtils.INSTANCE.checkoutGitRepo((String)it, this.gitRev, this.getConsolePrinter());
                baseScanCommand = baseScanCommand2;
                string = string3;
                if (string3 != null) break block49;
            }
            string = this.basicOptions.getRepoDir();
        }
        baseScanCommand.projectRepoDir = string;
        this.promptForAPIKey();
        String string4 = this.advancedOptions.getApplicationId();
        boolean isHostedConfig = BootstrapUtilsKt.isHostedConfig(confFiles, string4 != null ? Boolean.valueOf(!StringsKt.isBlank((CharSequence)string4)) : null);
        Ref.ObjectRef configFiles = new Ref.ObjectRef();
        if (!isHostedConfig) {
            LOG.debug("No hosted config files found. Parsing local configuration files.");
            configFiles.element = this.parseConfigFiles(confFiles, null);
        }
        if (this.proxyConfigOptions.getSslTrustStore() != null) {
            String string5 = this.proxyConfigOptions.getSslTrustStore();
            Intrinsics.checkNotNull((Object)string5);
            String explicitPath = string5;
            if (!new File(explicitPath).exists()) {
                throw new ScannerConfigException("Specified SSL truststore does not exist: " + explicitPath, null, null, 6, null);
            }
            LOG.debug("Using custom truststore from SSL_TRUST_STORE configuration: " + explicitPath);
            pair = new Pair((Object)explicitPath, (Object)this.proxyConfigOptions.getSslTrustStoreType());
        } else if (Intrinsics.areEqual((Object)this.proxyConfigOptions.getUseNativeTruststore(), (Object)false)) {
            LOG.debug("Native truststore disabled, using Java default truststore");
            pair = new Pair<String, String>(null, null);
        } else {
            Pair<String, String> nativeSettings = BootstrapUtils.INSTANCE.getOSNativeTruststoreSettings(this.proxyConfigOptions.getUseNativeTruststore());
            if (nativeSettings.getFirst() != null || nativeSettings.getSecond() != null) {
                String string6;
                String string7;
                if (BootstrapUtils.INSTANCE.isMacOS() && Intrinsics.areEqual((Object)nativeSettings.getSecond(), (Object)"KeychainStore")) {
                    LOG.warn("Using macOS KeychainStore on JDK < 23 will not include root certificates. Root certificate support requires JDK 23+ (see JDK-8321045). Falling back to Java default truststore is recommended.");
                }
                if ((string7 = (String)nativeSettings.getSecond()) == null) {
                    string7 = "default";
                }
                if ((string6 = (String)nativeSettings.getFirst()) == null) {
                    string6 = "(system default)";
                }
                LOG.debug("Using native truststore: type=" + string7 + ", path=" + string6);
            } else {
                LOG.debug("No native truststore available (Docker or unsupported OS), using Java default");
            }
            pair = nativeSettings;
        }
        Pair<String, String> pair2 = pair;
        String trustStorePath = (String)pair2.component1();
        String trustStoreType = (String)pair2.component2();
        this.setStackhawkApiClient(Bootstrap.INSTANCE.apiClient(this.getTalonConfig(), this.proxyConfigOptions, trustStorePath, trustStoreType));
        TalonMessages.TalonHawkScanConf talonHawkScanConf = this.getTalonConfig();
        ConsolePrinter consolePrinter = this.getConsolePrinter();
        StackHawkApiClient stackHawkApiClient = this.getStackhawkApiClient();
        BasicHttpClient basicHttpClient = new BasicHttpClient(this.getStackhawkApiClient().getHttpClient());
        this.setCommandExecutor(new CommandExecutor(talonHawkScanConf, basicHttpClient, null, consolePrinter, stackHawkApiClient, 4, null));
        Runtime.getRuntime().addShutdownHook(new ShutdownHandler(this.getCompleted(), this.getConsolePrinter(), this.getHsteProcessRef(), this.getScanResponseOutputHandlerRef(), this.getBeforeScanStartedRef(), this.getBeforeScanRef(), ErrorUtils.INSTANCE, this.getTalonConfig(), this.getCommandExecutor(), this.getApplicationRef()));
        try {
            this.getTerminalUtils().withTerminalProgress("Authenticating to platform", (Function0)new Function0<Unit>(this, isHostedConfig, (Ref.ObjectRef<List<String>>)configFiles, confFiles){
                final /* synthetic */ BaseScanCommand this$0;
                final /* synthetic */ boolean $isHostedConfig;
                final /* synthetic */ Ref.ObjectRef<List<String>> $configFiles;
                final /* synthetic */ List<String> $confFiles;
                {
                    this.this$0 = $receiver;
                    this.$isHostedConfig = $isHostedConfig;
                    this.$configFiles = $configFiles;
                    this.$confFiles = $confFiles;
                    super(0);
                }

                public final void invoke() {
                    if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.this$0.getTalonConfig()) && this.$isHostedConfig) {
                        BaseScanCommand.Companion.getLOG().debug("Authenticating before parsing configuration files.");
                        Auth.JWT jwt = CommandExecutor.authenticate$default(this.this$0.getCommandExecutor(), this.this$0.getNewKey(), false, 2, null);
                        this.this$0.getStackhawkApiClient().start(jwt);
                        this.$configFiles.element = this.this$0.parseConfigFiles(this.$confFiles, this.this$0.getStackhawkApiClient());
                        this.this$0.getCommandExecutor().setTalonConfig(this.this$0.getTalonConfig());
                    }
                }
            });
            String string8 = this.getTalonConfig().getSessionHomeDir();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getSessionHomeDir(...)");
            BootstrapUtils.INSTANCE.cleanupSessionDirectories(string8, this.getTalonConfig().getNumSessionsStored() - 1);
            Path sessionDir = TalonHawkScanConfExtensions.INSTANCE.scanSessionDirectory(this.getTalonConfig());
            String string9 = this.getTalonConfig().getLogRollSize();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getLogRollSize(...)");
            BootstrapUtils.INSTANCE.createScanSessionDirectory(sessionDir, string9, this.getTalonConfig().getLogRollCount());
            this.getCommandExecutor().setTalonConfig(this.getTalonConfig());
            if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.getTalonConfig()) && !isHostedConfig) {
                LOG.debug("Authenticating after parsing configuration files.");
                Auth.JWT jwt = CommandExecutor.authenticate$default(this.getCommandExecutor(), this.newKey, false, 2, null);
                this.getStackhawkApiClient().start(jwt);
            }
            HawkScanMessages.HawkscanConf hawkscanConf = this.getTalonConfig().getHawkscanConf();
            Intrinsics.checkNotNullExpressionValue((Object)hawkscanConf, (String)"getHawkscanConf(...)");
            if (!((Collection)HawkConfExtensions.INSTANCE.redactionTokens(hawkscanConf)).isEmpty()) {
                List tokens;
                HawkScanMessages.HawkscanConf hawkscanConf2;
                List upd$iv;
                Object cur$iv;
                AtomicRef $this$getAndUpdate$iv = LoggerUtils.INSTANCE.getRedactTokens();
                boolean $i$f$getAndUpdate = false;
                do {
                    cur$iv = $this$getAndUpdate$iv.getValue();
                    tokens = (List)cur$iv;
                    boolean bl = false;
                    hawkscanConf2 = this.getTalonConfig().getHawkscanConf();
                    Intrinsics.checkNotNullExpressionValue((Object)hawkscanConf2, (String)"getHawkscanConf(...)");
                } while (!$this$getAndUpdate$iv.compareAndSet(cur$iv, (Object)(upd$iv = CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)HawkConfExtensions.INSTANCE.redactionTokens(hawkscanConf2), (Iterable)tokens))))));
            }
            this.setTalonConfig(TalonHawkScanConfExtensions.INSTANCE.optimizeApiScan(this.getTalonConfig()));
            this.getCommandExecutor().setTalonConfig(this.getTalonConfig());
            if (BootstrapUtils.isInDocker$default(BootstrapUtils.INSTANCE, null, 1, null) && this.displayBrowsers.contains(this.getTalonConfig().getHawkscanConf().getHawk().getSpider().getAjaxBrowser())) {
                this.setTalonConfig(TalonHawkScanConfExtensions.INSTANCE.setAjaxBrowser(this.getTalonConfig(), HawkScanMessages.HawkConf.Spider.AjaxBrowser.FIREFOX_HEADLESS));
                this.getCommandExecutor().setTalonConfig(this.getTalonConfig());
            } else {
                this.setUpAjaxBrowser();
            }
            this.customizeConfiguration();
            this.getCommandExecutor().setTalonConfig(this.getTalonConfig());
            this.getApplicationRef().getAndSet(this.getTerminalUtils().withTerminalProgress("Validating application and environment", (Function0)new Function0<ApplicationService.Application>(this){
                final /* synthetic */ BaseScanCommand this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final ApplicationService.Application invoke() {
                    ApplicationService.Application application;
                    if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.this$0.getTalonConfig())) {
                        CommandExecutor commandExecutor = this.this$0.getCommandExecutor();
                        String string = this.this$0.getTalonConfig().getHawkscanConf().getApp().getApplicationId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationId(...)");
                        Map<UserMessages.UserOrganization, List<ApplicationService.Application>> appOrgs = commandExecutor.getAppOrgs(string);
                        this.this$0.setOrganization((UserMessages.UserOrganization)CollectionsKt.first((Iterable)appOrgs.keySet()));
                        CommandExecutor commandExecutor2 = this.this$0.getCommandExecutor();
                        HawkScanMessages.AppConf appConf = this.this$0.getTalonConfig().getHawkscanConf().getApp();
                        Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
                        application = commandExecutor2.validateAppAndEnvironment(appConf, appOrgs);
                    } else {
                        application = null;
                    }
                    return application;
                }
            }));
            HawkScanMessages.OpenApiConf openApiConf = this.getTalonConfig().getHawkscanConf().getApp().getOpenApiConf();
            Intrinsics.checkNotNullExpressionValue((Object)openApiConf, (String)"getOpenApiConf(...)");
            List<String> hostedOASIds = HawkConfExtensionsKt.hostedOASIds(openApiConf);
            boolean usePlatform = this.getTalonConfig().getHawkscanConf().getApp().getOpenApiConf().getUsePlatform();
            boolean canFetchHostedOAS = this.organization != null && this.stackhawkApiClient != null;
            boolean shouldFetchHostedOAS = !((Collection)hostedOASIds).isEmpty() || usePlatform;
            String appId = this.getTalonConfig().getHawkscanConf().getApp().getApplicationId();
            if (canFetchHostedOAS && shouldFetchHostedOAS) {
                this.getTerminalUtils().withTerminalProgress("Fetching hosted OAS files", (Function0)new Function0<Unit>(this, hostedOASIds, sessionDir, usePlatform, appId){
                    final /* synthetic */ BaseScanCommand this$0;
                    final /* synthetic */ List<String> $hostedOASIds;
                    final /* synthetic */ Path $sessionDir;
                    final /* synthetic */ boolean $usePlatform;
                    final /* synthetic */ String $appId;
                    {
                        this.this$0 = $receiver;
                        this.$hostedOASIds = $hostedOASIds;
                        this.$sessionDir = $sessionDir;
                        this.$usePlatform = $usePlatform;
                        this.$appId = $appId;
                        super(0);
                    }

                    public final void invoke() {
                        if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.this$0.getTalonConfig())) {
                            UserMessages.UserOrganization userOrganization;
                            this.this$0.downloadHostedOASFiles(this.$hostedOASIds, this.$sessionDir, this.this$0.getStackhawkApiClient(), (userOrganization = this.this$0.getOrganization()) != null && (userOrganization = userOrganization.getOrganization()) != null ? userOrganization.getId() : null, this.$usePlatform, this.$appId);
                        }
                    }
                });
            }
            this.getTerminalUtils().withTerminalProgress("Validating scan policy", (Function0)new Function0<Unit>(this){
                final /* synthetic */ BaseScanCommand this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.this$0.getTalonConfig())) {
                        String string = TalonHawkScanConfExtensions.INSTANCE.getScanPolicyName(this.this$0.getTalonConfig());
                        ProtocolStringList protocolStringList = this.this$0.getTalonConfig().getHawkscanConf().getHawk().getScan().getIncludedPluginsList();
                        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getIncludedPluginsList(...)");
                        Set set = CollectionsKt.toSet((Iterable)((Iterable)protocolStringList));
                        String string2 = this.this$0.getTalonConfig().getHawkscanConf().getHawk().getScan().getPolicyName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPolicyName(...)");
                        ScanPolicyResolverOptions policyResolverOptions = new ScanPolicyResolverOptions(string, set, !StringsKt.isBlank((CharSequence)string2), this.this$0.getOrganization(), this.this$0.getStackhawkApiClient(), this.this$0.getStackhawkApiClient().assetManagerClient());
                        ScanPolicyMessages.ScanPolicy scanPolicy = TalonHawkScanConfExtensions.INSTANCE.resolveScanPolicy(this.this$0.getTalonConfig(), policyResolverOptions);
                        if (this.this$0.getAdvancedOptions().getDebug()) {
                            String scanPolicyJSON = JsonFormat.printer().print((MessageOrBuilder)scanPolicy);
                            BaseScanCommand.Companion.getLOG().debug("Resolved Scan Policy" + System.lineSeparator() + scanPolicyJSON);
                        }
                        TalonMessages.TalonHawkScanConf talonHawkScanConf = this.this$0.getTalonConfig().toBuilder().setScanPolicy(scanPolicy).build();
                        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
                        this.this$0.setTalonConfig(talonHawkScanConf);
                    }
                }
            });
            this.getCommandExecutor().setTalonConfig(this.getTalonConfig());
            this.customValidation(this.organization);
            ApplicationService.Application application = (ApplicationService.Application)this.getApplicationRef().getValue();
            if (application != null) {
                List list;
                ApplicationService.Application it = application;
                boolean bl = false;
                ConsolePrinter consolePrinter2 = this.getConsolePrinter();
                TalonMessages.TalonHawkScanConf talonHawkScanConf3 = this.getTalonConfig();
                String string10 = BootstrapUtils.INSTANCE.hawkScanVersionWithTag();
                if (configFiles.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"configFiles");
                    list = null;
                } else {
                    list = (List)configFiles.element;
                }
                consolePrinter2.printBanner(talonHawkScanConf3, string10, list, it);
                v21 = Unit.INSTANCE;
            } else {
                v21 = null;
            }
            List<String> combinedJvmOpts = this.buildSslJvmOptions(trustStorePath, trustStoreType, this.advancedOptions.getHawkJvmOpts());
            if (!((Collection)combinedJvmOpts).isEmpty()) {
                this.getConsolePrinter().printAdvancedProxyOptions(combinedJvmOpts);
            }
            if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.getTalonConfig())) {
                this.getCommandExecutor().checkForNewerVersion();
            }
            HawkScanMessages.HawkRuntimeInfo hawkRuntimeInfo = BootstrapUtils.INSTANCE.hawkRuntimeInfo(this.cicdPlatform);
            HawkScanMessages.ScanMetadata scanMetadata = this.getCommandExecutor().scanMetadata(this.projectRepoDir, hawkRuntimeInfo);
            if (this.getTalonConfig().getHawkscanConf().getApp().getWaitForAppTarget().getWaitTimeoutMillis() > 0L) {
                Object object;
                HawkScanMessages.AppConf appConf = this.getTalonConfig().getHawkscanConf().getApp();
                Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
                String targetHost = HawkConfExtensionsKt.cleanHost(appConf);
                if (BootstrapUtils.isDockerLocalHost$default(BootstrapUtils.INSTANCE, targetHost, null, 2, null) && !BootstrapUtils.INSTANCE.isInKubernetes()) {
                    String scheme = new URI(targetHost).getScheme();
                    object = scheme + "://" + BootstrapUtils.getDockerTarget$default(BootstrapUtils.INSTANCE, TalonHawkScanConfExtensions.INSTANCE.cleanTargetHost(this.getTalonConfig()), null, 2, null).getSecond();
                } else {
                    object = targetHost;
                }
                String target = object;
                this.getTerminalUtils().withTerminalProgress("Waiting for " + targetHost + " to become available", (Function0)new Function0<Unit>(this, target, targetHost){
                    final /* synthetic */ BaseScanCommand this$0;
                    final /* synthetic */ String $target;
                    final /* synthetic */ String $targetHost;
                    {
                        this.this$0 = $receiver;
                        this.$target = $target;
                        this.$targetHost = $targetHost;
                        super(0);
                    }

                    public final void invoke() {
                        Utils utils = Utils.INSTANCE;
                        long l = this.this$0.getTalonConfig().getHawkscanConf().getApp().getWaitForAppTarget().getWaitTimeoutMillis();
                        long l2 = this.this$0.getTalonConfig().getHawkscanConf().getApp().getWaitForAppTarget().getPollDelay();
                        String string = this.this$0.getTalonConfig().getHawkscanConf().getApp().getWaitForAppTarget().getRequestMethod().name();
                        String string2 = this.this$0.getTalonConfig().getHawkscanConf().getApp().getWaitForAppTarget().getRequestBody();
                        String string3 = this.this$0.getTalonConfig().getHawkscanConf().getApp().getWaitForAppTarget().getPath();
                        Map map = this.this$0.getTalonConfig().getHawkscanConf().getApp().getWaitForAppTarget().getRequestHeadersMap();
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getRequestHeadersMap(...)");
                        Map map2 = MapsKt.toMap((Map)map);
                        Intrinsics.checkNotNull((Object)string3);
                        Intrinsics.checkNotNull((Object)string2);
                        Utils.waitForTargetToBeAvailable$default(utils, this.$target, string3, string2, string, l2, l, this.$targetHost, null, map2, 128, null);
                    }
                });
            }
            if (BootstrapUtils.isDockerLocalHost$default(BootstrapUtils.INSTANCE, TalonHawkScanConfExtensions.INSTANCE.cleanTargetHost(this.getTalonConfig()), null, 2, null)) {
                String[] simpleProxyCommand = BootstrapUtils.INSTANCE.proxyCommandBuilder(TalonHawkScanConfExtensions.INSTANCE.cleanTargetHost(this.getTalonConfig()), TalonHawkScanConfExtensions.INSTANCE.cleanTargetHost(this.getTalonConfig()));
                BootstrapUtils.startProcess$default(BootstrapUtils.INSTANCE, simpleProxyCommand, null, 2, null);
                Thread.sleep(1000L);
            }
            Map hsteEnvMap = new LinkedHashMap();
            String string11 = BootstrapUtils.INSTANCE.startXvfb();
            if (string11 != null) {
                String it = string11;
                boolean bl = false;
                hsteEnvMap.put("DISPLAY", it);
                v25 = Unit.INSTANCE;
            } else {
                v25 = null;
            }
            if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.getTalonConfig())) {
                this.getBeforeScanStartedRef().getAndSet(true);
                ScanResultMessages.BeforeScan beforeScan = (ScanResultMessages.BeforeScan)this.getCommandExecutor().beforeScan(scanMetadata, this.parentScanId).component2();
                this.getBeforeScanRef().getAndSet((Object)beforeScan);
            }
            String path = new URI(this.getTalonConfig().getHawkscanConf().getApp().getHost()).getPath();
            Intrinsics.checkNotNull((Object)path);
            if (((CharSequence)path).length() > 0 && !path.equals("/")) {
                this.getConsolePrinter().printWarning("The app.host should not contain a path, only the base URL of the application. Using " + TalonHawkScanConfExtensions.INSTANCE.cleanTargetHost(this.getTalonConfig()) + " instead.\nhttps://docs.stackhawk.com/hawkscan/configuration/#app");
            }
            this.getConsolePrinter().printViewResultsOnPlatform(this.getTalonConfig());
            Channel scanResponseChannel = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
            TalonScanResponseServer talonScanResponseServer = new TalonScanResponseServer(null, scanResponseChannel, Bootstrap.INSTANCE.getAsyncScope(), 1, null);
            int scanResponseServicePort = talonScanResponseServer.start();
            CommandExecutor commandExecutor = this.getCommandExecutor();
            TalonMessages.TalonHawkScanConf talonHawkScanConf4 = this.getTalonConfig().toBuilder().setScanResponseServicePort(scanResponseServicePort).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf4, (String)"build(...)");
            commandExecutor.setTalonConfig(talonHawkScanConf4);
            int exitCode = this.getCommandExecutor().runHsteProcess(this.getConsolePrinter(), this.getScanResponseOutputHandlerRef(), this.getHsteProcessRef(), sessionDir, hsteEnvMap, AdvancedScanOptionsKt.hsteLoggingOptions(this.advancedOptions), this.displayBrowsers, (Channel<TalonMessages.TalonScanResponse>)scanResponseChannel, "Starting Scan Engine", this.cliConfig.getHsteUI(), this.cliConfig.getJvmDebugServer(), combinedJvmOpts);
            if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.getTalonConfig())) {
                this.getTerminalUtils().withTerminalProgress("Sending logs to platform", (Function0)new Function0<Unit>(this, sessionDir){
                    final /* synthetic */ BaseScanCommand this$0;
                    final /* synthetic */ Path $sessionDir;
                    {
                        this.this$0 = $receiver;
                        this.$sessionDir = $sessionDir;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.uploadHawkScanLog(this.this$0.getCommandExecutor(), this.this$0.getTalonConfig(), this.$sessionDir, this.this$0.getStackhawkApiClient());
                    }
                });
            }
            ScanResponseOutputHandler scanResponseOutputHandler2 = (ScanResponseOutputHandler)this.getScanResponseOutputHandlerRef().getValue();
            if (scanResponseOutputHandler2 != null) {
                ScanResponseOutputHandler scanResponseOutputHandler3 = scanResponseOutputHandler2;
                boolean bl = false;
                TalonMessages.AlertsCompact alertsCompact = scanResponseOutputHandler3.getAlertsCompactOpt();
                if (alertsCompact != null) {
                    TalonMessages.AlertsCompact alertsCompact2 = alertsCompact;
                    boolean bl6 = false;
                    TalonMessages.SeverityCounts severityCounts = alertsCompact2.getSeverityCounts();
                    Intrinsics.checkNotNullExpressionValue((Object)severityCounts, (String)"getSeverityCounts(...)");
                    HawkScanMessages.HawkConf hawkConf = this.getTalonConfig().getHawkscanConf().getHawk();
                    Intrinsics.checkNotNullExpressionValue((Object)hawkConf, (String)"getHawk(...)");
                    BootstrapUtils.INSTANCE.thresholdCheck(severityCounts, hawkConf);
                    v32 = Unit.INSTANCE;
                } else {
                    v32 = null;
                }
                if (exitCode > 0) {
                    ScanResultMessages.ScanResult errorScanResult = MainKt.errorScanResult((TalonMessages.TalonError)scanResponseOutputHandler3.getTalonError().getValue(), ErrorUtils.INSTANCE.errorScan(this.getTalonConfig(), BootstrapUtils.INSTANCE.getHawkscanVersion()));
                    if (TalonHawkScanConfExtensions.INSTANCE.canSend(this.getTalonConfig())) {
                        ErrorUtils.INSTANCE.handleErrorForPlatform(this.getTalonConfig(), this.getCommandExecutor(), errorScanResult);
                    }
                }
                v33 = Unit.INSTANCE;
            } else {
                v33 = null;
            }
            this.getStackhawkApiClient().stop();
            this.getCompleted().getAndSet(true);
            System.exit(exitCode);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (OverThresholdException ote) {
            this.getTerminalUtils().stopTerminalProgress();
            this.getCompleted().getAndSet(true);
            this.getStackhawkApiClient().stop();
            ErrorUtils.INSTANCE.printHawkscanException(ote, this.getConsolePrinter());
            System.exit(ote.exitCode());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (HawkScanException he) {
            this.getTerminalUtils().stopTerminalProgress();
            this.getCompleted().getAndSet(true);
            ErrorUtils.INSTANCE.handleException(he, this.getTalonConfig(), this.getCommandExecutor(), (ApplicationService.Application)this.getApplicationRef().getValue());
            System.exit(he.exitCode());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Exception e) {
            this.getTerminalUtils().stopTerminalProgress();
            this.getCompleted().getAndSet(true);
            String string12 = e.getMessage();
            if (string12 == null) {
                string12 = "";
            }
            UnexpectedError he = new UnexpectedError(string12, e, null, 4, null);
            ErrorUtils.INSTANCE.handleException(he, this.getTalonConfig(), this.getCommandExecutor(), (ApplicationService.Application)this.getApplicationRef().getValue());
            System.exit(2);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void setUpAjaxBrowser() {
        boolean isAjax = this.getCommandExecutor().getTalonConfig().getHawkscanConf().getHawk().getSpider().getAjax();
        if (isAjax) {
            String browserName = this.getCommandExecutor().getTalonConfig().getHawkscanConf().getHawk().getSpider().getAjaxBrowser().name();
            BootstrapUtils.INSTANCE.confirmBrowserForAjax(browserName);
        }
    }

    private final List<String> buildSslJvmOptions(String trustStorePath, String trustStoreType, List<String> hawkJvmOpts) {
        List sslJvmOpts;
        block2: {
            String it;
            sslJvmOpts = new ArrayList();
            String string = trustStorePath;
            if (string != null) {
                it = string;
                boolean bl = false;
                sslJvmOpts.add("-Djavax.net.ssl.trustStore=" + it);
            }
            String string2 = trustStoreType;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                sslJvmOpts.add("-Djavax.net.ssl.trustStoreType=" + it);
            }
            String string3 = this.proxyConfigOptions.getSslTrustStorePassword();
            if (string3 == null) break block2;
            String it2 = string3;
            boolean bl = false;
            sslJvmOpts.add("-Djavax.net.ssl.trustStorePassword=" + it2);
        }
        return CollectionsKt.plus((Collection)sslJvmOpts, (Iterable)hawkJvmOpts);
    }

    static /* synthetic */ List buildSslJvmOptions$default(BaseScanCommand baseScanCommand, String string, String string2, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSslJvmOptions");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return baseScanCommand.buildSslJvmOptions(string, string2, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> parseConfigFiles(@NotNull List<String> confFiles, @Nullable StackHawkApiClient stackHawkApiClient) {
        String it;
        List list;
        Intrinsics.checkNotNullParameter(confFiles, (String)"confFiles");
        if (!((Collection)confFiles).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = confFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void confFile;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ConfigUtils.Companion.isRemoteUriString((String)confFile) ? confFile : this.projectRepoDir + File.separator + (String)confFile);
            }
            list = (List)destination$iv$iv;
        } else {
            list = Config.INSTANCE.resolveDefaultConfigFiles(this.projectRepoDir, this.advancedOptions.getApplicationId());
        }
        List configFiles = list;
        String string = this.advancedOptions.getApplicationId();
        if (string != null) {
            it = string;
            boolean bl = false;
            this.setTalonConfig(TalonHawkScanConfExtensions.INSTANCE.setApplicationId(this.getTalonConfig(), it));
        }
        String string2 = this.advancedOptions.getEnvironmentName();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.setTalonConfig(TalonHawkScanConfExtensions.INSTANCE.setEnvironment(this.getTalonConfig(), it));
        }
        AssetManagerClient assetManager = this.stackhawkApiClient != null ? this.getStackhawkApiClient().assetManagerClient() : null;
        this.setTalonConfig((TalonMessages.TalonHawkScanConf)this.getTerminalUtils().withTerminalProgress("Parsing configuration files", (Function0)new Function0<TalonMessages.TalonHawkScanConf>(this, (List<String>)configFiles, assetManager, stackHawkApiClient){
            final /* synthetic */ BaseScanCommand this$0;
            final /* synthetic */ List<String> $configFiles;
            final /* synthetic */ AssetManagerClient $assetManager;
            final /* synthetic */ StackHawkApiClient $stackHawkApiClient;
            {
                this.this$0 = $receiver;
                this.$configFiles = $configFiles;
                this.$assetManager = $assetManager;
                this.$stackHawkApiClient = $stackHawkApiClient;
                super(0);
            }

            @NotNull
            public final TalonMessages.TalonHawkScanConf invoke() {
                return BootstrapUtils.parseConfig$default(BootstrapUtils.INSTANCE, this.this$0.getTalonConfig(), this.$configFiles, this.this$0.getBasicOptions().getEnvFile(), this.this$0.getBasicOptions().getEnv(), this.this$0.getAdvancedOptions(), this.this$0.getCliConfig().getNoColor(), this.this$0.getBasicOptions().getRepoDir(), null, this.$assetManager, this.$stackHawkApiClient, 128, null);
            }
        }));
        return configFiles;
    }

    private final Path nextRolledLogFile(Path sessionDir, int nextFileNumber) {
        return sessionDir.resolve("hawkscan.log." + nextFileNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void concatenateFiles(List<? extends File> filesToConcat, File outputFile) {
        try {
            Object object = outputFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                Iterable $this$forEach$iv = filesToConcat;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl2 = false;
                    Object object4 = file;
                    Object object5 = Charsets.UTF_8;
                    int n2 = 8192;
                    Object object6 = object4;
                    object4 = (object6 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object6), (Charset)object5)) instanceof BufferedReader ? (BufferedReader)object6 : new BufferedReader((Reader)object6, n2);
                    object5 = null;
                    try {
                        BufferedReader reader = (BufferedReader)object4;
                        boolean bl3 = false;
                        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(writer){
                            final /* synthetic */ BufferedWriter $writer;
                            {
                                this.$writer = $writer;
                                super(1);
                            }

                            public final void invoke(@NotNull String line) {
                                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                this.$writer.write(line);
                                this.$writer.write(System.lineSeparator());
                            }
                        }));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object5 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object4, (Throwable)object5);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception e) {
            LOG.error("Error concatenating files: ", (Throwable)e);
        }
    }

    private final Path writeRolledHawkScanLogFile(Path sessionDir, int logRollCount) {
        int nextFileNumber;
        File outputFileTemp = sessionDir.resolve("hawkscan.log.outfile").toFile();
        Path rolledLastLogFile = sessionDir.resolve("hawkscan.log");
        List rolledLogFiles = new ArrayList();
        for (nextFileNumber = 1; this.nextRolledLogFile(sessionDir, nextFileNumber).toFile().exists() && nextFileNumber <= logRollCount; ++nextFileNumber) {
            File file = this.nextRolledLogFile(sessionDir, nextFileNumber).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            rolledLogFiles.add(file);
        }
        File file = rolledLastLogFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        rolledLogFiles.add(file);
        outputFileTemp.createNewFile();
        if (nextFileNumber > logRollCount) {
            this.getConsolePrinter().printWarning("Warning: maximum " + logRollCount + " log files sent to platform. Some logs may be missing; consider increasing logRollSize or logFilesCount settings.");
        }
        Intrinsics.checkNotNull((Object)outputFileTemp);
        this.concatenateFiles(rolledLogFiles, outputFileTemp);
        outputFileTemp.renameTo(rolledLastLogFile.toFile());
        Intrinsics.checkNotNull((Object)rolledLastLogFile);
        return rolledLastLogFile;
    }

    public final void uploadHawkScanLog(@NotNull CommandExecutor commandExecutor, @NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull Path sessionDir, @NotNull StackHawkApiClient stackHawkApiClient) {
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
        Intrinsics.checkNotNullParameter((Object)sessionDir, (String)"sessionDir");
        Intrinsics.checkNotNullParameter((Object)stackHawkApiClient, (String)"stackHawkApiClient");
        Path uploadLog = sessionDir.resolve(this.scanLogFilename);
        int logRollCount = talonConfig.getLogRollCount();
        Path hawkscanLogFile = this.writeRolledHawkScanLogFile(sessionDir, logRollCount);
        Path path = Path.of(BootstrapUtils.INSTANCE.getLogFile(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Intrinsics.checkNotNull((Object)uploadLog);
        this.mergeLogFiles(path, hawkscanLogFile, uploadLog);
        String string = uploadLog.toFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        File zipFile = CommandExecutor.uploadHawkScanLog$default(commandExecutor, string, stackHawkApiClient, null, 4, null);
        zipFile.delete();
        FileUtils.deleteQuietly((File)uploadLog.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergeLogFiles(@NotNull Path hawkLog, @NotNull Path scanLog, @NotNull Path uploadLog) {
        Intrinsics.checkNotNullParameter((Object)hawkLog, (String)"hawkLog");
        Intrinsics.checkNotNullParameter((Object)scanLog, (String)"scanLog");
        Intrinsics.checkNotNullParameter((Object)uploadLog, (String)"uploadLog");
        String scanLogBanner = "--------------------------------------------------------------------------------------------------\nHSTE Scan Log\n--------------------------------------------------------------------------------------------------\n";
        String hawkLogBanner = "--------------------------------------------------------------------------------------------------\nHawk Log\n--------------------------------------------------------------------------------------------------\n";
        File file = uploadLog.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Object object = file;
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            File file2;
            FileOutputStream logOutStream = (FileOutputStream)object;
            boolean bl = false;
            byte[] byArray = hawkLogBanner.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            IOUtils.copy((InputStream)new ByteArrayInputStream(byArray), (OutputStream)logOutStream);
            if (hawkLog.toFile().exists()) {
                File file3 = hawkLog.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                file2 = file3;
                IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)logOutStream);
            }
            byte[] byArray2 = scanLogBanner.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            IOUtils.copy((InputStream)new ByteArrayInputStream(byArray2), (OutputStream)logOutStream);
            if (scanLog.toFile().exists()) {
                File file4 = scanLog.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"toFile(...)");
                file2 = file4;
                IOUtils.copy((InputStream)new FileInputStream(file2), (OutputStream)logOutStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final String promptForBrowser() {
        Object[] objectArray = new String[]{"yes", "y", "no", "n"};
        return ConsolePrinter.prompt$default(this.getConsolePrinter(), "No API key found. Select yes to open a browser and create a new API key or no if you have already have an API key.", CollectionsKt.listOf((Object[])objectArray), null, 4, null);
    }

    private final void promptForAPIKey() {
        if (!this.cliConfig.getDevMode()) {
            String string = this.getTalonConfig().getApiKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
            if (((CharSequence)string).length() == 0) {
                CharSequence charSequence;
                if (!BootstrapUtils.isInDocker$default(BootstrapUtils.INSTANCE, null, 1, null) && !this.advancedOptions.getNoProgress() && ((charSequence = (CharSequence)this.cicdPlatform) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    Unit unit;
                    Ref.ObjectRef popBrowser = new Ref.ObjectRef();
                    TerminalUtils.withTimeout$default(this.getTerminalUtils(), (Function0)new Function0<Boolean>((Ref.ObjectRef<String>)popBrowser){
                        final /* synthetic */ Ref.ObjectRef<String> $popBrowser;
                        {
                            this.$popBrowser = $popBrowser;
                            super(0);
                        }

                        @NotNull
                        public final Boolean invoke() {
                            CharSequence charSequence = (CharSequence)this.$popBrowser.element;
                            return charSequence == null || charSequence.length() == 0;
                        }
                    }, 0L, 0L, (Function0)new Function0<Unit>((Ref.ObjectRef<String>)popBrowser, this){
                        final /* synthetic */ Ref.ObjectRef<String> $popBrowser;
                        final /* synthetic */ BaseScanCommand this$0;
                        {
                            this.$popBrowser = $popBrowser;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            this.$popBrowser.element = BaseScanCommand.access$promptForBrowser(this.this$0);
                        }
                    }, 6, null);
                    String apiKeySettingsUrl = TalonHawkScanConfExtensions.INSTANCE.getPlatformUrl(this.getTalonConfig()) + "/settings/apikeys";
                    String string2 = (String)popBrowser.element;
                    if (string2 != null) {
                        String apikey;
                        String it = string2;
                        boolean bl = false;
                        String string3 = it.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        String string4 = string3;
                        if (Intrinsics.areEqual((Object)string4, (Object)"y") ? true : Intrinsics.areEqual((Object)string4, (Object)"yes")) {
                            if (BrowserUtils.INSTANCE.browseToPage(new URI(apiKeySettingsUrl + "?new_key_name=HawkKey"))) {
                                this.getConsolePrinter().println("Please create a new API key and copy the new field.");
                            } else {
                                this.getConsolePrinter().println("Please browse to " + apiKeySettingsUrl + " and create a new API key.");
                            }
                        } else {
                            this.getConsolePrinter().println("Please browse to " + apiKeySettingsUrl + " and create a new API key.");
                        }
                        String string5 = apikey = ConsolePrinter.prompt$default(this.getConsolePrinter(), "Enter API key", null, null, 2, null);
                        if (!(string5 != null ? ((CharSequence)string5).length() > 0 : false)) {
                            throw new InstalledEnvironmentException("An API key is required.", null, null, 6, null);
                        }
                        TalonMessages.TalonHawkScanConf talonHawkScanConf = this.getTalonConfig().toBuilder().setApiKey(apikey).build();
                        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
                        this.setTalonConfig(talonHawkScanConf);
                        HawkValuesSource.storeProperty$default(HawkValuesSource.INSTANCE, "api-key", apikey, null, 4, null);
                        this.newKey = true;
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        throw new InstalledEnvironmentException("An API key is required.", null, null, 6, null);
                    }
                } else {
                    throw new InstalledEnvironmentException("An API key is required.", null, null, 6, null);
                }
            }
        }
    }

    public final void downloadHostedOASFiles(@NotNull List<String> hostedOASIds, @NotNull Path sessionDir, @NotNull StackHawkApiClient stackhawkApiClient, @Nullable String orgId, @Nullable Boolean usePlatform, @Nullable String appId) {
        Intrinsics.checkNotNullParameter(hostedOASIds, (String)"hostedOASIds");
        Intrinsics.checkNotNullParameter((Object)sessionDir, (String)"sessionDir");
        Intrinsics.checkNotNullParameter((Object)stackhawkApiClient, (String)"stackhawkApiClient");
        new HostedOASDownloader(hostedOASIds, sessionDir, stackhawkApiClient, orgId, appId, usePlatform).download();
    }

    public static /* synthetic */ void downloadHostedOASFiles$default(BaseScanCommand baseScanCommand, List list, Path path, StackHawkApiClient stackHawkApiClient, String string, Boolean bl, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: downloadHostedOASFiles");
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        baseScanCommand.downloadHostedOASFiles(list, path, stackHawkApiClient, string, bl, string2);
    }

    public abstract void customizeConfiguration();

    public abstract void customValidation(@Nullable UserMessages.UserOrganization var1);

    public static /* synthetic */ void customValidation$default(BaseScanCommand baseScanCommand, UserMessages.UserOrganization userOrganization, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: customValidation");
        }
        if ((n & 1) != 0) {
            userOrganization = null;
        }
        baseScanCommand.customValidation(userOrganization);
    }

    public static final /* synthetic */ String access$promptForBrowser(BaseScanCommand $this) {
        return $this.promptForBrowser();
    }

    static {
        Logger logger = LogManager.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stackhawk/hste/BaseScanCommand$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "getLOG", "()Lorg/apache/logging/log4j/Logger;", "talon-bootstrap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

