/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.output.Localization;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.ThemeKt;
import com.github.ajalt.mordant.terminal.Terminal;
import com.stackhawk.cli.HawkScanCommandLocalization;
import com.stackhawk.cli.HawkValidationError;
import com.stackhawk.cli.options.AdvancedScanOptions;
import com.stackhawk.hawk.BrowserUtils;
import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.Bootstrap;
import com.stackhawk.hste.BootstrapUtils;
import com.stackhawk.hste.CliConfig;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.ErrorUtils;
import com.stackhawk.hste.GitWrapper;
import com.stackhawk.hste.HawkValuesSource;
import com.stackhawk.hste.JavaRuntimeChecker;
import com.stackhawk.hste.JavaRuntimeResult;
import com.stackhawk.hste.extension.talon.TalonHawkScanConfExtensions;
import com.stackhawk.hste.extension.talon.client.AssetManagerClient;
import com.stackhawk.hste.extension.talon.client.BasicHttpClient;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.config.AppVariables;
import com.stackhawk.hste.extension.talon.config.Config;
import com.stackhawk.hste.extension.talon.config.ConfigResolverOptions;
import com.stackhawk.hste.extension.talon.hawkscan.api.ConfException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ConfigValidationException;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanException;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanNetworkingException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InstalledEnvironmentException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidYamlException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidYamlFileException;
import com.stackhawk.hste.extension.talon.hawkscan.api.OverThresholdException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScannerConfigException;
import com.stackhawk.hste.extension.talon.hawkscan.api.UnexpectedError;
import com.stackhawk.hste.logger.LoggerUtils;
import com.stackhawk.nest.HawkScanMessages;
import com.stackhawk.nest.TalonMessages;
import com.stackhawk.nest.insights.ThresholdHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.AtomicRef;
import net.jimblackler.jsonschemafriend.ListValidationException;
import net.jimblackler.jsonschemafriend.SchemaException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.software.os.mac.MacOperatingSystem;
import oshi.software.os.windows.WindowsOperatingSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jh\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00042\b\b\u0002\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00042\b\b\u0002\u0010*\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020\u00042\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020-2\b\b\u0002\u00100\u001a\u00020\u0004J\u0010\u00101\u001a\u00020-2\b\b\u0002\u00102\u001a\u00020\u0004J \u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\b\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u00106\u001a\u000207J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00042\b\b\u0002\u0010;\u001a\u00020-J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0004J\u001e\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020A2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020-J\"\u0010B\u001a\u0002092\u0006\u0010C\u001a\u00020A2\b\b\u0002\u0010.\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020-J\u0010\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020-J\u0006\u0010G\u001a\u00020\u0004J\u0006\u0010H\u001a\u00020\u0004J\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040JJ\u0006\u0010K\u001a\u00020=J\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040MJ$\u0010N\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00040J2\u0006\u0010O\u001a\u00020\u00042\b\b\u0002\u0010P\u001a\u00020\u0004J\u0006\u0010Q\u001a\u00020RJ'\u0010S\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040J2\n\b\u0002\u0010T\u001a\u0004\u0018\u00010=\u00a2\u0006\u0002\u0010UJ\f\u0010V\u001a\b\u0012\u0004\u0012\u00020-0\u0019J\u0012\u0010W\u001a\u00020X2\n\b\u0002\u0010Y\u001a\u0004\u0018\u00010\u0004J\u0006\u0010Z\u001a\u00020\u0004J\u000e\u0010[\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0010\u0010\\\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010]\u001a\u00020\u0004J\u0006\u0010^\u001a\u00020=J\u0018\u0010_\u001a\u00020=2\u0006\u0010O\u001a\u00020\u00042\b\b\u0002\u0010`\u001a\u00020\u0004J\u0010\u0010a\u001a\u00020=2\b\b\u0002\u0010`\u001a\u00020\u0004J\u0006\u0010b\u001a\u00020=J\u0006\u0010c\u001a\u00020=J\u000e\u0010d\u001a\u00020=2\u0006\u0010O\u001a\u00020\u0004J\u0006\u0010e\u001a\u00020=J\u0006\u0010f\u001a\u00020=J\u0014\u0010g\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010:\u001a\u00020\u0004J\u001a\u0010h\u001a\u00020\u00042\u0006\u0010i\u001a\u00020\u00172\b\b\u0002\u0010j\u001a\u00020-H\u0002J\u0006\u0010k\u001a\u00020\u0004Jv\u0010l\u001a\u00020$2\u0006\u0010m\u001a\u00020$2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\b\u0010o\u001a\u0004\u0018\u00010\u00042\u0012\u0010p\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040M2\n\b\u0002\u0010q\u001a\u0004\u0018\u00010r2\u0006\u0010s\u001a\u00020=2\u0006\u0010t\u001a\u00020\u00042\b\b\u0002\u0010u\u001a\u00020v2\n\b\u0002\u0010w\u001a\u0004\u0018\u00010x2\b\u0010y\u001a\u0004\u0018\u00010zJ\"\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020~2\b\b\u0002\u0010s\u001a\u00020=2\b\u0010y\u001a\u0004\u0018\u00010zJ%\u0010\u007f\u001a\t\u0012\u0004\u0012\u00020\u00040\u0080\u00012\u0006\u0010O\u001a\u00020\u00042\b\b\u0002\u0010P\u001a\u00020\u0004\u00a2\u0006\u0003\u0010\u0081\u0001J+\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u000e\u0010\u0084\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u0080\u00012\u000b\b\u0002\u0010\u0085\u0001\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0003\u0010\u0086\u0001J\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0004J\u000f\u0010\u0088\u0001\u001a\u0002092\u0006\u0010F\u001a\u00020-J\u0007\u0010\u0089\u0001\u001a\u00020-J\u0007\u0010\u008a\u0001\u001a\u00020=J\u0007\u0010\u008b\u0001\u001a\u00020=J\u0007\u0010\u008c\u0001\u001a\u00020=J\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u0004J\u001b\u0010\u008e\u0001\u001a\u0002092\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001J\u0010\u0010\u0093\u0001\u001a\u0002092\u0007\u0010\u0094\u0001\u001a\u00020\u0004J\u001b\u0010\u0095\u0001\u001a\u00020\u00042\u0007\u0010\u0096\u0001\u001a\u00020\u00042\t\b\u0002\u0010\u0097\u0001\u001a\u00020=J\u0017\u0010\u0098\u0001\u001a\u000209*\u00030\u0099\u00012\t\b\u0002\u0010\u009a\u0001\u001a\u00020=R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u000e\u0010\"\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lcom/stackhawk/hste/BootstrapUtils;", "", "()V", "JAVA_HOME", "", "cwd", "getCwd", "()Ljava/lang/String;", "defaultSessionHome", "defaultSessionHomeFile", "Ljava/io/File;", "getDefaultSessionHomeFile", "()Ljava/io/File;", "hawkscanVersion", "getHawkscanVersion", "installDir", "getInstallDir", "localHostPattern", "Lkotlin/text/Regex;", "logDir", "logFile", "getLogFile", "maxMem", "", "memUnits", "", "systemInfo", "Loshi/SystemInfo;", "getSystemInfo", "()Loshi/SystemInfo;", "userHome", "getUserHome", "userName", "getUserName", "uuidPattern", "buildTalonConfig", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "cliConfig", "Lcom/stackhawk/hste/CliConfig;", "apiEndpoint", "authEndpoint", "apiKey", "hoastUrl", "perchEndpoint", "numStoredSessions", "", "logRollSize", "logRollCount", "perchKey", "checkXvfbLockFile", "baseDir", "checkoutGitRepo", "gitUrl", "gitRev", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "cleanupSessionDirectories", "", "sessionHomeDir", "keepLast", "confirmBrowserForAjax", "", "browserName", "createLog4jPropertiesFile", "dir", "Ljava/nio/file/Path;", "createScanSessionDirectory", "sessionDir", "daemonProcess", "Loshi/software/os/OSProcess;", "pid", "defaultGateway", "defaultHSTEJvmMemory", "defaultHsteJarAndClasspath", "Lkotlin/Pair;", "defaultNoColor", "defaultProps", "", "getDockerTarget", "host", "dockerGateway", "getOS", "Loshi/software/os/OperatingSystem;", "getOSNativeTruststoreSettings", "useNativeTruststore", "(Ljava/lang/Boolean;)Lkotlin/Pair;", "getPids", "hawkRuntimeInfo", "Lcom/stackhawk/nest/HawkScanMessages$HawkRuntimeInfo;", "cicdPlatform", "hawkScanVersionWithTag", "hsteClasspath", "hsteJar", "inferredJavaHome", "isDockerInternalHostSupported", "isDockerLocalHost", "directoryPath", "isInDocker", "isInKubernetes", "isLinux", "isLocalhost", "isMacOS", "isWindows", "listSessionDirs", "memStr", "bytes", "pos", "osFamily", "parseConfig", "talonConfig", "configFiles", "envFile", "env", "advancedOptions", "Lcom/stackhawk/cli/options/AdvancedScanOptions;", "noColor", "repoDir", "httpClient", "Lcom/stackhawk/hste/extension/talon/client/BasicHttpClient;", "assetManagerClient", "Lcom/stackhawk/hste/extension/talon/client/AssetManagerClient;", "stackHawkApiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "parseStackHawkYamlFiles", "Lcom/stackhawk/nest/HawkScanMessages$HawkscanConf;", "options", "Lcom/stackhawk/hste/extension/talon/config/ConfigResolverOptions;", "proxyCommandBuilder", "", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "startProcess", "Ljava/lang/Process;", "commands", "outputFile", "([Ljava/lang/String;Ljava/io/File;)Ljava/lang/Process;", "startXvfb", "stopProcess", "thisProcessId", "thisProcessIsHawkExe", "thisProcessIsHawkMacOS", "thisProcessIsJava", "thisProcessPath", "thresholdCheck", "severityCounts", "Lcom/stackhawk/nest/TalonMessages$SeverityCounts;", "hawkConf", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf;", "updateTokens", "token", "wrapBright", "txt", "colorEnabled", "hawkContext", "Lcom/github/ajalt/clikt/core/Context$Builder;", "color", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nBootstrapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapUtils.kt\ncom/stackhawk/hste/BootstrapUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AtomicFU.common.kt\nkotlinx/atomicfu/AtomicFU_commonKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,663:1\n1#2:664\n112#3,4:665\n1557#4:669\n1628#4,3:670\n774#4:673\n865#4,2:674\n774#4:676\n865#4,2:677\n1863#4,2:679\n1062#4:681\n1863#4,2:682\n774#4:684\n865#4,2:685\n1557#4:687\n1628#4,3:688\n*S KotlinDebug\n*F\n+ 1 BootstrapUtils.kt\ncom/stackhawk/hste/BootstrapUtils\n*L\n137#1:665,4\n327#1:669\n327#1:670,3\n516#1:673\n516#1:674,2\n525#1:676\n525#1:677,2\n526#1:679,2\n532#1:681\n532#1:682,2\n599#1:684\n599#1:685,2\n604#1:687\n604#1:688,3\n*E\n"})
public final class BootstrapUtils {
    @NotNull
    public static final BootstrapUtils INSTANCE = new BootstrapUtils();
    @NotNull
    private static final String userName;
    @NotNull
    private static final String userHome;
    @NotNull
    private static final String installDir;
    @NotNull
    private static final String logDir;
    @NotNull
    private static final String logFile;
    @NotNull
    private static final String hawkscanVersion;
    @NotNull
    private static final String cwd;
    @NotNull
    private static final String defaultSessionHome;
    @NotNull
    private static final File defaultSessionHomeFile;
    @NotNull
    public static final String JAVA_HOME = "JAVA_HOME";
    private static final long maxMem = 10485760000L;
    @NotNull
    private static final Regex localHostPattern;
    @NotNull
    private static final Regex uuidPattern;
    @NotNull
    private static final List<String> memUnits;

    private BootstrapUtils() {
    }

    private final SystemInfo getSystemInfo() {
        return new SystemInfo();
    }

    @NotNull
    public final String getUserName() {
        return userName;
    }

    @NotNull
    public final String getUserHome() {
        return userHome;
    }

    @NotNull
    public final String getInstallDir() {
        return installDir;
    }

    @NotNull
    public final String getLogFile() {
        return logFile;
    }

    @NotNull
    public final String getHawkscanVersion() {
        return hawkscanVersion;
    }

    @NotNull
    public final String getCwd() {
        return cwd;
    }

    @NotNull
    public final File getDefaultSessionHomeFile() {
        return defaultSessionHomeFile;
    }

    @Nullable
    public final String hsteJar(@NotNull String installDir) {
        Comparable<Path> comparable;
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
            Stream<Path> stream = Files.list(Path.of(installDir, new String[0]));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"list(...)");
            Sequence sequence = StreamsKt.asSequence(stream);
            for (Object e : sequence) {
                Path it = (Path)e;
                boolean bl = false;
                String string = it.toFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"hste-", (boolean)false, (int)2, null)) continue;
                v2 = e;
                break block1;
            }
            v2 = null;
        }
        return (comparable = (Path)v2) != null && (comparable = comparable.toFile()) != null ? ((File)comparable).getName() : null;
    }

    @NotNull
    public final String hsteClasspath(@NotNull String installDir) {
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        String sep = this.getOS() instanceof WindowsOperatingSystem ? "\\" : "/";
        return Path.of(installDir + "/lib", new String[0]) + sep + "*";
    }

    @NotNull
    public final Pair<String, String> defaultHsteJarAndClasspath() {
        String string = this.hsteJar(installDir);
        if (string == null) {
            throw new InstalledEnvironmentException("Hste jar not found in " + installDir + " :(", null, null, 6, null);
        }
        String hsteJar = string;
        String hsteClasspath = this.hsteClasspath(installDir);
        return TuplesKt.to((Object)hsteJar, (Object)hsteClasspath);
    }

    @NotNull
    public final String defaultHSTEJvmMemory() {
        long defaultMem = this.getSystemInfo().getHardware().getMemory().getTotal() / (long)3;
        long bytes = defaultMem > 10485760000L ? 10485760000L : defaultMem;
        return BootstrapUtils.memStr$default(this, bytes, 0, 2, null);
    }

    @NotNull
    public final String wrapBright(@NotNull String txt, boolean colorEnabled) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        return ConsolePrinter.Companion.wrapBright(txt, colorEnabled);
    }

    public static /* synthetic */ String wrapBright$default(BootstrapUtils bootstrapUtils, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = !bootstrapUtils.defaultNoColor();
        }
        return bootstrapUtils.wrapBright(string, bl);
    }

    public final boolean defaultNoColor() {
        Map<String, String> props = this.defaultProps();
        return props.containsKey("no-color") && !Intrinsics.areEqual((Object)props.get("no-color"), (Object)"false");
    }

    @NotNull
    public final Map<String, String> defaultProps() {
        Map rcMap = HawkValuesSource.rcValues$default(HawkValuesSource.INSTANCE, null, 1, null);
        Map propMap = HawkValuesSource.propValues$default(HawkValuesSource.INSTANCE, null, 1, null);
        Map<String, String> envMap = HawkValuesSource.INSTANCE.envValues();
        return MapsKt.plus((Map)MapsKt.plus((Map)rcMap, (Map)propMap), envMap);
    }

    private final String memStr(long bytes, int pos) {
        return bytes < 1024L ? bytes + memUnits.get(pos) : this.memStr(bytes >> 10, pos + 1);
    }

    static /* synthetic */ String memStr$default(BootstrapUtils bootstrapUtils, long l, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return bootstrapUtils.memStr(l, n);
    }

    public final void updateTokens(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (((CharSequence)token).length() > 0) {
            List tokens;
            List upd$iv;
            Object cur$iv;
            AtomicRef $this$getAndUpdate$iv = LoggerUtils.INSTANCE.getRedactTokens();
            boolean $i$f$getAndUpdate = false;
            do {
                cur$iv = $this$getAndUpdate$iv.getValue();
                tokens = (List)cur$iv;
                boolean bl = false;
            } while (!$this$getAndUpdate$iv.compareAndSet(cur$iv, (Object)(upd$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)token), (Iterable)tokens))));
        }
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf buildTalonConfig(@NotNull CliConfig cliConfig, @NotNull String apiEndpoint, @NotNull String authEndpoint, @NotNull String apiKey, @NotNull String hoastUrl, @NotNull String perchEndpoint, int numStoredSessions, @NotNull String logRollSize, int logRollCount, @NotNull String perchKey) {
        Intrinsics.checkNotNullParameter((Object)cliConfig, (String)"cliConfig");
        Intrinsics.checkNotNullParameter((Object)apiEndpoint, (String)"apiEndpoint");
        Intrinsics.checkNotNullParameter((Object)authEndpoint, (String)"authEndpoint");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)hoastUrl, (String)"hoastUrl");
        Intrinsics.checkNotNullParameter((Object)perchEndpoint, (String)"perchEndpoint");
        Intrinsics.checkNotNullParameter((Object)logRollSize, (String)"logRollSize");
        Intrinsics.checkNotNullParameter((Object)perchKey, (String)"perchKey");
        TalonMessages.TalonHawkScanConf talonHawkScanConf = cliConfig.getTalonConfig().toBuilder().setApiEndpoint(apiEndpoint).setAuthEndpoint(authEndpoint).setPerchEndpoint(perchEndpoint).setApiKey(apiKey).setHoastUrl(hoastUrl).setNumSessionsStored(numStoredSessions).setLogRollSize(logRollSize).setLogRollCount(logRollCount).setPreScanStartTimeMillis(Instant.now().toEpochMilli()).setPerchKey(perchKey).build();
        Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
        return talonHawkScanConf;
    }

    public static /* synthetic */ TalonMessages.TalonHawkScanConf buildTalonConfig$default(BootstrapUtils bootstrapUtils, CliConfig cliConfig, String string, String string2, String string3, String string4, String string5, int n, String string6, int n2, String string7, int n3, Object object) {
        if ((n3 & 2) != 0) {
            String string8 = cliConfig.getTalonConfig().getApiEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getApiEndpoint(...)");
            string = string8;
        }
        if ((n3 & 4) != 0) {
            String string9 = cliConfig.getTalonConfig().getAuthEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getAuthEndpoint(...)");
            string2 = string9;
        }
        if ((n3 & 8) != 0) {
            String string10 = cliConfig.getTalonConfig().getApiKey();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getApiKey(...)");
            string3 = string10;
        }
        if ((n3 & 0x10) != 0) {
            String string11 = cliConfig.getTalonConfig().getHoastUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getHoastUrl(...)");
            string4 = string11;
        }
        if ((n3 & 0x20) != 0) {
            String string12 = cliConfig.getTalonConfig().getPerchEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getPerchEndpoint(...)");
            string5 = string12;
        }
        if ((n3 & 0x40) != 0) {
            n = 4;
        }
        if ((n3 & 0x80) != 0) {
            string6 = "100MB";
        }
        if ((n3 & 0x100) != 0) {
            n2 = 10;
        }
        if ((n3 & 0x200) != 0) {
            String string13 = cliConfig.getTalonConfig().getPerchKey();
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getPerchKey(...)");
            string7 = string13;
        }
        return bootstrapUtils.buildTalonConfig(cliConfig, string, string2, string3, string4, string5, n, string6, n2, string7);
    }

    @NotNull
    public final OperatingSystem getOS() {
        OperatingSystem operatingSystem = this.getSystemInfo().getOperatingSystem();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"getOperatingSystem(...)");
        return operatingSystem;
    }

    public final boolean isInDocker(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        File directory = new File(directoryPath);
        return this.getOS() instanceof LinuxOperatingSystem && directory.isDirectory() && directory.exists();
    }

    public static /* synthetic */ boolean isInDocker$default(BootstrapUtils bootstrapUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/steve";
        }
        return bootstrapUtils.isInDocker(string);
    }

    public final boolean isDockerInternalHostSupported() {
        boolean bl;
        try {
            InetAddress.getByName("host.docker.internal");
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final boolean isDockerLocalHost(@NotNull String host, @NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        return this.isInDocker(directoryPath) && this.isLocalhost(host);
    }

    public static /* synthetic */ boolean isDockerLocalHost$default(BootstrapUtils bootstrapUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "/steve";
        }
        return bootstrapUtils.isDockerLocalHost(string, string2);
    }

    public final boolean isInKubernetes() {
        return System.getenv("KUBERNETES_SERVICE_HOST") != null;
    }

    @NotNull
    public final Pair<Integer, String> getDockerTarget(@NotNull String host, @NotNull String dockerGateway) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)dockerGateway, (String)"dockerGateway");
        String target = this.isDockerInternalHostSupported() ? "host.docker.internal" : dockerGateway;
        URI uri = new URI(host);
        int port = Utils.INSTANCE.port(uri);
        if (port < 1024) {
            String message = "Unable to scan localhost on ports 0..1023. Please use a permitted port 1024..65535 to proceed. Please refer to the Networking section of the Troubleshooting guide for more information. (https://docs.stackhawk.com/hawkscan/troubleshooting.html#networking)";
            throw new HawkScanNetworkingException(message, null, null, 6, null);
        }
        return new Pair((Object)port, (Object)(target + ":" + port));
    }

    public static /* synthetic */ Pair getDockerTarget$default(BootstrapUtils bootstrapUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = bootstrapUtils.defaultGateway();
        }
        return bootstrapUtils.getDockerTarget(string, string2);
    }

    @NotNull
    public final String defaultGateway() {
        String string = this.getSystemInfo().getOperatingSystem().getNetworkParams().getIpv4DefaultGateway();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIpv4DefaultGateway(...)");
        return string;
    }

    @NotNull
    public final String[] proxyCommandBuilder(@NotNull String host, @NotNull String dockerGateway) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)dockerGateway, (String)"dockerGateway");
        if (this.isLocalhost(host)) {
            Pair<Integer, String> target = this.getDockerTarget(host, dockerGateway);
            String[] stringArray = new String[]{"simpleproxy", "-L", String.valueOf(((Number)target.getFirst()).intValue()), "-R", target.getSecond()};
            return stringArray;
        }
        throw new ScannerConfigException("Invalid host URI", null, null, 6, null);
    }

    public static /* synthetic */ String[] proxyCommandBuilder$default(BootstrapUtils bootstrapUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = bootstrapUtils.defaultGateway();
        }
        return bootstrapUtils.proxyCommandBuilder(string, string2);
    }

    public final boolean isLocalhost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return localHostPattern.containsMatchIn((CharSequence)host);
    }

    @Nullable
    public final String startXvfb() {
        String string;
        if (BootstrapUtils.isInDocker$default(this, null, 1, null)) {
            int display = BootstrapUtils.checkXvfbLockFile$default(this, null, 1, null);
            String[] stringArray = new String[]{"Xvfb", ":" + display, "-screen", "0", "800x600x16", "-ac"};
            this.startProcess(stringArray, new File("/dev/null"));
            string = ":" + display + ".0";
        } else {
            string = null;
        }
        return string;
    }

    public final int checkXvfbLockFile(@NotNull String baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        int display = 1;
        String[] stringArray = new String[]{".X" + display + "-lock"};
        File lockFile = Path.of(baseDir, stringArray).toFile();
        while (lockFile.exists()) {
            stringArray = new String[]{".X" + ++display + "-lock"};
            lockFile = Path.of(baseDir, stringArray).toFile();
            if (display <= 5) continue;
            throw new InstalledEnvironmentException("No suitable Xvfb display could be created.", null, null, 6, null);
        }
        return display;
    }

    public static /* synthetic */ int checkXvfbLockFile$default(BootstrapUtils bootstrapUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/tmp";
        }
        return bootstrapUtils.checkXvfbLockFile(string);
    }

    @NotNull
    public final Process startProcess(@NotNull String[] commands, @Nullable File outputFile) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        File file = outputFile;
        if (file != null) {
            File it = file;
            boolean bl = false;
            processBuilder.redirectOutput(outputFile);
            processBuilder.redirectError(outputFile);
        }
        processBuilder.command(Arrays.copyOf(commands, commands.length));
        Process process = processBuilder.start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
        return process;
    }

    public static /* synthetic */ Process startProcess$default(BootstrapUtils bootstrapUtils, String[] stringArray, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return bootstrapUtils.startProcess(stringArray, file);
    }

    public final void thresholdCheck(@NotNull TalonMessages.SeverityCounts severityCounts, @NotNull HawkScanMessages.HawkConf hawkConf) {
        Intrinsics.checkNotNullParameter((Object)severityCounts, (String)"severityCounts");
        Intrinsics.checkNotNullParameter((Object)hawkConf, (String)"hawkConf");
        int alertsOverThreshold = ThresholdHelper.INSTANCE.countAlertsOverThreshold(severityCounts, hawkConf);
        if (alertsOverThreshold > 0) {
            String string = hawkConf.getFailureThreshold();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFailureThreshold(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            throw new OverThresholdException(alertsOverThreshold + " findings with severity greater than or equal to " + string2, null, null, 6, null);
        }
    }

    public final void hawkContext(@NotNull Context.Builder $this$hawkContext, boolean color) {
        Terminal terminal;
        Intrinsics.checkNotNullParameter((Object)$this$hawkContext, (String)"<this>");
        if (!color) {
            terminal = new Terminal(AnsiLevel.NONE, null, Integer.valueOf(120), null, null, 0, null, 122, null);
        } else {
            Theme hawkTheme2 = ThemeKt.Theme((Theme)$this$hawkContext.getTerminal().getTheme(), (Function1)hawkContext.hawkTheme.1.INSTANCE);
            terminal = new Terminal(null, hawkTheme2, Integer.valueOf(120), null, null, 0, null, 121, null);
        }
        $this$hawkContext.setTerminal(terminal);
        $this$hawkContext.setHelpFormatter((Function1)hawkContext.1.INSTANCE);
        $this$hawkContext.setLocalization((Localization)new HawkScanCommandLocalization(color));
        $this$hawkContext.setValueSource(HawkValuesSource.from$default(HawkValuesSource.INSTANCE, null, 1, null));
        JavaRuntimeResult javaRuntimeResult = JavaRuntimeChecker.INSTANCE.verifyCompatibleJVMVersion();
        if (!javaRuntimeResult.getCompatible()) {
            String allowedJavaVersions = CollectionsKt.joinToString$default((Iterable)javaRuntimeResult.getSupportedMajorJavaVersions(), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
            Terminal.danger$default((Terminal)$this$hawkContext.getTerminal(), (Object)StringsKt.trimIndent((String)("\n        Incompatible JVM version detected!\n        You are using Java " + javaRuntimeResult.getActualMajorVersion() + ".\n\n        Please use one of the following major Java versions: " + allowedJavaVersions + ".\n        ")), null, null, null, null, (boolean)false, (int)62, null);
            System.exit(78);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    public static /* synthetic */ void hawkContext$default(BootstrapUtils bootstrapUtils, Context.Builder builder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = !bootstrapUtils.defaultNoColor();
        }
        bootstrapUtils.hawkContext(builder, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String hawkScanVersionWithTag() {
        Object v2;
        block2: {
            void $this$mapTo$iv$iv;
            Enumeration<URL> enumeration = BootstrapUtils.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
            ArrayList<URL> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable $this$map$iv = arrayList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                URL uRL = (URL)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Manifest(it.openStream()).getMainAttributes());
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                Attributes it = (Attributes)e;
                boolean bl = false;
                if (!(it.getValue("Hawk-VersionWithTag") != null)) continue;
                v2 = e;
                break block2;
            }
            v2 = null;
        }
        Attributes attributes = v2;
        String string = attributes != null ? attributes.getValue("Hawk-VersionWithTag") : null;
        return string == null ? Utils.INSTANCE.hawkScanVersion() + "-dev" : string;
    }

    @NotNull
    public final HawkScanMessages.HawkRuntimeInfo hawkRuntimeInfo(@Nullable String cicdPlatform) {
        CharSequence charSequence;
        HawkScanMessages.HawkRuntimeInfo.Builder builder = HawkScanMessages.HawkRuntimeInfo.newBuilder();
        builder.setType(BootstrapUtils.isInDocker$default(this, null, 1, null) ? HawkScanMessages.HawkRuntimeInfo.Type.DOCKER : (!((charSequence = (CharSequence)cicdPlatform) == null || StringsKt.isBlank((CharSequence)charSequence)) ? HawkScanMessages.HawkRuntimeInfo.Type.CICD : HawkScanMessages.HawkRuntimeInfo.Type.CLI));
        charSequence = this.getOS();
        builder.setOs(charSequence instanceof MacOperatingSystem ? HawkScanMessages.HawkRuntimeInfo.OS.MACOS : (charSequence instanceof LinuxOperatingSystem ? HawkScanMessages.HawkRuntimeInfo.OS.LINUX : (charSequence instanceof WindowsOperatingSystem ? HawkScanMessages.HawkRuntimeInfo.OS.WINDOWS : HawkScanMessages.HawkRuntimeInfo.OS.UNKNOWN_OS)));
        builder.setArch(System.getProperty("os.arch", ""));
        builder.setOsVersion(System.getProperty("os.version", ""));
        String string = cicdPlatform;
        if (string != null) {
            String it = string;
            boolean bl = false;
            builder.setCicdPlatform(it);
        }
        HawkScanMessages.HawkRuntimeInfo hawkRuntimeInfo = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)hawkRuntimeInfo, (String)"build(...)");
        return hawkRuntimeInfo;
    }

    public static /* synthetic */ HawkScanMessages.HawkRuntimeInfo hawkRuntimeInfo$default(BootstrapUtils bootstrapUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return bootstrapUtils.hawkRuntimeInfo(string);
    }

    public final int thisProcessId() {
        return (int)ProcessHandle.current().pid();
    }

    @Nullable
    public final String thisProcessPath() {
        OSProcess procSelf;
        OSProcess oSProcess = procSelf = this.getSystemInfo().getOperatingSystem().getProcess(this.thisProcessId());
        return oSProcess != null ? oSProcess.getPath() : null;
    }

    @NotNull
    public final String osFamily() {
        String string = this.getSystemInfo().getOperatingSystem().getFamily();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFamily(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    public final boolean isWindows() {
        return Intrinsics.areEqual((Object)this.osFamily(), (Object)"windows");
    }

    public final boolean isLinux() {
        Object[] objectArray = new String[]{"ubuntu", "debian", "linux"};
        return CollectionsKt.listOf((Object[])objectArray).contains(this.osFamily());
    }

    public final boolean isMacOS() {
        return Intrinsics.areEqual((Object)this.osFamily(), (Object)"macos");
    }

    @NotNull
    public final Pair<String, String> getOSNativeTruststoreSettings(@Nullable Boolean useNativeTruststore) {
        String linuxCerts;
        String keychainPath;
        boolean shouldUseNative;
        if (BootstrapUtils.isInDocker$default(this, null, 1, null)) {
            return new Pair(null, null);
        }
        Boolean bl = useNativeTruststore;
        boolean bl2 = bl != null ? bl : (this.isMacOS() ? false : (this.isWindows() ? true : (shouldUseNative = this.isLinux())));
        if (!shouldUseNative) {
            return new Pair(null, null);
        }
        Pair pair = this.isMacOS() ? (new File(keychainPath = "/Library/Keychains/System.keychain").exists() ? new Pair((Object)keychainPath, (Object)"KeychainStore") : new Pair(null, null)) : (this.isWindows() ? new Pair(null, (Object)"WINDOWS-ROOT") : (this.isLinux() ? (new File(linuxCerts = "/etc/ssl/certs/java/cacerts").exists() ? new Pair((Object)linuxCerts, null) : new Pair(null, null)) : new Pair(null, null)));
        return pair;
    }

    public static /* synthetic */ Pair getOSNativeTruststoreSettings$default(BootstrapUtils bootstrapUtils, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return bootstrapUtils.getOSNativeTruststoreSettings(bl);
    }

    public final boolean thisProcessIsJava() {
        boolean bl;
        String string = this.thisProcessPath();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = Path.of(it, new String[0]).getFileName().startsWith("java");
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean thisProcessIsHawkExe() {
        if (!this.isWindows()) return false;
        String string = this.thisProcessPath();
        if (string == null) return false;
        String it = string;
        boolean bl = false;
        if (!Path.of(it, new String[0]).getFileName().startsWith("hawk.exe")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean thisProcessIsHawkMacOS() {
        if (!this.isMacOS()) return false;
        String string = this.thisProcessPath();
        if (string == null) return false;
        String it = string;
        boolean bl = false;
        if (!Path.of(it, new String[0]).getFileName().startsWith("hawk")) return false;
        if (!Path.of(it, new String[0]).getParent().getFileName().startsWith("MacOS")) return false;
        return true;
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf parseConfig(@NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull List<String> configFiles, @Nullable String envFile, @NotNull Map<String, String> env, @Nullable AdvancedScanOptions advancedOptions, boolean noColor, @NotNull String repoDir, @NotNull BasicHttpClient httpClient, @Nullable AssetManagerClient assetManagerClient, @Nullable StackHawkApiClient stackHawkApiClient) {
        Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
        Intrinsics.checkNotNullParameter(configFiles, (String)"configFiles");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)repoDir, (String)"repoDir");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        try {
            TalonMessages.TalonHawkScanConf.Builder builder = talonConfig.toBuilder();
            Map<String, String> map = Config.INSTANCE.parseEnvVarsFile(envFile);
            Map<String, String> map2 = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
            AdvancedScanOptions advancedScanOptions = advancedOptions;
            AdvancedScanOptions advancedScanOptions2 = advancedOptions;
            TalonMessages.TalonHawkScanConf talonHawkScanConf = builder.mergeHawkscanConf(this.parseStackHawkYamlFiles(new ConfigResolverOptions(configFiles, MapsKt.plus((Map)MapsKt.plus(map, map2), env), null, false, httpClient, assetManagerClient, new AppVariables(TalonHawkScanConfExtensions.INSTANCE.applicationId(talonConfig), TalonHawkScanConfExtensions.INSTANCE.environment(talonConfig)), 12, null), noColor, stackHawkApiClient)).setBaseDir(repoDir).setGitlabDastArtifact(advancedScanOptions != null ? advancedScanOptions.getDastArtifact() : false).setSarifArtifact(advancedScanOptions2 != null ? advancedScanOptions2.getSarifArtifact() : false).build();
            Intrinsics.checkNotNullExpressionValue((Object)talonHawkScanConf, (String)"build(...)");
            return talonHawkScanConf;
        }
        catch (HawkScanException he) {
            throw he;
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Parsing error";
            }
            throw new ConfException(string, e, "config-verify.linting.parse", null, 8, null);
        }
    }

    public static /* synthetic */ TalonMessages.TalonHawkScanConf parseConfig$default(BootstrapUtils bootstrapUtils, TalonMessages.TalonHawkScanConf talonHawkScanConf, List list, String string, Map map, AdvancedScanOptions advancedScanOptions, boolean bl, String string2, BasicHttpClient basicHttpClient, AssetManagerClient assetManagerClient, StackHawkApiClient stackHawkApiClient, int n, Object object) {
        if ((n & 0x10) != 0) {
            advancedScanOptions = null;
        }
        if ((n & 0x80) != 0) {
            basicHttpClient = Utils.INSTANCE.createHttpClient();
        }
        if ((n & 0x100) != 0) {
            assetManagerClient = null;
        }
        return bootstrapUtils.parseConfig(talonHawkScanConf, list, string, map, advancedScanOptions, bl, string2, basicHttpClient, assetManagerClient, stackHawkApiClient);
    }

    @NotNull
    public final HawkScanMessages.HawkscanConf parseStackHawkYamlFiles(@NotNull ConfigResolverOptions options, boolean noColor, @Nullable StackHawkApiClient stackHawkApiClient) {
        HawkScanMessages.HawkscanConf hawkscanConf;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        try {
            hawkscanConf = Config.INSTANCE.parseStackHawkYamlFiles(options, stackHawkApiClient);
        }
        catch (InvalidYamlFileException yamlFileException) {
            throw new InvalidYamlException(ErrorUtils.INSTANCE.createInvalidYamlExceptionMessage(yamlFileException, noColor), null, null, 6, null);
        }
        catch (HawkScanException he) {
            throw he;
        }
        catch (SchemaException schemaException) {
            if (schemaException instanceof ListValidationException) {
                throw new ConfigValidationException(new HawkValidationError((ListValidationException)schemaException, noColor).yamlStringWithErrors(), schemaException, null, 4, null);
            }
            String string = schemaException.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new ConfigValidationException(string, schemaException, null, 4, null);
        }
        catch (Exception e) {
            throw ErrorUtils.INSTANCE.genericConfException(e);
        }
        return hawkscanConf;
    }

    public static /* synthetic */ HawkScanMessages.HawkscanConf parseStackHawkYamlFiles$default(BootstrapUtils bootstrapUtils, ConfigResolverOptions configResolverOptions, boolean bl, StackHawkApiClient stackHawkApiClient, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return bootstrapUtils.parseStackHawkYamlFiles(configResolverOptions, bl, stackHawkApiClient);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> listSessionDirs(@NotNull String sessionHomeDir) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sessionHomeDir, (String)"sessionHomeDir");
        Collection collection = FileUtils.listFilesAndDirs((File)Path.of(sessionHomeDir, new String[0]).toFile(), (IOFileFilter)DirectoryFileFilter.DIRECTORY, null);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"listFilesAndDirs(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!uuidPattern.matches((CharSequence)string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    public final void cleanupSessionDirectories(@NotNull String sessionHomeDir, int keepLast) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)sessionHomeDir, (String)"sessionHomeDir");
            if (!Path.of(sessionHomeDir, new String[0]).toFile().exists()) break block8;
            $this$filter$iv = this.listSessionDirs(sessionHomeDir);
            $i$f$filter = false;
            var5_5 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var8_11 = $this$filterTo$iv$iv.iterator();
            while (var8_11.hasNext()) {
                element$iv$iv = var8_11.next();
                it = (File)element$iv$iv;
                $i$a$-filter-BootstrapUtils$cleanupSessionDirectories$1 = false;
                v0 = it.listFiles();
                v1 = v0 != null ? v0.length == 1 : false;
                if (!v1) ** GOTO lbl-1000
                var12_17 = it.listFiles();
                v2 = var12_17;
                if (var12_17 == null) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)v2);
                v2 = (File)ArraysKt.first((Object[])var12_17);
                if (v2 != null) {
                    v3 = v2.getName();
                } else lbl-1000:
                // 2 sources

                {
                    v3 = null;
                }
                if (Intrinsics.areEqual(v3, (Object)"log4j2.properties")) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                $i$a$-forEach-BootstrapUtils$cleanupSessionDirectories$2 = false;
                FileUtils.deleteDirectory((File)it);
            }
            sessionDirs = this.listSessionDirs(sessionHomeDir);
            last = sessionDirs.size() - keepLast;
            if (last > 0) {
                $this$sortedByDescending$iv = sessionDirs;
                $i$f$sortedByDescending = false;
                $this$forEach$iv = CollectionsKt.takeLast((List)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        File it = (File)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.lastModified());
                        it = (File)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
                    }
                }), (int)last);
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (File)element$iv;
                    $i$a$-forEach-BootstrapUtils$cleanupSessionDirectories$4 = false;
                    FileUtils.deleteDirectory((File)it);
                }
            }
        }
    }

    public static /* synthetic */ void cleanupSessionDirectories$default(BootstrapUtils bootstrapUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        bootstrapUtils.cleanupSessionDirectories(string, n);
    }

    public final void createScanSessionDirectory(@NotNull Path sessionDir, @NotNull String logRollSize, int logRollCount) {
        Intrinsics.checkNotNullParameter((Object)sessionDir, (String)"sessionDir");
        Intrinsics.checkNotNullParameter((Object)logRollSize, (String)"logRollSize");
        Files.createDirectories(sessionDir, new FileAttribute[0]);
        this.createLog4jPropertiesFile(sessionDir, logRollSize, logRollCount);
    }

    public static /* synthetic */ void createScanSessionDirectory$default(BootstrapUtils bootstrapUtils, Path path, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "100MB";
        }
        if ((n2 & 4) != 0) {
            n = 10;
        }
        bootstrapUtils.createScanSessionDirectory(path, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createLog4jPropertiesFile(@NotNull Path dir, @NotNull String logRollSize, int logRollCount) {
        Closeable closeable;
        Object v3;
        Object object;
        Object object2;
        File log4jFile;
        block7: {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)logRollSize, (String)"logRollSize");
            log4jFile = dir.resolve("log4j2.properties").toFile();
            if (log4jFile.exists()) {
                log4jFile.delete();
            }
            Enumeration<URL> enumeration = BootstrapUtils.class.getClassLoader().getResources("log4j2.properties");
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
            ArrayList<URL> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            object2 = arrayList;
            object = object2.iterator();
            while (object.hasNext()) {
                Object t = object.next();
                URL it = (URL)t;
                boolean bl = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"talon-common", (boolean)false, (int)2, null)) continue;
                v3 = t;
                break block7;
            }
            v3 = null;
        }
        URL uRL = v3;
        InputStream resourceStream = uRL != null && (closeable = uRL.openStream()) != null ? closeable : BootstrapUtils.class.getResourceAsStream("/log4j2.properties");
        Intrinsics.checkNotNull((Object)resourceStream);
        closeable = resourceStream;
        object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)closeable, (Charset)object2);
        int n = 8192;
        closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        Object resourceStreamText = object;
        String logRollSizeStringToReplace = "${logRollSize:-100MB}";
        String logRollCountStringToReplace = "${logRollCount:10}";
        object = StringsKt.replace$default((String)StringsKt.replace$default((String)resourceStreamText, (String)logRollSizeStringToReplace, (String)logRollSize, (boolean)false, (int)4, null), (String)logRollCountStringToReplace, (String)String.valueOf(logRollCount), (boolean)false, (int)4, null);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        InputStream inputStream = new ByteArrayInputStream(byArray);
        Intrinsics.checkNotNull((Object)log4jFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(log4jFile));
    }

    @NotNull
    public final String inferredJavaHome() {
        String string;
        block7: {
            block6: {
                String string2;
                if (this.thisProcessIsHawkExe() && (string2 = this.thisProcessPath()) != null) {
                    String it = string2;
                    boolean bl = false;
                    return ((Object)Path.of(it, new String[0]).getParent()).toString();
                }
                if (this.thisProcessIsHawkMacOS() && (string2 = this.thisProcessPath()) != null) {
                    String it = string2;
                    boolean bl = false;
                    return ((Object)Path.of(it, new String[0]).getParent().getParent().resolve("runtime/Contents/Home")).toString();
                }
                String javaHome = System.getenv(JAVA_HOME);
                if (javaHome != null) {
                    return javaHome;
                }
                string = this.thisProcessPath();
                if (string == null) break block6;
                String it = string;
                boolean bl = false;
                String string3 = ((Object)Path.of(it, new String[0]).getParent().getParent()).toString();
                string = string3;
                if (string3 != null) break block7;
            }
            throw new UnexpectedError("JAVA_HOME or the java executable runtime path cannot be found or inferred.", null, null, 6, null);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<Integer> getPids() {
        v0 = this.getSystemInfo().getOperatingSystem().getProcesses();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProcesses(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (OSProcess)element$iv$iv;
            $i$a$-filter-BootstrapUtils$getPids$1 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"java") && !Intrinsics.areEqual((Object)it.getName(), (Object)"javaw")) ** GOTO lbl-1000
            v1 = it.getCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getCommandLine(...)");
            if (!StringsKt.contains$default((CharSequence)v1, (CharSequence)"hawkscan", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v2 = it.getCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCommandLine(...)");
            if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"hste", (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (OSProcess)item$iv$iv;
            var10_10 = destination$iv$iv;
            $i$a$-map-BootstrapUtils$getPids$2 = false;
            var10_10.add(it.getProcessID());
        }
        return (List)destination$iv$iv;
    }

    public final void stopProcess(int pid) {
        OSProcess process;
        OSProcess oSProcess = process = this.daemonProcess(pid);
        if (oSProcess != null) {
            OSProcess it = oSProcess;
            boolean bl = false;
            v1 = INSTANCE.getOS() instanceof WindowsOperatingSystem ? Runtime.getRuntime().exec("taskkill /PID " + pid + " /F") : Runtime.getRuntime().exec("kill -9 " + pid);
        } else {
            v1 = null;
        }
    }

    @Nullable
    public final OSProcess daemonProcess(int pid) {
        return this.getSystemInfo().getOperatingSystem().getProcess(pid);
    }

    @NotNull
    public final String checkoutGitRepo(@NotNull String gitUrl, @Nullable String gitRev, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)gitUrl, (String)"gitUrl");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        String string = new GitWrapper(gitUrl, gitRev, consolePrinter).init().cloneAndCheckoutGitRepo().getProjectDirFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean confirmBrowserForAjax(@NotNull String browserName) {
        Intrinsics.checkNotNullParameter((Object)browserName, (String)"browserName");
        OperatingSystem os = this.getOS();
        if (BrowserUtils.INSTANCE.checkIfBrowserIsInstalled(os, browserName)) {
            return true;
        }
        String string = BrowserUtils.INSTANCE.convertBrowserName(browserName);
        if (Intrinsics.areEqual((Object)string, (Object)"firefox")) {
            if (BrowserUtils.INSTANCE.checkIfBrowserIsInstalled(os, "chrome")) {
                throw new ScannerConfigException("Firefox is not installed, try Chrome instead.", null, null, 6, null);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"chrome") && BrowserUtils.INSTANCE.checkIfBrowserIsInstalled(os, "firefox")) {
            throw new ScannerConfigException("Chrome is not installed, try Firefox instead.", null, null, 6, null);
        }
        throw new ScannerConfigException("No supported browser detected. HawkScan supports Chrome and Firefox.", null, null, 6, null);
    }

    static {
        String string = System.getProperty("user.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        userName = string;
        String string2 = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        userHome = string2;
        installDir = Utils.INSTANCE.jarLocation(Reflection.getOrCreateKotlinClass(Bootstrap.class));
        logDir = ((Object)Path.of(userHome + "/.hawk/logs", new String[0])).toString();
        logFile = ((Object)Path.of(logDir + "/hawkscan.log", new String[0])).toString();
        hawkscanVersion = Utils.INSTANCE.hawkScanVersion();
        cwd = BootstrapUtils.isInDocker$default(INSTANCE, null, 1, null) ? "/hawk" : ((Object)Paths.get("", new String[0]).toAbsolutePath()).toString();
        defaultSessionHome = ((Object)Path.of(userHome + "/.hawk/sessions", new String[0])).toString();
        defaultSessionHomeFile = new File(defaultSessionHome);
        localHostPattern = new Regex("(?:http[s]?://)?(?:localhost|127.0.0.1)(/.*)?");
        uuidPattern = new Regex("\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b");
        Object[] objectArray = new String[]{"", "k", "m", "g", "t", "p"};
        memUnits = CollectionsKt.listOf((Object[])objectArray);
    }
}

