/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.google.protobuf.ProtocolStringList;
import com.stackhawk.hste.Bootstrap;
import com.stackhawk.hste.BootstrapUtils;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.HawkValuesSource;
import com.stackhawk.hste.HsteCommand;
import com.stackhawk.hste.MetaDataParser;
import com.stackhawk.hste.PlatformApi;
import com.stackhawk.hste.config.HsteLoggingOptions;
import com.stackhawk.hste.config.HsteStarterOptions;
import com.stackhawk.hste.extension.talon.HawkConfExtensions;
import com.stackhawk.hste.extension.talon.TalonHawkScanConfExtensions;
import com.stackhawk.hste.extension.talon.client.AssetManagerClient;
import com.stackhawk.hste.extension.talon.client.BasicHttpClient;
import com.stackhawk.hste.extension.talon.client.StackHawkAWSClient;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClientConfig;
import com.stackhawk.hste.extension.talon.hawkscan.api.CreateApplicationException;
import com.stackhawk.hste.extension.talon.hawkscan.api.CustomPluginRegistrationException;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanException;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanNetworkingException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidApiKeyException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidAppIdException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidScanIdException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidSecurityCertificateException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScanLogException;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScanNotFound;
import com.stackhawk.hste.extension.talon.hawkscan.api.ScanPolicyException;
import com.stackhawk.hste.handlers.ScanResponseOutputHandler;
import com.stackhawk.hste.handlers.ScanResponseOutputHandlerImpl;
import com.stackhawk.hste.logger.LoggerUtils;
import com.stackhawk.http.HttpClient;
import com.stackhawk.nest.ApplicationService;
import com.stackhawk.nest.Auth;
import com.stackhawk.nest.HawkScanMessages;
import com.stackhawk.nest.OrganizationMessages;
import com.stackhawk.nest.ScanResultMessages;
import com.stackhawk.nest.TalonMessages;
import com.stackhawk.nest.TeamMessages;
import com.stackhawk.nest.UserMessages;
import de.skuzzle.semantic.Version;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.SSLException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 {2\u00020\u0001:\u0001{B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001fJ(\u0010!\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0007J\u0006\u0010'\u001a\u00020(J&\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0002J\u001a\u00107\u001a\u0004\u0018\u00010\u00072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020:H\u0007J \u0010;\u001a\u0014\u0012\u0004\u0012\u00020=\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0>0<2\u0006\u00108\u001a\u00020\u0007J<\u0010?\u001a\u00020#2\u0006\u00106\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%2\u0006\u00108\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u0007H\u0002J\u0016\u0010D\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010E2\u0006\u00106\u001a\u00020\u0007J\u0010\u0010G\u001a\u0004\u0018\u00010\u00072\u0006\u00108\u001a\u00020\u0007J\u000e\u0010H\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007J\u0006\u0010I\u001a\u00020JJ\u001c\u0010K\u001a\b\u0012\u0004\u0012\u00020L0>2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u0007J\u000e\u0010N\u001a\u00020(2\u0006\u00106\u001a\u00020\u0007J&\u0010O\u001a\n\u0012\u0004\u0012\u00020P\u0018\u00010>2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0007J\u0016\u0010Q\u001a\u00020(2\u0006\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020TJ\u0016\u0010U\u001a\u00020\u00072\u0006\u0010V\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007J\u00a8\u0001\u0010W\u001a\u00020X2\u0006\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010Y\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010[0Z2\u0010\b\u0002\u0010\\\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010]0Z2\u0006\u0010^\u001a\u00020_2\u0014\b\u0002\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070<2\u0006\u0010`\u001a\u00020a2\u000e\b\u0002\u0010b\u001a\b\u0012\u0004\u0012\u00020c0>2\u000e\b\u0002\u0010d\u001a\b\u0012\u0004\u0012\u00020f0e2\b\b\u0002\u0010g\u001a\u00020\u00072\b\b\u0002\u0010h\u001a\u00020\u001f2\b\b\u0002\u0010i\u001a\u00020\u001f2\u0010\b\u0002\u0010j\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010>J\u0018\u0010k\u001a\u00020%2\u0006\u0010l\u001a\u00020\u00072\b\b\u0002\u0010m\u001a\u00020nJB\u0010o\u001a\u000e\u0012\u0004\u0012\u00020]\u0012\u0004\u0012\u0002000\"2\u0006\u00101\u001a\u0002022\u0014\b\u0002\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070<2\u0010\b\u0002\u0010\\\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010]0ZJ\"\u0010p\u001a\u0002042\u0006\u00105\u001a\u00020\u00072\b\b\u0002\u0010q\u001a\u00020\u000b2\b\b\u0002\u0010r\u001a\u00020sJ,\u0010t\u001a\u0004\u0018\u00010*2\u0006\u0010u\u001a\u00020v2\u001a\b\u0002\u0010w\u001a\u0014\u0012\u0004\u0012\u00020=\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0>0<J$\u0010x\u001a\u00020(2\u0006\u00108\u001a\u00020\u00072\f\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00070>2\u0006\u0010z\u001a\u00020\u0007R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006|"}, d2={"Lcom/stackhawk/hste/CommandExecutor;", "", "talonConfig", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "basicHttpClient", "Lcom/stackhawk/hste/extension/talon/client/BasicHttpClient;", "hawkscanVersion", "", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "apiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "(Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;Lcom/stackhawk/hste/extension/talon/client/BasicHttpClient;Ljava/lang/String;Lcom/stackhawk/hste/ConsolePrinter;Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;)V", "LOG", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getApiClient", "()Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "getBasicHttpClient", "()Lcom/stackhawk/hste/extension/talon/client/BasicHttpClient;", "getConsolePrinter", "()Lcom/stackhawk/hste/ConsolePrinter;", "getHawkscanVersion", "()Ljava/lang/String;", "getTalonConfig", "()Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "setTalonConfig", "(Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;)V", "authenticate", "Lcom/stackhawk/nest/Auth$JWT;", "removeApiKeyProperty", "", "hawkInit", "beforeScan", "Lkotlin/Pair;", "Lcom/stackhawk/nest/ScanResultMessages$BeforeScan;", "metadata", "Lcom/stackhawk/nest/HawkScanMessages$ScanMetadata;", "parentScanId", "checkForNewerVersion", "", "createApplication", "Lcom/stackhawk/nest/ApplicationService$Application;", "organizationId", "applicationName", "environmentName", "teamId", "createHsteCommand", "Lcom/stackhawk/hste/HsteCommand;", "hsteStarterOptions", "Lcom/stackhawk/hste/config/HsteStarterOptions;", "createZip", "Ljava/io/File;", "logFile", "scanId", "errorScan", "applicationId", "errorResult", "Lcom/stackhawk/nest/ScanResultMessages$ScanResult;", "getAppOrgs", "", "Lcom/stackhawk/nest/UserMessages$UserOrganization;", "", "getBeforeScanPayload", "environment", "hawkscanConf", "Lcom/stackhawk/nest/HawkScanMessages$HawkscanConf;", "scanParentId", "getLastScanAlertPlugins", "", "Lcom/stackhawk/nest/ApplicationService$ApplicationAlert;", "getLastScanId", "getScanLogUrl", "getUser", "Lcom/stackhawk/nest/UserMessages$UserResponse;", "getUserTeams", "Lcom/stackhawk/nest/TeamMessages$Team;", "userId", "isValidScanId", "listCustomPlugins", "Lcom/stackhawk/nest/OrganizationMessages$Plugin;", "printScanLog", "url", "awsClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkAWSClient;", "registerCustomPluginID", "name", "runHsteProcess", "", "scanResponseOutputHandlerRef", "Lkotlinx/atomicfu/AtomicRef;", "Lcom/stackhawk/hste/handlers/ScanResponseOutputHandler;", "hsteProcessRef", "Ljava/lang/Process;", "sessionDir", "Ljava/nio/file/Path;", "hsteLoggingOptions", "Lcom/stackhawk/hste/config/HsteLoggingOptions;", "displayBrowsers", "Lcom/stackhawk/nest/HawkScanMessages$HawkConf$Spider$AjaxBrowser;", "scanResponseChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/stackhawk/nest/TalonMessages$TalonScanResponse;", "startUpMsg", "hsteUI", "jvmDebugServer", "jvmOpts", "scanMetadata", "repoPath", "hawkRuntimeInfo", "Lcom/stackhawk/nest/HawkScanMessages$HawkRuntimeInfo;", "startHSTE", "uploadHawkScanLog", "stackHawkApiClient", "assetManagerClient", "Lcom/stackhawk/hste/extension/talon/client/AssetManagerClient;", "validateAppAndEnvironment", "appConf", "Lcom/stackhawk/nest/HawkScanMessages$AppConf;", "allOrgApps", "validateFeatureFlag", "requiredFlags", "feature", "Companion", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandExecutor.kt\ncom/stackhawk/hste/CommandExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,515:1\n1#2:516\n1863#3,2:517\n1557#3:522\n1628#3,3:523\n535#4:519\n520#4,2:520\n522#4,4:526\n*S KotlinDebug\n*F\n+ 1 CommandExecutor.kt\ncom/stackhawk/hste/CommandExecutor\n*L\n355#1:517,2\n504#1:522\n504#1:523,3\n503#1:519\n503#1:520,2\n503#1:526,4\n*E\n"})
public final class CommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TalonMessages.TalonHawkScanConf talonConfig;
    @NotNull
    private final BasicHttpClient basicHttpClient;
    @NotNull
    private final String hawkscanVersion;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final StackHawkApiClient apiClient;
    private final Logger LOG;

    public CommandExecutor(@NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull BasicHttpClient basicHttpClient, @NotNull String hawkscanVersion, @NotNull ConsolePrinter consolePrinter, @NotNull StackHawkApiClient apiClient) {
        Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
        Intrinsics.checkNotNullParameter((Object)basicHttpClient, (String)"basicHttpClient");
        Intrinsics.checkNotNullParameter((Object)hawkscanVersion, (String)"hawkscanVersion");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        this.talonConfig = talonConfig;
        this.basicHttpClient = basicHttpClient;
        this.hawkscanVersion = hawkscanVersion;
        this.consolePrinter = consolePrinter;
        this.apiClient = apiClient;
        this.LOG = LogManager.getLogger(this.getClass());
    }

    public /* synthetic */ CommandExecutor(TalonMessages.TalonHawkScanConf talonHawkScanConf, BasicHttpClient basicHttpClient, String string, ConsolePrinter consolePrinter, StackHawkApiClient stackHawkApiClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            basicHttpClient = new BasicHttpClient(null, 1, null);
        }
        if ((n & 4) != 0) {
            string = BootstrapUtils.INSTANCE.getHawkscanVersion();
        }
        if ((n & 8) != 0) {
            consolePrinter = new ConsolePrinter(null, false, false, false, false, null, 63, null);
        }
        if ((n & 0x10) != 0) {
            stackHawkApiClient = com.stackhawk.hste.CommandExecutor$Companion.defaultStackHawkApiClient$default(Companion, talonHawkScanConf, null, 2, null);
        }
        this(talonHawkScanConf, basicHttpClient, string, consolePrinter, stackHawkApiClient);
    }

    @NotNull
    public final TalonMessages.TalonHawkScanConf getTalonConfig() {
        return this.talonConfig;
    }

    public final void setTalonConfig(@NotNull TalonMessages.TalonHawkScanConf talonHawkScanConf) {
        Intrinsics.checkNotNullParameter((Object)talonHawkScanConf, (String)"<set-?>");
        this.talonConfig = talonHawkScanConf;
    }

    @NotNull
    public final BasicHttpClient getBasicHttpClient() {
        return this.basicHttpClient;
    }

    @NotNull
    public final String getHawkscanVersion() {
        return this.hawkscanVersion;
    }

    @NotNull
    public final ConsolePrinter getConsolePrinter() {
        return this.consolePrinter;
    }

    @NotNull
    public final StackHawkApiClient getApiClient() {
        return this.apiClient;
    }

    public final void checkForNewerVersion() {
        String response2 = BasicHttpClient.getStringBody$default(this.basicHttpClient, "https://api.stackhawk.com/hawkscan/version", null, 2, null);
        String latestVersion = ((Object)StringsKt.trim((CharSequence)response2)).toString();
        Version ver = Version.parseVersion((String)this.hawkscanVersion);
        Version latestVer = Version.parseVersion((String)latestVersion);
        if (latestVer.isGreaterThan(ver)) {
            ConsolePrinter.logNewVersionMessage$default(this.consolePrinter, latestVersion, BootstrapUtils.isInDocker$default(BootstrapUtils.INSTANCE, null, 1, null), false, false, 12, null);
        }
    }

    @NotNull
    public final Auth.JWT authenticate(boolean removeApiKeyProperty, boolean hawkInit) {
        Auth.JWT jWT;
        try {
            jWT = this.apiClient.getJwtTokenObj(hawkInit);
        }
        catch (Exception e) {
            Throwable throwable;
            Throwable cause;
            Throwable throwable2 = e.getCause();
            if (throwable2 == null) {
                throwable2 = cause = (Throwable)e;
            }
            if (removeApiKeyProperty) {
                HawkValuesSource.removeProperty$default(HawkValuesSource.INSTANCE, "api-key", null, 2, null);
            }
            if ((throwable = cause) instanceof SSLException ? true : throwable instanceof CertificateException) {
                throw new InvalidSecurityCertificateException("Unable to verify certificate. The Trust chain for the certificate may not be able to be verified. This could indicate a transparent TLS proxy intercepting the traffic or other Person-In-The-Middle issue. If you need help troubleshooting this issue, please reach out to support@stackhawk.com  " + e.getMessage(), e, null, 4, null);
            }
            if (((throwable instanceof HttpHostConnectException ? true : throwable instanceof ConnectException) ? true : throwable instanceof SocketException) ? true : throwable instanceof SocketTimeoutException) {
                throw new HawkScanNetworkingException("Error authenticating to StackHawk: " + e.getMessage(), e, null, 4, null);
            }
            throw new InvalidApiKeyException("Error authenticating to StackHawk: " + e.getMessage(), e, null, 4, null);
        }
        return jWT;
    }

    public static /* synthetic */ Auth.JWT authenticate$default(CommandExecutor commandExecutor, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return commandExecutor.authenticate(bl, bl2);
    }

    @Nullable
    public final ApplicationService.Application validateAppAndEnvironment(@NotNull HawkScanMessages.AppConf appConf, @NotNull Map<UserMessages.UserOrganization, ? extends List<ApplicationService.Application>> allOrgApps) {
        Intrinsics.checkNotNullParameter((Object)appConf, (String)"appConf");
        Intrinsics.checkNotNullParameter(allOrgApps, (String)"allOrgApps");
        try {
            String string = appConf.getApplicationId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationId(...)");
            String string2 = appConf.getEnv();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEnv(...)");
            ApplicationService.Application application = PlatformApi.INSTANCE.resolveOrgAppsAndEnv(string, string2, allOrgApps, this.apiClient);
            ApplicationService.Application application2 = application;
            if (application2 == null) {
                throw new Exception("Could not resolve application");
            }
            return application2;
        }
        catch (Exception e) {
            if (e instanceof ScanPolicyException) {
                throw e;
            }
            throw new InvalidAppIdException("Unable to validate applicationId: " + appConf.getApplicationId() + System.lineSeparator() + e.getMessage(), e, "platform.invalid-app-id");
        }
    }

    public static /* synthetic */ ApplicationService.Application validateAppAndEnvironment$default(CommandExecutor commandExecutor, HawkScanMessages.AppConf appConf, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return commandExecutor.validateAppAndEnvironment(appConf, map);
    }

    @NotNull
    public final HawkScanMessages.ScanMetadata scanMetadata(@NotNull String repoPath, @NotNull HawkScanMessages.HawkRuntimeInfo hawkRuntimeInfo) {
        Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
        Intrinsics.checkNotNullParameter((Object)hawkRuntimeInfo, (String)"hawkRuntimeInfo");
        HawkScanMessages.ScanMetadata.Builder builder = MetaDataParser.INSTANCE.scanMetadataBuilder(repoPath);
        builder.setHawkRuntimeInfo(hawkRuntimeInfo);
        HawkScanMessages.ScanMetadata scanMetadata = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)scanMetadata, (String)"build(...)");
        return scanMetadata;
    }

    public static /* synthetic */ HawkScanMessages.ScanMetadata scanMetadata$default(CommandExecutor commandExecutor, String string, HawkScanMessages.HawkRuntimeInfo hawkRuntimeInfo, int n, Object object) {
        if ((n & 2) != 0) {
            hawkRuntimeInfo = BootstrapUtils.hawkRuntimeInfo$default(BootstrapUtils.INSTANCE, null, 1, null);
        }
        return commandExecutor.scanMetadata(string, hawkRuntimeInfo);
    }

    @NotNull
    public final Pair<String, ScanResultMessages.BeforeScan> beforeScan(@NotNull HawkScanMessages.ScanMetadata metadata, @Nullable String parentScanId) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        String string = this.talonConfig.getScanId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScanId(...)");
        String string2 = TalonHawkScanConfExtensions.INSTANCE.applicationId(this.talonConfig);
        String string3 = TalonHawkScanConfExtensions.INSTANCE.environment(this.talonConfig);
        HawkScanMessages.HawkscanConf hawkscanConf = this.talonConfig.getHawkscanConf();
        Intrinsics.checkNotNullExpressionValue((Object)hawkscanConf, (String)"getHawkscanConf(...)");
        ScanResultMessages.BeforeScan payload = this.getBeforeScanPayload(string, metadata, string2, string3, HawkConfExtensions.INSTANCE.redacted(hawkscanConf), parentScanId);
        return TuplesKt.to((Object)PlatformApi.INSTANCE.sendBeforeScan(TalonHawkScanConfExtensions.INSTANCE.applicationId(this.talonConfig), payload, this.apiClient), (Object)payload);
    }

    public static /* synthetic */ Pair beforeScan$default(CommandExecutor commandExecutor, HawkScanMessages.ScanMetadata scanMetadata, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return commandExecutor.beforeScan(scanMetadata, string);
    }

    private final ScanResultMessages.BeforeScan getBeforeScanPayload(String scanId, HawkScanMessages.ScanMetadata metadata, String applicationId2, String environment, HawkScanMessages.HawkscanConf hawkscanConf, String scanParentId) {
        ScanResultMessages.BeforeScan.Builder builder = ScanResultMessages.BeforeScan.newBuilder();
        ScanResultMessages.Scan.Builder builder2 = ScanResultMessages.Scan.newBuilder().setId(scanId);
        ProtocolStringList protocolStringList = metadata.getUpstreamReposList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getUpstreamReposList(...)");
        ScanResultMessages.Scan.Builder builder3 = builder2.setRepoId((String)CollectionsKt.first((List)((List)protocolStringList))).setTimestamp(Instant.now().toEpochMilli()).setVersion(this.hawkscanVersion).setApplicationId(applicationId2).setEnv(environment);
        String string = scanParentId;
        if (string == null) {
            string = "";
        }
        ScanResultMessages.BeforeScan beforeScan = builder.setScan(builder3.setParentScanId(string).build()).setConfig(HawkScanMessages.HawkscanConf.newBuilder().mergeFrom(hawkscanConf)).setMetadata(HawkScanMessages.ScanMetadata.newBuilder().mergeFrom(metadata)).build();
        Intrinsics.checkNotNullExpressionValue((Object)beforeScan, (String)"build(...)");
        return beforeScan;
    }

    static /* synthetic */ ScanResultMessages.BeforeScan getBeforeScanPayload$default(CommandExecutor commandExecutor, String string, HawkScanMessages.ScanMetadata scanMetadata, String string2, String string3, HawkScanMessages.HawkscanConf hawkscanConf, String string4, int n, Object object) {
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        return commandExecutor.getBeforeScanPayload(string, scanMetadata, string2, string3, hawkscanConf, string4);
    }

    @NotNull
    public final File uploadHawkScanLog(@NotNull String logFile, @NotNull StackHawkApiClient stackHawkApiClient, @NotNull AssetManagerClient assetManagerClient) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        Intrinsics.checkNotNullParameter((Object)stackHawkApiClient, (String)"stackHawkApiClient");
        Intrinsics.checkNotNullParameter((Object)assetManagerClient, (String)"assetManagerClient");
        String string = this.talonConfig.getScanId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScanId(...)");
        File zipFile = this.createZip(logFile, string);
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)assetManagerClient.getApiClient().getDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SimpleHttpResponse>, Object>(assetManagerClient, this, zipFile, null){
            int label;
            final /* synthetic */ AssetManagerClient $assetManagerClient;
            final /* synthetic */ CommandExecutor this$0;
            final /* synthetic */ File $zipFile;
            {
                this.$assetManagerClient = $assetManagerClient;
                this.this$0 = $receiver;
                this.$zipFile = $zipFile;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String string = TalonHawkScanConfExtensions.INSTANCE.applicationId(this.this$0.getTalonConfig());
                        String string2 = TalonHawkScanConfExtensions.INSTANCE.environment(this.this$0.getTalonConfig());
                        String string3 = this.this$0.getTalonConfig().getScanId();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getScanId(...)");
                        this.label = 1;
                        Object object3 = AssetManagerClient.uploadFileAssetAsync$default(this.$assetManagerClient, string, string2, string3, ScanResultMessages.ScanAssetUploadRequest.AssetType.ZAP_LOG, this.$zipFile, null, (Continuation)this, 32, null);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SimpleHttpResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return zipFile;
    }

    public static /* synthetic */ File uploadHawkScanLog$default(CommandExecutor commandExecutor, String string, StackHawkApiClient stackHawkApiClient, AssetManagerClient assetManagerClient, int n, Object object) {
        if ((n & 2) != 0) {
            stackHawkApiClient = commandExecutor.apiClient;
        }
        if ((n & 4) != 0) {
            assetManagerClient = new AssetManagerClient(stackHawkApiClient, new StackHawkAWSClient(StackHawkApiClient.Companion.defaultHttpClient$default(StackHawkApiClient.Companion, 0L, false, false, null, null, commandExecutor.talonConfig.getHawkscanConf().getHawk().getOutboundProxy(), null, null, null, 479, null), false, 0, 0L, 14, null));
        }
        return commandExecutor.uploadHawkScanLog(string, stackHawkApiClient, assetManagerClient);
    }

    private final File createZip(String logFile, String scanId) {
        Path logFilePath = Paths.get(logFile, new String[0]);
        Path zipLogPath = Paths.get(logFile + ".zip", new String[0]);
        Files.deleteIfExists(zipLogPath);
        File zipfile = Files.createFile(zipLogPath, new FileAttribute[0]).toFile();
        ZipOutputStream $this$createZip_u24lambda_u240 = new ZipOutputStream(new FileOutputStream(zipfile));
        boolean bl = false;
        ZipEntry entry = new ZipEntry(scanId + "-" + logFilePath.getFileName());
        $this$createZip_u24lambda_u240.putNextEntry(entry);
        IOUtils.copy((InputStream)new FileInputStream(Paths.get(logFile, new String[0]).toFile()), (OutputStream)$this$createZip_u24lambda_u240);
        $this$createZip_u24lambda_u240.closeEntry();
        $this$createZip_u24lambda_u240.close();
        Intrinsics.checkNotNull((Object)zipfile);
        return zipfile;
    }

    @ExperimentalCoroutinesApi
    @Nullable
    public final String errorScan(@NotNull String applicationId2, @NotNull ScanResultMessages.ScanResult errorResult) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)errorResult, (String)"errorResult");
        return PlatformApi.INSTANCE.sendErrorScan(applicationId2, errorResult, this.apiClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printScanLog(@NotNull String url, @NotNull StackHawkAWSClient awsClient) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)awsClient, (String)"awsClient");
        InputStream inputStream = awsClient.getFileAssetFromS3(url);
        try {
            Closeable closeable = new ZipInputStream(inputStream);
            Throwable throwable = null;
            try {
                Integer n;
                ZipEntry zipEntry;
                ZipInputStream zipInputStream = (ZipInputStream)closeable;
                boolean bl = false;
                ZipEntry zipEntry2 = zipEntry = zipInputStream.getNextEntry();
                if (zipEntry2 != null) {
                    Intrinsics.checkNotNull((Object)zipEntry2);
                    ZipEntry it = zipEntry;
                    boolean bl2 = false;
                    n = IOUtils.copy((InputStream)zipInputStream, (OutputStream)this.consolePrinter.getOutputStream());
                } else {
                    n = null;
                }
                Integer n2 = n;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (ZipException zipException) {
            throw new ScanLogException("Problem reading scan log from server", null, "scan.log-stream", 2, null);
        }
    }

    @NotNull
    public final String getScanLogUrl(@NotNull String scanId) {
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        try {
            return PlatformApi.INSTANCE.getScanLogUrl(scanId, this.apiClient);
        }
        catch (Exception exception) {
            throw new ScanLogException("Problem reading scan log from server", null, "scan.log-not-available", 2, null);
        }
    }

    public final void isValidScanId(@NotNull String scanId) {
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        if (!Pattern.compile("^[{]?[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}[}]?$").matcher(scanId).matches()) {
            throw new InvalidScanIdException("Invalid Scan ID: " + scanId, null, "scan.invalid-scan-id", 2, null);
        }
    }

    @NotNull
    public final String registerCustomPluginID(@NotNull String name, @NotNull String applicationId2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        try {
            return PlatformApi.INSTANCE.registerCustomPlugin(applicationId2, name, this.apiClient);
        }
        catch (Exception ex) {
            if (ex instanceof HawkScanException) {
                throw ex;
            }
            String string = "Error registering plugin " + name + ". " + ex.getMessage();
            throw new CustomPluginRegistrationException(string, ex, "plugin.registriation-error");
        }
    }

    @Nullable
    public final List<OrganizationMessages.Plugin> listCustomPlugins(@Nullable String applicationId2, @Nullable String organizationId) {
        return PlatformApi.INSTANCE.listCustomPlugins(applicationId2, organizationId, this.apiClient);
    }

    public static /* synthetic */ List listCustomPlugins$default(CommandExecutor commandExecutor, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return commandExecutor.listCustomPlugins(string, string2);
    }

    @NotNull
    public final HsteCommand createHsteCommand(@NotNull HsteStarterOptions hsteStarterOptions) {
        Intrinsics.checkNotNullParameter((Object)hsteStarterOptions, (String)"hsteStarterOptions");
        Pair pair = (Pair)hsteStarterOptions.getHsteJarAndClasspathFn().invoke();
        String hsteJar = (String)pair.component1();
        String hsteClasspath = (String)pair.component2();
        HsteCommand.Builder builder = new HsteCommand.Builder(null, null, null, null, 15, null).installDir(hsteStarterOptions.getHsteInstallDir()).hsteJar(hsteJar).hsteClasspath(hsteClasspath);
        String string = this.talonConfig.getHawkMem();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHawkMem(...)");
        HsteCommand.Builder builder2 = builder.jvmMemoryStr(string).talonHawkScanConf(this.talonConfig).port(this.talonConfig.getProxyPort());
        HawkScanMessages.HawkConf.Spider.AjaxBrowser ajaxBrowser = this.talonConfig.getHawkscanConf().getHawk().getSpider().getAjaxBrowser();
        Intrinsics.checkNotNullExpressionValue((Object)ajaxBrowser, (String)"getAjaxBrowser(...)");
        HsteCommand.Builder hsteCommandBuilder = builder2.hsteConf("rules.domxss.browserid", HawkConfExtensions.INSTANCE.id(ajaxBrowser)).hsteConf("scanner.analyser.redirectEqualsNotFound", "true").debug(hsteStarterOptions.getLoggingOptions().getDebug()).trace(hsteStarterOptions.getLoggingOptions().getTrace());
        if (hsteStarterOptions.getJvmDebugServer()) {
            hsteCommandBuilder.jvmArg("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:5005");
        }
        List<String> list = hsteStarterOptions.getJvmOpts();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                hsteCommandBuilder.jvmArg(it);
            }
        }
        if (hsteStarterOptions.getHsteUI() || !BootstrapUtils.isInDocker$default(BootstrapUtils.INSTANCE, null, 1, null) && this.talonConfig.getHawkscanConf().getHawk().getSpider().getAjax() && hsteStarterOptions.getDisplayBrowsers().contains(this.talonConfig.getHawkscanConf().getHawk().getSpider().getAjaxBrowser())) {
            hsteCommandBuilder.withDisplay();
        }
        if (hsteStarterOptions.getHsteUI()) {
            hsteCommandBuilder.withHsteUI();
        }
        if (hsteStarterOptions.isPerch()) {
            hsteCommandBuilder.isPerch();
        }
        String string2 = this.talonConfig.getScanId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getScanId(...)");
        String fileIdentifier = ((CharSequence)string2).length() > 0 ? "-" + this.talonConfig.getScanId() : "";
        File talonPbFile = hsteStarterOptions.getSessionDir().resolve(".talon" + fileIdentifier + ".pb").toFile();
        if (talonPbFile.exists()) {
            talonPbFile.delete();
        }
        Intrinsics.checkNotNull((Object)talonPbFile);
        byte[] byArray = this.talonConfig.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        FilesKt.writeBytes((File)talonPbFile, (byte[])byArray);
        if (!((Collection)LoggerUtils.INSTANCE.getRedactTokens().getValue()).isEmpty()) {
            File tmpTokenFile = hsteStarterOptions.getSessionDir().resolve(".tmp-tokens" + fileIdentifier).toFile();
            Intrinsics.checkNotNull((Object)tmpTokenFile);
            LoggerUtils.INSTANCE.saveTokens(tmpTokenFile);
            String string3 = tmpTokenFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
            hsteCommandBuilder.jvmProperty("hawkscan.redactionTokens", string3);
        }
        String string4 = hsteStarterOptions.getSessionDir().toFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
        hsteCommandBuilder.homeDir(string4);
        String string5 = talonPbFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
        hsteCommandBuilder.talonHawkScanConfFile(string5);
        return hsteCommandBuilder.build();
    }

    public final int runHsteProcess(@NotNull ConsolePrinter consolePrinter, @NotNull AtomicRef<ScanResponseOutputHandler> scanResponseOutputHandlerRef, @NotNull AtomicRef<Process> hsteProcessRef, @NotNull Path sessionDir, @NotNull Map<String, String> environment, @NotNull HsteLoggingOptions hsteLoggingOptions, @NotNull List<? extends HawkScanMessages.HawkConf.Spider.AjaxBrowser> displayBrowsers, @NotNull Channel<TalonMessages.TalonScanResponse> scanResponseChannel, @NotNull String startUpMsg, boolean hsteUI, boolean jvmDebugServer, @Nullable List<String> jvmOpts) {
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter(scanResponseOutputHandlerRef, (String)"scanResponseOutputHandlerRef");
        Intrinsics.checkNotNullParameter(hsteProcessRef, (String)"hsteProcessRef");
        Intrinsics.checkNotNullParameter((Object)sessionDir, (String)"sessionDir");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)hsteLoggingOptions, (String)"hsteLoggingOptions");
        Intrinsics.checkNotNullParameter(displayBrowsers, (String)"displayBrowsers");
        Intrinsics.checkNotNullParameter(scanResponseChannel, (String)"scanResponseChannel");
        Intrinsics.checkNotNullParameter((Object)startUpMsg, (String)"startUpMsg");
        int exitCode = 0;
        Pair<Process, HsteCommand> pair = this.startHSTE(new HsteStarterOptions(hsteLoggingOptions, displayBrowsers, hsteUI, jvmDebugServer, sessionDir, null, null, false, jvmOpts, 224, null), environment, hsteProcessRef);
        Process proc = (Process)pair.component1();
        HsteCommand hsteCommand = (HsteCommand)pair.component2();
        ScanResponseOutputHandlerImpl scanResponseOutputHandler2 = new ScanResponseOutputHandlerImpl(Bootstrap.INSTANCE.getAsyncScope(), scanResponseChannel, consolePrinter, this.talonConfig, 0L, 0L, false, (Function0)new Function0<Boolean>(proc){
            final /* synthetic */ Process $proc;
            {
                this.$proc = $proc;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$proc.isAlive();
            }
        }, null, 368, null);
        scanResponseOutputHandlerRef.getAndSet((Object)scanResponseOutputHandler2);
        scanResponseOutputHandler2.start(startUpMsg);
        exitCode += ScanResponseOutputHandlerImpl.waitForCompletion$default(scanResponseOutputHandler2, 0L, 1, null);
        exitCode += proc.waitFor();
        if (hsteLoggingOptions.getVerbose()) {
            hsteCommand.stopTailHSTELog();
        }
        scanResponseOutputHandler2.stopGenericProgress();
        return exitCode;
    }

    public static /* synthetic */ int runHsteProcess$default(CommandExecutor commandExecutor, ConsolePrinter consolePrinter, AtomicRef atomicRef, AtomicRef atomicRef2, Path path, Map map, HsteLoggingOptions hsteLoggingOptions, List list, Channel channel, String string, boolean bl, boolean bl2, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            atomicRef = AtomicFU.atomic(null);
        }
        if ((n & 4) != 0) {
            atomicRef2 = AtomicFU.atomic(null);
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            channel = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        }
        if ((n & 0x100) != 0) {
            string = "Starting Scan Engine";
        }
        if ((n & 0x200) != 0) {
            bl = false;
        }
        if ((n & 0x400) != 0) {
            bl2 = false;
        }
        if ((n & 0x800) != 0) {
            list2 = null;
        }
        return commandExecutor.runHsteProcess(consolePrinter, (AtomicRef<ScanResponseOutputHandler>)atomicRef, (AtomicRef<Process>)atomicRef2, path, map, hsteLoggingOptions, list, (Channel<TalonMessages.TalonScanResponse>)channel, string, bl, bl2, list2);
    }

    @NotNull
    public final Pair<Process, HsteCommand> startHSTE(@NotNull HsteStarterOptions hsteStarterOptions, @NotNull Map<String, String> environment, @NotNull AtomicRef<Process> hsteProcessRef) {
        Intrinsics.checkNotNullParameter((Object)hsteStarterOptions, (String)"hsteStarterOptions");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter(hsteProcessRef, (String)"hsteProcessRef");
        HsteCommand hsteCommand = this.createHsteCommand(hsteStarterOptions);
        this.LOG.info("HSTE Command: " + hsteCommand);
        String[] stringArray = hsteCommand.getCommandArgs();
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(Arrays.copyOf(stringArray, stringArray.length));
        pb.environment().putAll(environment);
        Process proc = pb.start();
        hsteProcessRef.getAndSet((Object)proc);
        this.LOG.info("HSTE Process running at " + proc.pid());
        if (hsteStarterOptions.getLoggingOptions().getVerbose()) {
            hsteCommand.startTailHSTELog(Bootstrap.INSTANCE.getAsyncScope());
        }
        return new Pair((Object)proc, (Object)hsteCommand);
    }

    public static /* synthetic */ Pair startHSTE$default(CommandExecutor commandExecutor, HsteStarterOptions hsteStarterOptions, Map map, AtomicRef atomicRef, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            atomicRef = AtomicFU.atomic(null);
        }
        return commandExecutor.startHSTE(hsteStarterOptions, map, (AtomicRef<Process>)atomicRef);
    }

    @Nullable
    public final List<ApplicationService.ApplicationAlert> getLastScanAlertPlugins(@NotNull String scanId) {
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        try {
            ApplicationService.ListApplicationAlertsResponse scanResults = PlatformApi.INSTANCE.getScanResults(scanId, this.apiClient);
            List list = scanResults.getApplicationScanResultsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getApplicationScanResultsList(...)");
            ApplicationService.ApplicationScanResult applicationScanResult = (ApplicationService.ApplicationScanResult)CollectionsKt.firstOrNull((List)list);
            return applicationScanResult != null ? applicationScanResult.getApplicationAlertsList() : null;
        }
        catch (Exception ex) {
            if (ex instanceof HawkScanException) {
                throw ex;
            }
            String string = "Error getting last scan " + ex.getMessage();
            throw new ScanNotFound(string, ex, "rescan.no-parent");
        }
    }

    @Nullable
    public final String getLastScanId(@NotNull String applicationId2) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        return PlatformApi.INSTANCE.getLastScanId(applicationId2, this.apiClient);
    }

    public final void validateFeatureFlag(@NotNull String applicationId2, @NotNull List<String> requiredFlags, @NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter(requiredFlags, (String)"requiredFlags");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        PlatformApi.INSTANCE.validateFeatureFlag(applicationId2, requiredFlags, feature, this.apiClient);
    }

    @NotNull
    public final UserMessages.UserResponse getUser() {
        return PlatformApi.INSTANCE.getUser(this.apiClient);
    }

    @NotNull
    public final List<TeamMessages.Team> getUserTeams(@NotNull String organizationId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)organizationId, (String)"organizationId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        List<TeamMessages.Team> list = PlatformApi.INSTANCE.getUserTeams(organizationId, userId, this.apiClient);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUserTeams(...)");
        return list;
    }

    @NotNull
    public final ApplicationService.Application createApplication(@NotNull String organizationId, @NotNull String applicationName, @NotNull String environmentName, @NotNull String teamId) {
        Intrinsics.checkNotNullParameter((Object)organizationId, (String)"organizationId");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)teamId, (String)"teamId");
        try {
            return PlatformApi.INSTANCE.createApplication(organizationId, applicationName, environmentName, teamId, this.apiClient);
        }
        catch (Exception exception) {
            throw new CreateApplicationException("Could not create application", null, "create.application", 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<UserMessages.UserOrganization, List<ApplicationService.Application>> getAppOrgs(@NotNull String applicationId2) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        try {
            void $this$filterTo$iv$iv;
            Map<UserMessages.UserOrganization, List<ApplicationService.Application>> $this$filter$iv = PlatformApi.INSTANCE.getAppOrgsByUserAsync(applicationId2, this.apiClient);
            boolean $i$f$filter = false;
            Map<UserMessages.UserOrganization, List<ApplicationService.Application>> map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable $this$map$iv = (Iterable)it.getValue();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void application;
                    ApplicationService.Application application2 = (ApplicationService.Application)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(application.getApplicationId());
                }
                if (!((List)destination$iv$iv2).contains(applicationId2)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }
        catch (Exception e) {
            throw new InvalidAppIdException("Unable to validate applicationId: " + applicationId2 + System.lineSeparator() + e.getMessage(), e, "platform.invalid-app-id");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/stackhawk/hste/CommandExecutor$Companion;", "", "()V", "defaultStackHawkApiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "talonConfig", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "httpClient", "Lcom/stackhawk/http/HttpClient;", "talon-bootstrap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StackHawkApiClient defaultStackHawkApiClient(@NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull HttpClient httpClient) {
            Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            String string = talonConfig.getApiKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApiKey(...)");
            String string2 = talonConfig.getApiEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getApiEndpoint(...)");
            String string3 = talonConfig.getAuthEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAuthEndpoint(...)");
            return new StackHawkApiClient(new StackHawkApiClientConfig(string, string2, string3, httpClient, false, BootstrapUtils.INSTANCE.getHawkscanVersion(), null, null, 192, null));
        }

        public static /* synthetic */ StackHawkApiClient defaultStackHawkApiClient$default(Companion companion, TalonMessages.TalonHawkScanConf talonHawkScanConf, HttpClient httpClient, int n, Object object) {
            if ((n & 2) != 0) {
                httpClient = StackHawkApiClient.Companion.defaultHttpClient$default(StackHawkApiClient.Companion, 0L, false, false, null, null, talonHawkScanConf.getHawkscanConf().getHawk().getOutboundProxy(), null, null, null, 479, null);
            }
            return companion.defaultStackHawkApiClient(talonHawkScanConf, httpClient);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

