/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.github.ajalt.mordant.animation.progress.BlockingAnimator;
import com.github.ajalt.mordant.animation.progress.ProgressTaskUpdateScope;
import com.github.ajalt.mordant.animation.progress.ThreadAnimatorKt;
import com.github.ajalt.mordant.animation.progress.ThreadProgressTaskAnimator;
import com.github.ajalt.mordant.rendering.TextColors;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.widgets.progress.ProgressBarDefinition;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutCellsKt;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutScope;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutScopeKt;
import com.google.protobuf.ProtocolStringList;
import com.stackhawk.hste.BootstrapUtils;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.MainKt;
import com.stackhawk.hste.extension.talon.HawkConfExtensionsKt;
import com.stackhawk.hste.extension.talon.TalonHawkScanConfExtensions;
import com.stackhawk.nest.ApplicationService;
import com.stackhawk.nest.HawkScanMessages;
import com.stackhawk.nest.TalonMessages;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0019\n\u0002\b\n\u0018\u0000 x2\u00020\u0001:\u0002xyBA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0010J6\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J,\u0010(\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001c2\b\b\u0002\u0010%\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001cJ\u0016\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0014\u00100\u001a\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c02JN\u00103\u001a\u00020\u00102\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010<\u001a\u00020\u0005J\u000e\u0010=\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001cJ\u000e\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@J,\u0010A\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@2\u0006\u0010B\u001a\u00020\u001c2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001c022\u0006\u0010D\u001a\u00020EJ\u0010\u0010F\u001a\u00020\u00102\b\b\u0002\u0010G\u001a\u00020/J\u001e\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u0002062\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001cJ\u0016\u0010J\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0006\u0010K\u001a\u00020\u0010J\u0016\u0010L\u001a\u00020\u00102\u0006\u0010M\u001a\u00020N2\u0006\u0010.\u001a\u00020/J\u0006\u0010O\u001a\u00020\u0010J(\u0010P\u001a\u00020\u00102\u0006\u0010Q\u001a\u00020R2\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010S\u001a\u00020\u0005J0\u0010T\u001a\u00020\u00102\u0006\u0010I\u001a\u0002062\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010<\u001a\u00020\u0005J\u0010\u0010U\u001a\u00020\u00102\b\b\u0002\u0010V\u001a\u00020/J \u0010W\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@2\u0006\u0010X\u001a\u00020Y2\b\b\u0002\u0010<\u001a\u00020\u0005J.\u0010Z\u001a\u00020\u00102\u0006\u0010I\u001a\u0002062\u0006\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001cJ\u0016\u0010[\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0006\u0010\\\u001a\u00020\u0010J\u000e\u0010]\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001cJ.\u0010^\u001a\u00020\u00102\u0006\u0010X\u001a\u00020Y2\u0006\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001cJ\u001a\u0010_\u001a\u00020\u00102\u0006\u0010`\u001a\u00020a2\n\b\u0002\u0010b\u001a\u0004\u0018\u00010\u001cJ&\u0010c\u001a\u00020\u00102\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u001c022\u0006\u0010e\u001a\u00020\u001c2\b\b\u0002\u0010f\u001a\u00020/J\u000e\u0010g\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@J\u000e\u0010h\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001cJ\u0006\u0010i\u001a\u00020\u0010J\u000e\u0010i\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001cJ\u000e\u0010j\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001cJ,\u0010k\u001a\u0004\u0018\u00010\u001c2\u0006\u0010e\u001a\u00020\u001c2\u000e\b\u0002\u0010l\u001a\b\u0012\u0004\u0012\u00020\u001c022\n\b\u0002\u0010m\u001a\u0004\u0018\u00010\u001cJ\b\u0010n\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010o\u001a\u00020pJ\u000e\u0010q\u001a\u00020\u00102\u0006\u0010r\u001a\u00020\u001cJ\u0018\u0010s\u001a\u00020\u00102\u0006\u0010r\u001a\u00020\u001c2\b\b\u0002\u0010t\u001a\u00020\u001fJ\u0006\u0010u\u001a\u00020\u0010J\u000e\u0010v\u001a\u00020\u00102\u0006\u0010r\u001a\u00020\u001cJ\b\u0010w\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lcom/stackhawk/hste/ConsolePrinter;", "", "outputStream", "Ljava/io/OutputStream;", "color", "", "debug", "verbose", "showProgress", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(Ljava/io/OutputStream;ZZZZLcom/github/ajalt/mordant/terminal/Terminal;)V", "getOutputStream", "()Ljava/io/OutputStream;", "progress", "Lcom/github/ajalt/mordant/animation/progress/ThreadProgressTaskAnimator;", "", "getProgress", "()Lcom/github/ajalt/mordant/animation/progress/ThreadProgressTaskAnimator;", "setProgress", "(Lcom/github/ajalt/mordant/animation/progress/ThreadProgressTaskAnimator;)V", "getShowProgress", "()Z", "getTerminal", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "threadFuture", "Ljava/util/concurrent/Future;", "threadProgress", "", "advanceProgressBar", "currentProgress", "", "flush", "getUpgradeMessage", "newVersion", "messageColor", "resetColor", "isDocker", "isOsx", "isWindows", "logNewVersionMessage", "print", "msg", "printActiveScanExtraUrls", "siteUrls", "Lcom/stackhawk/nest/TalonMessages$SiteUrls;", "urlsToPrintCount", "", "printAdvancedProxyOptions", "combinedJvmOpts", "", "printAlerts", "alerts", "", "Lcom/stackhawk/nest/TalonMessages$UniqueAlert;", "highSeverityColor", "mediumSeverityColor", "lowSeverityColor", "boldColor", "highlightColor", "excludeTriagedPaths", "printAttention", "printAuthStatus", "talonHawkScanConf", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "printBanner", "version", "stackHawkConfigFiles", "application", "Lcom/stackhawk/nest/ApplicationService$Application;", "printBreak", "length", "printCheatsheet", "alert", "printDiscoveredUrls", "printErrorFooter", "printGraphQLRoutes", "routes", "Lcom/stackhawk/nest/TalonMessages$GraphQLRoutes;", "printHelpLinksLine", "printPath", "xPath", "Lcom/stackhawk/nest/TalonMessages$XPath;", "fullPath", "printPaths", "printReset", "cnt", "printResults", "alertsCompact", "Lcom/stackhawk/nest/TalonMessages$AlertsCompact;", "printRisk", "printScannedUrls", "printSuccessfulApiValidation", "printSuggestion", "printSummary", "printTalonError", "talonError", "Lcom/stackhawk/nest/TalonMessages$TalonError;", "nudge", "printUrls", "urls", "message", "urlsCount", "printViewResultsOnPlatform", "printWarning", "println", "progressPrintLn", "prompt", "choices", "default", "readConsoleLine", "readConsolePassword", "", "startProgressBar", "title", "startThreadProgressBar", "taskNum", "stopProgressBar", "updateThreadProgressBar", "waitForThreadProgressBar", "Companion", "ConsoleColors", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nConsolePrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsolePrinter.kt\ncom/stackhawk/hste/ConsolePrinter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,615:1\n1#2:616\n1863#3,2:617\n1863#3,2:619\n1053#3:621\n1863#3,2:622\n774#3:624\n865#3,2:625\n1053#3:627\n1863#3,2:628\n*S KotlinDebug\n*F\n+ 1 ConsolePrinter.kt\ncom/stackhawk/hste/ConsolePrinter\n*L\n182#1:617,2\n240#1:619,2\n359#1:621\n360#1:622,2\n403#1:624\n403#1:625,2\n410#1:627\n488#1:628,2\n*E\n"})
public final class ConsolePrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputStream outputStream;
    private final boolean color;
    private final boolean debug;
    private final boolean verbose;
    private final boolean showProgress;
    @NotNull
    private final Terminal terminal;
    @Nullable
    private ThreadProgressTaskAnimator<Unit> progress;
    @Nullable
    private ThreadProgressTaskAnimator<String> threadProgress;
    @Nullable
    private Future<?> threadFuture;
    @NotNull
    public static final String eagleEmoji = "\ud83e\udd85";

    public ConsolePrinter(@NotNull OutputStream outputStream, boolean color, boolean debug, boolean verbose, boolean showProgress, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.outputStream = outputStream;
        this.color = color;
        this.debug = debug;
        this.verbose = verbose;
        this.showProgress = showProgress;
        this.terminal = terminal;
    }

    public /* synthetic */ ConsolePrinter(OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4, Terminal terminal, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            outputStream = printStream;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = true;
        }
        if ((n & 0x20) != 0) {
            terminal = new Terminal(null, null, null, null, null, 0, null, 127, null);
        }
        this(outputStream, bl, bl2, bl3, bl4, terminal);
    }

    @NotNull
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final boolean getShowProgress() {
        return this.showProgress;
    }

    @NotNull
    public final Terminal getTerminal() {
        return this.terminal;
    }

    @Nullable
    public final ThreadProgressTaskAnimator<Unit> getProgress() {
        return this.progress;
    }

    public final void setProgress(@Nullable ThreadProgressTaskAnimator<Unit> threadProgressTaskAnimator) {
        this.progress = threadProgressTaskAnimator;
    }

    public final void print(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String string = msg;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.outputStream.write(byArray);
    }

    public final void println(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String string = msg + System.lineSeparator();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.outputStream.write(byArray);
    }

    public final void println() {
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.outputStream.write(byArray);
    }

    public final void progressPrintLn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.showProgress) {
            Terminal.println$default((Terminal)this.terminal, (Object)msg, null, null, null, null, (boolean)false, (int)62, null);
        }
    }

    @Nullable
    public final String prompt(@NotNull String message, @NotNull List<String> choices, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        return Terminal.prompt$default((Terminal)this.terminal, (String)message, (String)string, (boolean)false, (boolean)false, (boolean)false, (Collection)choices, null, null, (int)220, null);
    }

    public static /* synthetic */ String prompt$default(ConsolePrinter consolePrinter, String string, List list, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            string2 = "no";
        }
        return consolePrinter.prompt(string, list, string2);
    }

    public final void printTalonError(@NotNull TalonMessages.TalonError talonError, @Nullable String nudge) {
        String string;
        Intrinsics.checkNotNullParameter((Object)talonError, (String)"talonError");
        String errorLabelColor = this.color ? "\u001b[1;91m" : "";
        String resetColor = this.color ? "\u001b[0m" : "";
        this.stopProgressBar();
        ConsolePrinter.printReset$default(this, 0, 1, null);
        this.println();
        String string2 = nudge;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.printSuggestion(it);
        }
        if ((string = talonError.getMessage()) == null) {
            string = "";
        }
        String errTxt = string;
        CharSequence charSequence = errTxt;
        String string3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator(...)");
        String lblSeparator = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null) || errTxt.length() > 200 ? System.lineSeparator() : ": ";
        this.println(errorLabelColor + talonError.getLabel() + lblSeparator + resetColor + errTxt + resetColor);
        if (this.debug) {
            String string4 = talonError.getStacktrace();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStacktrace(...)");
            this.println(string4);
        }
        this.println();
        this.printHelpLinksLine();
        ProtocolStringList protocolStringList = talonError.getHelpUrlsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getHelpUrlsList(...)");
        Iterable $this$forEach$iv = (Iterable)protocolStringList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.println(it);
        }
        this.println();
    }

    public static /* synthetic */ void printTalonError$default(ConsolePrinter consolePrinter, TalonMessages.TalonError talonError, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        consolePrinter.printTalonError(talonError, string);
    }

    public final void printReset(int cnt) {
        this.print(CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, cnt)), (CharSequence)" ", null, null, (int)0, null, (Function1)printReset.1.INSTANCE, (int)30, null) + "\r");
    }

    public static /* synthetic */ void printReset$default(ConsolePrinter consolePrinter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        consolePrinter.printReset(n);
    }

    public final void printHelpLinksLine() {
        String documentationColor = this.color ? "\u001b[1m" : "";
        String resetColor = this.color ? "\u001b[0m" : "";
        this.println(documentationColor + "Documentation" + resetColor);
    }

    public final void logNewVersionMessage(@NotNull String newVersion, boolean isDocker, boolean isOsx, boolean isWindows) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        String messageColor = this.color ? "\u001b[1m" : "";
        String resetColor = this.color ? "\u001b[0m" : "";
        this.println(this.getUpgradeMessage(newVersion, messageColor, resetColor, isDocker, isOsx, isWindows));
    }

    public static /* synthetic */ void logNewVersionMessage$default(ConsolePrinter consolePrinter, String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        consolePrinter.logNewVersionMessage(string, bl, bl2, bl3);
    }

    @NotNull
    public final String getUpgradeMessage(@NotNull String newVersion, @NotNull String messageColor, @NotNull String resetColor, boolean isDocker, boolean isOsx, boolean isWindows) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        Intrinsics.checkNotNullParameter((Object)messageColor, (String)"messageColor");
        Intrinsics.checkNotNullParameter((Object)resetColor, (String)"resetColor");
        String preamble = messageColor + "KAAKAWW!! There's a newer HawkScan version " + newVersion + " now available." + resetColor + "\nHawkScan is updated regularly with new features, bug fixes and a splash of KAAKAWW!";
        String updateHint = isDocker ? "Run `docker pull stackhawk/hawkscan` to upgrade the container image." : (isOsx ? "Run `brew install stackhawk/cli/hawk` to update brew package or download the latest zip https://docs.stackhawk.com/stackhawk-cli/#install-with-zip-file" : (isWindows ? "Run `msiexec.exe /i https://download.stackhawk.com/hawk/msi/hawk-" + newVersion + ".msi` to download and install the latest HawkScan" : "Download the latest zip: https://docs.stackhawk.com/stackhawk-cli/#install-with-zip-file"));
        return preamble + System.lineSeparator() + updateHint + System.lineSeparator();
    }

    public final void printAuthStatus(@NotNull TalonMessages.TalonHawkScanConf talonHawkScanConf) {
        Intrinsics.checkNotNullParameter((Object)talonHawkScanConf, (String)"talonHawkScanConf");
        if (talonHawkScanConf.getHawkscanConf().getApp().hasAuthentication()) {
            this.println(System.lineSeparator() + "* Authentication succeeded *");
            this.println("Test path " + talonHawkScanConf.getHawkscanConf().getApp().getAuthentication().getTestPath().getPath() + " returned a successful match" + System.lineSeparator());
        }
    }

    public final void printAdvancedProxyOptions(@NotNull List<String> combinedJvmOpts) {
        Intrinsics.checkNotNullParameter(combinedJvmOpts, (String)"combinedJvmOpts");
        if (!((Collection)combinedJvmOpts).isEmpty()) {
            Iterable $this$forEach$iv = combinedJvmOpts;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.println("* " + it);
            }
        }
    }

    public final void printBanner(@NotNull TalonMessages.TalonHawkScanConf talonHawkScanConf, @NotNull String version, @NotNull List<String> stackHawkConfigFiles, @NotNull ApplicationService.Application application) {
        Intrinsics.checkNotNullParameter((Object)talonHawkScanConf, (String)"talonHawkScanConf");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(stackHawkConfigFiles, (String)"stackHawkConfigFiles");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.println(Companion.wrapBrightWhite("StackHawk \ud83e\udd85 HAWKSCAN - v" + version, this.color));
        this.println("* application:             " + application.getName());
        this.println("* environment:             " + talonHawkScanConf.getHawkscanConf().getApp().getEnv());
        this.println("* scan id:                 " + talonHawkScanConf.getScanId());
        this.println("* scan configs:            [" + CollectionsKt.joinToString$default((Iterable)stackHawkConfigFiles, (CharSequence)", ", null, null, (int)0, null, (Function1)printBanner.1.INSTANCE, (int)30, null) + "]");
        this.println("* app host:                " + talonHawkScanConf.getHawkscanConf().getApp().getHost());
        this.println("* hawk memory:             " + talonHawkScanConf.getHawkMem());
        CharSequence charSequence = talonHawkScanConf.getScanPolicy().getName();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.println("* scan policy:             " + talonHawkScanConf.getScanPolicy().getName() + " (" + talonHawkScanConf.getScanPolicy().getDisplayName() + ")");
        }
        if (TalonHawkScanConfExtensions.INSTANCE.graphqlEnabled(talonHawkScanConf)) {
            HawkScanMessages.GraphQLConf graphQLConf = talonHawkScanConf.getHawkscanConf().getApp().getGraphqlConf();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLConf, (String)"getGraphqlConf(...)");
            HawkScanMessages.AppConf appConf = talonHawkScanConf.getHawkscanConf().getApp();
            Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
            this.println("* GraphQL:                 " + MainKt.typeForBanner(graphQLConf, HawkConfExtensionsKt.cleanHost(appConf)));
        }
        if (TalonHawkScanConfExtensions.INSTANCE.soapEnabled(talonHawkScanConf)) {
            CharSequence charSequence2;
            ConsolePrinter consolePrinter = this;
            charSequence = TalonHawkScanConfExtensions.INSTANCE.soapFullUrlPath(talonHawkScanConf);
            if (charSequence.length() == 0) {
                ConsolePrinter consolePrinter2 = consolePrinter;
                boolean bl = false;
                charSequence2 = TalonHawkScanConfExtensions.INSTANCE.soapFullFilePath(talonHawkScanConf);
                consolePrinter = consolePrinter2;
            } else {
                charSequence2 = charSequence;
            }
            consolePrinter.println("* SOAP:                    " + charSequence2);
        }
        if (TalonHawkScanConfExtensions.INSTANCE.openApiEnabled(talonHawkScanConf)) {
            HawkScanMessages.OpenApiConf openApiConf = talonHawkScanConf.getHawkscanConf().getApp().getOpenApiConf();
            Intrinsics.checkNotNullExpressionValue((Object)openApiConf, (String)"getOpenApiConf(...)");
            HawkScanMessages.AppConf appConf = talonHawkScanConf.getHawkscanConf().getApp();
            Intrinsics.checkNotNullExpressionValue((Object)appConf, (String)"getApp(...)");
            this.println("* OpenAPI:                 " + MainKt.typeForBanner(openApiConf, HawkConfExtensionsKt.cleanHost(appConf)));
        }
        if (TalonHawkScanConfExtensions.INSTANCE.harEnabled(talonHawkScanConf)) {
            HawkScanMessages.HARImportConfig hARImportConfig = talonHawkScanConf.getHawkscanConf().getHawk().getSpider().getHar();
            Intrinsics.checkNotNullExpressionValue((Object)hARImportConfig, (String)"getHar(...)");
            this.println("* HAR:                     " + MainKt.typeForBanner(hARImportConfig));
        }
        if (this.verbose) {
            String[] stringArray = new String[]{talonHawkScanConf.getScanId(), "hawkscan.log"};
            Path scanLogFile = Path.of(talonHawkScanConf.getSessionHomeDir(), stringArray);
            this.println("* debug logging:           " + this.debug);
            this.println("* scan session directory:  " + TalonHawkScanConfExtensions.INSTANCE.scanSessionDirectory(talonHawkScanConf));
            this.println("* scan log file:           " + scanLogFile.toAbsolutePath());
            this.println("* scan HTTP proxy:         " + TalonHawkScanConfExtensions.INSTANCE.httpProxy(talonHawkScanConf));
            this.println("* this process id:         " + BootstrapUtils.INSTANCE.thisProcessId());
            this.println("* this executable path:    " + BootstrapUtils.INSTANCE.thisProcessPath());
            this.println("* java home:               " + BootstrapUtils.INSTANCE.inferredJavaHome());
            this.println("* os family:               " + BootstrapUtils.INSTANCE.osFamily());
            this.println("* log roll size:           " + talonHawkScanConf.getLogRollSize());
            this.println("* log files max count:     " + talonHawkScanConf.getLogRollCount());
        }
    }

    public final void printResults(@NotNull TalonMessages.TalonHawkScanConf talonHawkScanConf, @NotNull TalonMessages.AlertsCompact alertsCompact, boolean excludeTriagedPaths) {
        Intrinsics.checkNotNullParameter((Object)talonHawkScanConf, (String)"talonHawkScanConf");
        Intrinsics.checkNotNullParameter((Object)alertsCompact, (String)"alertsCompact");
        String highSeverityColor = this.color ? "\u001b[1;91m" : "";
        String mediumSeverityColor = this.color ? "\u001b[1;95m" : "";
        String lowSeverityColor = this.color ? "\u001b[1m" : "";
        String boldColor = this.color ? "\u001b[1;97m" : "";
        String highlightColor = this.color ? "\u001b[0;37m" : "";
        String resetColor = this.color ? "\u001b[0m" : "";
        this.println("Scan results for " + talonHawkScanConf.getHawkscanConf().getApp().getHost());
        ConsolePrinter.printBreak$default(this, 0, 1, null);
        this.printSummary(alertsCompact, highSeverityColor, mediumSeverityColor, lowSeverityColor, resetColor);
        ConsolePrinter.printBreak$default(this, 0, 1, null);
        this.printAlerts(alertsCompact.getAlertsMap().values(), highSeverityColor, mediumSeverityColor, lowSeverityColor, boldColor, highlightColor, resetColor, excludeTriagedPaths);
        this.printViewResultsOnPlatform(talonHawkScanConf);
    }

    public static /* synthetic */ void printResults$default(ConsolePrinter consolePrinter, TalonMessages.TalonHawkScanConf talonHawkScanConf, TalonMessages.AlertsCompact alertsCompact, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        consolePrinter.printResults(talonHawkScanConf, alertsCompact, bl);
    }

    public final void printViewResultsOnPlatform(@NotNull TalonMessages.TalonHawkScanConf talonHawkScanConf) {
        Intrinsics.checkNotNullParameter((Object)talonHawkScanConf, (String)"talonHawkScanConf");
        this.println("View on StackHawk platform: " + TalonHawkScanConfExtensions.INSTANCE.getPlatformUrl(talonHawkScanConf) + "/scans/" + talonHawkScanConf.getScanId());
    }

    public final void printBreak(int length) {
        this.println(StringsKt.repeat((CharSequence)"-", (int)length));
    }

    public static /* synthetic */ void printBreak$default(ConsolePrinter consolePrinter, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 60;
        }
        consolePrinter.printBreak(n);
    }

    public final void printSummary(@NotNull TalonMessages.AlertsCompact alertsCompact, @NotNull String highSeverityColor, @NotNull String mediumSeverityColor, @NotNull String lowSeverityColor, @NotNull String resetColor) {
        Intrinsics.checkNotNullParameter((Object)alertsCompact, (String)"alertsCompact");
        Intrinsics.checkNotNullParameter((Object)highSeverityColor, (String)"highSeverityColor");
        Intrinsics.checkNotNullParameter((Object)mediumSeverityColor, (String)"mediumSeverityColor");
        Intrinsics.checkNotNullParameter((Object)lowSeverityColor, (String)"lowSeverityColor");
        Intrinsics.checkNotNullParameter((Object)resetColor, (String)"resetColor");
        this.println("Criticality: New/Triaged");
        this.println("   High: " + highSeverityColor + alertsCompact.getSeverityCounts().getHigh() + resetColor + "/" + alertsCompact.getTriagedSeverityCounts().getHigh() + "    Medium: " + mediumSeverityColor + alertsCompact.getSeverityCounts().getMedium() + resetColor + "/" + alertsCompact.getTriagedSeverityCounts().getMedium() + "    Low: " + lowSeverityColor + alertsCompact.getSeverityCounts().getLow() + resetColor + "/" + alertsCompact.getTriagedSeverityCounts().getLow());
    }

    public final void printAlerts(@NotNull Collection<TalonMessages.UniqueAlert> alerts, @NotNull String highSeverityColor, @NotNull String mediumSeverityColor, @NotNull String lowSeverityColor, @NotNull String boldColor, @NotNull String highlightColor, @NotNull String resetColor, boolean excludeTriagedPaths) {
        Intrinsics.checkNotNullParameter(alerts, (String)"alerts");
        Intrinsics.checkNotNullParameter((Object)highSeverityColor, (String)"highSeverityColor");
        Intrinsics.checkNotNullParameter((Object)mediumSeverityColor, (String)"mediumSeverityColor");
        Intrinsics.checkNotNullParameter((Object)lowSeverityColor, (String)"lowSeverityColor");
        Intrinsics.checkNotNullParameter((Object)boldColor, (String)"boldColor");
        Intrinsics.checkNotNullParameter((Object)highlightColor, (String)"highlightColor");
        Intrinsics.checkNotNullParameter((Object)resetColor, (String)"resetColor");
        int alertCount = 0;
        alertCount = 1;
        Iterable $this$sortedBy$iv = alerts;
        boolean $i$f$sortedBy = false;
        List sortAlerts = CollectionsKt.reversed((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TalonMessages.UniqueAlert it = (TalonMessages.UniqueAlert)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getRiskNum());
                it = (TalonMessages.UniqueAlert)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getRiskNum()));
            }
        }));
        Iterable $this$forEach$iv = sortAlerts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TalonMessages.UniqueAlert it = (TalonMessages.UniqueAlert)element$iv;
            boolean bl = false;
            this.println(alertCount + ") " + boldColor + it.getName() + resetColor);
            ++alertCount;
            this.printRisk(it, highSeverityColor, mediumSeverityColor, lowSeverityColor, resetColor);
            this.printCheatsheet(it, boldColor, resetColor);
            this.printPaths(it, boldColor, highlightColor, resetColor, excludeTriagedPaths);
        }
    }

    public static /* synthetic */ void printAlerts$default(ConsolePrinter consolePrinter, Collection collection, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        consolePrinter.printAlerts(collection, string, string2, string3, string4, string5, string6, bl);
    }

    public final void printRisk(@NotNull TalonMessages.UniqueAlert alert, @NotNull String highSeverityColor, @NotNull String mediumSeverityColor, @NotNull String lowSeverityColor, @NotNull String resetColor) {
        Intrinsics.checkNotNullParameter((Object)alert, (String)"alert");
        Intrinsics.checkNotNullParameter((Object)highSeverityColor, (String)"highSeverityColor");
        Intrinsics.checkNotNullParameter((Object)mediumSeverityColor, (String)"mediumSeverityColor");
        Intrinsics.checkNotNullParameter((Object)lowSeverityColor, (String)"lowSeverityColor");
        Intrinsics.checkNotNullParameter((Object)resetColor, (String)"resetColor");
        if (Intrinsics.areEqual((Object)alert.getRisk(), (Object)"High")) {
            this.println("   Risk: " + highSeverityColor + alert.getRisk() + resetColor);
        } else if (Intrinsics.areEqual((Object)alert.getRisk(), (Object)"Medium")) {
            this.println("   Risk: " + mediumSeverityColor + alert.getRisk() + resetColor);
        } else if (Intrinsics.areEqual((Object)alert.getRisk(), (Object)"Low")) {
            this.println("   Risk: " + lowSeverityColor + alert.getRisk() + resetColor);
        }
    }

    public final void printCheatsheet(@NotNull TalonMessages.UniqueAlert alert, @NotNull String boldColor, @NotNull String resetColor) {
        Intrinsics.checkNotNullParameter((Object)alert, (String)"alert");
        Intrinsics.checkNotNullParameter((Object)boldColor, (String)"boldColor");
        Intrinsics.checkNotNullParameter((Object)resetColor, (String)"resetColor");
        Object cheatsheetToPrint = "";
        String originalCheatsheet = alert.getCheatsheet();
        if (!Intrinsics.areEqual((Object)originalCheatsheet, (Object)"")) {
            cheatsheetToPrint = " " + originalCheatsheet;
        }
        this.println("   Cheatsheet:" + boldColor + (String)cheatsheetToPrint + resetColor);
    }

    /*
     * WARNING - void declaration
     */
    public final void printPaths(@NotNull TalonMessages.UniqueAlert alert, @NotNull String boldColor, @NotNull String highlightColor, @NotNull String resetColor, boolean excludeTriagedPaths) {
        List list;
        Intrinsics.checkNotNullParameter((Object)alert, (String)"alert");
        Intrinsics.checkNotNullParameter((Object)boldColor, (String)"boldColor");
        Intrinsics.checkNotNullParameter((Object)highlightColor, (String)"highlightColor");
        Intrinsics.checkNotNullParameter((Object)resetColor, (String)"resetColor");
        int pathsToPrint = 0;
        List allPaths = alert.getXPathsList();
        if (excludeTriagedPaths) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNull((Object)allPaths);
            Iterable $this$filter$iv = allPaths;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TalonMessages.XPath it = (TalonMessages.XPath)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStatus(), (Object)"New")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = alert.getXPathsList();
        }
        List pathsList = list;
        this.println("   Paths (" + boldColor + pathsList.size() + resetColor + "):");
        pathsToPrint = pathsList.size() <= 5 ? pathsList.size() : 5;
        List partialPaths = pathsList.subList(0, pathsToPrint);
        Iterable $this$sortedBy$iv = partialPaths;
        boolean $i$f$sortedBy = false;
        List pathsToPrintList = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TalonMessages.XPath it = (TalonMessages.XPath)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStatus().length());
                it = (TalonMessages.XPath)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStatus().length()));
            }
        });
        for (int i = 0; i < pathsToPrint; ++i) {
            Object e = pathsToPrintList.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            ConsolePrinter.printPath$default(this, (TalonMessages.XPath)e, boldColor, resetColor, false, 8, null);
        }
        if (pathsList.size() > 5) {
            int morePaths = pathsList.size() - pathsToPrint;
            this.println(highlightColor + "     ... " + morePaths + " more in details" + resetColor);
        }
    }

    public static /* synthetic */ void printPaths$default(ConsolePrinter consolePrinter, TalonMessages.UniqueAlert uniqueAlert, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        consolePrinter.printPaths(uniqueAlert, string, string2, string3, bl);
    }

    public final void printPath(@NotNull TalonMessages.XPath xPath, @NotNull String boldColor, @NotNull String resetColor, boolean fullPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)xPath, (String)"xPath");
        Intrinsics.checkNotNullParameter((Object)boldColor, (String)"boldColor");
        Intrinsics.checkNotNullParameter((Object)resetColor, (String)"resetColor");
        Object pathToPrint = !Intrinsics.areEqual((Object)xPath.getPath(), (Object)"") ? " " + xPath.getPath() : xPath.getPath();
        String pathLineToPrint = null;
        String originalPathLine = "     [" + xPath.getStatus() + "] " + xPath.getMethod() + boldColor + (String)pathToPrint + resetColor;
        if (fullPath || originalPathLine.length() <= 80 + boldColor.length()) {
            object = originalPathLine;
        } else {
            String string = originalPathLine.substring(0, 80 + boldColor.length());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        }
        pathLineToPrint = object;
        this.println(pathLineToPrint);
    }

    public static /* synthetic */ void printPath$default(ConsolePrinter consolePrinter, TalonMessages.XPath xPath, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        consolePrinter.printPath(xPath, string, string2, bl);
    }

    public final void printActiveScanExtraUrls(@NotNull TalonMessages.SiteUrls siteUrls, int urlsToPrintCount) {
        Intrinsics.checkNotNullParameter((Object)siteUrls, (String)"siteUrls");
        ProtocolStringList protocolStringList = siteUrls.getUrlsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getUrlsList(...)");
        this.printUrls((List)protocolStringList, "Active scan added " + siteUrls.getUrlsCount() + " URLs:", urlsToPrintCount);
    }

    public final void printDiscoveredUrls(@NotNull TalonMessages.SiteUrls siteUrls, int urlsToPrintCount) {
        Intrinsics.checkNotNullParameter((Object)siteUrls, (String)"siteUrls");
        ProtocolStringList protocolStringList = siteUrls.getUrlsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getUrlsList(...)");
        this.printUrls((List)protocolStringList, "Discovered " + siteUrls.getUrlsCount() + " URLs:", urlsToPrintCount);
    }

    public final void printScannedUrls(@NotNull TalonMessages.SiteUrls siteUrls, int urlsToPrintCount) {
        Intrinsics.checkNotNullParameter((Object)siteUrls, (String)"siteUrls");
        ProtocolStringList protocolStringList = siteUrls.getUrlsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getUrlsList(...)");
        this.printUrls((List)protocolStringList, "Hawk Scanned " + siteUrls.getUrlsCount() + " URLs:", urlsToPrintCount);
    }

    public final void printGraphQLRoutes(@NotNull TalonMessages.GraphQLRoutes routes, int urlsToPrintCount) {
        Intrinsics.checkNotNullParameter((Object)routes, (String)"routes");
        ProtocolStringList protocolStringList = routes.getRoutesList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getRoutesList(...)");
        this.printUrls((List)protocolStringList, "Talon found " + routes.getRoutesCount() + " GraphQL routes:", urlsToPrintCount);
    }

    public final void printUrls(@NotNull List<String> urls, @NotNull String message, int urlsCount) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String boldColor = this.color ? "\u001b[1;97m" : "";
        String resetColor = this.color ? "\u001b[0m" : "";
        this.println(boldColor + message + resetColor);
        int urlsToPrintCount = 0;
        int additionalUrlsCount = 0;
        if (urls.size() > urlsCount) {
            urlsToPrintCount = urlsCount;
            additionalUrlsCount = urls.size() - urlsCount;
        } else {
            urlsToPrintCount = urls.size();
            additionalUrlsCount = 0;
        }
        List<String> urlsToPrint = urls.subList(0, urlsToPrintCount);
        String space = null;
        space = "";
        Iterable $this$forEach$iv = urlsToPrint;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.println(boldColor + space + it + resetColor);
            space = "  ";
        }
        if (additionalUrlsCount > 0) {
            this.println(boldColor + "  ... " + additionalUrlsCount + " additional URLs" + resetColor);
        }
    }

    public static /* synthetic */ void printUrls$default(ConsolePrinter consolePrinter, List list, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        consolePrinter.printUrls(list, string, n);
    }

    public final void printSuccessfulApiValidation() {
        Pair pair = this.color ? new Pair((Object)"\u001b[0;96m", (Object)"\u001b[0m") : new Pair((Object)"", (Object)"");
        String blueColor = (String)pair.component1();
        String resetColor = (String)pair.component2();
        this.println(blueColor + "KaaKaww! API spec validation was successful." + resetColor);
    }

    public final void printWarning(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.println(Companion.wrapYellow("\nWARNING: " + msg + "\n", this.color));
    }

    public final void printSuggestion(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.println(Companion.wrapCyan("\n" + msg + "\n", this.color));
    }

    public final void printAttention(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.println(Companion.wrapYellow(msg, this.color));
    }

    public final void printErrorFooter() {
        this.println();
        this.printHelpLinksLine();
        this.println("https://docs.stackhawk.com/hawkscan/configuration");
        this.println();
    }

    public final void flush() {
        this.outputStream.flush();
    }

    @Nullable
    public final String readConsoleLine() {
        return ConsoleKt.readLine();
    }

    @NotNull
    public final char[] readConsolePassword() {
        char[] cArray = System.console().readPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"readPassword(...)");
        return cArray;
    }

    public final void startProgressBar(@NotNull String title) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            if (!this.showProgress) {
                return;
            }
            if (this.progress != null) {
                this.stopProgressBar();
            }
            this.progress = ThreadAnimatorKt.animateOnThread-u4uj9nY$default((ProgressBarDefinition)ProgressLayoutScopeKt.progressBarLayout$default((int)0, (boolean)false, (int)0, (int)0, null, null, (Function1)((Function1)new Function1<ProgressLayoutScope<Unit>, Unit>(title){
                final /* synthetic */ String $title;
                {
                    this.$title = $title;
                    super(1);
                }

                public final void invoke(@NotNull ProgressLayoutScope<Unit> $this$progressBarLayout) {
                    Intrinsics.checkNotNullParameter($this$progressBarLayout, (String)"$this$progressBarLayout");
                    ProgressLayoutCellsKt.percentage$default($this$progressBarLayout, (int)0, null, null, (int)7, null);
                    ProgressLayoutCellsKt.progressBar-vXyW-Bk$default($this$progressBarLayout, (Integer)50, null, null, null, (TextStyle)TextColors.Companion.rgb$default((TextColors.Companion)TextColors.Companion, (String)"F8F7FF", null, (int)2, null), null, (TextStyle)TextColors.Companion.rgb$default((TextColors.Companion)TextColors.Companion, (String)"00D7D2", null, (int)2, null), null, null, (long)0L, null, (int)0, (int)4014, null);
                    ProgressLayoutCellsKt.text$default($this$progressBarLayout, (String)this.$title, null, null, (int)6, null);
                }
            }), (int)63, null), (Terminal)this.terminal, null, (long)0L, (boolean)false, (boolean)false, (boolean)false, (long)0L, null, null, (int)510, null);
            ThreadProgressTaskAnimator<Unit> threadProgressTaskAnimator = this.progress;
            if (threadProgressTaskAnimator != null) {
                threadProgressTaskAnimator.update((Function1)startProgressBar.2.INSTANCE);
            }
            ThreadProgressTaskAnimator<Unit> threadProgressTaskAnimator2 = this.progress;
            if (threadProgressTaskAnimator2 == null) break block3;
            ThreadAnimatorKt.execute$default((BlockingAnimator)((BlockingAnimator)threadProgressTaskAnimator2), null, (int)1, null);
        }
    }

    public final void startThreadProgressBar(@NotNull String title, long taskNum) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        if (!this.showProgress) {
            return;
        }
        if (this.progress != null) {
            this.stopProgressBar();
        }
        if (this.threadProgress != null) {
            ThreadProgressTaskAnimator<String> threadProgressTaskAnimator = this.threadProgress;
            if (threadProgressTaskAnimator != null) {
                threadProgressTaskAnimator.clear();
            }
            this.threadProgress = null;
        }
        this.threadProgress = ThreadAnimatorKt.animateOnThread-TNmY5B4$default((ProgressBarDefinition)ProgressLayoutScopeKt.progressBarContextLayout$default((int)0, (boolean)false, (int)0, (int)0, null, null, (Function1)((Function1)new Function1<ProgressLayoutScope<String>, Unit>(this){
            final /* synthetic */ ConsolePrinter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ProgressLayoutScope<String> $this$progressBarContextLayout) {
                Intrinsics.checkNotNullParameter($this$progressBarContextLayout, (String)"$this$progressBarContextLayout");
                ProgressLayoutCellsKt.progressBar-vXyW-Bk$default($this$progressBarContextLayout, (Integer)50, null, null, null, (TextStyle)TextColors.Companion.rgb$default((TextColors.Companion)TextColors.Companion, (String)"F8F7FF", null, (int)2, null), null, (TextStyle)TextColors.Companion.rgb$default((TextColors.Companion)TextColors.Companion, (String)"00D7D2", null, (int)2, null), null, null, (long)0L, null, (int)0, (int)4014, null);
                ProgressLayoutCellsKt.completed$default($this$progressBarContextLayout, null, (boolean)false, (int)0, (TextStyle)this.this$0.getTerminal().getTheme().getSuccess(), null, (int)0, (int)55, null);
                ProgressLayoutCellsKt.text$default($this$progressBarContextLayout, null, null, (int)0, (Function1)startThreadProgressBar.1.INSTANCE, (int)7, null);
            }
        }), (int)63, null), (Terminal)this.terminal, (Object)title, (Long)taskNum, (long)1L, (boolean)false, (boolean)false, (boolean)true, (long)0L, null, null, (int)944, null);
        ThreadProgressTaskAnimator<String> threadProgressTaskAnimator = this.threadProgress;
        this.threadFuture = threadProgressTaskAnimator != null ? ThreadAnimatorKt.execute$default((BlockingAnimator)((BlockingAnimator)threadProgressTaskAnimator), null, (int)1, null) : null;
    }

    public static /* synthetic */ void startThreadProgressBar$default(ConsolePrinter consolePrinter, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 4L;
        }
        consolePrinter.startThreadProgressBar(string, l);
    }

    public final void updateThreadProgressBar(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, title, null){
            int label;
            final /* synthetic */ ConsolePrinter this$0;
            final /* synthetic */ String $title;
            {
                this.this$0 = $receiver;
                this.$title = $title;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ThreadProgressTaskAnimator threadProgressTaskAnimator = ConsolePrinter.access$getThreadProgress$p(this.this$0);
                        if (threadProgressTaskAnimator != null) {
                            threadProgressTaskAnimator.update((Function1)new Function1<ProgressTaskUpdateScope<String>, Unit>(this.$title){
                                final /* synthetic */ String $title;
                                {
                                    this.$title = $title;
                                    super(1);
                                }

                                public final void invoke(@NotNull ProgressTaskUpdateScope<String> $this$update) {
                                    Intrinsics.checkNotNullParameter($this$update, (String)"$this$update");
                                    $this$update.setContext((Object)this.$title);
                                    $this$update.setCompleted($this$update.getCompleted() + 1L);
                                }
                            });
                        }
                        this.label = 1;
                        Object object3 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Nullable
    public final Object waitForThreadProgressBar() {
        Future<?> future = this.threadFuture;
        return future != null ? future.get() : null;
    }

    public final void advanceProgressBar(long currentProgress) {
        block1: {
            if (!this.showProgress) {
                return;
            }
            long progNum = currentProgress < 0L ? 0L : currentProgress;
            ThreadProgressTaskAnimator<Unit> threadProgressTaskAnimator = this.progress;
            if (threadProgressTaskAnimator == null) break block1;
            threadProgressTaskAnimator.update((Function1)new Function1<ProgressTaskUpdateScope<Unit>, Unit>(progNum){
                final /* synthetic */ long $progNum;
                {
                    this.$progNum = $progNum;
                    super(1);
                }

                public final void invoke(@NotNull ProgressTaskUpdateScope<Unit> $this$update) {
                    Intrinsics.checkNotNullParameter($this$update, (String)"$this$update");
                    $this$update.setCompleted(this.$progNum);
                }
            });
        }
    }

    public final void stopProgressBar() {
        if (!this.showProgress) {
            return;
        }
        ThreadProgressTaskAnimator<Unit> threadProgressTaskAnimator = this.progress;
        if (threadProgressTaskAnimator != null) {
            threadProgressTaskAnimator.clear();
        }
        this.progress = null;
    }

    public ConsolePrinter() {
        this(null, false, false, false, false, null, 63, null);
    }

    public static final /* synthetic */ ThreadProgressTaskAnimator access$getThreadProgress$p(ConsolePrinter $this) {
        return $this.threadProgress;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stackhawk/hste/ConsolePrinter$Companion;", "", "()V", "eagleEmoji", "", "wrapBright", "txt", "colorEnabled", "", "wrapBrightWhite", "wrapCyan", "wrapInColor", "color", "wrapRed", "wrapYellow", "talon-bootstrap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String wrapBright(@NotNull String txt, boolean colorEnabled) {
            Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
            return this.wrapInColor(txt, "\u001b[1m", colorEnabled);
        }

        @NotNull
        public final String wrapBrightWhite(@NotNull String txt, boolean colorEnabled) {
            Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
            return this.wrapInColor(txt, "\u001b[1;97m", colorEnabled);
        }

        @NotNull
        public final String wrapRed(@NotNull String txt, boolean colorEnabled) {
            Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
            return this.wrapInColor(txt, "\u001b[0;31m", colorEnabled);
        }

        @NotNull
        public final String wrapYellow(@NotNull String txt, boolean colorEnabled) {
            Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
            return this.wrapInColor(txt, "\u001b[0;33m", colorEnabled);
        }

        @NotNull
        public final String wrapCyan(@NotNull String txt, boolean colorEnabled) {
            Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
            return this.wrapInColor(txt, "\u001b[0;36m", colorEnabled);
        }

        private final String wrapInColor(String txt, String color, boolean colorEnabled) {
            return colorEnabled ? color + txt + "\u001b[0m" : txt;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b<\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/stackhawk/hste/ConsolePrinter$ConsoleColors;", "", "()V", "BLACK", "", "BLACK_BACKGROUND", "BLACK_BACKGROUND_BRIGHT", "BLACK_BOLD", "BLACK_BOLD_BRIGHT", "BLACK_BRIGHT", "BLACK_UNDERLINED", "BLUE", "BLUE_BACKGROUND", "BLUE_BACKGROUND_BRIGHT", "BLUE_BOLD", "BLUE_BOLD_BRIGHT", "BLUE_BRIGHT", "BLUE_UNDERLINED", "BOLD_BRIGHT", "CYAN", "CYAN_BACKGROUND", "CYAN_BACKGROUND_BRIGHT", "CYAN_BOLD", "CYAN_BOLD_BRIGHT", "CYAN_BRIGHT", "CYAN_UNDERLINED", "GREEN", "GREEN_BACKGROUND", "GREEN_BACKGROUND_BRIGHT", "GREEN_BOLD", "GREEN_BOLD_BRIGHT", "GREEN_BRIGHT", "GREEN_UNDERLINED", "PURPLE", "PURPLE_BACKGROUND", "PURPLE_BACKGROUND_BRIGHT", "PURPLE_BOLD", "PURPLE_BOLD_BRIGHT", "PURPLE_BRIGHT", "PURPLE_UNDERLINED", "RED", "RED_BACKGROUND", "RED_BACKGROUND_BRIGHT", "RED_BOLD", "RED_BOLD_BRIGHT", "RED_BRIGHT", "RED_UNDERLINED", "RESET", "SH_OSPREY_BLUE", "SH_WHITE", "WHITE", "WHITE_BACKGROUND", "WHITE_BACKGROUND_BRIGHT", "WHITE_BOLD", "WHITE_BOLD_BRIGHT", "WHITE_BRIGHT", "WHITE_UNDERLINED", "YELLOW", "YELLOW_BACKGROUND", "YELLOW_BACKGROUND_BRIGHT", "YELLOW_BOLD", "YELLOW_BOLD_BRIGHT", "YELLOW_BRIGHT", "YELLOW_UNDERLINED", "talon-bootstrap"})
    public static final class ConsoleColors {
        @NotNull
        public static final ConsoleColors INSTANCE = new ConsoleColors();
        @NotNull
        public static final String RESET = "\u001b[0m";
        @NotNull
        public static final String BLACK = "\u001b[0;30m";
        @NotNull
        public static final String RED = "\u001b[0;31m";
        @NotNull
        public static final String GREEN = "\u001b[0;32m";
        @NotNull
        public static final String YELLOW = "\u001b[0;33m";
        @NotNull
        public static final String BLUE = "\u001b[0;34m";
        @NotNull
        public static final String PURPLE = "\u001b[0;35m";
        @NotNull
        public static final String CYAN = "\u001b[0;36m";
        @NotNull
        public static final String WHITE = "\u001b[0;37m";
        @NotNull
        public static final String BLACK_BOLD = "\u001b[1;30m";
        @NotNull
        public static final String RED_BOLD = "\u001b[1;31m";
        @NotNull
        public static final String GREEN_BOLD = "\u001b[1;32m";
        @NotNull
        public static final String YELLOW_BOLD = "\u001b[1;33m";
        @NotNull
        public static final String BLUE_BOLD = "\u001b[1;34m";
        @NotNull
        public static final String PURPLE_BOLD = "\u001b[1;35m";
        @NotNull
        public static final String CYAN_BOLD = "\u001b[1;36m";
        @NotNull
        public static final String WHITE_BOLD = "\u001b[1;37m";
        @NotNull
        public static final String BLACK_UNDERLINED = "\u001b[4;30m";
        @NotNull
        public static final String RED_UNDERLINED = "\u001b[4;31m";
        @NotNull
        public static final String GREEN_UNDERLINED = "\u001b[4;32m";
        @NotNull
        public static final String YELLOW_UNDERLINED = "\u001b[4;33m";
        @NotNull
        public static final String BLUE_UNDERLINED = "\u001b[4;34m";
        @NotNull
        public static final String PURPLE_UNDERLINED = "\u001b[4;35m";
        @NotNull
        public static final String CYAN_UNDERLINED = "\u001b[4;36m";
        @NotNull
        public static final String WHITE_UNDERLINED = "\u001b[4;37m";
        @NotNull
        public static final String BLACK_BACKGROUND = "\u001b[40m";
        @NotNull
        public static final String RED_BACKGROUND = "\u001b[41m";
        @NotNull
        public static final String GREEN_BACKGROUND = "\u001b[42m";
        @NotNull
        public static final String YELLOW_BACKGROUND = "\u001b[43m";
        @NotNull
        public static final String BLUE_BACKGROUND = "\u001b[44m";
        @NotNull
        public static final String PURPLE_BACKGROUND = "\u001b[45m";
        @NotNull
        public static final String CYAN_BACKGROUND = "\u001b[46m";
        @NotNull
        public static final String WHITE_BACKGROUND = "\u001b[47m";
        @NotNull
        public static final String BLACK_BRIGHT = "\u001b[0;90m";
        @NotNull
        public static final String RED_BRIGHT = "\u001b[0;91m";
        @NotNull
        public static final String GREEN_BRIGHT = "\u001b[0;92m";
        @NotNull
        public static final String YELLOW_BRIGHT = "\u001b[0;93m";
        @NotNull
        public static final String BLUE_BRIGHT = "\u001b[0;94m";
        @NotNull
        public static final String PURPLE_BRIGHT = "\u001b[0;95m";
        @NotNull
        public static final String CYAN_BRIGHT = "\u001b[0;96m";
        @NotNull
        public static final String WHITE_BRIGHT = "\u001b[0;97m";
        @NotNull
        public static final String BOLD_BRIGHT = "\u001b[1m";
        @NotNull
        public static final String BLACK_BOLD_BRIGHT = "\u001b[1;90m";
        @NotNull
        public static final String RED_BOLD_BRIGHT = "\u001b[1;91m";
        @NotNull
        public static final String GREEN_BOLD_BRIGHT = "\u001b[1;92m";
        @NotNull
        public static final String YELLOW_BOLD_BRIGHT = "\u001b[1;93m";
        @NotNull
        public static final String BLUE_BOLD_BRIGHT = "\u001b[1;94m";
        @NotNull
        public static final String PURPLE_BOLD_BRIGHT = "\u001b[1;95m";
        @NotNull
        public static final String CYAN_BOLD_BRIGHT = "\u001b[1;96m";
        @NotNull
        public static final String WHITE_BOLD_BRIGHT = "\u001b[1;97m";
        @NotNull
        public static final String BLACK_BACKGROUND_BRIGHT = "\u001b[0;100m";
        @NotNull
        public static final String RED_BACKGROUND_BRIGHT = "\u001b[0;101m";
        @NotNull
        public static final String GREEN_BACKGROUND_BRIGHT = "\u001b[0;102m";
        @NotNull
        public static final String YELLOW_BACKGROUND_BRIGHT = "\u001b[0;103m";
        @NotNull
        public static final String BLUE_BACKGROUND_BRIGHT = "\u001b[0;104m";
        @NotNull
        public static final String PURPLE_BACKGROUND_BRIGHT = "\u001b[0;105m";
        @NotNull
        public static final String CYAN_BACKGROUND_BRIGHT = "\u001b[0;106m";
        @NotNull
        public static final String WHITE_BACKGROUND_BRIGHT = "\u001b[0;107m";
        @NotNull
        public static final String SH_OSPREY_BLUE = "00D7D2";
        @NotNull
        public static final String SH_WHITE = "F8F7FF";

        private ConsoleColors() {
        }
    }
}

