/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.github.ajalt.mordant.terminal.Terminal;
import com.stackhawk.hste.CommandExecutor;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.ErrorUtils;
import com.stackhawk.hste.TerminalUtils;
import com.stackhawk.hste.extension.talon.client.StackHawkApiClient;
import com.stackhawk.hste.extension.talon.hawkscan.api.CreateApplicationException;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanException;
import com.stackhawk.nest.ApplicationService;
import com.stackhawk.nest.Auth;
import com.stackhawk.nest.TeamMessages;
import com.stackhawk.nest.UserMessages;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u001e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J \u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0002J.\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00182\b\u0010&\u001a\u0004\u0018\u00010\u00182\b\u0010'\u001a\u0004\u0018\u00010\u00182\b\u0010(\u001a\u0004\u0018\u00010\u0018J0\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00182\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00182\b\u0010%\u001a\u0004\u0018\u00010\u00182\u0006\u0010-\u001a\u00020.J\u0018\u00100\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u00182\u0006\u0010-\u001a\u00020.J(\u00101\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010-\u001a\u00020.H\u0002J(\u00102\u001a\u00020\u00182\b\u0010(\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007J4\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018052\b\u0010'\u001a\u0004\u0018\u00010\u00182\u0006\u0010-\u001a\u00020.2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J&\u00106\u001a\u00020$2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lcom/stackhawk/hste/CreateUtils;", "", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "stackhawkApiClient", "Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "commandExecutor", "Lcom/stackhawk/hste/CommandExecutor;", "terminalUtils", "Lcom/stackhawk/hste/TerminalUtils;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(Lcom/stackhawk/hste/ConsolePrinter;Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;Lcom/stackhawk/hste/CommandExecutor;Lcom/stackhawk/hste/TerminalUtils;Lcom/github/ajalt/mordant/terminal/Terminal;)V", "getCommandExecutor", "()Lcom/stackhawk/hste/CommandExecutor;", "getConsolePrinter", "()Lcom/stackhawk/hste/ConsolePrinter;", "getStackhawkApiClient", "()Lcom/stackhawk/hste/extension/talon/client/StackHawkApiClient;", "getTerminal", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "getTerminalUtils", "()Lcom/stackhawk/hste/TerminalUtils;", "addQuotesIfContainsWhiteSpace", "", "string", "checkOrganizationIdIsValid", "organizationId", "organizations", "", "Lcom/stackhawk/nest/UserMessages$UserOrganization;", "checkTeamIdIsValid", "teamId", "teams", "Lcom/stackhawk/nest/TeamMessages$Team;", "createApplication", "", "applicationNameArg", "environmentNameArg", "organizationIdArg", "teamIdArg", "createApplicationWithValues", "Lcom/stackhawk/nest/ApplicationService$Application;", "applicationName", "environmentName", "interactiveMode", "", "getApplicationName", "getEnvironmentName", "getOrganizationId", "getTeamId", "userId", "getUserIdAndOrganizationId", "Lkotlin/Pair;", "printHint", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nCreateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateUtils.kt\ncom/stackhawk/hste/CreateUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n295#2,2:202\n295#2,2:204\n*S KotlinDebug\n*F\n+ 1 CreateUtils.kt\ncom/stackhawk/hste/CreateUtils\n*L\n128#1:202,2\n149#1:204,2\n*E\n"})
public final class CreateUtils {
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final StackHawkApiClient stackhawkApiClient;
    @NotNull
    private final CommandExecutor commandExecutor;
    @NotNull
    private final TerminalUtils terminalUtils;
    @NotNull
    private final Terminal terminal;

    public CreateUtils(@NotNull ConsolePrinter consolePrinter, @NotNull StackHawkApiClient stackhawkApiClient, @NotNull CommandExecutor commandExecutor, @NotNull TerminalUtils terminalUtils, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter((Object)stackhawkApiClient, (String)"stackhawkApiClient");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)terminalUtils, (String)"terminalUtils");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.consolePrinter = consolePrinter;
        this.stackhawkApiClient = stackhawkApiClient;
        this.commandExecutor = commandExecutor;
        this.terminalUtils = terminalUtils;
        this.terminal = terminal;
    }

    @NotNull
    public final ConsolePrinter getConsolePrinter() {
        return this.consolePrinter;
    }

    @NotNull
    public final StackHawkApiClient getStackhawkApiClient() {
        return this.stackhawkApiClient;
    }

    @NotNull
    public final CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @NotNull
    public final TerminalUtils getTerminalUtils() {
        return this.terminalUtils;
    }

    @NotNull
    public final Terminal getTerminal() {
        return this.terminal;
    }

    public final void createApplication(@Nullable String applicationNameArg, @Nullable String environmentNameArg, @Nullable String organizationIdArg, @Nullable String teamIdArg) {
        try {
            Auth.JWT jwt = CommandExecutor.authenticate$default(this.commandExecutor, false, false, 3, null);
            this.stackhawkApiClient.start(jwt);
            CharSequence charSequence = applicationNameArg;
            boolean interactiveMode = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
            String applicationName = this.getApplicationName(applicationNameArg, interactiveMode);
            String environmentName = this.getEnvironmentName(environmentNameArg, interactiveMode);
            Pair<String, String> pair = this.getUserIdAndOrganizationId(organizationIdArg, interactiveMode, this.terminalUtils, this.commandExecutor);
            String userId = (String)pair.component1();
            String organizationId = (String)pair.component2();
            String teamId = this.getTeamId(teamIdArg, organizationId, userId, this.commandExecutor);
            this.createApplicationWithValues(applicationName, environmentName, organizationId, teamId, interactiveMode);
        }
        catch (HawkScanException hawkScanException) {
            ErrorUtils.INSTANCE.printHawkscanException(hawkScanException, this.consolePrinter);
            this.stackhawkApiClient.stop();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getApplicationName(@Nullable String applicationNameArg, boolean interactiveMode) {
        String string;
        String invalidApplicationNameExceptionMessage = "Invalid application name provided";
        CreateApplicationException invalidApplicationNameException = new CreateApplicationException(invalidApplicationNameExceptionMessage, null, "create.application", 2, null);
        CharSequence charSequence = applicationNameArg;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            string = applicationNameArg;
            return string;
        } else {
            if (!interactiveMode) throw invalidApplicationNameException;
            String applicationName = Terminal.prompt$default((Terminal)this.terminal, (String)"Application Name", null, (boolean)false, (boolean)false, (boolean)false, null, null, null, (int)254, null);
            CharSequence charSequence2 = applicationName;
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) throw invalidApplicationNameException;
            string = applicationName;
        }
        return string;
    }

    @NotNull
    public final String getEnvironmentName(@Nullable String environmentNameArg, boolean interactiveMode) {
        String environmentName;
        CharSequence charSequence;
        String developmentEnvironment = "Development";
        CharSequence charSequence2 = environmentNameArg;
        String string = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? environmentNameArg : (interactiveMode ? (!((charSequence = (CharSequence)(environmentName = Terminal.prompt$default((Terminal)this.terminal, (String)"Environment Name (Enter for Development)", (String)"Development", (boolean)false, (boolean)false, (boolean)false, null, null, null, (int)248, null))) == null || StringsKt.isBlank((CharSequence)charSequence)) ? environmentName : developmentEnvironment) : developmentEnvironment);
        return string;
    }

    @NotNull
    public final Pair<String, String> getUserIdAndOrganizationId(@Nullable String organizationIdArg, boolean interactiveMode, @NotNull TerminalUtils terminalUtils, @NotNull CommandExecutor commandExecutor) {
        UserMessages.User user2;
        Intrinsics.checkNotNullParameter((Object)terminalUtils, (String)"terminalUtils");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        try {
            user2 = (UserMessages.User)terminalUtils.withTerminalProgress("Getting organization", (Function0)new Function0<UserMessages.User>(commandExecutor){
                final /* synthetic */ CommandExecutor $commandExecutor;
                {
                    this.$commandExecutor = $commandExecutor;
                    super(0);
                }

                public final UserMessages.User invoke() {
                    return this.$commandExecutor.getUser().getUser();
                }
            });
        }
        catch (Exception exception) {
            throw new CreateApplicationException("Cannot find organization", null, "create.application", 2, null);
        }
        UserMessages.User user3 = user2;
        String string = user3.getExternal().getId();
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
        String userId = string;
        List organizations = user3.getExternal().getOrganizationsList();
        Intrinsics.checkNotNull((Object)organizations);
        String organizationId = this.getOrganizationId(organizationIdArg, organizations, interactiveMode);
        return TuplesKt.to((Object)userId, (Object)organizationId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getOrganizationId(String organizationIdArg, List<UserMessages.UserOrganization> organizations, boolean interactiveMode) {
        CharSequence charSequence;
        CharSequence charSequence2 = organizationIdArg;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            charSequence = this.checkOrganizationIdIsValid(organizationIdArg, organizations);
            return charSequence;
        } else if (organizations.size() != 1) {
            if (!interactiveMode) throw new CreateApplicationException("No organization ID provided", null, "create.application", 2, null);
            String string = Terminal.prompt$default((Terminal)this.terminal, (String)"Organization ID", null, (boolean)false, (boolean)false, (boolean)false, null, null, null, (int)254, null);
            if (string == null) {
                string = "";
            }
            String organizationId = string;
            charSequence = this.checkOrganizationIdIsValid(organizationId, organizations);
            return charSequence;
        } else {
            charSequence2 = ((UserMessages.UserOrganization)CollectionsKt.first(organizations)).getOrganization().getId();
            Intrinsics.checkNotNull((Object)charSequence2);
            charSequence = charSequence2;
        }
        return charSequence;
    }

    private final String checkOrganizationIdIsValid(String organizationId, List<UserMessages.UserOrganization> organizations) {
        UserMessages.UserOrganization userOrganization;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = organizations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UserMessages.UserOrganization it = (UserMessages.UserOrganization)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOrganization().getId(), (Object)organizationId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        String foundOrganizationId = (userOrganization = (UserMessages.UserOrganization)v0) != null && (userOrganization = userOrganization.getOrganization()) != null ? userOrganization.getId() : null;
        CharSequence charSequence = foundOrganizationId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return foundOrganizationId;
        }
        throw new CreateApplicationException("Invalid organization ID provided", null, "create.application", 2, null);
    }

    @NotNull
    public final String getTeamId(@Nullable String teamIdArg, @NotNull String organizationId, @NotNull String userId, @NotNull CommandExecutor commandExecutor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)organizationId, (String)"organizationId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        CharSequence charSequence = teamIdArg;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            List<TeamMessages.Team> list;
            try {
                list = commandExecutor.getUserTeams(organizationId, userId);
            }
            catch (Exception exception) {
                throw new CreateApplicationException("Cannot find team", null, "create.application", 2, null);
            }
            List<TeamMessages.Team> teams = list;
            string = this.checkTeamIdIsValid(teamIdArg, teams);
        } else {
            string = "";
        }
        return string;
    }

    private final String checkTeamIdIsValid(String teamId, List<TeamMessages.Team> teams) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = teams;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TeamMessages.Team it = (TeamMessages.Team)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)teamId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        TeamMessages.Team team = v0;
        String foundTeamId = team != null ? team.getId() : null;
        CharSequence charSequence = foundTeamId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return foundTeamId;
        }
        throw new CreateApplicationException("Invalid team ID provided", null, "create.application", 2, null);
    }

    private final String addQuotesIfContainsWhiteSpace(String string) {
        Regex regex = new Regex("\\s");
        return regex.containsMatchIn((CharSequence)string) ? "\"" + string + "\"" : string;
    }

    public final void printHint(@NotNull String applicationName, @NotNull String environmentName, boolean interactiveMode, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        String applicationNameString = this.addQuotesIfContainsWhiteSpace(applicationName);
        String environmentNameString = this.addQuotesIfContainsWhiteSpace(environmentName);
        if (interactiveMode) {
            consolePrinter.println("\nHINT: avoid having to answer these questions next time with - hawk create app --name " + applicationNameString + " --env " + environmentNameString + "\n");
        }
    }

    private final ApplicationService.Application createApplicationWithValues(String applicationName, String environmentName, String organizationId, String teamId, boolean interactiveMode) {
        ApplicationService.Application app2 = (ApplicationService.Application)this.terminalUtils.withTerminalProgress("Creating app", (Function0)new Function0<ApplicationService.Application>(this, organizationId, applicationName, environmentName, teamId){
            final /* synthetic */ CreateUtils this$0;
            final /* synthetic */ String $organizationId;
            final /* synthetic */ String $applicationName;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $teamId;
            {
                this.this$0 = $receiver;
                this.$organizationId = $organizationId;
                this.$applicationName = $applicationName;
                this.$environmentName = $environmentName;
                this.$teamId = $teamId;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final ApplicationService.Application invoke() {
                Unit unit;
                try {
                    unit = this.this$0.getCommandExecutor().createApplication(this.$organizationId, this.$applicationName, this.$environmentName, this.$teamId);
                }
                catch (HawkScanException hawkScanException) {
                    ErrorUtils.INSTANCE.printHawkscanException(hawkScanException, this.this$0.getConsolePrinter());
                    unit = Unit.INSTANCE;
                }
                finally {
                    this.this$0.getStackhawkApiClient().stop();
                }
                Unit unit2 = unit;
                Intrinsics.checkNotNull((Object)unit2, (String)"null cannot be cast to non-null type com.stackhawk.nest.ApplicationService.Application");
                return (ApplicationService.Application)unit2;
            }
        });
        this.printHint(applicationName, environmentName, interactiveMode, this.consolePrinter);
        this.consolePrinter.println("KaaKaww! Here is your new application ID:");
        String string = app2.getApplicationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationId(...)");
        this.consolePrinter.println(string);
        return app2;
    }
}

