/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.stackhawk.hawk.Utils;
import com.stackhawk.hste.BootstrapUtils;
import com.stackhawk.hste.CommandExecutor;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.MainKt;
import com.stackhawk.hste.extension.talon.TalonHawkScanConfExtensions;
import com.stackhawk.hste.extension.talon.hawkscan.api.ConfException;
import com.stackhawk.hste.extension.talon.hawkscan.api.HawkScanException;
import com.stackhawk.hste.extension.talon.hawkscan.api.InvalidYamlFileException;
import com.stackhawk.nest.ApplicationService;
import com.stackhawk.nest.ScanResultMessages;
import com.stackhawk.nest.TalonMessages;
import java.time.Instant;
import java.util.List;
import java.util.Timer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.MarkedYAMLException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ*\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0016\u0010\"\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/stackhawk/hste/ErrorUtils;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createInvalidYamlExceptionMessage", "", "invalidYamlException", "Lcom/stackhawk/hste/extension/talon/hawkscan/api/InvalidYamlFileException;", "noColor", "", "createTalonError", "Lcom/stackhawk/nest/TalonMessages$TalonError;", "he", "Lcom/stackhawk/hste/extension/talon/hawkscan/api/HawkScanException;", "errorScan", "Lcom/stackhawk/nest/ScanResultMessages$Scan;", "talonConfig", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "hawkscanVersion", "genericConfException", "Lcom/stackhawk/hste/extension/talon/hawkscan/api/ConfException;", "e", "", "handleErrorForPlatform", "", "commandExecutor", "Lcom/stackhawk/hste/CommandExecutor;", "errorScanResult", "Lcom/stackhawk/nest/ScanResultMessages$ScanResult;", "handleException", "application", "Lcom/stackhawk/nest/ApplicationService$Application;", "printHawkscanException", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nErrorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorUtils.kt\ncom/stackhawk/hste/ErrorUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n360#2,7:127\n*S KotlinDebug\n*F\n+ 1 ErrorUtils.kt\ncom/stackhawk/hste/ErrorUtils\n*L\n98#1:127,7\n*E\n"})
public final class ErrorUtils {
    @NotNull
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    private static final Logger LOG = LogManager.getLogger(INSTANCE.getClass());

    private ErrorUtils() {
    }

    @NotNull
    public final ConfException genericConfException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = e.getMessage();
        if (string == null) {
            string = "Parsing error";
        }
        return new ConfException(string, e, "config-verify.linting.parse", null, 8, null);
    }

    @NotNull
    public final TalonMessages.TalonError createTalonError(@NotNull HawkScanException he) {
        Intrinsics.checkNotNullParameter((Object)he, (String)"he");
        String string = he.getCategory();
        if (string == null) {
            string = "";
        }
        return Utils.INSTANCE.talonError(string, he.label(), he.getMessage(), ExceptionsKt.stackTraceToString((Throwable)he), he.helpUrls());
    }

    public final void printHawkscanException(@NotNull HawkScanException he, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)he, (String)"he");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        consolePrinter.printTalonError(this.createTalonError(he), he.getNudge());
    }

    public final void handleException(@NotNull HawkScanException he, @NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull CommandExecutor commandExecutor, @Nullable ApplicationService.Application application) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)he, (String)"he");
            Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
            Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
            LOG.error("Bootstrap error", (Throwable)he);
            TalonMessages.TalonError talonError = this.createTalonError(he);
            commandExecutor.getConsolePrinter().printTalonError(talonError, he.getNudge());
            ApplicationService.Application application2 = application;
            if (application2 != null) {
                ApplicationService.Application it = application2;
                boolean bl = false;
                ScanResultMessages.ScanResult errorScanResult = MainKt.errorScanResult(talonError, INSTANCE.errorScan(talonConfig, BootstrapUtils.INSTANCE.getHawkscanVersion()));
                INSTANCE.handleErrorForPlatform(talonConfig, commandExecutor, errorScanResult);
            }
            Timer timer = commandExecutor.getApiClient().getTokenTimer();
            if (timer == null) break block1;
            timer.cancel();
        }
    }

    public static /* synthetic */ void handleException$default(ErrorUtils errorUtils, HawkScanException hawkScanException, TalonMessages.TalonHawkScanConf talonHawkScanConf, CommandExecutor commandExecutor, ApplicationService.Application application, int n, Object object) {
        if ((n & 8) != 0) {
            application = null;
        }
        errorUtils.handleException(hawkScanException, talonHawkScanConf, commandExecutor, application);
    }

    public final void handleErrorForPlatform(@NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull CommandExecutor commandExecutor, @NotNull ScanResultMessages.ScanResult errorScanResult) {
        Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)errorScanResult, (String)"errorScanResult");
        commandExecutor.errorScan(TalonHawkScanConfExtensions.INSTANCE.applicationId(talonConfig), errorScanResult);
    }

    @NotNull
    public final ScanResultMessages.Scan errorScan(@NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull String hawkscanVersion) {
        Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
        Intrinsics.checkNotNullParameter((Object)hawkscanVersion, (String)"hawkscanVersion");
        ScanResultMessages.Scan scan2 = ScanResultMessages.Scan.newBuilder().setId(talonConfig.getScanId()).setApplicationId(TalonHawkScanConfExtensions.INSTANCE.applicationId(talonConfig)).setEnv(TalonHawkScanConfExtensions.INSTANCE.environment(talonConfig)).setTimestamp(Instant.now().toEpochMilli()).setVersion(hawkscanVersion).build();
        Intrinsics.checkNotNullExpressionValue((Object)scan2, (String)"build(...)");
        return scan2;
    }

    @NotNull
    public final String createInvalidYamlExceptionMessage(@NotNull InvalidYamlFileException invalidYamlException, boolean noColor) {
        Object object;
        block12: {
            block11: {
                int startIndex;
                int n;
                MarkedYAMLException exception;
                List confLines;
                String lineSeparator;
                String resetColor;
                String boldColor;
                String errorColor;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)invalidYamlException, (String)"invalidYamlException");
                    errorColor = !noColor ? "\u001b[1;91m" : "";
                    boldColor = !noColor ? "\u001b[1m" : "";
                    resetColor = !noColor ? "\u001b[0m" : "";
                    lineSeparator = System.lineSeparator();
                    CharSequence charSequence = invalidYamlException.confText();
                    String[] stringArray = new String[1];
                    Intrinsics.checkNotNull((Object)lineSeparator);
                    stringArray[0] = lineSeparator;
                    confLines = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    object = invalidYamlException.markedYamlException();
                    if (object == null) break block11;
                    exception = object;
                    boolean bl = false;
                    String string = exception.getProblemMark().get_snippet();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get_snippet(...)");
                    int snippetKeyEndIndex = StringsKt.indexOf$default((CharSequence)string, (String)":", (int)0, (boolean)false, (int)6, null);
                    int snippetKeyStartIndex = 0;
                    String string2 = exception.getProblemMark().get_snippet();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get_snippet(...)");
                    String string3 = string2;
                    int n2 = 0;
                    String string4 = string3.substring(n2, snippetKeyEndIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    snippetKeyStartIndex = StringsKt.lastIndexOf$default((CharSequence)string4, (String)" ", (int)0, (boolean)false, (int)6, null);
                    if (snippetKeyStartIndex < 0) {
                        snippetKeyStartIndex = 0;
                    }
                    List $this$indexOfFirst$iv = confLines;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        String string5;
                        String it = (String)item$iv;
                        boolean bl2 = false;
                        CharSequence charSequence2 = StringsKt.trimIndent((String)it);
                        Intrinsics.checkNotNullExpressionValue((Object)exception.getProblemMark().get_snippet(), (String)"get_snippet(...)");
                        int n3 = snippetKeyStartIndex;
                        String string6 = string5.substring(n3, snippetKeyEndIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        if (StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)StringsKt.trimIndent((String)string6), (boolean)false, (int)2, null)) {
                            n = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int confErrorLineIndex = n;
                Object snippet = "";
                int maxLinesDigits = String.valueOf(confLines.size()).length();
                boolean nearTop = confErrorLineIndex - 5 < 0;
                for (int i = startIndex = nearTop ? 0 : confErrorLineIndex - 5; i < confErrorLineIndex; ++i) {
                    snippet = (String)snippet + StringsKt.repeat((CharSequence)" ", (int)(maxLinesDigits - String.valueOf(i + 1).length())) + (i + 1) + "  " + confLines.get(i) + lineSeparator;
                }
                snippet = (String)snippet + StringsKt.repeat((CharSequence)" ", (int)(maxLinesDigits - String.valueOf(confErrorLineIndex + 1).length())) + resetColor + errorColor + (confErrorLineIndex + 1) + "  " + confLines.get(confErrorLineIndex) + lineSeparator;
                snippet = (String)snippet + StringsKt.repeat((CharSequence)" ", (int)(maxLinesDigits - String.valueOf(confErrorLineIndex + 1).length())) + StringsKt.repeat((CharSequence)" ", (int)String.valueOf(confErrorLineIndex).length()) + "  " + StringsKt.repeat((CharSequence)" ", (int)exception.getProblemMark().getColumn()) + "^";
                snippet = (String)snippet + " " + exception.getProblem() + resetColor + boldColor + lineSeparator;
                boolean nearBottom = confErrorLineIndex + 5 > confLines.size() - 1;
                int endIndex = nearBottom ? confLines.size() - 1 : confErrorLineIndex + 5;
                for (int i = confErrorLineIndex + 1; i < endIndex; ++i) {
                    snippet = (String)snippet + StringsKt.repeat((CharSequence)" ", (int)(maxLinesDigits - String.valueOf(i + 1).length())) + (i + 1) + "  " + confLines.get(i) + lineSeparator;
                }
                snippet = (String)snippet + confLines.get(endIndex);
                Object startEllipsis = nearTop ? "" : "..." + lineSeparator;
                Object endEllipsis = nearBottom ? "" : lineSeparator + "...";
                String string = boldColor + (String)startEllipsis + StringsKt.substringBeforeLast$default((String)snippet, (String)lineSeparator, null, (int)2, null) + (String)endEllipsis + resetColor;
                object = string;
                if (string != null) break block12;
            }
            if ((object = invalidYamlException.getMessage()) == null) {
                object = "";
            }
        }
        return object;
    }

    public static /* synthetic */ String createInvalidYamlExceptionMessage$default(ErrorUtils errorUtils, InvalidYamlFileException invalidYamlFileException, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return errorUtils.createInvalidYamlExceptionMessage(invalidYamlFileException, bl);
    }
}

