/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.stackhawk.hste.BootstrapUtils;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.extension.talon.hawkscan.api.InstalledEnvironmentException;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\u0000J\u0016\u0010!\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0016J\u0006\u0010#\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/stackhawk/hste/GitWrapper;", "", "gitUrl", "", "gitRev", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "(Ljava/lang/String;Ljava/lang/String;Lcom/stackhawk/hste/ConsolePrinter;)V", "cloneCmd", "Lorg/eclipse/jgit/api/CloneCommand;", "getConsolePrinter", "()Lcom/stackhawk/hste/ConsolePrinter;", "gitRepo", "Lorg/eclipse/jgit/api/Git;", "getGitRepo", "()Lorg/eclipse/jgit/api/Git;", "setGitRepo", "(Lorg/eclipse/jgit/api/Git;)V", "getGitRev", "()Ljava/lang/String;", "getGitUrl", "projectDirFile", "Ljava/io/File;", "getProjectDirFile", "()Ljava/io/File;", "setProjectDirFile", "(Ljava/io/File;)V", "callCommandCheckout", "Lorg/eclipse/jgit/lib/Ref;", "repo", "callCommandClone", "cmd", "cloneAndCheckoutGitRepo", "commandClone", "projectDirectory", "init", "talon-bootstrap"})
public final class GitWrapper {
    @NotNull
    private final String gitUrl;
    @Nullable
    private final String gitRev;
    @Nullable
    private final ConsolePrinter consolePrinter;
    public File projectDirFile;
    public Git gitRepo;
    private CloneCommand cloneCmd;

    public GitWrapper(@NotNull String gitUrl, @Nullable String gitRev, @Nullable ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)gitUrl, (String)"gitUrl");
        this.gitUrl = gitUrl;
        this.gitRev = gitRev;
        this.consolePrinter = consolePrinter;
    }

    public /* synthetic */ GitWrapper(String string, String string2, ConsolePrinter consolePrinter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            consolePrinter = null;
        }
        this(string, string2, consolePrinter);
    }

    @NotNull
    public final String getGitUrl() {
        return this.gitUrl;
    }

    @Nullable
    public final String getGitRev() {
        return this.gitRev;
    }

    @Nullable
    public final ConsolePrinter getConsolePrinter() {
        return this.consolePrinter;
    }

    @NotNull
    public final File getProjectDirFile() {
        File file = this.projectDirFile;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"projectDirFile");
        return null;
    }

    public final void setProjectDirFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.projectDirFile = file;
    }

    @NotNull
    public final Git getGitRepo() {
        Git git = this.gitRepo;
        if (git != null) {
            return git;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"gitRepo");
        return null;
    }

    public final void setGitRepo(@NotNull Git git) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"<set-?>");
        this.gitRepo = git;
    }

    @NotNull
    public final GitWrapper init() {
        this.setProjectDirFile(this.projectDirectory());
        this.cloneCmd = this.commandClone(this.gitUrl, this.projectDirectory());
        return this;
    }

    @NotNull
    public final CloneCommand commandClone(@NotNull String gitUrl, @NotNull File projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)gitUrl, (String)"gitUrl");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        CloneCommand cloneCommand = Git.cloneRepository().setURI(gitUrl).setDirectory(projectDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)cloneCommand, (String)"setDirectory(...)");
        return cloneCommand;
    }

    @Nullable
    public final Ref callCommandCheckout(@NotNull Git repo, @NotNull String gitRev) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)gitRev, (String)"gitRev");
        return repo.checkout().setName(gitRev).call();
    }

    @NotNull
    public final Git callCommandClone(@NotNull CloneCommand cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Git git = cmd.call();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"call(...)");
        return git;
    }

    @NotNull
    public final File projectDirectory() {
        String projectDir = BootstrapUtils.isInDocker$default(BootstrapUtils.INSTANCE, null, 1, null) && !new File("/hawk").exists() && !Intrinsics.areEqual((Object)BootstrapUtils.INSTANCE.getUserName(), (Object)"root") ? BootstrapUtils.INSTANCE.getUserHome() + "/projectDir" : BootstrapUtils.INSTANCE.getCwd() + "/projectDir";
        File projectDirFile = new File(projectDir);
        FilesKt.deleteRecursively((File)projectDirFile);
        projectDirFile.deleteOnExit();
        return projectDirFile;
    }

    @NotNull
    public final GitWrapper cloneAndCheckoutGitRepo() {
        block13: {
            Ref ref;
            Git git;
            try {
                CloneCommand cloneCommand = this.cloneCmd;
                if (cloneCommand == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cloneCmd");
                    cloneCommand = null;
                }
                git = this.callCommandClone(cloneCommand);
            }
            catch (TransportException te) {
                ConsolePrinter consolePrinter = this.consolePrinter;
                if (consolePrinter != null) {
                    consolePrinter.print("Git Username: ");
                }
                ConsolePrinter consolePrinter2 = this.consolePrinter;
                String username = consolePrinter2 != null ? consolePrinter2.readConsoleLine() : null;
                ConsolePrinter consolePrinter3 = this.consolePrinter;
                if (consolePrinter3 != null) {
                    consolePrinter3.print("Git Password or Personal Access Token: ");
                }
                ConsolePrinter consolePrinter4 = this.consolePrinter;
                char[] pw = (char[])(consolePrinter4 != null ? consolePrinter4.readConsolePassword() : null);
                try {
                    CloneCommand cloneCommand = this.cloneCmd;
                    if (cloneCommand == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"cloneCmd");
                        cloneCommand = null;
                    }
                    CloneCommand gitCred = (CloneCommand)cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, pw));
                    Intrinsics.checkNotNull((Object)gitCred);
                    ref = this.callCommandClone(gitCred);
                }
                catch (InvalidRemoteException invalidRemoteException) {
                    throw new InstalledEnvironmentException(this.gitUrl + " is not a valid repository url.", null, null, 6, null);
                }
                git = ref;
            }
            catch (InvalidRemoteException invalidRemoteException) {
                throw new InstalledEnvironmentException(this.gitUrl + " is not a valid repository url.", null, null, 6, null);
            }
            Git repo = git;
            String string = this.gitRev;
            if (string == null) break block13;
            String it = string;
            boolean bl = false;
            try {
                ref = this.callCommandCheckout(repo, it);
            }
            catch (RefNotFoundException refNotFoundException) {
                Ref ref2;
                try {
                    ref2 = this.callCommandCheckout(repo, "origin/" + it);
                }
                catch (RefNotFoundException refNotFoundException2) {
                    throw new InstalledEnvironmentException(this.gitRev + " is not a valid branch or commit Id.", null, null, 6, null);
                }
                ref = ref2;
            }
        }
        return this;
    }
}

