/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.github.ajalt.clikt.sources.MapValueSource;
import com.github.ajalt.clikt.sources.PropertiesValueSource;
import com.github.ajalt.clikt.sources.ValueSource;
import com.stackhawk.hste.extension.talon.hawkscan.api.InstalledEnvironmentException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001bJ\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001bJ\u0016\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0!J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u00012\b\b\u0002\u0010'\u001a\u00020\u0004H\u0002J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001b2\b\b\u0002\u0010'\u001a\u00020)J\u0006\u0010*\u001a\u00020\u001eJ\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001b2\b\b\u0002\u0010'\u001a\u00020)J\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020)J\u000e\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eJ\u0018\u0010.\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\b\b\u0002\u0010'\u001a\u00020\u0004J\u0016\u0010/\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0001J \u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u00012\b\b\u0002\u00101\u001a\u00020\u0004R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u0019\u0010\u0013\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/stackhawk/hste/HawkValuesSource;", "", "()V", "daemonProperties", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getDaemonProperties", "()Ljava/nio/file/Path;", "daemonSession", "getDaemonSession", "deamonDir", "getDeamonDir", "defaultSources", "", "", "getDefaultSources", "()Ljava/util/Set;", "path", "getPath", "propFile", "getPropFile", "props", "Ljava/util/Properties;", "rcFile", "getRcFile", "userHome", "daemonPropValues", "", "envValues", "from", "Lcom/github/ajalt/clikt/sources/ValueSource;", "files", "fromEnvType", "Lkotlin/Pair;", "pair", "modifyProperty", "", "propertyName", "propertyValue", "file", "propValues", "Ljava/io/File;", "propValuesSource", "rcValues", "rcValuesSource", "removeDaemonProperty", "removeProperty", "storeDaemonProperty", "storeProperty", "propertiesFile", "talon-bootstrap"})
@SourceDebugExtension(value={"SMAP\nHawkValuesSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HawkValuesSource.kt\ncom/stackhawk/hste/HawkValuesSource\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n126#2:125\n153#2,3:126\n1187#3,2:129\n1261#3,4:131\n1611#3,9:135\n1863#3:144\n1864#3:147\n1620#3:148\n1187#3,2:149\n1261#3,4:151\n1557#3:155\n1628#3,3:156\n1#4:145\n1#4:146\n*S KotlinDebug\n*F\n+ 1 HawkValuesSource.kt\ncom/stackhawk/hste/HawkValuesSource\n*L\n68#1:125\n68#1:126,3\n68#1:129,2\n68#1:131,4\n75#1:135,9\n75#1:144\n75#1:147\n75#1:148\n79#1:149,2\n79#1:151,4\n98#1:155\n98#1:156,3\n75#1:146\n*E\n"})
public final class HawkValuesSource {
    @NotNull
    public static final HawkValuesSource INSTANCE = new HawkValuesSource();
    @NotNull
    private static final String userHome;
    private static final Path path;
    @NotNull
    private static final Properties props;
    private static final Path propFile;
    private static final Path rcFile;
    @NotNull
    private static final Set<String> defaultSources;
    private static final Path deamonDir;
    private static final Path daemonProperties;
    private static final Path daemonSession;

    private HawkValuesSource() {
    }

    public final Path getPath() {
        return path;
    }

    public final Path getPropFile() {
        return propFile;
    }

    public final Path getRcFile() {
        return rcFile;
    }

    @NotNull
    public final Set<String> getDefaultSources() {
        return defaultSources;
    }

    public final Path getDeamonDir() {
        return deamonDir;
    }

    public final Path getDaemonProperties() {
        return daemonProperties;
    }

    public final Path getDaemonSession() {
        return daemonSession;
    }

    public final void storeProperty(@NotNull String propertyName, @NotNull Object propertyValue, @NotNull Path propertiesFile) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        if (!Files.exists(propertiesFile, new LinkOption[0])) {
            File file = propertiesFile.toFile();
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        this.modifyProperty(propertyName, propertyValue, propertiesFile);
    }

    public static /* synthetic */ void storeProperty$default(HawkValuesSource hawkValuesSource, String string, Object object, Path path, int n, Object object2) {
        if ((n & 4) != 0) {
            Path path2 = propFile;
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        }
        hawkValuesSource.storeProperty(string, object, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modifyProperty(String propertyName, Object propertyValue, Path file) {
        Closeable closeable = new FileInputStream(file.toFile());
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            props.load(it);
            props.setProperty(propertyName, propertyValue.toString());
            OutputStream out = new FileOutputStream(file.toFile());
            props.store(out, "HawkScan Properties");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void modifyProperty$default(HawkValuesSource hawkValuesSource, String string, Object object, Path path, int n, Object object2) {
        if ((n & 4) != 0) {
            Path path2 = propFile;
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        }
        hawkValuesSource.modifyProperty(string, object, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProperty(@NotNull String propertyName, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileInputStream(file.toFile());
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            props.load(it);
            props.remove(propertyName);
            OutputStream out = new FileOutputStream(file.toFile());
            props.store(out, "HawkScan Properties");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void removeProperty$default(HawkValuesSource hawkValuesSource, String string, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            Path path2 = propFile;
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        }
        hawkValuesSource.removeProperty(string, path);
    }

    @NotNull
    public final Map<String, String> propValues(@NotNull File file) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            map = props;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    public static /* synthetic */ Map propValues$default(HawkValuesSource hawkValuesSource, File file, int n, Object object) {
        if ((n & 1) != 0) {
            File file2 = propFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            file = file2;
        }
        return hawkValuesSource.propValues(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> envValues() {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
        Map<String, String> $this$map$iv = map;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), it.getValue()));
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair<String, String> pair = INSTANCE.fromEnvType((Pair<String, String>)it);
            map3.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> rcValues(@NotNull File file) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            void $this$associateTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = FilesKt.readLines$default((File)file, null, (int)1, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<Pair> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                String[] stringArray = new String[]{"="};
                List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if ((String)CollectionsKt.firstOrNull((List)parts) != null) {
                    String it;
                    boolean bl3 = false;
                    String string = (String)CollectionsKt.lastOrNull((List)parts);
                    if (string == null) {
                        string = "";
                    }
                    pair = TuplesKt.to((Object)it, (Object)string);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                Pair<String, String> pair = INSTANCE.fromEnvType((Pair<String, String>)it);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv2;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    public static /* synthetic */ Map rcValues$default(HawkValuesSource hawkValuesSource, File file, int n, Object object) {
        if ((n & 1) != 0) {
            File file2 = rcFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            file = file2;
        }
        return hawkValuesSource.rcValues(file);
    }

    @NotNull
    public final Pair<String, String> fromEnvType(@NotNull Pair<String, String> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        String string = (String)pair.getFirst();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return TuplesKt.to((Object)((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)string2, (String)"_", (String)"-", (boolean)false, (int)4, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)((String)pair.getSecond()))).toString());
    }

    @NotNull
    public final ValueSource propValuesSource() {
        File file = propFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        String string = FilesKt.readText$default((File)file, null, (int)1, null);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        props.load(new ByteArrayInputStream(byArray));
        return PropertiesValueSource.from$default((PropertiesValueSource)PropertiesValueSource.INSTANCE, (Properties)props, null, (int)2, null);
    }

    @NotNull
    public final ValueSource rcValuesSource(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (ValueSource)new MapValueSource(this.rcValues(file), null, 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final ValueSource from(@NotNull Set<String> files) {
        ValueSource valueSource;
        Object v0;
        block6: {
            Iterator $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Iterable $this$map$iv = files;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p;
                Object item$iv$iv = iterator.next();
                String string = (String)item$iv$iv;
                Collection collection2 = collection;
                boolean bl = false;
                collection2.add(Path.of((String)p, new String[0]).toFile());
            }
            Iterable iterable2 = (List)collection;
            for (Object t : iterable2) {
                File f = (File)t;
                boolean bl = false;
                if (!f.exists()) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        File file = v0;
        if (file != null) {
            ValueSource valueSource2;
            File f = file;
            boolean bl = false;
            String string = f.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            if (StringsKt.endsWith$default((String)string, (String)".rc", (boolean)false, (int)2, null)) {
                v2 = INSTANCE.rcValuesSource(f);
            } else {
                String string2 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)".properties", (boolean)false, (int)2, null)) throw new InstalledEnvironmentException("Unsupported file type, only .rc and .properties files are supported.", null, null, 6, null);
                v2 = valueSource2 = PropertiesValueSource.from$default((PropertiesValueSource)PropertiesValueSource.INSTANCE, (File)f, (boolean)false, null, (int)6, null);
            }
            if (valueSource2 != null) {
                valueSource = valueSource2;
                return valueSource;
            }
        }
        valueSource = (ValueSource)new MapValueSource(MapsKt.emptyMap(), null, 2, null);
        return valueSource;
    }

    public static /* synthetic */ ValueSource from$default(HawkValuesSource hawkValuesSource, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = defaultSources;
        }
        return hawkValuesSource.from(set);
    }

    public final void storeDaemonProperty(@NotNull String propertyName, @NotNull Object propertyValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        Path path = daemonProperties;
        Intrinsics.checkNotNull((Object)path);
        this.storeProperty(propertyName, propertyValue, path);
    }

    public final void removeDaemonProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Path path = daemonProperties;
        Intrinsics.checkNotNull((Object)path);
        this.removeProperty(propertyName, path);
    }

    @NotNull
    public final Map<String, String> daemonPropValues() {
        File file = daemonProperties.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this.propValues(file);
    }

    static {
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        userHome = string;
        path = Paths.get(userHome + File.separator + ".hawk", new String[0]);
        props = new Properties();
        propFile = Paths.get(path + File.separator + "hawk.properties", new String[0]);
        rcFile = Paths.get(path + File.separator + "hawk.rc", new String[0]);
        Object[] objectArray = new String[2];
        objectArray[0] = ((Object)propFile).toString();
        objectArray[1] = ((Object)rcFile).toString();
        defaultSources = SetsKt.setOf((Object[])objectArray);
        deamonDir = Paths.get(path + File.separator + "daemon", new String[0]);
        daemonProperties = Paths.get(deamonDir + File.separator + "hawk_daemon.properties", new String[0]);
        daemonSession = Paths.get(deamonDir + File.separator + "session", new String[0]);
    }
}

