/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.stackhawk.hste.Bootstrap;
import com.stackhawk.hste.CommandExecutor;
import com.stackhawk.hste.ConsolePrinter;
import com.stackhawk.hste.ErrorUtils;
import com.stackhawk.hste.extension.talon.hawkscan.api.UnexpectedError;
import com.stackhawk.hste.handlers.ScanResponseOutputHandler;
import com.stackhawk.nest.ApplicationService;
import com.stackhawk.nest.ScanResultMessages;
import com.stackhawk.nest.TalonMessages;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0007\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/stackhawk/hste/ShutdownHandler;", "Ljava/lang/Thread;", "completed", "Lkotlinx/atomicfu/AtomicBoolean;", "consolePrinter", "Lcom/stackhawk/hste/ConsolePrinter;", "hsteProcessRef", "Lkotlinx/atomicfu/AtomicRef;", "Ljava/lang/Process;", "scanResponseOutputHandlerRef", "Lcom/stackhawk/hste/handlers/ScanResponseOutputHandler;", "beforeScanStartedRef", "beforeScanRef", "Lcom/stackhawk/nest/ScanResultMessages$BeforeScan;", "errorUtils", "Lcom/stackhawk/hste/ErrorUtils;", "talonConfig", "Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;", "commandExecutor", "Lcom/stackhawk/hste/CommandExecutor;", "applicationRef", "Lcom/stackhawk/nest/ApplicationService$Application;", "(Lkotlinx/atomicfu/AtomicBoolean;Lcom/stackhawk/hste/ConsolePrinter;Lkotlinx/atomicfu/AtomicRef;Lkotlinx/atomicfu/AtomicRef;Lkotlinx/atomicfu/AtomicBoolean;Lkotlinx/atomicfu/AtomicRef;Lcom/stackhawk/hste/ErrorUtils;Lcom/stackhawk/nest/TalonMessages$TalonHawkScanConf;Lcom/stackhawk/hste/CommandExecutor;Lkotlinx/atomicfu/AtomicRef;)V", "delayMillis", "", "waitTimeoutSeconds", "run", "", "sendTerminatedByUserError", "waitForComplete", "waitForJobs", "talon-bootstrap"})
public final class ShutdownHandler
extends Thread {
    @NotNull
    private final AtomicBoolean completed;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final AtomicRef<Process> hsteProcessRef;
    @NotNull
    private final AtomicRef<ScanResponseOutputHandler> scanResponseOutputHandlerRef;
    @NotNull
    private final AtomicBoolean beforeScanStartedRef;
    @NotNull
    private final AtomicRef<ScanResultMessages.BeforeScan> beforeScanRef;
    @NotNull
    private final ErrorUtils errorUtils;
    @NotNull
    private final TalonMessages.TalonHawkScanConf talonConfig;
    @NotNull
    private final CommandExecutor commandExecutor;
    @NotNull
    private final AtomicRef<ApplicationService.Application> applicationRef;
    private final long waitTimeoutSeconds;
    private final long delayMillis;

    public ShutdownHandler(@NotNull AtomicBoolean completed, @NotNull ConsolePrinter consolePrinter, @NotNull AtomicRef<Process> hsteProcessRef, @NotNull AtomicRef<ScanResponseOutputHandler> scanResponseOutputHandlerRef, @NotNull AtomicBoolean beforeScanStartedRef, @NotNull AtomicRef<ScanResultMessages.BeforeScan> beforeScanRef, @NotNull ErrorUtils errorUtils, @NotNull TalonMessages.TalonHawkScanConf talonConfig, @NotNull CommandExecutor commandExecutor, @NotNull AtomicRef<ApplicationService.Application> applicationRef) {
        Intrinsics.checkNotNullParameter((Object)completed, (String)"completed");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter(hsteProcessRef, (String)"hsteProcessRef");
        Intrinsics.checkNotNullParameter(scanResponseOutputHandlerRef, (String)"scanResponseOutputHandlerRef");
        Intrinsics.checkNotNullParameter((Object)beforeScanStartedRef, (String)"beforeScanStartedRef");
        Intrinsics.checkNotNullParameter(beforeScanRef, (String)"beforeScanRef");
        Intrinsics.checkNotNullParameter((Object)errorUtils, (String)"errorUtils");
        Intrinsics.checkNotNullParameter((Object)talonConfig, (String)"talonConfig");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter(applicationRef, (String)"applicationRef");
        this.completed = completed;
        this.consolePrinter = consolePrinter;
        this.hsteProcessRef = hsteProcessRef;
        this.scanResponseOutputHandlerRef = scanResponseOutputHandlerRef;
        this.beforeScanStartedRef = beforeScanStartedRef;
        this.beforeScanRef = beforeScanRef;
        this.errorUtils = errorUtils;
        this.talonConfig = talonConfig;
        this.commandExecutor = commandExecutor;
        this.applicationRef = applicationRef;
        this.waitTimeoutSeconds = 30L;
        this.delayMillis = 10L;
    }

    @Override
    public void run() {
        if (!this.completed.getValue()) {
            ConsolePrinter.printReset$default(this.consolePrinter, 0, 1, null);
            this.consolePrinter.println("Termination signal received");
            Process process = (Process)this.hsteProcessRef.getValue();
            if (process != null) {
                process.destroy();
            }
            if (this.scanResponseOutputHandlerRef.getValue() == null) {
                if (this.beforeScanStartedRef.getValue()) {
                    this.waitForJobs();
                }
                this.completed.getAndSet(true);
                if (this.beforeScanRef.getValue() != null) {
                    this.sendTerminatedByUserError();
                }
            } else {
                ScanResponseOutputHandler scanResponseOutputHandler2 = (ScanResponseOutputHandler)this.scanResponseOutputHandlerRef.getValue();
                if (scanResponseOutputHandler2 != null) {
                    scanResponseOutputHandler2.terminate();
                }
            }
            this.waitForComplete();
        }
    }

    private final void waitForJobs() {
        Instant start2 = Instant.now();
        while (Bootstrap.INSTANCE.getAsyncScope().getJobQueue().size() > 0 && Instant.now().isBefore(start2.plusSeconds(this.waitTimeoutSeconds))) {
            Thread.sleep(this.delayMillis);
        }
    }

    private final void waitForComplete() {
        Instant start2 = Instant.now();
        while (!this.completed.getValue() && Instant.now().isBefore(start2.plusSeconds(this.waitTimeoutSeconds))) {
            Thread.sleep(this.delayMillis);
        }
    }

    private final void sendTerminatedByUserError() {
        UnexpectedError he = new UnexpectedError("Process terminated by user", null, null, 6, null);
        this.errorUtils.handleException(he, this.talonConfig, this.commandExecutor, (ApplicationService.Application)this.applicationRef.getValue());
    }
}

