/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.apikey;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\u0000J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/stackhawk/apikey/Key;", "", "identifier", "", "secret", "(Ljava/lang/String;Ljava/lang/String;)V", "getIdentifier", "()Ljava/lang/String;", "getSecret", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "hashed", "toString", "nest"})
public final class Key {
    @NotNull
    private final String identifier;
    @NotNull
    private final String secret;

    public Key(@NotNull String identifier, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.identifier = identifier;
        this.secret = secret;
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final String getSecret() {
        return this.secret;
    }

    @NotNull
    public final Key hashed() {
        String string = DigestUtils.sha256Hex((String)this.secret);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sha256Hex(secret)");
        return new Key(this.identifier, string);
    }

    @NotNull
    public String toString() {
        return "hawk." + this.identifier + "." + this.secret;
    }

    @NotNull
    public final String component1() {
        return this.identifier;
    }

    @NotNull
    public final String component2() {
        return this.secret;
    }

    @NotNull
    public final Key copy(@NotNull String identifier, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        return new Key(identifier, secret);
    }

    public static /* synthetic */ Key copy$default(Key key, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = key.identifier;
        }
        if ((n & 2) != 0) {
            string2 = key.secret;
        }
        return key.copy(string, string2);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = result * 31 + this.secret.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Key)) {
            return false;
        }
        Key key = (Key)other;
        if (!Intrinsics.areEqual((Object)this.identifier, (Object)key.identifier)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.secret, (Object)key.secret);
    }
}

