/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.grpc.test;

import com.stackhawk.grpc.GlobalGrpcExceptionHandler;
import com.stackhawk.grpc.test.CleanupTarget;
import com.stackhawk.grpc.test.ManagedChannelCleanupTarget;
import com.stackhawk.grpc.test.ServerCleanupTarget;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stackhawk/grpc/test/GrpcCleanupExtension;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "Lorg/junit/jupiter/api/extension/BeforeAllCallback;", "()V", "cleanupTargets", "", "Lcom/stackhawk/grpc/test/CleanupTarget;", "addService", "Lio/grpc/ManagedChannel;", "service", "Lio/grpc/BindableService;", "afterEach", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "beforeAll", "extContext", "isAllTerminated", "", "Companion", "nest"})
@SourceDebugExtension(value={"SMAP\nGrpcCleanupExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcCleanupExtension.kt\ncom/stackhawk/grpc/test/GrpcCleanupExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1#2:145\n1855#3,2:146\n1726#3,3:148\n*S KotlinDebug\n*F\n+ 1 GrpcCleanupExtension.kt\ncom/stackhawk/grpc/test/GrpcCleanupExtension\n*L\n89#1:146,2\n113#1:148,3\n*E\n"})
public final class GrpcCleanupExtension
implements AfterEachCallback,
BeforeAllCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<CleanupTarget> cleanupTargets = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger(GrpcCleanupExtension.class);
    @NotNull
    private static GlobalGrpcExceptionHandler globalGrpcExceptionHandler = new GlobalGrpcExceptionHandler(null, null, null, 7, null);
    public static final long TERMINATION_TIMEOUT_MS = 250L;
    public static final int MAX_NUM_TERMINATIONS = 100;

    public void beforeAll(@NotNull ExtensionContext extContext) {
        Object object;
        Object it;
        Object $this$beforeAll_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)extContext, (String)"extContext");
        Object object2 = this;
        try {
            $this$beforeAll_u24lambda_u240 = object2;
            boolean bl = false;
            ApplicationContext applicationContext = SpringExtension.getApplicationContext((ExtensionContext)extContext);
            Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"getApplicationContext(extContext)");
            ApplicationContext springContext = applicationContext;
            $this$beforeAll_u24lambda_u240 = Result.constructor-impl((Object)((GlobalGrpcExceptionHandler)springContext.getBean(GlobalGrpcExceptionHandler.class)));
        }
        catch (Throwable bl) {
            $this$beforeAll_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$beforeAll_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = $this$beforeAll_u24lambda_u240 = throwable;
            boolean bl = false;
            logger.debug("Unable to find a bean for the GlobalGrpcExceptionHandler, defaulting to an unconfigured global exception handler instance...", (Throwable)e);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            it = (GlobalGrpcExceptionHandler)object2;
            boolean bl = false;
            object = it;
        } else {
            it = throwable2;
            boolean bl = false;
            object = new GlobalGrpcExceptionHandler(null, null, null, 7, null);
        }
        Object globalGrpcExceptionHandlerResult = object;
        globalGrpcExceptionHandler = globalGrpcExceptionHandlerResult;
    }

    @NotNull
    public final ManagedChannel addService(@NotNull BindableService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        String string = InProcessServerBuilder.generateName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateName()");
        String serverName = string;
        Server server = ((InProcessServerBuilder)((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).intercept((ServerInterceptor)globalGrpcExceptionHandler)).addService(service)).build().start();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"forName(serverName)\n    \u2026\n                .start()");
        this.cleanupTargets.add(new ServerCleanupTarget(server));
        ManagedChannel channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        this.cleanupTargets.add(new ManagedChannelCleanupTarget(channel));
        return channel;
    }

    public void afterEach(@Nullable ExtensionContext context) {
        Iterable $this$forEach$iv = this.cleanupTargets;
        boolean $i$f$forEach = false;
        block2: for (Object element$iv : $this$forEach$iv) {
            CleanupTarget cleanupTarget = (CleanupTarget)element$iv;
            boolean bl = false;
            try {
                int count = 0;
                cleanupTarget.shutdown();
                do {
                    cleanupTarget.awaitTermination(250L, TimeUnit.MILLISECONDS);
                    if (++count <= 100) continue;
                    logger.error("Hit max count " + count + " trying to shut down down cleanupTarget " + cleanupTarget);
                    continue block2;
                } while (!cleanupTarget.isTerminated());
            }
            catch (Exception e) {
                logger.error("Problem shutting down cleanupTarget " + cleanupTarget, (Throwable)e);
            }
        }
        if (this.isAllTerminated()) {
            this.cleanupTargets.clear();
        } else {
            logger.error("Not all cleanupTargets are terminated");
        }
    }

    public final boolean isAllTerminated() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.cleanupTargets;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CleanupTarget it = (CleanupTarget)element$iv;
                    boolean bl2 = false;
                    if (it.isTerminated()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stackhawk/grpc/test/GrpcCleanupExtension$Companion;", "", "()V", "MAX_NUM_TERMINATIONS", "", "TERMINATION_TIMEOUT_MS", "", "globalGrpcExceptionHandler", "Lcom/stackhawk/grpc/GlobalGrpcExceptionHandler;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "nest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

