/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.health;

import com.stackhawk.nest.health.dao.HealthDao;
import java.security.Security;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stackhawk/nest/health/DbTickleHealthIndicator;", "Lorg/springframework/boot/actuate/health/HealthIndicator;", "()V", "healthDao", "Lcom/stackhawk/nest/health/dao/HealthDao;", "getHealthDao", "()Lcom/stackhawk/nest/health/dao/HealthDao;", "setHealthDao", "(Lcom/stackhawk/nest/health/dao/HealthDao;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "health", "Lorg/springframework/boot/actuate/health/Health;", "Companion", "nest"})
public class DbTickleHealthIndicator
implements HealthIndicator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LoggerFactory.getLogger(DbTickleHealthIndicator.class);
    @Autowired
    public HealthDao healthDao;
    @NotNull
    public static final String HEALTH_CHECK_KEY = "health";

    public DbTickleHealthIndicator() {
        Security.setProperty("networkaddress.cache.ttl", "60");
    }

    @NotNull
    public HealthDao getHealthDao() {
        HealthDao healthDao = this.healthDao;
        if (healthDao != null) {
            return healthDao;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"healthDao");
        return null;
    }

    public void setHealthDao(@NotNull HealthDao healthDao) {
        Intrinsics.checkNotNullParameter((Object)healthDao, (String)"<set-?>");
        this.healthDao = healthDao;
    }

    @NotNull
    public Health health() {
        Health health;
        try {
            this.getHealthDao().checkUpdateHealth(HEALTH_CHECK_KEY);
            Health health2 = Health.up().build();
            Intrinsics.checkNotNullExpressionValue((Object)health2, (String)"{\n      healthDao.checkU\u2026Health.up().build()\n    }");
            health = health2;
        }
        catch (Throwable t) {
            this.logger.error("Error updating health table.", t);
            Health health3 = Health.down().build();
            Intrinsics.checkNotNullExpressionValue((Object)health3, (String)"{\n      logger.error(\"Er\u2026alth.down().build()\n    }");
            health = health3;
        }
        return health;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stackhawk/nest/health/DbTickleHealthIndicator$Companion;", "", "()V", "HEALTH_CHECK_KEY", "", "nest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

