/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.markdown;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Message;
import com.stackhawk.nest.markdown.NestMarkdownProtoResolver;
import com.stackhawk.nest.proto.NestProtoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eJ\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J$\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020&0%H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000eH\u0002J$\u0010,\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020&0%H\u0002J\u0018\u0010-\u001a\u00020(2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0012\u0010.\u001a\u00020\u000e*\u00020/2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020/01*\u0002022\u0006\u0010\u0013\u001a\u00020\u000eJ\u0012\u00103\u001a\u00020\u000e*\u00020/2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0016\u00104\u001a\u0004\u0018\u000105*\u00020\u00112\u0006\u00106\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00067"}, d2={"Lcom/stackhawk/nest/markdown/MarkdownDocumentationCustomizer;", "", "()V", "controlSequenceRegex", "Lkotlin/text/Regex;", "getControlSequenceRegex", "()Lkotlin/text/Regex;", "gson", "Lcom/google/gson/Gson;", "nestProtoResolver", "Lcom/stackhawk/nest/markdown/NestMarkdownProtoResolver;", "getNestProtoResolver", "()Lcom/stackhawk/nest/markdown/NestMarkdownProtoResolver;", "applyInterpolatedCustomMarkdown", "", "markdown", "createMarkdownDocumentation", "Lcom/google/gson/JsonObject;", "generateJavaProtoExample", "protoSimpleName", "generateJavaScriptProtoExample", "generateJsonCProtoExample", "generateJsonProtoExample", "generateKotlinProtoExample", "generateProtoEnumMarkdownTable", "protoName", "generateProtoLanguageExample", "language", "generateProtoMessageDescription", "generateProtoMessageMarkdownTable", "generatePythonProtoExample", "generateRustProtoExample", "generateTypeScriptProtoExample", "getEnumObjectNode", "ed", "Lcom/google/protobuf/DescriptorProtos$EnumDescriptorProto;", "property", "", "Lcom/google/protobuf/DescriptorProtos$SourceCodeInfo$Location;", "getFieldsNode", "Lcom/google/gson/JsonArray;", "dd", "Lcom/google/protobuf/DescriptorProtos$DescriptorProto;", "javaName", "getMessageObjectNode", "getValuesNode", "defaultValue", "Lcom/google/protobuf/DescriptorProtos$FieldDescriptorProto;", "hawkMarkdownFields", "", "Lcom/google/protobuf/Message;", "readMoreUrl", "tryGet", "Lcom/google/gson/JsonElement;", "name", "nest"})
@SourceDebugExtension(value={"SMAP\nMarkdownDocumentationCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownDocumentationCustomizer.kt\ncom/stackhawk/nest/markdown/MarkdownDocumentationCustomizer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n215#2,2:373\n1855#3,2:375\n1549#3:377\n1620#3,3:378\n1864#3,3:381\n1603#3,9:385\n1855#3:394\n1856#3:396\n1612#3:397\n766#3:398\n857#3,2:399\n1#4:384\n1#4:395\n*S KotlinDebug\n*F\n+ 1 MarkdownDocumentationCustomizer.kt\ncom/stackhawk/nest/markdown/MarkdownDocumentationCustomizer\n*L\n27#1:373,2\n52#1:375,2\n81#1:377\n81#1:378,3\n82#1:381,3\n168#1:385,9\n168#1:394\n168#1:396\n168#1:397\n328#1:398\n328#1:399,2\n168#1:395\n*E\n"})
public final class MarkdownDocumentationCustomizer {
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private final NestMarkdownProtoResolver nestProtoResolver = new NestMarkdownProtoResolver();
    @NotNull
    private final Regex controlSequenceRegex = new Regex("\\{: ([\\w-]+) ([^\\s}]+) ([^\\s}]+)?\\s?}");

    @NotNull
    public final NestMarkdownProtoResolver getNestProtoResolver() {
        return this.nestProtoResolver;
    }

    @NotNull
    public final Regex getControlSequenceRegex() {
        return this.controlSequenceRegex;
    }

    @NotNull
    public final JsonObject createMarkdownDocumentation() {
        JsonObject markdown = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonArray enums = new JsonArray();
        Map<String, DescriptorProtos.SourceCodeInfo.Location> $this$forEach$iv = this.nestProtoResolver.getProtoSourceNameCache();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DescriptorProtos.SourceCodeInfo.Location>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DescriptorProtos.SourceCodeInfo.Location> element$iv;
            Map.Entry<String, DescriptorProtos.SourceCodeInfo.Location> it = element$iv = iterator.next();
            boolean bl = false;
            Message dd = this.nestProtoResolver.getProtoDescriptorNameCache().get(it.getKey());
            if (!StringsKt.contains$default((CharSequence)it.getKey(), (CharSequence)"com.stackhawk.nest", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)it.getKey(), (CharSequence)"$", (boolean)false, (int)2, null)) continue;
            Message message = dd;
            if (message instanceof DescriptorProtos.DescriptorProto) {
                JsonObject msg = this.getMessageObjectNode((DescriptorProtos.DescriptorProto)dd, it);
                messages.add((JsonElement)msg);
                continue;
            }
            if (!(message instanceof DescriptorProtos.EnumDescriptorProto)) continue;
            JsonObject jsonObject = this.getEnumObjectNode((DescriptorProtos.EnumDescriptorProto)dd, it);
            enums.add((JsonElement)jsonObject);
        }
        markdown.add("messages", (JsonElement)messages);
        markdown.add("enums", (JsonElement)enums);
        return markdown;
    }

    private final JsonArray getFieldsNode(DescriptorProtos.DescriptorProto dd, String javaName) {
        JsonArray array = new JsonArray();
        String string = this.nestProtoResolver.javaNameToSimpleName(javaName);
        if (string == null) {
            string = "";
        }
        String protoSimpleName = string;
        Iterable $this$forEach$iv = this.hawkMarkdownFields((Message)dd, protoSimpleName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean hidden;
            boolean bl;
            DescriptorProtos.FieldDescriptorProto it = (DescriptorProtos.FieldDescriptorProto)element$iv;
            boolean bl2 = false;
            JsonObject field = new JsonObject();
            String name2 = javaName + "." + it.getName();
            DescriptorProtos.SourceCodeInfo.Location location = this.nestProtoResolver.locationByJavaName(name2);
            String description = location != null ? NestProtoUtils.INSTANCE.hawkDescription(location) : null;
            field.addProperty("name", it.getName());
            field.addProperty("number", (Number)it.getNumber());
            String string2 = description;
            if (string2 == null) {
                string2 = "";
            }
            field.addProperty("description", string2);
            String string3 = description;
            if (string3 == null) {
                string3 = "";
            }
            field.addProperty("markdownDescription", string3);
            field.addProperty("type", it.getType().name());
            String string4 = it.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.typeName");
            field.addProperty("typeName", StringsKt.capitalize((String)StringsKt.replace$default((String)string4, (String)".", (String)"", (boolean)false, (int)4, null)));
            String string5 = it.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.typeName");
            String string6 = this.nestProtoResolver.simpleNameToJavaName(StringsKt.removePrefix((String)string5, (CharSequence)"."));
            if (string6 == null) {
                string6 = "";
            }
            field.addProperty("javaType", string6);
            field.addProperty("defaultValue", this.defaultValue(it, protoSimpleName));
            field.addProperty("readMoreUrl", this.readMoreUrl(it, protoSimpleName));
            if (this.nestProtoResolver.extensionMarkdown(name2) != null) {
                String it2;
                boolean bl3 = false;
                JsonObject jsonObject = (JsonObject)this.gson.fromJson(it2, JsonObject.class);
                bl = Intrinsics.areEqual(jsonObject != null && (jsonObject = jsonObject.getAsJsonPrimitive("hidden")) != null ? jsonObject.toString() : null, (Object)"true");
            } else {
                bl = false;
            }
            if (hidden = bl) continue;
            array.add((JsonElement)field);
        }
        return array;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonArray getValuesNode(DescriptorProtos.EnumDescriptorProto ed, String javaName) {
        void $this$forEachIndexed$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        JsonArray array = new JsonArray();
        Object object = new String[]{"."};
        String enumParent = StringsKt.removeSuffix((String)javaName, (CharSequence)((CharSequence)CollectionsKt.last((List)StringsKt.split$default((CharSequence)javaName, (String[])object, (boolean)false, (int)0, (int)6, null))));
        List list2 = ed.getValueList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ed.valueList");
        object = list2;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DescriptorProtos.EnumValueDescriptorProto enumValueDescriptorProto = (DescriptorProtos.EnumValueDescriptorProto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean hidden;
            boolean bl;
            void enum_;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (String)item$iv;
            int index = n;
            boolean bl2 = false;
            JsonObject value = new JsonObject();
            String name2 = enumParent + (String)enum_;
            DescriptorProtos.SourceCodeInfo.Location location = this.nestProtoResolver.locationByJavaName(name2);
            String description = location != null ? NestProtoUtils.INSTANCE.hawkDescription(location) : null;
            value.addProperty("name", (String)enum_);
            value.addProperty("number", (Number)index);
            String string = description;
            if (string == null) {
                string = "";
            }
            value.addProperty("description", string);
            String string2 = description;
            if (string2 == null) {
                string2 = "";
            }
            value.addProperty("markdownDescription", string2);
            if (this.nestProtoResolver.extensionMarkdown(name2) != null) {
                String it;
                boolean bl3 = false;
                JsonObject jsonObject = (JsonObject)this.gson.fromJson(it, JsonObject.class);
                bl = Intrinsics.areEqual(jsonObject != null && (jsonObject = jsonObject.getAsJsonPrimitive("hidden")) != null ? jsonObject.toString() : null, (Object)"true");
            } else {
                bl = false;
            }
            if (hidden = bl) continue;
            array.add((JsonElement)value);
        }
        return array;
    }

    private final JsonObject getMessageObjectNode(DescriptorProtos.DescriptorProto dd, Map.Entry<String, DescriptorProtos.SourceCodeInfo.Location> property) {
        JsonObject objectNode = new JsonObject();
        objectNode.addProperty("name", dd.getName());
        objectNode.addProperty("javaName", property.getKey());
        objectNode.addProperty("description", NestProtoUtils.INSTANCE.hawkDescription(property.getValue()));
        objectNode.addProperty("markdownDescription", NestProtoUtils.INSTANCE.hawkDescription(property.getValue()));
        JsonArray fields2 = this.getFieldsNode(dd, property.getKey());
        objectNode.add("fields", (JsonElement)fields2);
        return objectNode;
    }

    private final JsonObject getEnumObjectNode(DescriptorProtos.EnumDescriptorProto ed, Map.Entry<String, DescriptorProtos.SourceCodeInfo.Location> property) {
        JsonObject objectNode = new JsonObject();
        String[] stringArray = new String[]{"$"};
        objectNode.addProperty("name", StringsKt.replace$default((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)property.getKey(), (String[])stringArray, (boolean)false, (int)0, (int)6, null))), (String)".", (String)"", (boolean)false, (int)4, null));
        objectNode.addProperty("javaName", property.getKey());
        objectNode.addProperty("description", NestProtoUtils.INSTANCE.hawkDescription(property.getValue()));
        objectNode.addProperty("markdownDescription", NestProtoUtils.INSTANCE.hawkDescription(property.getValue()));
        JsonArray values2 = this.getValuesNode(ed, property.getKey());
        objectNode.add("values", (JsonElement)values2);
        return objectNode;
    }

    @NotNull
    public final String applyInterpolatedCustomMarkdown(@NotNull String markdown) {
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        return this.controlSequenceRegex.replace((CharSequence)markdown, (Function1)new Function1<MatchResult, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String operation = (String)destructured.getMatch().getGroupValues().get(1);
                String protoName = (String)destructured.getMatch().getGroupValues().get(2);
                String arg2 = (String)destructured.getMatch().getGroupValues().get(3);
                switch (operation) {
                    case "proto-message-table": {
                        charSequence = this.this$0.generateProtoMessageMarkdownTable(protoName);
                        break;
                    }
                    case "proto-enum-table": {
                        charSequence = this.this$0.generateProtoEnumMarkdownTable(protoName);
                        break;
                    }
                    case "proto-message-example": {
                        charSequence = this.this$0.generateProtoLanguageExample(protoName, arg2);
                        break;
                    }
                    case "proto-message-description": {
                        charSequence = this.this$0.generateProtoMessageDescription(protoName);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Control sequence matched with unexpected operation: '" + operation + "'");
                    }
                }
                return charSequence;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateProtoMessageMarkdownTable(@NotNull String protoSimpleName) {
        void $this$mapNotNullTo$iv$iv;
        String string;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)protoSimpleName, (String)"protoSimpleName");
                string = this.nestProtoResolver.simpleNameToJavaName(protoSimpleName);
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                Message message = this.nestProtoResolver.lookupProtoByJavaName(it);
                string = message;
                if (message != null) break block4;
            }
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        String message = string;
        List<DescriptorProtos.FieldDescriptorProto> fields2 = this.hawkMarkdownFields((Message)message, protoSimpleName);
        String header = "| Parameter | Default | Description |\n|:---:|:---:|:---:|";
        Iterable $this$mapNotNull$iv = fields2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DescriptorProtos.FieldDescriptorProto p0 = (DescriptorProtos.FieldDescriptorProto)element$iv$iv;
            boolean bl2 = false;
            if (MarkdownDocumentationCustomizer.generateProtoMessageMarkdownTable$tableRow(protoSimpleName, this, p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator()");
        String table2 = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null);
        return StringsKt.trimIndent((String)(header + System.lineSeparator() + table2));
    }

    @NotNull
    public final String generateProtoEnumMarkdownTable(@NotNull String protoName) {
        Intrinsics.checkNotNullParameter((Object)protoName, (String)"protoName");
        List<String> enumValues = this.nestProtoResolver.enumValues(protoName);
        String header = "| Parameter | Description |" + System.lineSeparator() + "|:---:|:---:|";
        Iterable iterable = enumValues;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String table2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this, protoName){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            final /* synthetic */ String $protoName;
            {
                this.this$0 = $receiver;
                this.$protoName = $protoName;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DescriptorProtos.SourceCodeInfo.Location location = this.this$0.getNestProtoResolver().locationBySimpleName(this.$protoName + "." + it);
                return "|" + it + "|" + (location != null ? NestProtoUtils.INSTANCE.hawkDescription(location) : null) + "|";
            }
        }), (int)30, null);
        return StringsKt.trimIndent((String)(header + System.lineSeparator() + table2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String generateProtoLanguageExample(@NotNull String protoName, @Nullable String language) {
        String string;
        block22: {
            block16: {
                block21: {
                    block17: {
                        block18: {
                            block20: {
                                block19: {
                                    Intrinsics.checkNotNullParameter((Object)protoName, (String)"protoName");
                                    String string2 = language;
                                    if (string2 == null) throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                    switch (string2.hashCode()) {
                                        case 101429371: {
                                            if (!string2.equals("jsonc")) {
                                                throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                            }
                                            break block16;
                                        }
                                        case 3512292: {
                                            if (!string2.equals("rust")) {
                                                throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                            }
                                            break block17;
                                        }
                                        case -973197092: {
                                            if (!string2.equals("python")) {
                                                throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                            }
                                            break block18;
                                        }
                                        case 3254818: {
                                            if (!string2.equals("java")) {
                                                throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                            }
                                            break block19;
                                        }
                                        case -1125574399: {
                                            if (!string2.equals("kotlin")) {
                                                throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                            }
                                            break block20;
                                        }
                                        case 3271912: {
                                            if (!string2.equals("json")) {
                                                throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                            }
                                            break block21;
                                        }
                                        case -522285947: {
                                            if (string2.equals("typescript")) break;
                                            throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                        }
                                        case 188995949: {
                                            if (!string2.equals("javascript")) throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
                                            string = this.generateJavaScriptProtoExample(protoName);
                                            break block22;
                                        }
                                    }
                                    string = this.generateTypeScriptProtoExample(protoName);
                                    break block22;
                                }
                                string = this.generateJavaProtoExample(protoName);
                                break block22;
                            }
                            string = this.generateKotlinProtoExample(protoName);
                            break block22;
                        }
                        string = this.generatePythonProtoExample(protoName);
                        break block22;
                    }
                    string = this.generateRustProtoExample(protoName);
                    break block22;
                }
                string = this.generateJsonProtoExample(protoName);
                break block22;
            }
            string = this.generateJsonCProtoExample(protoName);
            break block22;
            throw new IllegalArgumentException("Could not resolve language example '" + language + "'");
        }
        String example = string;
        return StringsKt.trimMargin$default((String)("```" + language + System.lineSeparator() + example + System.lineSeparator() + "```"), null, (int)1, null);
    }

    @NotNull
    public final String generateProtoMessageDescription(@NotNull String protoSimpleName) {
        Intrinsics.checkNotNullParameter((Object)protoSimpleName, (String)"protoSimpleName");
        Object object = this.nestProtoResolver.locationBySimpleName(protoSimpleName);
        if (object == null || (object = NestProtoUtils.INSTANCE.hawkDescription((DescriptorProtos.SourceCodeInfo.Location)object)) == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        return object;
    }

    private final String generateJavaScriptProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        Iterable iterable = this.hawkMarkdownFields(message2, protoSimpleName);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String fields2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\t" + it.getJsonName() + ": " + this.this$0.getNestProtoResolver().fieldDescriptorDefaultValue(it) + ",";
            }
        }), (int)30, null);
        String[] stringArray = new String[]{"."};
        String string2 = ((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null))).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String varName = string2;
        return StringsKt.trimIndent((String)("\nconst " + varName + " = {" + System.lineSeparator() + fields2 + System.lineSeparator() + "}\n    "));
    }

    private final String generateTypeScriptProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        List<DescriptorProtos.FieldDescriptorProto> markdownFields = this.hawkMarkdownFields(message2, protoSimpleName);
        Iterable iterable = markdownFields;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String fields2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\t" + it.getJsonName() + ": " + this.this$0.getNestProtoResolver().fieldDescriptorDefaultValue(it) + ",";
            }
        }), (int)30, null);
        Iterable iterable2 = markdownFields;
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator()");
        String typeFields2 = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string2, null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\t" + it.getJsonName() + ": " + this.this$0.getNestProtoResolver().fieldDescriptorJavascriptType(it);
            }
        }), (int)30, null);
        String[] stringArray = new String[]{"."};
        String string3 = ((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null))).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String varName = string3;
        String[] stringArray2 = new String[]{"."};
        String typeName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        return StringsKt.trimIndent((String)("\ninterface " + typeName + " {" + System.lineSeparator() + typeFields2 + System.lineSeparator() + "} " + System.lineSeparator() + "\nconst " + varName + ": " + typeName + " = {" + System.lineSeparator() + fields2 + System.lineSeparator() + "}\n    "));
    }

    private final String generateJsonProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        String fields2 = CollectionsKt.joinToString$default((Iterable)this.hawkMarkdownFields(message2, protoSimpleName), (CharSequence)("," + System.lineSeparator()), null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\t\"" + it.getJsonName() + "\": " + this.this$0.getNestProtoResolver().fieldDescriptorDefaultValue(it);
            }
        }), (int)30, null);
        return StringsKt.trimIndent((String)("{" + System.lineSeparator() + fields2 + System.lineSeparator() + "}"));
    }

    private final String generateJsonCProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        Iterable iterable = this.hawkMarkdownFields(message2, protoSimpleName);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String fields2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this, protoSimpleName){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            final /* synthetic */ String $protoSimpleName;
            {
                this.this$0 = $receiver;
                this.$protoSimpleName = $protoSimpleName;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DescriptorProtos.SourceCodeInfo.Location location = this.this$0.getNestProtoResolver().locationBySimpleName(this.$protoSimpleName + "." + it.getName());
                return "\t\"" + it.getJsonName() + "\": " + this.this$0.getNestProtoResolver().fieldDescriptorDefaultValue(it) + ", // " + (location != null ? NestProtoUtils.INSTANCE.hawkDescription(location) : null);
            }
        }), (int)30, null);
        String[] stringArray = new String[]{"."};
        DescriptorProtos.SourceCodeInfo.Location location = this.nestProtoResolver.locationBySimpleName(protoSimpleName);
        String header = "// " + CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) + " - " + (location != null ? NestProtoUtils.INSTANCE.hawkDescription(location) : null);
        return StringsKt.trimIndent((String)(header + System.lineSeparator() + "{" + System.lineSeparator() + fields2 + System.lineSeparator() + "}"));
    }

    private final String generatePythonProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        String[] stringArray = new String[]{"."};
        String className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        String header = "class " + className + ":";
        Iterable iterable = this.hawkMarkdownFields(message2, protoSimpleName);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String properties2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\t" + it.getJsonName() + " = " + this.this$0.getNestProtoResolver().fieldDescriptorDefaultValue(it);
            }
        }), (int)30, null);
        return header + System.lineSeparator() + properties2;
    }

    private final String generateRustProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        String[] stringArray = new String[]{"."};
        String className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        Iterable iterable = this.hawkMarkdownFields(message2, protoSimpleName);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String properties2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\t" + it.getJsonName() + ": " + this.this$0.getNestProtoResolver().fieldDescriptorRustType(it) + ",";
            }
        }), (int)30, null);
        return "struct " + className + " {" + System.lineSeparator() + properties2 + System.lineSeparator() + "}";
    }

    private final String generateJavaProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        String[] stringArray = new String[]{"."};
        String className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        Iterable iterable = this.hawkMarkdownFields(message2, protoSimpleName);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        String properties2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\tpublic " + this.this$0.getNestProtoResolver().fieldDescriptorJdkType(it) + " " + it.getJsonName() + ";";
            }
        }), (int)30, null);
        return "public class " + className + " {" + System.lineSeparator() + System.lineSeparator() + properties2 + System.lineSeparator() + System.lineSeparator() + "}";
    }

    private final String generateKotlinProtoExample(String protoSimpleName) {
        Message message = this.nestProtoResolver.lookupProtoByJavaName(protoSimpleName);
        if (message == null) {
            throw new IllegalArgumentException("Could not resolve proto: '" + protoSimpleName + "'");
        }
        Message message2 = message;
        String[] stringArray = new String[]{"."};
        String className = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)protoSimpleName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        String properties2 = CollectionsKt.joinToString$default((Iterable)this.hawkMarkdownFields(message2, protoSimpleName), (CharSequence)("," + System.lineSeparator()), null, null, (int)0, null, (Function1)((Function1)new Function1<DescriptorProtos.FieldDescriptorProto, CharSequence>(this){
            final /* synthetic */ MarkdownDocumentationCustomizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DescriptorProtos.FieldDescriptorProto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "\tvar " + it.getJsonName() + ": " + StringsKt.capitalize((String)this.this$0.getNestProtoResolver().fieldDescriptorJdkType(it));
            }
        }), (int)30, null);
        return "data class " + className + "(" + System.lineSeparator() + properties2 + System.lineSeparator() + ")";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DescriptorProtos.FieldDescriptorProto> hawkMarkdownFields(@NotNull Message $this$hawkMarkdownFields, @NotNull String protoSimpleName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hawkMarkdownFields, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protoSimpleName, (String)"protoSimpleName");
        Iterable $this$filter$iv = NestProtoUtils.INSTANCE.hawkFieldDescriptors($this$hawkMarkdownFields);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonObject schemaJson;
            JsonObject jsonObject;
            String mdSchema;
            String string;
            DescriptorProtos.FieldDescriptorProto descriptor = (DescriptorProtos.FieldDescriptorProto)element$iv$iv;
            boolean bl = false;
            String simpleName = protoSimpleName + "." + descriptor.getName();
            String javaName = this.nestProtoResolver.simpleNameToJavaName(simpleName);
            if (javaName != null) {
                String it;
                boolean bl2 = false;
                String string2 = this.nestProtoResolver.extensionMarkdown(it);
                if (string2 != null) {
                    CharSequence charSequence;
                    CharSequence charSequence2 = string2;
                    if (charSequence2.length() == 0) {
                        boolean bl3 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    string = (String)charSequence;
                } else {
                    string = null;
                }
            } else {
                string = mdSchema = null;
            }
            if (mdSchema != null) {
                String it;
                boolean bl4 = false;
                jsonObject = (JsonObject)this.gson.fromJson(it, JsonObject.class);
            } else {
                jsonObject = null;
            }
            JsonObject jsonObject2 = schemaJson = jsonObject;
            boolean hidden = StringsKt.contains$default((CharSequence)String.valueOf(jsonObject2 != null ? jsonObject2.getAsJsonPrimitive("hidden") : null), (CharSequence)"true", (boolean)false, (int)2, null);
            if (!(!hidden)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String defaultValue(@NotNull DescriptorProtos.FieldDescriptorProto $this$defaultValue, @NotNull String protoSimpleName) {
        String string;
        String string2;
        JsonElement mdDefault;
        JsonObject schemaJson;
        JsonObject jsonObject;
        String mdSchema;
        String string3;
        String javaName;
        Intrinsics.checkNotNullParameter((Object)$this$defaultValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protoSimpleName, (String)"protoSimpleName");
        String simpleName = protoSimpleName + "." + $this$defaultValue.getName();
        String string4 = javaName = this.nestProtoResolver.simpleNameToJavaName(simpleName);
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            String string5 = this.nestProtoResolver.extensionMarkdown(it);
            if (string5 != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string5;
                if (charSequence2.length() == 0) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                string3 = (String)charSequence;
            } else {
                string3 = null;
            }
        } else {
            string3 = null;
        }
        String string6 = mdSchema = string3;
        if (string6 != null) {
            String it = string6;
            boolean bl = false;
            jsonObject = (JsonObject)this.gson.fromJson(it, JsonObject.class);
        } else {
            jsonObject = null;
        }
        JsonObject jsonObject2 = schemaJson = jsonObject;
        JsonElement jsonElement = mdDefault = jsonObject2 != null ? this.tryGet(jsonObject2, "default") : null;
        if (StringsKt.contains$default((CharSequence)$this$defaultValue.getType().name(), (CharSequence)"INT", (boolean)false, (int)2, null)) {
            Object object = mdDefault;
            string2 = object != null && (object = object.getAsNumber()) != null ? object.toString() : null;
        } else {
            JsonElement jsonElement2 = mdDefault;
            string2 = string = jsonElement2 != null ? jsonElement2.toString() : null;
        }
        if (string2 == null) {
            string = this.nestProtoResolver.fieldDescriptorDefaultValue($this$defaultValue);
        }
        String defaultValue = string;
        return defaultValue;
    }

    @NotNull
    public final String readMoreUrl(@NotNull DescriptorProtos.FieldDescriptorProto $this$readMoreUrl, @NotNull String protoSimpleName) {
        JsonObject schemaJson;
        JsonObject jsonObject;
        String mdSchema;
        String string;
        String javaName;
        Intrinsics.checkNotNullParameter((Object)$this$readMoreUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protoSimpleName, (String)"protoSimpleName");
        String simpleName = protoSimpleName + "." + $this$readMoreUrl.getName();
        String string2 = javaName = this.nestProtoResolver.simpleNameToJavaName(simpleName);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = this.nestProtoResolver.extensionMarkdown(it);
            if (string3 != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string3;
                if (charSequence2.length() == 0) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String string4 = mdSchema = string;
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            jsonObject = (JsonObject)this.gson.fromJson(it, JsonObject.class);
        } else {
            jsonObject = null;
        }
        JsonObject jsonObject2 = schemaJson = jsonObject;
        Object mdReadMoreUrl = jsonObject2 != null ? jsonObject2.getAsJsonPrimitive("readMoreUrl") : null;
        Object object = mdReadMoreUrl;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        Object readMoreUrl = object;
        return readMoreUrl;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonElement tryGet(JsonObject $this$tryGet, String name2) {
        void var3_3;
        JsonElement element = $this$tryGet.get(name2);
        return element instanceof JsonPrimitive ? (JsonElement)$this$tryGet.getAsJsonPrimitive(name2) : (element instanceof JsonObject ? (JsonElement)$this$tryGet.getAsJsonObject(name2) : (element instanceof JsonArray ? (JsonElement)$this$tryGet.getAsJsonArray(name2) : var3_3));
    }

    private static final String generateProtoMessageMarkdownTable$tableRow(String $protoSimpleName, MarkdownDocumentationCustomizer this$0, DescriptorProtos.FieldDescriptorProto descriptor) {
        Object object;
        boolean hidden;
        Object defaultValue;
        String description;
        block13: {
            block12: {
                JsonObject schemaJson;
                JsonObject jsonObject;
                String mdSchema;
                String string;
                String simpleName = $protoSimpleName + "." + descriptor.getName();
                String javaName = this$0.nestProtoResolver.simpleNameToJavaName(simpleName);
                DescriptorProtos.SourceCodeInfo.Location location = this$0.nestProtoResolver.locationBySimpleName($protoSimpleName + "." + descriptor.getName());
                description = location != null ? NestProtoUtils.INSTANCE.hawkDescription(location) : null;
                String string2 = javaName;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    String string3 = this$0.nestProtoResolver.extensionMarkdown(it);
                    if (string3 != null) {
                        CharSequence charSequence;
                        CharSequence charSequence2 = string3;
                        if (charSequence2.length() == 0) {
                            boolean bl2 = false;
                            charSequence = null;
                        } else {
                            charSequence = charSequence2;
                        }
                        string = (String)charSequence;
                    } else {
                        string = null;
                    }
                } else {
                    string = null;
                }
                String string4 = mdSchema = string;
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    jsonObject = (JsonObject)this$0.gson.fromJson(it, JsonObject.class);
                } else {
                    jsonObject = null;
                }
                JsonObject jsonObject2 = schemaJson = jsonObject;
                JsonElement mdDefault = jsonObject2 != null ? this$0.tryGet(jsonObject2, "default") : null;
                Object object2 = mdDefault;
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = this$0.nestProtoResolver.fieldDescriptorDefaultValue(descriptor);
                }
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"mdDefault?.toString() ?:\u2026rDefaultValue(descriptor)");
                defaultValue = object2;
                JsonObject jsonObject3 = schemaJson;
                hidden = Intrinsics.areEqual((Object)String.valueOf(jsonObject3 != null ? jsonObject3.getAsJsonPrimitive("hidden") : null), (Object)"true");
                JsonObject jsonObject4 = schemaJson;
                String readMoreUrl = jsonObject4 != null && (jsonObject4 = jsonObject4.getAsJsonPrimitive("readMoreUrl")) != null ? jsonObject4.getAsString() : null;
                object = readMoreUrl;
                if (object == null) break block12;
                String it = object;
                boolean bl = false;
                String string5 = " [Read More](" + it + ")";
                object = string5;
                if (string5 != null) break block13;
            }
            object = "";
        }
        String readMoreLink = object;
        return hidden ? null : "|" + descriptor.getJsonName() + "|" + (String)defaultValue + "|" + description + readMoreLink + "|";
    }
}

