/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.pagination;

import com.google.protobuf.ProtocolStringList;
import com.stackhawk.nest.Pagination;
import com.stackhawk.nest.RepositoryMessages;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J2\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t*\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\f2\u0006\u0010\u000e\u001a\u00020\rJ+\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00100\t2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0013J$\u0010\u0014\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u00040\t0\f*\u00020\u0006J\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\t*\u00020\u0006J\n\u0010\u0016\u001a\u00020\u0004*\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stackhawk/nest/pagination/PaginationUtil;", "", "()V", "PAGE_PARAM_PREFIX", "", "decodePage", "Lcom/stackhawk/nest/Pagination$Page;", "encodedPage", "asUUIDs", "", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "", "Lcom/stackhawk/nest/RepositoryMessages$RepositorySearchFilterKey;", "key", "getFirstOrNull", "Lcom/stackhawk/nest/RepositoryMessages$RepositorySearchFilter;", "filters", "", "(Ljava/util/List;[Lcom/stackhawk/nest/RepositoryMessages$RepositorySearchFilter;)Lcom/stackhawk/nest/RepositoryMessages$RepositorySearchFilter;", "multiValueFilters", "singleValueFilters", "urlEncoded", "nest"})
@SourceDebugExtension(value={"SMAP\nPaginationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginationUtil.kt\ncom/stackhawk/nest/pagination/PaginationUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1603#2,9:56\n1855#2:65\n1856#2:67\n1612#2:68\n1603#2,9:69\n1855#2:78\n1856#2:80\n1612#2:81\n288#2,2:82\n1549#2:84\n1620#2,3:85\n1#3:66\n1#3:79\n1#3:88\n*S KotlinDebug\n*F\n+ 1 PaginationUtil.kt\ncom/stackhawk/nest/pagination/PaginationUtil\n*L\n17#1:56,9\n17#1:65\n17#1:67\n17#1:68\n27#1:69,9\n27#1:78\n27#1:80\n27#1:81\n38#1:82,2\n42#1:84\n42#1:85,3\n17#1:66\n27#1:79\n*E\n"})
public final class PaginationUtil {
    @NotNull
    public static final PaginationUtil INSTANCE = new PaginationUtil();
    @NotNull
    private static final String PAGE_PARAM_PREFIX = "p_";

    private PaginationUtil() {
    }

    @NotNull
    public final String urlEncoded(@NotNull Pagination.Page $this$urlEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$urlEncoded, (String)"<this>");
        byte[] src = $this$urlEncoded.toByteArray();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)src, (String)"src");
        return !(src.length == 0) ? PAGE_PARAM_PREFIX + Base64.getUrlEncoder().withoutPadding().encodeToString(src) : "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RepositoryMessages.RepositorySearchFilter> singleValueFilters(@NotNull Pagination.Page $this$singleValueFilters) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$singleValueFilters, (String)"<this>");
        List<Pagination.Filter> list2 = $this$singleValueFilters.getFiltersList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"filtersList");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RepositoryMessages.RepositorySearchFilter repositorySearchFilter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pagination.Filter it = (Pagination.Filter)element$iv$iv;
            boolean bl2 = false;
            if (it.getValueOptsCase() == Pagination.Filter.ValueOptsCase.VALUE) {
                String string = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
                repositorySearchFilter = RepositoryMessages.RepositorySearchFilter.valueOf(string);
            } else {
                repositorySearchFilter = null;
            }
            if (repositorySearchFilter == null) continue;
            RepositoryMessages.RepositorySearchFilter it$iv$iv = repositorySearchFilter;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<RepositoryMessages.RepositorySearchFilterKey, List<String>> multiValueFilters(@NotNull Pagination.Page $this$multiValueFilters) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$multiValueFilters, (String)"<this>");
        List<Pagination.Filter> list2 = $this$multiValueFilters.getFiltersList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"filtersList");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pagination.Filter it = (Pagination.Filter)element$iv$iv;
            boolean bl2 = false;
            if (it.getValueOptsCase() == Pagination.Filter.ValueOptsCase.MULTI) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                RepositoryMessages.RepositorySearchFilterKey repositorySearchFilterKey = RepositoryMessages.RepositorySearchFilterKey.valueOf(string);
                ProtocolStringList protocolStringList = it.getMulti().getValuesList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"it.multi.valuesList");
                pair = TuplesKt.to((Object)((Object)repositorySearchFilterKey), (Object)CollectionsKt.toList((Iterable)((Iterable)protocolStringList)));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final RepositoryMessages.RepositorySearchFilter getFirstOrNull(@NotNull List<? extends RepositoryMessages.RepositorySearchFilter> $this$getFirstOrNull, RepositoryMessages.RepositorySearchFilter ... filters) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$getFirstOrNull, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Iterable $this$firstOrNull$iv = $this$getFirstOrNull;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RepositoryMessages.RepositorySearchFilter it = (RepositoryMessages.RepositorySearchFilter)((Object)element$iv);
                boolean bl = false;
                if (!ArraysKt.contains((Object[])filters, (Object)((Object)it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UUID> asUUIDs(@NotNull Map<RepositoryMessages.RepositorySearchFilterKey, ? extends List<String>> $this$asUUIDs, @NotNull RepositoryMessages.RepositorySearchFilterKey key) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$asUUIDs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Iterable $this$map$iv = $this$asUUIDs.getOrDefault((Object)key, CollectionsKt.emptyList());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UUID.fromString((String)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Pagination.Page decodePage(@NotNull String encodedPage) {
        Intrinsics.checkNotNullParameter((Object)encodedPage, (String)"encodedPage");
        if (!StringsKt.isBlank((CharSequence)encodedPage)) {
            if (!StringsKt.startsWith$default((String)encodedPage, (String)PAGE_PARAM_PREFIX, (boolean)false, (int)2, null)) {
                boolean bl = false;
                String string = "Unknown encoded page: " + encodedPage;
                throw new IllegalArgumentException(string.toString());
            }
            Pagination.Page page = Pagination.Page.parseFrom(Base64.getUrlDecoder().decode(StringsKt.substringAfter$default((String)encodedPage, (String)PAGE_PARAM_PREFIX, null, (int)2, null)));
            Intrinsics.checkNotNullExpressionValue((Object)page, (String)"parseFrom(\n          Bas\u2026E_PARAM_PREFIX)),\n      )");
            return page;
        }
        Pagination.Page page = Pagination.Page.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"{\n      Pagination.Page.getDefaultInstance()\n    }");
        return page;
    }
}

