/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.nest.redis;

import com.stackhawk.nest.redis.config.JedisProperties;
import es.moki.ratelimitj.core.limiter.request.AbstractRequestRateLimiterFactory;
import es.moki.ratelimitj.core.limiter.request.ReactiveRequestRateLimiter;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.redis.request.RedisSlidingWindowRequestRateLimiter;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import java.net.Inet4Address;
import java.time.Duration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0014J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stackhawk/nest/redis/LettuceRateLimiterFactory;", "Les/moki/ratelimitj/core/limiter/request/AbstractRequestRateLimiterFactory;", "Les/moki/ratelimitj/redis/request/RedisSlidingWindowRequestRateLimiter;", "jedisProperties", "Lcom/stackhawk/nest/redis/config/JedisProperties;", "(Lcom/stackhawk/nest/redis/config/JedisProperties;)V", "connection", "Lio/lettuce/core/api/StatefulRedisConnection;", "", "redisClient", "Lio/lettuce/core/RedisClient;", "kotlin.jvm.PlatformType", "close", "", "create", "rules", "", "Les/moki/ratelimitj/core/limiter/request/RequestLimitRule;", "getInstance", "Les/moki/ratelimitj/core/limiter/request/RequestRateLimiter;", "", "getInstanceReactive", "Les/moki/ratelimitj/core/limiter/request/ReactiveRequestRateLimiter;", "nest"})
public final class LettuceRateLimiterFactory
extends AbstractRequestRateLimiterFactory<RedisSlidingWindowRequestRateLimiter> {
    private final RedisClient redisClient;
    @NotNull
    private StatefulRedisConnection<String, String> connection;

    public LettuceRateLimiterFactory(@NotNull JedisProperties jedisProperties) {
        Intrinsics.checkNotNullParameter((Object)jedisProperties, (String)"jedisProperties");
        this.redisClient = RedisClient.create();
        String addr = jedisProperties.getSsl() ? jedisProperties.getHost() : Inet4Address.getByName(jedisProperties.getHost()).getHostAddress();
        RedisURI master = new RedisURI(addr, jedisProperties.getPort().intValue(), Duration.ofSeconds(30L));
        master.setSsl(jedisProperties.getSsl());
        StatefulRedisConnection statefulRedisConnection = this.redisClient.connect(master);
        Intrinsics.checkNotNullExpressionValue((Object)statefulRedisConnection, (String)"redisClient.connect(master)");
        this.connection = statefulRedisConnection;
    }

    public void close() {
    }

    @NotNull
    public RequestRateLimiter getInstance(@NotNull Set<? extends RequestLimitRule> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Object object = this.lookupInstance(rules);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lookupInstance(rules)");
        return (RequestRateLimiter)object;
    }

    @NotNull
    public ReactiveRequestRateLimiter getInstanceReactive(@NotNull Set<? extends RequestLimitRule> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Object object = this.lookupInstance(rules);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lookupInstance(rules)");
        return (ReactiveRequestRateLimiter)object;
    }

    @NotNull
    protected RedisSlidingWindowRequestRateLimiter create(@Nullable Set<RequestLimitRule> rules) {
        RedisScriptingReactiveCommands redisScriptingReactiveCommands = (RedisScriptingReactiveCommands)this.connection.reactive();
        RedisKeyReactiveCommands redisKeyReactiveCommands = (RedisKeyReactiveCommands)this.connection.reactive();
        Set<RequestLimitRule> set = rules;
        Intrinsics.checkNotNull(set);
        return new RedisSlidingWindowRequestRateLimiter(redisScriptingReactiveCommands, redisKeyReactiveCommands, set);
    }
}

