/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal.syscalls.jna;

import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.internal.syscalls.SyscallHandlerJvmPosix;
import com.github.ajalt.mordant.internal.syscalls.SyscallHandlerPosix;
import com.github.ajalt.mordant.internal.syscalls.jna.PosixLibC;
import com.oracle.svm.core.annotate.Delete;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Delete
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0014J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/ajalt/mordant/internal/syscalls/jna/SyscallHandlerJnaLinux;", "Lcom/github/ajalt/mordant/internal/syscalls/SyscallHandlerJvmPosix;", "<init>", "()V", "TIOCGWINSZ", "", "TCSADRAIN", "termiosConstants", "Lcom/github/ajalt/mordant/internal/syscalls/SyscallHandlerPosix$TermiosConstants;", "getTermiosConstants", "()Lcom/github/ajalt/mordant/internal/syscalls/SyscallHandlerPosix$TermiosConstants;", "libC", "Lcom/github/ajalt/mordant/internal/syscalls/jna/PosixLibC;", "isatty", "", "fd", "getTerminalSize", "Lcom/github/ajalt/mordant/internal/Size;", "getStdinTermios", "Lcom/github/ajalt/mordant/internal/syscalls/SyscallHandlerPosix$Termios;", "setStdinTermios", "", "termios", "mordant"})
public final class SyscallHandlerJnaLinux
extends SyscallHandlerJvmPosix {
    @NotNull
    public static final SyscallHandlerJnaLinux INSTANCE = new SyscallHandlerJnaLinux();
    private static final int TIOCGWINSZ = 21523;
    private static final int TCSADRAIN = 1;
    @NotNull
    private static final PosixLibC libC;

    private SyscallHandlerJnaLinux() {
    }

    @Override
    @NotNull
    public SyscallHandlerPosix.TermiosConstants getTermiosConstants() {
        return SyscallHandlerPosix.Companion.getLinuxTermiosConstants();
    }

    @Override
    protected boolean isatty(int fd) {
        return libC.isatty(fd) != 0;
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        PosixLibC.winsize size = new PosixLibC.winsize();
        return libC.ioctl(0, 21523, size) < 0 ? null : new Size(size.ws_col, size.ws_row);
    }

    @Override
    @NotNull
    public SyscallHandlerPosix.Termios getStdinTermios() {
        PosixLibC.termios termios2 = new PosixLibC.termios();
        libC.tcgetattr(0, termios2);
        int n = UInt.constructor-impl((int)termios2.c_iflag);
        int n2 = UInt.constructor-impl((int)termios2.c_oflag);
        int n3 = UInt.constructor-impl((int)termios2.c_cflag);
        int n4 = UInt.constructor-impl((int)termios2.c_lflag);
        byte[] byArray = Arrays.copyOf(termios2.c_cc, termios2.c_cc.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return new SyscallHandlerPosix.Termios(n, n2, n3, n4, byArray, null);
    }

    @Override
    public void setStdinTermios(@NotNull SyscallHandlerPosix.Termios termios2) {
        Intrinsics.checkNotNullParameter((Object)termios2, (String)"termios");
        PosixLibC.termios nativeTermios = new PosixLibC.termios();
        libC.tcgetattr(0, nativeTermios);
        nativeTermios.c_iflag = termios2.getIflag-pVg5ArA();
        nativeTermios.c_oflag = termios2.getOflag-pVg5ArA();
        nativeTermios.c_cflag = termios2.getCflag-pVg5ArA();
        nativeTermios.c_lflag = termios2.getLflag-pVg5ArA();
        ArraysKt.copyInto$default((byte[])termios2.getCc(), (byte[])nativeTermios.c_cc, (int)0, (int)0, (int)0, (int)14, null);
        libC.tcsetattr(0, 1, nativeTermios);
    }

    static {
        Library library = Native.load((String)Platform.C_LIBRARY_NAME, PosixLibC.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        libC = (PosixLibC)library;
    }
}

