/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal.syscalls.jna;

import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.internal.syscalls.SyscallHandlerWindows;
import com.github.ajalt.mordant.internal.syscalls.jna.WinKernel32Lib;
import com.oracle.svm.core.annotate.Delete;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Delete
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u000f\u0010\u0014\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/ajalt/mordant/internal/syscalls/jna/SyscallHandlerJnaWindows;", "Lcom/github/ajalt/mordant/internal/syscalls/SyscallHandlerWindows;", "<init>", "()V", "kernel", "Lcom/github/ajalt/mordant/internal/syscalls/jna/WinKernel32Lib;", "kotlin.jvm.PlatformType", "Lcom/github/ajalt/mordant/internal/syscalls/jna/WinKernel32Lib;", "stdoutHandle", "Lcom/github/ajalt/mordant/internal/syscalls/jna/WinKernel32Lib$HANDLE;", "stdinHandle", "stderrHandle", "handleInteractive", "", "handle", "stdoutInteractive", "stdinInteractive", "stderrInteractive", "getTerminalSize", "Lcom/github/ajalt/mordant/internal/Size;", "getStdinConsoleMode", "Lkotlin/UInt;", "getStdinConsoleMode-pVg5ArA", "()I", "setStdinConsoleMode", "", "dwMode", "setStdinConsoleMode-WZ4Q5Ns", "(I)V", "readRawEvent", "Lcom/github/ajalt/mordant/internal/syscalls/SyscallHandlerWindows$EventRecord;", "dwMilliseconds", "", "mordant"})
@SourceDebugExtension(value={"SMAP\nSyscallHandler.jna.windows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyscallHandler.jna.windows.kt\ncom/github/ajalt/mordant/internal/syscalls/jna/SyscallHandlerJnaWindows\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
public final class SyscallHandlerJnaWindows
extends SyscallHandlerWindows {
    @NotNull
    public static final SyscallHandlerJnaWindows INSTANCE = new SyscallHandlerJnaWindows();
    private static final WinKernel32Lib kernel = (WinKernel32Lib)Native.load((String)"kernel32", WinKernel32Lib.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    @NotNull
    private static final WinKernel32Lib.HANDLE stdoutHandle = kernel.GetStdHandle(-11);
    @NotNull
    private static final WinKernel32Lib.HANDLE stdinHandle = kernel.GetStdHandle(-10);
    @NotNull
    private static final WinKernel32Lib.HANDLE stderrHandle = kernel.GetStdHandle(-12);

    private SyscallHandlerJnaWindows() {
    }

    private final boolean handleInteractive(WinKernel32Lib.HANDLE handle) {
        boolean bl;
        try {
            kernel.GetConsoleMode(handle, new IntByReference());
            bl = true;
        }
        catch (LastErrorException e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean stdoutInteractive() {
        return this.handleInteractive(stdoutHandle);
    }

    @Override
    public boolean stdinInteractive() {
        return this.handleInteractive(stdinHandle);
    }

    @Override
    public boolean stderrInteractive() {
        return this.handleInteractive(stderrHandle);
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        Size size;
        WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO csbi = new WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO();
        if (!kernel.GetConsoleScreenBufferInfo(stdoutHandle, csbi)) {
            return null;
        }
        WinKernel32Lib.SMALL_RECT sMALL_RECT = csbi.srWindow;
        if (sMALL_RECT != null) {
            WinKernel32Lib.SMALL_RECT $this$getTerminalSize_u24lambda_u240 = sMALL_RECT;
            boolean bl = false;
            size = new Size($this$getTerminalSize_u24lambda_u240.Right - $this$getTerminalSize_u24lambda_u240.Left + 1, $this$getTerminalSize_u24lambda_u240.Bottom - $this$getTerminalSize_u24lambda_u240.Top + 1);
        } else {
            size = null;
        }
        return size;
    }

    @Override
    protected int getStdinConsoleMode-pVg5ArA() {
        IntByReference originalMode = new IntByReference();
        kernel.GetConsoleMode(stdinHandle, originalMode);
        return UInt.constructor-impl((int)originalMode.getValue());
    }

    @Override
    protected void setStdinConsoleMode-WZ4Q5Ns(int dwMode) {
        kernel.SetConsoleMode(stdinHandle, dwMode);
    }

    @Override
    @Nullable
    protected SyscallHandlerWindows.EventRecord readRawEvent(int dwMilliseconds) {
        SyscallHandlerWindows.EventRecord eventRecord;
        Pointer pointer = stdinHandle.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
        int waitResult = kernel.WaitForSingleObject(pointer, dwMilliseconds);
        if (waitResult != 0) {
            throw new RuntimeException("Timeout reading from console input");
        }
        WinKernel32Lib.INPUT_RECORD[] inputEvents = new WinKernel32Lib.INPUT_RECORD[1];
        IntByReference eventsRead = new IntByReference();
        kernel.ReadConsoleInput(stdinHandle, inputEvents, inputEvents.length, eventsRead);
        WinKernel32Lib.INPUT_RECORD iNPUT_RECORD = inputEvents[0];
        if (iNPUT_RECORD == null) {
            throw new RuntimeException("Error reading from console input");
        }
        WinKernel32Lib.INPUT_RECORD inputEvent = iNPUT_RECORD;
        short s = inputEvent.EventType;
        if (s == 1) {
            WinKernel32Lib.INPUT_RECORD.EventUnion eventUnion = inputEvent.Event;
            Intrinsics.checkNotNull((Object)((Object)eventUnion));
            WinKernel32Lib.KEY_EVENT_RECORD kEY_EVENT_RECORD = eventUnion.KeyEvent;
            Intrinsics.checkNotNull((Object)((Object)kEY_EVENT_RECORD));
            WinKernel32Lib.KEY_EVENT_RECORD keyEvent = kEY_EVENT_RECORD;
            boolean bl = keyEvent.bKeyDown;
            short s2 = UShort.constructor-impl((short)keyEvent.wVirtualKeyCode);
            WinKernel32Lib.UnionChar unionChar = keyEvent.uChar;
            Intrinsics.checkNotNull((Object)((Object)unionChar));
            eventRecord = new SyscallHandlerWindows.EventRecord.Key(bl, s2, unionChar.UnicodeChar, UInt.constructor-impl((int)keyEvent.dwControlKeyState), null);
        } else if (s == 2) {
            WinKernel32Lib.INPUT_RECORD.EventUnion eventUnion = inputEvent.Event;
            Intrinsics.checkNotNull((Object)((Object)eventUnion));
            WinKernel32Lib.MOUSE_EVENT_RECORD mOUSE_EVENT_RECORD = eventUnion.MouseEvent;
            Intrinsics.checkNotNull((Object)((Object)mOUSE_EVENT_RECORD));
            WinKernel32Lib.MOUSE_EVENT_RECORD mouseEvent = mOUSE_EVENT_RECORD;
            WinKernel32Lib.COORD cOORD = mouseEvent.dwMousePosition;
            Intrinsics.checkNotNull((Object)((Object)cOORD));
            short s3 = cOORD.X;
            WinKernel32Lib.COORD cOORD2 = mouseEvent.dwMousePosition;
            Intrinsics.checkNotNull((Object)((Object)cOORD2));
            eventRecord = new SyscallHandlerWindows.EventRecord.Mouse(s3, cOORD2.Y, UInt.constructor-impl((int)mouseEvent.dwButtonState), UInt.constructor-impl((int)mouseEvent.dwControlKeyState), UInt.constructor-impl((int)mouseEvent.dwEventFlags), null);
        } else {
            eventRecord = null;
        }
        return eventRecord;
    }
}

