/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.VerticalAlign;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.CellBuilderInstance;
import com.github.ajalt.mordant.table.CellContent;
import com.github.ajalt.mordant.table.CellStyleBuilder;
import com.github.ajalt.mordant.table.ColumnBuilder;
import com.github.ajalt.mordant.table.RowBuilderInstance;
import com.github.ajalt.mordant.table.SectionBuilderInstance;
import com.github.ajalt.mordant.table.TableBuilderInstance;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.table.TableImpl;
import com.github.ajalt.mordant.table.TableLayoutKt;
import com.github.ajalt.mordant.widgets.EmptyWidget;
import com.github.ajalt.mordant.widgets.Padding;
import com.github.ajalt.mordant.widgets.PaddingKt;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\n0\t2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/ajalt/mordant/table/TableLayout;", "", "table", "Lcom/github/ajalt/mordant/table/TableBuilderInstance;", "<init>", "(Lcom/github/ajalt/mordant/table/TableBuilderInstance;)V", "buildTable", "Lcom/github/ajalt/mordant/table/TableImpl;", "buildSection", "", "Lcom/github/ajalt/mordant/table/MutableRow;", "Lcom/github/ajalt/mordant/table/Cell;", "section", "Lcom/github/ajalt/mordant/table/SectionBuilderInstance;", "builderWidth", "", "insertCell", "", "cell", "Lcom/github/ajalt/mordant/table/CellBuilderInstance;", "rows", "startingX", "startingY", "mordant"})
@SourceDebugExtension(value={"SMAP\nTableLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableLayout.kt\ncom/github/ajalt/mordant/table/TableLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Padding.kt\ncom/github/ajalt/mordant/widgets/Padding$Companion\n*L\n1#1,204:1\n1#2:205\n12#3,2:206\n*S KotlinDebug\n*F\n+ 1 TableLayout.kt\ncom/github/ajalt/mordant/table/TableLayout\n*L\n103#1:206,2\n*E\n"})
public final class TableLayout {
    @NotNull
    private final TableBuilderInstance table;

    public TableLayout(@NotNull TableBuilderInstance table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TableImpl buildTable() {
        int n;
        int n2;
        Object object;
        int it2;
        Iterator<Object> r;
        Iterator<Object> iterator;
        Object[] objectArray = new SectionBuilderInstance[]{this.table.getHeaderSection(), this.table.getBodySection(), this.table.getFooterSection()};
        Iterator iterator2 = ((Iterable)CollectionsKt.listOf((Object[])objectArray)).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        SectionBuilderInstance it2 = (SectionBuilderInstance)iterator2.next();
        boolean bl = false;
        Iterator iterator3 = ((Iterable)it2.getRows()).iterator();
        if (!iterator3.hasNext()) {
            iterator = null;
        } else {
            r = (RowBuilderInstance)iterator3.next();
            boolean bl2 = false;
            r = ((RowBuilderInstance)((Object)r)).getCells().size();
            while (iterator3.hasNext()) {
                Object r2 = (RowBuilderInstance)iterator3.next();
                bl3 = false;
                if (r.compareTo((Object)(r2 = (Comparable)Integer.valueOf(((RowBuilderInstance)r2).getCells().size()))) >= 0) continue;
                r = r2;
            }
            iterator = r;
        }
        Integer n3 = (Integer)((Object)iterator);
        int n4 = it2 = n3 != null ? n3 : 0;
        while (iterator2.hasNext()) {
            Object object2;
            SectionBuilderInstance it222 = (SectionBuilderInstance)iterator2.next();
            $i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = false;
            r = ((Iterable)it222.getRows()).iterator();
            if (!r.hasNext()) {
                object2 = null;
            } else {
                Object r3 = (RowBuilderInstance)r.next();
                boolean bl3 = false;
                r3 = ((RowBuilderInstance)r3).getCells().size();
                while (r.hasNext()) {
                    Object r4 = (RowBuilderInstance)r.next();
                    $i$a$-maxOfOrNull-TableLayout$buildTable$builderWidth$1$1 = false;
                    if (r3.compareTo(r4 = (Comparable)Integer.valueOf(((RowBuilderInstance)r4).getCells().size())) >= 0) continue;
                    r3 = r4;
                }
                object2 = r3;
            }
            Integer n5 = (Integer)object2;
            int it222 = n5 != null ? n5 : 0;
            if (it2 >= it222) continue;
            it2 = it222;
        }
        int builderWidth = it2;
        List<List<Cell>> header = this.buildSection(this.table.getHeaderSection(), builderWidth);
        List<List<Cell>> body = this.buildSection(this.table.getBodySection(), builderWidth);
        List<List<Cell>> footer = this.buildSection(this.table.getFooterSection(), builderWidth);
        Object $i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = new List[]{header, body, footer};
        if (($i$a$-maxOf-TableLayout$buildTable$builderWidth$2 = (Collection)CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])$i$a$-maxOf-TableLayout$buildTable$builderWidth$2))).isEmpty()) {
            boolean bl4 = false;
            Borders borders = this.table.getTableBorders();
            if (borders == null) {
                borders = Borders.ALL;
            }
            Borders b = borders;
            Cell.Content cell = new Cell.Content(EmptyWidget.INSTANCE, 1, 1, b.getLeft(), b.getTop(), b.getRight(), b.getBottom(), null, TextAlign.LEFT, VerticalAlign.TOP, 0);
            object = CollectionsKt.listOf((Object)CollectionsKt.listOf((Object)cell));
        } else {
            object = $i$a$-maxOf-TableLayout$buildTable$builderWidth$2;
        }
        List rows = (List)object;
        Object object3 = ((Iterable)rows).iterator();
        if (!object3.hasNext()) {
            throw new NoSuchElementException();
        }
        List it3 = (List)object3.next();
        boolean bl5 = false;
        int n6 = it3.size();
        while (object3.hasNext()) {
            List it4 = (List)object3.next();
            n2 = 0;
            n = it4.size();
            if (n6 >= n) continue;
            n6 = n;
        }
        int columnCount = n6;
        object3 = new ArrayList(columnCount);
        for (n6 = 0; n6 < columnCount; ++n6) {
            void i;
            n2 = n = n6;
            Object object4 = object3;
            boolean bl6 = false;
            ColumnBuilder columnBuilder = this.table.getColumns().get((int)i);
            ((ArrayList)object4).add(TableDslKt.toCustom(columnBuilder != null ? columnBuilder.getWidth() : null));
        }
        List columnWidths = (List)object3;
        return new TableImpl(rows, this.table.getBorderType(), this.table.getBorderStyle(), header.size(), footer.size(), columnWidths, this.table.getTableBorders(), this.table.getAddPaddingWidthToFixedWidth());
    }

    private final List<List<Cell>> buildSection(SectionBuilderInstance section, int builderWidth) {
        int n = section.getRows().size();
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList(section.getRows().size()));
        }
        List rows = arrayList;
        Iterator iterator = ((Iterable)section.getRows()).iterator();
        int n5 = 0;
        while (iterator.hasNext()) {
            int y = n5++;
            RowBuilderInstance row = (RowBuilderInstance)iterator.next();
            int x = 0;
            for (CellBuilderInstance cellBuilder : row.getCells()) {
                x = TableLayoutKt.access$findEmptyColumn(rows, x, y);
                this.insertCell(cellBuilder, section, rows, x, y, builderWidth);
                ++x;
            }
        }
        return rows;
    }

    /*
     * WARNING - void declaration
     */
    private final void insertCell(CellBuilderInstance cell, SectionBuilderInstance section, List<List<Cell>> rows, int startingX, int startingY, int builderWidth) {
        Widget widget;
        void $this$insertCell_u24lambda_u248;
        Padding.Builder builder;
        Comparable comparable;
        ColumnBuilder tableCol = this.table.getColumns().get(startingX);
        CellStyleBuilder sectionCol = section.getColumns().get(startingX);
        RowBuilderInstance row = section.getRows().get(startingY);
        Iterator iterator = ((Iterable)RangesKt.until((int)startingY, (int)(startingY + cell.getRowSpan()))).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            int it22 = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Object object = (RowBuilderInstance)CollectionsKt.getOrNull(section.getRows(), (int)it22);
            Comparable it22 = Integer.valueOf(object != null && (object = ((RowBuilderInstance)object).getCells()) != null ? object.size() : 0);
            while (iterator.hasNext()) {
                int it32 = ((IntIterator)iterator).nextInt();
                $i$a$-maxOfOrNull-TableLayout$insertCell$maxRowSize$1 = false;
                Object object2 = (RowBuilderInstance)CollectionsKt.getOrNull(section.getRows(), (int)it32);
                Comparable it32 = Integer.valueOf(object2 != null && (object2 = ((RowBuilderInstance)object2).getCells()) != null ? object2.size() : 0);
                if (it22.compareTo(it32) >= 0) continue;
                it22 = it32;
            }
            comparable = it22;
        }
        Integer n = (Integer)comparable;
        int maxRowSize = n != null ? n : 0;
        int columnSpan = RangesKt.coerceAtMost((int)cell.getColumnSpan(), (int)(builderWidth - maxRowSize + 1));
        int rowSpan = RangesKt.coerceAtMost((int)cell.getRowSpan(), (int)(rows.size() - startingY));
        Borders borders = TableLayout.insertCell$getStyle(cell, row, sectionCol, tableCol, section, this, Borders.ALL, TableLayout::insertCell$lambda$7);
        Padding.Companion this_$iv = Padding.Companion;
        boolean $i$f$invoke = false;
        Padding.Builder builder2 = builder = new Padding.Builder(0, 0, 0, 0);
        Object object = this;
        SectionBuilderInstance sectionBuilderInstance = section;
        ColumnBuilder columnBuilder = tableCol;
        Object object3 = sectionCol;
        RowBuilderInstance rowBuilderInstance = row;
        CellBuilderInstance cellBuilderInstance = cell;
        boolean bl = false;
        $this$insertCell_u24lambda_u248.setHorizontal(1);
        Object object4 = Unit.INSTANCE;
        Padding.Builder b$iv = builder;
        Padding padding = TableLayout.insertCell$getStyle(cellBuilderInstance, rowBuilderInstance, (CellStyleBuilder)object3, columnBuilder, sectionBuilderInstance, (TableLayout)object, new Padding(b$iv.getTop(), b$iv.getRight(), b$iv.getBottom(), b$iv.getLeft()), TableLayout::insertCell$lambda$9);
        Whitespace whitespace = TableLayout.insertCell$getStyle(cell, row, sectionCol, tableCol, section, this, Whitespace.PRE, TableLayout::insertCell$lambda$10);
        TextAlign textAlign = TableLayout.insertCell$getStyle(cell, row, sectionCol, tableCol, section, this, TextAlign.NONE, TableLayout::insertCell$lambda$11);
        VerticalAlign verticalAlign = TableLayout.insertCell$getStyle(cell, row, sectionCol, tableCol, section, this, VerticalAlign.TOP, TableLayout::insertCell$lambda$12);
        OverflowWrap overflowWrap = TableLayout.insertCell$getStyle(cell, row, sectionCol, tableCol, section, this, OverflowWrap.ELLIPSES, TableLayout::insertCell$lambda$13);
        TextStyle stripedStyle = !((Collection)section.getRowStyles()).isEmpty() ? section.getRowStyles().get(startingY % section.getRowStyles().size()) : null;
        TextStyle[] textStyleArray = new TextStyle[7];
        textStyleArray[0] = cell.getStyle();
        textStyleArray[1] = row.getStyle();
        textStyleArray[2] = stripedStyle;
        CellStyleBuilder cellStyleBuilder = sectionCol;
        textStyleArray[3] = cellStyleBuilder != null ? cellStyleBuilder.getStyle() : null;
        ColumnBuilder columnBuilder2 = tableCol;
        textStyleArray[4] = columnBuilder2 != null ? columnBuilder2.getStyle() : null;
        textStyleArray[5] = section.getStyle();
        textStyleArray[6] = this.table.getStyle();
        TextStyle style = TextStyleKt.foldStyles(textStyleArray);
        CellContent cellContent = cell.getContent();
        if (cellContent instanceof CellContent.WidgetContent) {
            widget = ((CellContent.WidgetContent)cell.getContent()).getWidget();
        } else if (cellContent instanceof CellContent.TextContent) {
            widget = new Text(((CellContent.TextContent)cell.getContent()).getText(), whitespace, textAlign, overflowWrap, null, null, 48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Widget content = PaddingKt.withPadding$default(widget, padding, false, 2, null);
        Boolean bl2 = borders.getRight();
        boolean bl3 = bl2;
        object4 = borders.getTop();
        object = borders.getLeft();
        int n2 = columnSpan;
        int n3 = rowSpan;
        object3 = content;
        boolean bl4 = false;
        boolean bl5 = columnSpan == 1;
        Boolean bl6 = bl5 ? bl2 : null;
        bl2 = borders.getBottom();
        boolean it = bl2;
        Boolean bl7 = bl6;
        boolean bl8 = false;
        boolean bl9 = rowSpan == 1;
        int n4 = padding.getLeft() + padding.getRight();
        VerticalAlign verticalAlign2 = verticalAlign;
        TextAlign textAlign2 = textAlign;
        TextStyle textStyle = style;
        Boolean bl10 = bl9 ? bl2 : null;
        Boolean bl11 = bl7;
        Object object5 = object4;
        Object object6 = object;
        int n5 = n2;
        int n6 = n3;
        Object object7 = object3;
        Cell.Content builtCell = new Cell.Content((Widget)object7, n6, n5, (Boolean)object6, (Boolean)object5, bl11, bl10, textStyle, textAlign2, verticalAlign2, n4);
        int lastX = startingX + columnSpan - 1;
        int x = startingX;
        if (x <= lastX) {
            while (true) {
                int lastY;
                int y;
                if ((y = startingY) <= (lastY = startingY + rowSpan - 1)) {
                    while (true) {
                        Cell cell2;
                        if (x == startingX && y == startingY) {
                            cell2 = builtCell;
                        } else {
                            Boolean bl12 = borders.getLeft();
                            boolean bl13 = bl12;
                            object3 = builtCell;
                            boolean bl14 = false;
                            boolean bl15 = x == startingX;
                            Boolean bl16 = bl15 ? bl12 : null;
                            bl12 = borders.getTop();
                            boolean it2 = bl12;
                            Boolean bl17 = bl16;
                            boolean bl18 = false;
                            boolean bl19 = y == startingY;
                            Boolean bl20 = bl19 ? bl12 : null;
                            bl12 = borders.getRight();
                            it2 = bl12;
                            Boolean bl21 = bl20;
                            boolean bl22 = false;
                            boolean bl23 = x == lastX;
                            Boolean bl24 = bl23 ? bl12 : null;
                            bl12 = borders.getBottom();
                            it2 = bl12;
                            object = bl24;
                            boolean bl25 = false;
                            object4 = y == lastY;
                            Boolean bl26 = ((Boolean)object4).booleanValue() ? bl12 : null;
                            Object object8 = object;
                            Boolean bl27 = bl21;
                            Boolean bl28 = bl17;
                            Object object9 = object3;
                            cell2 = new Cell.SpanRef((Cell.Content)object9, bl28, bl27, (Boolean)object8, bl26);
                        }
                        Cell c = cell2;
                        List tableRow = TableLayoutKt.access$getRow(rows, y);
                        Cell existing = TableLayoutKt.access$getCell(tableRow, x);
                        if (!(existing == Cell.Empty.INSTANCE)) {
                            boolean bl29 = false;
                            String string = "Invalid table: cell spans cannot overlap";
                            throw new IllegalArgumentException(string.toString());
                        }
                        tableRow.set(x, c);
                        if (y == lastY) break;
                        ++y;
                    }
                }
                if (x == lastX) break;
                ++x;
            }
        }
    }

    private static final <T> T insertCell$getStyle(CellBuilderInstance $cell, RowBuilderInstance row, CellStyleBuilder sectionCol, ColumnBuilder tableCol, SectionBuilderInstance $section, TableLayout this$0, T t, Function1<? super CellStyleBuilder, ? extends T> getter) {
        Object object = getter.invoke((Object)$cell);
        if (object == null && (object = getter.invoke((Object)row)) == null) {
            CellStyleBuilder cellStyleBuilder = sectionCol;
            object = cellStyleBuilder != null ? getter.invoke((Object)cellStyleBuilder) : null;
            if (object == null) {
                ColumnBuilder columnBuilder = tableCol;
                object = columnBuilder != null ? getter.invoke((Object)columnBuilder) : null;
                if (object == null && (object = getter.invoke((Object)$section)) == null && (object = getter.invoke((Object)this$0.table)) == null) {
                    object = t;
                }
            }
        }
        return (T)object;
    }

    private static final Borders insertCell$lambda$7(CellStyleBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCellBorders();
    }

    private static final Padding insertCell$lambda$9(CellStyleBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPadding();
    }

    private static final Whitespace insertCell$lambda$10(CellStyleBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getWhitespace();
    }

    private static final TextAlign insertCell$lambda$11(CellStyleBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAlign();
    }

    private static final VerticalAlign insertCell$lambda$12(CellStyleBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getVerticalAlign();
    }

    private static final OverflowWrap insertCell$lambda$13(CellStyleBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getOverflowWrap();
    }
}

