/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.MppInternal_jvmKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.TerminalDetection;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B;\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/github/ajalt/mordant/terminal/StdoutTerminalInterface;", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "<init>", "(Lcom/github/ajalt/mordant/terminal/TerminalInfo;)V", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "width", "", "height", "hyperlinks", "", "interactive", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "completePrintRequest", "", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "readLineOrNull", "", "hideInput", "mordant"})
public final class StdoutTerminalInterface
implements TerminalInterface {
    @NotNull
    private final TerminalInfo info;

    private StdoutTerminalInterface(TerminalInfo info) {
        this.info = info;
    }

    @Override
    @NotNull
    public TerminalInfo getInfo() {
        return this.info;
    }

    public StdoutTerminalInterface(@Nullable AnsiLevel ansiLevel, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, @Nullable Boolean interactive) {
        this(TerminalDetection.INSTANCE.detectTerminal(ansiLevel, width, height, hyperlinks, interactive));
    }

    @Override
    public void completePrintRequest(@NotNull PrintRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getStderr()) {
            MppInternal_jvmKt.printStderr(request.getText(), request.getTrailingLinebreak());
        } else if (request.getTrailingLinebreak()) {
            if (((CharSequence)request.getText()).length() == 0) {
                System.out.println();
            } else {
                System.out.println((Object)request.getText());
            }
        } else {
            System.out.print((Object)request.getText());
        }
    }

    @Override
    @Nullable
    public String readLineOrNull(boolean hideInput) {
        return MppInternal_jvmKt.readLineOrNullMpp(hideInput);
    }
}

