/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.AnsiRenderKt;
import com.github.ajalt.mordant.internal.MppAtomicRef;
import com.github.ajalt.mordant.internal.MppInternalKt;
import com.github.ajalt.mordant.internal.MppInternal_jvmKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.terminal.ConversionResult;
import com.github.ajalt.mordant.terminal.DisabledTerminalCursor;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Prompt;
import com.github.ajalt.mordant.terminal.StdoutTerminalInterface;
import com.github.ajalt.mordant.terminal.TerminalColors;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0004\b\f\u0010\rBY\b\u0016\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\f\u0010\u0015B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u0016B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u0017B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u0018JI\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u00105JI\u00106\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u00105JI\u00107\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u00105JI\u0010\u001d\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u00105JI\u00108\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u00105JI\u00109\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u00105JI\u0010:\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0002\u00105J\u0018\u00109\u001a\u00020,2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u00104\u001a\u00020\u0013J\u0018\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u00104\u001a\u00020\u0013J\u0010\u0010:\u001a\u00020,2\b\b\u0002\u00104\u001a\u00020\u0013J?\u0010=\u001a\u00020>2\b\u0010-\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010?J\u000e\u0010=\u001a\u00020>2\u0006\u0010;\u001a\u00020<J\u0010\u0010@\u001a\u0004\u0018\u00010>2\u0006\u0010A\u001a\u00020\u0013J\u008b\u0001\u0010B\u001a\u0004\u0018\u0001HC\"\u0004\b\u0000\u0010C2\u0006\u0010B\u001a\u00020>2\n\b\u0002\u0010D\u001a\u0004\u0018\u0001HC2\b\b\u0002\u0010E\u001a\u00020\u00132\b\b\u0002\u0010F\u001a\u00020\u00132\b\b\u0002\u0010A\u001a\u00020\u00132\u000e\b\u0002\u0010G\u001a\b\u0012\u0004\u0012\u0002HC0H2\b\b\u0002\u0010I\u001a\u00020>2\b\b\u0002\u0010J\u001a\u00020>2\u001a\b\u0004\u0010K\u001a\u0014\u0012\u0004\u0012\u00020>\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0M0LH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ^\u0010B\u001a\u0004\u0018\u00010>2\u0006\u0010B\u001a\u00020>2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010>2\b\b\u0002\u0010E\u001a\u00020\u00132\b\b\u0002\u0010F\u001a\u00020\u00132\b\b\u0002\u0010A\u001a\u00020\u00132\u000e\b\u0002\u0010G\u001a\b\u0012\u0004\u0012\u00020>0H2\b\b\u0002\u0010I\u001a\u00020>2\b\b\u0002\u0010J\u001a\u00020>J\u0018\u0010O\u001a\u00020,2\u0006\u0010-\u001a\u00020>2\b\b\u0002\u00104\u001a\u00020\u0013J\u0015\u0010P\u001a\u00020,2\u0006\u0010Q\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bRJ\u0015\u0010S\u001a\u00020,2\u0006\u0010Q\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bTJ\u0018\u0010U\u001a\u00020,2\u0006\u0010-\u001a\u00020>2\u0006\u00104\u001a\u00020\u0013H\u0002J\u0010\u0010V\u001a\u00020,2\u0006\u0010W\u001a\u00020XH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006Y"}, d2={"Lcom/github/ajalt/mordant/terminal/Terminal;", "", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "tabWidth", "", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "interceptors", "Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "<init>", "(Lcom/github/ajalt/mordant/rendering/Theme;ILcom/github/ajalt/mordant/terminal/TerminalInterface;Lcom/github/ajalt/mordant/internal/MppAtomicRef;)V", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "width", "height", "hyperlinks", "", "interactive", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Lcom/github/ajalt/mordant/rendering/Theme;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;ILjava/lang/Boolean;)V", "(Lcom/github/ajalt/mordant/rendering/Theme;ILcom/github/ajalt/mordant/terminal/TerminalInterface;)V", "(Lcom/github/ajalt/mordant/rendering/Theme;Lcom/github/ajalt/mordant/terminal/TerminalInterface;)V", "(Lcom/github/ajalt/mordant/terminal/TerminalInterface;)V", "getTheme", "()Lcom/github/ajalt/mordant/rendering/Theme;", "getTabWidth", "()I", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "colors", "Lcom/github/ajalt/mordant/terminal/TerminalColors;", "getColors$annotations", "()V", "getColors", "()Lcom/github/ajalt/mordant/terminal/TerminalColors;", "cursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "getCursor", "()Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "success", "", "message", "whitespace", "Lcom/github/ajalt/mordant/rendering/Whitespace;", "align", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "overflowWrap", "Lcom/github/ajalt/mordant/rendering/OverflowWrap;", "stderr", "(Ljava/lang/Object;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;Z)V", "danger", "warning", "muted", "print", "println", "widget", "Lcom/github/ajalt/mordant/rendering/Widget;", "render", "", "(Ljava/lang/Object;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;)Ljava/lang/String;", "readLineOrNull", "hideInput", "prompt", "T", "default", "showDefault", "showChoices", "choices", "", "promptSuffix", "invalidChoiceMessage", "convert", "Lkotlin/Function1;", "Lcom/github/ajalt/mordant/terminal/ConversionResult;", "(Ljava/lang/String;Ljava/lang/Object;ZZZLjava/util/Collection;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "rawPrint", "addInterceptor", "interceptor", "addInterceptor$mordant", "removeInterceptor", "removeInterceptor$mordant", "rawPrintln", "sendPrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "mordant"})
@SourceDebugExtension(value={"SMAP\nTerminal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Terminal.kt\ncom/github/ajalt/mordant/terminal/Terminal\n+ 2 MppInternal.kt\ncom/github/ajalt/mordant/internal/MppInternalKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,381:1\n303#1:382\n317#1:383\n20#2,7:384\n20#2,4:391\n24#2,3:398\n774#3:395\n865#3,2:396\n*S KotlinDebug\n*F\n+ 1 Terminal.kt\ncom/github/ajalt/mordant/terminal/Terminal\n*L\n344#1:382\n344#1:383\n365#1:384,7\n369#1:391,4\n369#1:398,3\n369#1:395\n369#1:396,2\n*E\n"})
public final class Terminal {
    @NotNull
    private final Theme theme;
    private final int tabWidth;
    @NotNull
    private final TerminalInterface terminalInterface;
    @NotNull
    private final MppAtomicRef<List<TerminalInterceptor>> interceptors;
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private final TerminalColors colors;
    @NotNull
    private final TerminalCursor cursor;

    private Terminal(Theme theme, int tabWidth, TerminalInterface terminalInterface, MppAtomicRef<List<TerminalInterceptor>> interceptors) {
        this.theme = theme;
        this.tabWidth = tabWidth;
        this.terminalInterface = terminalInterface;
        this.interceptors = interceptors;
        this.info = this.terminalInterface.getInfo();
        this.colors = new TerminalColors(this.info, this.theme);
        this.cursor = this.info.getInteractive() ? MppInternal_jvmKt.makePrintingTerminalCursor(this) : (TerminalCursor)DisabledTerminalCursor.INSTANCE;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    public final int getTabWidth() {
        return this.tabWidth;
    }

    public Terminal(@Nullable AnsiLevel ansiLevel, @NotNull Theme theme, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, int tabWidth, @Nullable Boolean interactive) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this(theme, tabWidth, new StdoutTerminalInterface(ansiLevel, width, height, hyperlinks, interactive));
    }

    public /* synthetic */ Terminal(AnsiLevel ansiLevel, Theme theme, Integer n, Integer n2, Boolean bl, int n3, Boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            ansiLevel = null;
        }
        if ((n4 & 2) != 0) {
            theme = Theme.Companion.getDefault();
        }
        if ((n4 & 4) != 0) {
            n = null;
        }
        if ((n4 & 8) != 0) {
            n2 = null;
        }
        if ((n4 & 0x10) != 0) {
            bl = null;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 8;
        }
        if ((n4 & 0x40) != 0) {
            bl2 = null;
        }
        this(ansiLevel, theme, n, n2, bl, n3, bl2);
    }

    public Terminal(@NotNull Theme theme, int tabWidth, @NotNull TerminalInterface terminalInterface) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)terminalInterface, (String)"terminalInterface");
        this(theme, tabWidth, terminalInterface, MppInternal_jvmKt.MppAtomicRef(CollectionsKt.emptyList()));
    }

    public Terminal(@NotNull Theme theme, @NotNull TerminalInterface terminalInterface) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)terminalInterface, (String)"terminalInterface");
        this(theme, 8, terminalInterface, MppInternal_jvmKt.MppAtomicRef(CollectionsKt.emptyList()));
    }

    public Terminal(@NotNull TerminalInterface terminalInterface) {
        Intrinsics.checkNotNullParameter((Object)terminalInterface, (String)"terminalInterface");
        this(Theme.Companion.getDefault(), 8, terminalInterface, MppInternal_jvmKt.MppAtomicRef(CollectionsKt.emptyList()));
    }

    @NotNull
    public final TerminalInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final TerminalColors getColors() {
        return this.colors;
    }

    @Deprecated(message="Use TextColors or .theme instead")
    public static /* synthetic */ void getColors$annotations() {
    }

    @NotNull
    public final TerminalCursor getCursor() {
        return this.cursor;
    }

    public final void success(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.println(this.theme.getSuccess().invoke(String.valueOf(message)), whitespace, align, overflowWrap, width, stderr);
    }

    public static /* synthetic */ void success$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, boolean bl, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        terminal.success(object, whitespace, textAlign, overflowWrap, n, bl);
    }

    public final void danger(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.println(this.theme.getDanger().invoke(String.valueOf(message)), whitespace, align, overflowWrap, width, stderr);
    }

    public static /* synthetic */ void danger$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, boolean bl, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        terminal.danger(object, whitespace, textAlign, overflowWrap, n, bl);
    }

    public final void warning(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.println(this.theme.getWarning().invoke(String.valueOf(message)), whitespace, align, overflowWrap, width, stderr);
    }

    public static /* synthetic */ void warning$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, boolean bl, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        terminal.warning(object, whitespace, textAlign, overflowWrap, n, bl);
    }

    public final void info(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.println(this.theme.getInfo().invoke(String.valueOf(message)), whitespace, align, overflowWrap, width, stderr);
    }

    public static /* synthetic */ void info$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, boolean bl, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        terminal.info(object, whitespace, textAlign, overflowWrap, n, bl);
    }

    public final void muted(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.println(this.theme.getMuted().invoke(String.valueOf(message)), whitespace, align, overflowWrap, width, stderr);
    }

    public static /* synthetic */ void muted$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, boolean bl, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        terminal.muted(object, whitespace, textAlign, overflowWrap, n, bl);
    }

    public final void print(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.rawPrint(this.render(message, whitespace, align, overflowWrap, width), stderr);
    }

    public static /* synthetic */ void print$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, boolean bl, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        terminal.print(object, whitespace, textAlign, overflowWrap, n, bl);
    }

    public final void println(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        this.rawPrintln(this.render(message, whitespace, align, overflowWrap, width), stderr);
    }

    public static /* synthetic */ void println$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, boolean bl, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        terminal.println(object, whitespace, textAlign, overflowWrap, n, bl);
    }

    public final void print(@NotNull Widget widget, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.rawPrint(this.render(widget), stderr);
    }

    public static /* synthetic */ void print$default(Terminal terminal, Widget widget, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        terminal.print(widget, bl);
    }

    public final void println(@NotNull Widget widget, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.rawPrintln(this.render(widget), stderr);
    }

    public static /* synthetic */ void println$default(Terminal terminal, Widget widget, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        terminal.println(widget, bl);
    }

    public final void println(boolean stderr) {
        this.sendPrintRequest(new PrintRequest("", true, stderr));
    }

    public static /* synthetic */ void println$default(Terminal terminal, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        terminal.println(bl);
    }

    @NotNull
    public final String render(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)((Object)whitespace), (String)"whitespace");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        Intrinsics.checkNotNullParameter((Object)((Object)overflowWrap), (String)"overflowWrap");
        Object object = message;
        return object instanceof Lines ? AnsiRenderKt.renderLinesAnsi((Lines)message, this.info.getAnsiLevel(), this.info.getAnsiHyperLinks()) : (object instanceof Widget ? this.render((Widget)message) : this.render(new Text(String.valueOf(message), whitespace, align, overflowWrap, width, null, 32, null)));
    }

    public static /* synthetic */ String render$default(Terminal terminal, Object object, Whitespace whitespace, TextAlign textAlign, OverflowWrap overflowWrap, Integer n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            whitespace = Whitespace.PRE;
        }
        if ((n2 & 4) != 0) {
            textAlign = TextAlign.NONE;
        }
        if ((n2 & 8) != 0) {
            overflowWrap = OverflowWrap.NORMAL;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return terminal.render(object, whitespace, textAlign, overflowWrap, n);
    }

    @NotNull
    public final String render(@NotNull Widget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        return AnsiRenderKt.renderLinesAnsi(Widget.DefaultImpls.render$default(widget, this, 0, 2, null), this.info.getAnsiLevel(), this.info.getAnsiHyperLinks());
    }

    @Nullable
    public final String readLineOrNull(boolean hideInput) {
        return this.terminalInterface.readLineOrNull(hideInput);
    }

    @Nullable
    public final <T> T prompt(@NotNull String prompt2, @Nullable T t, boolean showDefault, boolean showChoices, boolean hideInput, @NotNull Collection<? extends T> choices, @NotNull String promptSuffix, @NotNull String invalidChoiceMessage, @NotNull Function1<? super String, ? extends ConversionResult<? extends T>> convert) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        Intrinsics.checkNotNullParameter((Object)promptSuffix, (String)"promptSuffix");
        Intrinsics.checkNotNullParameter((Object)invalidChoiceMessage, (String)"invalidChoiceMessage");
        Intrinsics.checkNotNullParameter(convert, (String)"convert");
        boolean $i$f$prompt = false;
        return new Prompt<T>(prompt2, this, t, showDefault, showChoices, hideInput, choices, promptSuffix, invalidChoiceMessage, convert){
            final /* synthetic */ Function1<String, ConversionResult<T>> $convert;
            {
                this.$convert = $convert;
                super($prompt, $receiver, $default, $showDefault, $showChoices, $hideInput, $choices, $promptSuffix, $invalidChoiceMessage);
            }

            protected ConversionResult<T> convert(String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return (ConversionResult)this.$convert.invoke((Object)input);
            }
        }.ask();
    }

    public static /* synthetic */ Object prompt$default(Terminal $this, String prompt2, Object object, boolean showDefault, boolean showChoices, boolean hideInput, Collection choices, String promptSuffix, String invalidChoiceMessage, Function1 convert, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            showDefault = true;
        }
        if ((n & 8) != 0) {
            showChoices = true;
        }
        if ((n & 0x10) != 0) {
            hideInput = false;
        }
        if ((n & 0x20) != 0) {
            choices = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            promptSuffix = ": ";
        }
        if ((n & 0x80) != 0) {
            invalidChoiceMessage = "Invalid value, choose from ";
        }
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)choices, (String)"choices");
        Intrinsics.checkNotNullParameter((Object)promptSuffix, (String)"promptSuffix");
        Intrinsics.checkNotNullParameter((Object)invalidChoiceMessage, (String)"invalidChoiceMessage");
        Intrinsics.checkNotNullParameter((Object)convert, (String)"convert");
        boolean $i$f$prompt = false;
        return new /* invalid duplicate definition of identical inner class */.ask();
    }

    @Nullable
    public final String prompt(@NotNull String prompt2, @Nullable String string, boolean showDefault, boolean showChoices, boolean hideInput, @NotNull Collection<String> choices, @NotNull String promptSuffix, @NotNull String invalidChoiceMessage) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        Intrinsics.checkNotNullParameter((Object)promptSuffix, (String)"promptSuffix");
        Intrinsics.checkNotNullParameter((Object)invalidChoiceMessage, (String)"invalidChoiceMessage");
        Terminal this_$iv = this;
        boolean $i$f$prompt = false;
        return (String)new Prompt<String>(prompt2, this_$iv, (Object)string, showDefault, showChoices, hideInput, choices, promptSuffix, invalidChoiceMessage){

            protected ConversionResult<String> convert(String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                String it = input;
                boolean bl = false;
                return new ConversionResult.Valid<String>(it);
            }
        }.ask();
    }

    public static /* synthetic */ String prompt$default(Terminal terminal, String string, String string2, boolean bl, boolean bl2, boolean bl3, Collection collection, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            string3 = ": ";
        }
        if ((n & 0x80) != 0) {
            string4 = "Invalid value, choose from ";
        }
        return terminal.prompt(string, string2, bl, bl2, bl3, collection, string3, string4);
    }

    public final void rawPrint(@NotNull String message, boolean stderr) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.sendPrintRequest(new PrintRequest(message, false, stderr));
    }

    public static /* synthetic */ void rawPrint$default(Terminal terminal, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        terminal.rawPrint(string, bl);
    }

    public final void addInterceptor$mordant(@NotNull TerminalInterceptor interceptor) {
        List newValue$iv;
        List<TerminalInterceptor> old$iv;
        block2: {
            Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
            MppAtomicRef<List<TerminalInterceptor>> $this$update_u24default$iv = this.interceptors;
            int attempts$iv = 99;
            boolean $i$f$update = false;
            int n = 0;
            while (n < attempts$iv) {
                int it$iv = n++;
                boolean bl = false;
                List<TerminalInterceptor> $this$addInterceptor_u24lambda_u241 = old$iv = $this$update_u24default$iv.getValue();
                boolean bl2 = false;
                newValue$iv = CollectionsKt.plus((Collection)$this$addInterceptor_u24lambda_u241, (Object)interceptor);
                if (!$this$update_u24default$iv.compareAndSet(old$iv, newValue$iv)) {
                    continue;
                }
                break block2;
            }
            throw new ConcurrentModificationException("Failed to update state due to concurrent updates");
        }
        TuplesKt.to(old$iv, (Object)newValue$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeInterceptor$mordant(@NotNull TerminalInterceptor interceptor) {
        List newValue$iv;
        List<TerminalInterceptor> old$iv;
        block3: {
            Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
            MppAtomicRef<List<TerminalInterceptor>> $this$update_u24default$iv = this.interceptors;
            int attempts$iv = 99;
            boolean $i$f$update = false;
            for (int i = 0; i < attempts$iv; ++i) {
                void $this$filterTo$iv$iv;
                int it$iv = i;
                boolean bl = false;
                List<TerminalInterceptor> $this$removeInterceptor_u24lambda_u243 = old$iv = $this$update_u24default$iv.getValue();
                boolean bl2 = false;
                Iterable $this$filter$iv = $this$removeInterceptor_u24lambda_u243;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TerminalInterceptor it = (TerminalInterceptor)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)interceptor))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                newValue$iv = (List)destination$iv$iv;
                if (!$this$update_u24default$iv.compareAndSet(old$iv, newValue$iv)) {
                    continue;
                }
                break block3;
            }
            throw new ConcurrentModificationException("Failed to update state due to concurrent updates");
        }
        TuplesKt.to(old$iv, (Object)newValue$iv);
    }

    private final void rawPrintln(String message, boolean stderr) {
        this.sendPrintRequest(new PrintRequest(message, true, stderr));
    }

    private final void sendPrintRequest(PrintRequest request) {
        if (MppInternalKt.getSYSCALL_HANDLER().fastIsTty()) {
            this.info.updateTerminalSize();
        }
        MppInternal_jvmKt.sendInterceptedPrintRequest(request, this.terminalInterface, this.interceptors.getValue());
    }
}

