/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.mordant.internal.AnsiRenderKt;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.TextColors;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyles;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b:\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020DJ\u001e\u0010B\u001a\u00020\t2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020FJ\u001e\u0010I\u001a\u00020\t2\u0006\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020F2\u0006\u0010L\u001a\u00020FJ\u001e\u0010M\u001a\u00020\t2\u0006\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020F2\u0006\u0010N\u001a\u00020FJ&\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020Q2\u0006\u0010T\u001a\u00020QJ\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010U\u001a\u00020FJ\u001e\u0010V\u001a\u00020\t2\u0006\u0010W\u001a\u00020F2\u0006\u0010S\u001a\u00020F2\u0006\u0010X\u001a\u00020FJ\u001e\u0010Y\u001a\u00020\t2\u0006\u0010L\u001a\u00020F2\u0006\u0010Z\u001a\u00020F2\u0006\u0010H\u001a\u00020FJ\u000e\u0010[\u001a\u00020\t2\u0006\u0010[\u001a\u00020\\J\u0010\u0010]\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000bR\u0011\u0010\u001e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0011\u0010\"\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000bR\u0011\u0010$\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000bR\u0011\u0010&\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000bR\u0011\u0010(\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000bR\u0011\u0010*\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000bR\u0011\u0010,\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000bR\u0011\u0010.\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u000bR\u0011\u00100\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u000bR\u0011\u00102\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u000bR\u0011\u00104\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000bR\u0011\u00106\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u000bR\u0011\u00108\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u000bR\u0011\u0010:\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u000bR\u0011\u0010<\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u000bR\u0011\u0010>\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u000bR\u0011\u0010@\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u000bR\u0014\u0010_\u001a\u00020`8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010b\u00a8\u0006c"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalColors;", "", "terminalInfo", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "<init>", "(Lcom/github/ajalt/mordant/terminal/TerminalInfo;Lcom/github/ajalt/mordant/rendering/Theme;)V", "black", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "getBlack", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "red", "getRed", "green", "getGreen", "yellow", "getYellow", "blue", "getBlue", "magenta", "getMagenta", "cyan", "getCyan", "white", "getWhite", "gray", "getGray", "brightRed", "getBrightRed", "brightGreen", "getBrightGreen", "brightYellow", "getBrightYellow", "brightBlue", "getBrightBlue", "brightMagenta", "getBrightMagenta", "brightCyan", "getBrightCyan", "brightWhite", "getBrightWhite", "success", "getSuccess", "danger", "getDanger", "warning", "getWarning", "info", "getInfo", "muted", "getMuted", "bold", "getBold", "dim", "getDim", "italic", "getItalic", "underline", "getUnderline", "inverse", "getInverse", "strikethrough", "getStrikethrough", "plain", "getPlain", "rgb", "hex", "", "r", "", "g", "b", "hsl", "h", "s", "l", "hsv", "v", "cmyk", "c", "", "m", "y", "k", "fraction", "xyz", "x", "z", "lab", "a", "color", "Lcom/github/ajalt/colormath/Color;", "downsample", "style", "level", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "getLevel", "()Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "mordant"})
public final class TerminalColors {
    @NotNull
    private final TerminalInfo terminalInfo;
    @NotNull
    private final Theme theme;

    public TerminalColors(@NotNull TerminalInfo terminalInfo, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)terminalInfo, (String)"terminalInfo");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.terminalInfo = terminalInfo;
        this.theme = theme;
    }

    @NotNull
    public final TextStyle getBlack() {
        return this.downsample(TextColors.black);
    }

    @NotNull
    public final TextStyle getRed() {
        return this.downsample(TextColors.red);
    }

    @NotNull
    public final TextStyle getGreen() {
        return this.downsample(TextColors.green);
    }

    @NotNull
    public final TextStyle getYellow() {
        return this.downsample(TextColors.yellow);
    }

    @NotNull
    public final TextStyle getBlue() {
        return this.downsample(TextColors.blue);
    }

    @NotNull
    public final TextStyle getMagenta() {
        return this.downsample(TextColors.magenta);
    }

    @NotNull
    public final TextStyle getCyan() {
        return this.downsample(TextColors.cyan);
    }

    @NotNull
    public final TextStyle getWhite() {
        return this.downsample(TextColors.white);
    }

    @NotNull
    public final TextStyle getGray() {
        return this.downsample(TextColors.gray);
    }

    @NotNull
    public final TextStyle getBrightRed() {
        return this.downsample(TextColors.brightRed);
    }

    @NotNull
    public final TextStyle getBrightGreen() {
        return this.downsample(TextColors.brightGreen);
    }

    @NotNull
    public final TextStyle getBrightYellow() {
        return this.downsample(TextColors.brightYellow);
    }

    @NotNull
    public final TextStyle getBrightBlue() {
        return this.downsample(TextColors.brightBlue);
    }

    @NotNull
    public final TextStyle getBrightMagenta() {
        return this.downsample(TextColors.brightMagenta);
    }

    @NotNull
    public final TextStyle getBrightCyan() {
        return this.downsample(TextColors.brightCyan);
    }

    @NotNull
    public final TextStyle getBrightWhite() {
        return this.downsample(TextColors.brightWhite);
    }

    @NotNull
    public final TextStyle getSuccess() {
        return this.downsample(this.theme.getSuccess());
    }

    @NotNull
    public final TextStyle getDanger() {
        return this.downsample(this.theme.getDanger());
    }

    @NotNull
    public final TextStyle getWarning() {
        return this.downsample(this.theme.getWarning());
    }

    @NotNull
    public final TextStyle getInfo() {
        return this.downsample(this.theme.getInfo());
    }

    @NotNull
    public final TextStyle getMuted() {
        return this.downsample(this.theme.getMuted());
    }

    @NotNull
    public final TextStyle getBold() {
        return this.downsample(TextStyles.bold.getStyle());
    }

    @NotNull
    public final TextStyle getDim() {
        return this.downsample(TextStyles.dim.getStyle());
    }

    @NotNull
    public final TextStyle getItalic() {
        return this.downsample(TextStyles.italic.getStyle());
    }

    @NotNull
    public final TextStyle getUnderline() {
        return this.downsample(TextStyles.underline.getStyle());
    }

    @NotNull
    public final TextStyle getInverse() {
        return this.downsample(TextStyles.inverse.getStyle());
    }

    @NotNull
    public final TextStyle getStrikethrough() {
        return this.downsample(TextStyles.strikethrough.getStyle());
    }

    @NotNull
    public final TextStyle getPlain() {
        return ConstantsKt.getDEFAULT_STYLE();
    }

    @NotNull
    public final TextStyle rgb(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        return TextColors.Companion.rgb(hex, this.getLevel());
    }

    @NotNull
    public final TextStyle rgb(@NotNull Number r, @NotNull Number g, @NotNull Number b) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return TextColors.Companion.rgb(r, g, b, this.getLevel());
    }

    @NotNull
    public final TextStyle hsl(@NotNull Number h, @NotNull Number s, @NotNull Number l) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return TextColors.Companion.hsl(h, s, l, this.getLevel());
    }

    @NotNull
    public final TextStyle hsv(@NotNull Number h, @NotNull Number s, @NotNull Number v) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return TextColors.Companion.hsv(h, s, v, this.getLevel());
    }

    @NotNull
    public final TextStyle cmyk(int c, int m, int y, int k) {
        return TextColors.Companion.cmyk(c, m, y, k, this.getLevel());
    }

    @NotNull
    public final TextStyle gray(@NotNull Number fraction) {
        Intrinsics.checkNotNullParameter((Object)fraction, (String)"fraction");
        return TextColors.Companion.gray(fraction, this.getLevel());
    }

    @NotNull
    public final TextStyle xyz(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return TextColors.Companion.xyz(x, y, z, this.getLevel());
    }

    @NotNull
    public final TextStyle lab(@NotNull Number l, @NotNull Number a, @NotNull Number b) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return TextColors.Companion.lab(l, a, b, this.getLevel());
    }

    @NotNull
    public final TextStyle color(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return TextColors.Companion.color(color, this.getLevel());
    }

    private final TextStyle downsample(TextStyle style) {
        return AnsiRenderKt.downsample(style, this.getLevel(), this.terminalInfo.getAnsiHyperLinks());
    }

    private final AnsiLevel getLevel() {
        return this.terminalInfo.getAnsiLevel();
    }
}

