/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.Size;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.TerminalDetection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010!\u001a\u00020\bJ\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0007J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003JO\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010,\u001a\u00020\b2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019\u00a8\u00061"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "", "width", "", "height", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "ansiHyperLinks", "", "outputInteractive", "inputInteractive", "crClearsLine", "<init>", "(IILcom/github/ajalt/mordant/rendering/AnsiLevel;ZZZZ)V", "getWidth", "()I", "setWidth", "(I)V", "getHeight", "setHeight", "getAnsiLevel", "()Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "setAnsiLevel", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;)V", "getAnsiHyperLinks", "()Z", "setAnsiHyperLinks", "(Z)V", "getOutputInteractive", "getInputInteractive", "getCrClearsLine", "interactive", "getInteractive", "updateTerminalSize", "timeoutMs", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "mordant"})
public final class TerminalInfo {
    private int width;
    private int height;
    @NotNull
    private AnsiLevel ansiLevel;
    private boolean ansiHyperLinks;
    private final boolean outputInteractive;
    private final boolean inputInteractive;
    private final boolean crClearsLine;

    public TerminalInfo(int width, int height, @NotNull AnsiLevel ansiLevel, boolean ansiHyperLinks, boolean outputInteractive, boolean inputInteractive, boolean crClearsLine) {
        Intrinsics.checkNotNullParameter((Object)((Object)ansiLevel), (String)"ansiLevel");
        this.width = width;
        this.height = height;
        this.ansiLevel = ansiLevel;
        this.ansiHyperLinks = ansiHyperLinks;
        this.outputInteractive = outputInteractive;
        this.inputInteractive = inputInteractive;
        this.crClearsLine = crClearsLine;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    @NotNull
    public final AnsiLevel getAnsiLevel() {
        return this.ansiLevel;
    }

    public final void setAnsiLevel(@NotNull AnsiLevel ansiLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)ansiLevel), (String)"<set-?>");
        this.ansiLevel = ansiLevel;
    }

    public final boolean getAnsiHyperLinks() {
        return this.ansiHyperLinks;
    }

    public final void setAnsiHyperLinks(boolean bl) {
        this.ansiHyperLinks = bl;
    }

    public final boolean getOutputInteractive() {
        return this.outputInteractive;
    }

    public final boolean getInputInteractive() {
        return this.inputInteractive;
    }

    public final boolean getCrClearsLine() {
        return this.crClearsLine;
    }

    public final boolean getInteractive() {
        return this.inputInteractive && this.outputInteractive;
    }

    public final boolean updateTerminalSize() {
        Size size = TerminalDetection.INSTANCE.detectSize();
        if (size == null) {
            return false;
        }
        Size size2 = size;
        int w = size2.component1();
        int h = size2.component2();
        this.width = w;
        this.height = h;
        return true;
    }

    @Deprecated(message="The timeoutMs parameter is no longer used; this function does not open a subprocess", replaceWith=@ReplaceWith(expression="updateTerminalSize()", imports={}))
    public final boolean updateTerminalSize(long timeoutMs) {
        return this.updateTerminalSize();
    }

    public final int component1() {
        return this.width;
    }

    public final int component2() {
        return this.height;
    }

    @NotNull
    public final AnsiLevel component3() {
        return this.ansiLevel;
    }

    public final boolean component4() {
        return this.ansiHyperLinks;
    }

    public final boolean component5() {
        return this.outputInteractive;
    }

    public final boolean component6() {
        return this.inputInteractive;
    }

    public final boolean component7() {
        return this.crClearsLine;
    }

    @NotNull
    public final TerminalInfo copy(int width, int height, @NotNull AnsiLevel ansiLevel, boolean ansiHyperLinks, boolean outputInteractive, boolean inputInteractive, boolean crClearsLine) {
        Intrinsics.checkNotNullParameter((Object)((Object)ansiLevel), (String)"ansiLevel");
        return new TerminalInfo(width, height, ansiLevel, ansiHyperLinks, outputInteractive, inputInteractive, crClearsLine);
    }

    public static /* synthetic */ TerminalInfo copy$default(TerminalInfo terminalInfo, int n, int n2, AnsiLevel ansiLevel, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = terminalInfo.width;
        }
        if ((n3 & 2) != 0) {
            n2 = terminalInfo.height;
        }
        if ((n3 & 4) != 0) {
            ansiLevel = terminalInfo.ansiLevel;
        }
        if ((n3 & 8) != 0) {
            bl = terminalInfo.ansiHyperLinks;
        }
        if ((n3 & 0x10) != 0) {
            bl2 = terminalInfo.outputInteractive;
        }
        if ((n3 & 0x20) != 0) {
            bl3 = terminalInfo.inputInteractive;
        }
        if ((n3 & 0x40) != 0) {
            bl4 = terminalInfo.crClearsLine;
        }
        return terminalInfo.copy(n, n2, ansiLevel, bl, bl2, bl3, bl4);
    }

    @NotNull
    public String toString() {
        return "TerminalInfo(width=" + this.width + ", height=" + this.height + ", ansiLevel=" + (Object)((Object)this.ansiLevel) + ", ansiHyperLinks=" + this.ansiHyperLinks + ", outputInteractive=" + this.outputInteractive + ", inputInteractive=" + this.inputInteractive + ", crClearsLine=" + this.crClearsLine + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.width);
        result = result * 31 + Integer.hashCode(this.height);
        result = result * 31 + this.ansiLevel.hashCode();
        result = result * 31 + Boolean.hashCode(this.ansiHyperLinks);
        result = result * 31 + Boolean.hashCode(this.outputInteractive);
        result = result * 31 + Boolean.hashCode(this.inputInteractive);
        result = result * 31 + Boolean.hashCode(this.crClearsLine);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TerminalInfo)) {
            return false;
        }
        TerminalInfo terminalInfo = (TerminalInfo)other;
        if (this.width != terminalInfo.width) {
            return false;
        }
        if (this.height != terminalInfo.height) {
            return false;
        }
        if (this.ansiLevel != terminalInfo.ansiLevel) {
            return false;
        }
        if (this.ansiHyperLinks != terminalInfo.ansiHyperLinks) {
            return false;
        }
        if (this.outputInteractive != terminalInfo.outputInteractive) {
            return false;
        }
        if (this.inputInteractive != terminalInfo.inputInteractive) {
            return false;
        }
        return this.crClearsLine == terminalInfo.crClearsLine;
    }
}

