/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005BO\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\u0010J\u0006\u0010 \u001a\u00020!J\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001e\u001a\u00020\u0015J\u0006\u0010\u001f\u001a\u00020\u0015J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010&\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00060\u001cj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0014\u0010\u001e\u001a\u00060\u001cj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0014\u0010\u001f\u001a\u00060\u001cj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006'"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalRecorder;", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "<init>", "(Lcom/github/ajalt/mordant/terminal/TerminalInfo;)V", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "width", "", "height", "hyperlinks", "", "outputInteractive", "inputInteractive", "crClearsLine", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;IIZZZZ)V", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "inputLines", "", "", "getInputLines", "()Ljava/util/List;", "setInputLines", "(Ljava/util/List;)V", "stdout", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "Ljava/lang/StringBuilder;", "stderr", "output", "clearOutput", "", "completePrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "readLineOrNull", "hideInput", "mordant"})
public final class TerminalRecorder
implements TerminalInterface {
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private List<String> inputLines;
    @NotNull
    private final StringBuilder stdout;
    @NotNull
    private final StringBuilder stderr;
    @NotNull
    private final StringBuilder output;

    private TerminalRecorder(TerminalInfo info) {
        this.info = info;
        this.inputLines = new ArrayList();
        this.stdout = new StringBuilder();
        this.stderr = new StringBuilder();
        this.output = new StringBuilder();
    }

    @Override
    @NotNull
    public TerminalInfo getInfo() {
        return this.info;
    }

    public TerminalRecorder(@NotNull AnsiLevel ansiLevel, int width, int height, boolean hyperlinks, boolean outputInteractive, boolean inputInteractive, boolean crClearsLine) {
        Intrinsics.checkNotNullParameter((Object)((Object)ansiLevel), (String)"ansiLevel");
        this(new TerminalInfo(width, height, ansiLevel, hyperlinks, outputInteractive, inputInteractive, crClearsLine));
    }

    public /* synthetic */ TerminalRecorder(AnsiLevel ansiLevel, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            ansiLevel = AnsiLevel.TRUECOLOR;
        }
        if ((n3 & 2) != 0) {
            n = 79;
        }
        if ((n3 & 4) != 0) {
            n2 = 24;
        }
        if ((n3 & 8) != 0) {
            boolean bl5 = bl = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x10) != 0) {
            boolean bl6 = bl2 = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x20) != 0) {
            boolean bl7 = bl3 = ansiLevel != AnsiLevel.NONE;
        }
        if ((n3 & 0x40) != 0) {
            bl4 = false;
        }
        this(ansiLevel, n, n2, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final List<String> getInputLines() {
        return this.inputLines;
    }

    public final void setInputLines(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.inputLines = list;
    }

    public final void clearOutput() {
        StringsKt.clear((StringBuilder)this.stdout);
        StringsKt.clear((StringBuilder)this.stderr);
        StringsKt.clear((StringBuilder)this.output);
    }

    @NotNull
    public final String stdout() {
        String string = this.stdout.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String stderr() {
        String string = this.stderr.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String output() {
        String string = this.output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void completePrintRequest(@NotNull PrintRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        StringBuilder sb = request.getStderr() ? this.stderr : this.stdout;
        sb.append(request.getText());
        this.output.append(request.getText());
        if (request.getTrailingLinebreak()) {
            sb.append("\n");
            this.output.append("\n");
        }
    }

    @Override
    @Nullable
    public String readLineOrNull(boolean hideInput) {
        return (String)CollectionsKt.removeFirstOrNull(this.inputLines);
    }
}

