/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets.progress;

import com.github.ajalt.mordant.internal.MppAtomicRef;
import com.github.ajalt.mordant.internal.MppInternal_jvmKt;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.widgets.progress.ProgressBarCell;
import com.github.ajalt.mordant.widgets.progress.ProgressBarDefinition;
import com.github.ajalt.mordant.widgets.progress.ProgressState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010 \u001a\u00020\u000b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0002J \u0010\"\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\b\u0010#\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/github/ajalt/mordant/widgets/progress/CachedProgressBarDefinition;", "T", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarDefinition;", "definition", "timeSource", "Lkotlin/time/TimeSource$WithComparableMarks;", "<init>", "(Lcom/github/ajalt/mordant/widgets/progress/ProgressBarDefinition;Lkotlin/time/TimeSource$WithComparableMarks;)V", "cache", "Lcom/github/ajalt/mordant/internal/MppAtomicRef;", "", "", "Lkotlin/Pair;", "Lkotlin/time/ComparableTimeMark;", "Lcom/github/ajalt/mordant/rendering/Widget;", "cells", "", "Lcom/github/ajalt/mordant/widgets/progress/ProgressBarCell;", "getCells", "()Ljava/util/List;", "spacing", "getSpacing", "()I", "alignColumns", "", "getAlignColumns", "()Z", "invalidateCache", "", "fps", "getFps", "makeCell", "i", "cell", "isCacheValid", "lastFrameTime", "mordant"})
@SourceDebugExtension(value={"SMAP\nCachedProgressBarDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedProgressBarDefinition.kt\ncom/github/ajalt/mordant/widgets/progress/CachedProgressBarDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MppInternal.kt\ncom/github/ajalt/mordant/internal/MppInternalKt\n*L\n1#1,82:1\n1567#2:83\n1598#2,4:84\n1#3:88\n20#4,7:89\n*S KotlinDebug\n*F\n+ 1 CachedProgressBarDefinition.kt\ncom/github/ajalt/mordant/widgets/progress/CachedProgressBarDefinition\n*L\n22#1:83\n22#1:84,4\n45#1:89,7\n*E\n"})
public final class CachedProgressBarDefinition<T>
implements ProgressBarDefinition<T> {
    @NotNull
    private final TimeSource.WithComparableMarks timeSource;
    @NotNull
    private final MppAtomicRef<Map<Integer, Pair<ComparableTimeMark, Widget>>> cache;
    @NotNull
    private final List<ProgressBarCell<T>> cells;
    private final int spacing;
    private final boolean alignColumns;
    private final int fps;

    /*
     * WARNING - void declaration
     */
    public CachedProgressBarDefinition(@NotNull ProgressBarDefinition<T> definition, @NotNull TimeSource.WithComparableMarks timeSource) {
        Comparable comparable;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.timeSource = timeSource;
        this.cache = MppInternal_jvmKt.MppAtomicRef(MapsKt.emptyMap());
        Iterable iterable = definition.getCells();
        CachedProgressBarDefinition cachedProgressBarDefinition = this;
        boolean $i$f$mapIndexed = false;
        Iterator iterator = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void it;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProgressBarCell progressBarCell = (ProgressBarCell)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.makeCell((int)i, (ProgressBarCell<T>)it));
        }
        cachedProgressBarDefinition.cells = (List)destination$iv$iv;
        this.spacing = definition.getSpacing();
        this.alignColumns = definition.getAlignColumns();
        Iterable iterable2 = definition.getCells();
        cachedProgressBarDefinition = this;
        iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            ProgressBarCell it = (ProgressBarCell)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getFps());
            while (iterator.hasNext()) {
                ProgressBarCell it2 = (ProgressBarCell)iterator.next();
                $i$a$-maxOfOrNull-CachedProgressBarDefinition$fps$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getFps());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        cachedProgressBarDefinition.fps = n != null ? n : 0;
    }

    @Override
    @NotNull
    public List<ProgressBarCell<T>> getCells() {
        return this.cells;
    }

    @Override
    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public boolean getAlignColumns() {
        return this.alignColumns;
    }

    public final void invalidateCache() {
        this.cache.getAndSet(MapsKt.emptyMap());
    }

    public final int getFps() {
        return this.fps;
    }

    private final ProgressBarCell<T> makeCell(int i, ProgressBarCell<T> cell) {
        return new ProgressBarCell(cell.getColumnWidth(), cell.getFps(), cell.getAlign(), cell.getVerticalAlign(), arg_0 -> CachedProgressBarDefinition.makeCell$lambda$3(this, i, cell, arg_0));
    }

    private final boolean isCacheValid(ProgressBarCell<T> cell, ComparableTimeMark lastFrameTime) {
        if (lastFrameTime == null) {
            return false;
        }
        long timeSinceLastFrame = lastFrameTime.elapsedNow-UwyO8pc();
        long maxCacheRetentionDuration = DurationKt.toDuration((double)(1.0 / (double)cell.getFps()), (DurationUnit)DurationUnit.SECONDS);
        return Duration.compareTo-LRDsOJo((long)timeSinceLastFrame, (long)maxCacheRetentionDuration) < 0;
    }

    private static final Widget makeCell$lambda$3(CachedProgressBarDefinition this$0, int $i, ProgressBarCell $cell, ProgressState $this$ProgressBarCell) {
        Map newValue$iv;
        Map old$iv;
        block5: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$cell, (String)"$cell");
            Intrinsics.checkNotNullParameter((Object)$this$ProgressBarCell, (String)"$this$ProgressBarCell");
            MppAtomicRef<Map<Integer, Pair<ComparableTimeMark, Widget>>> $this$update_u24default$iv = this$0.cache;
            int attempts$iv = 99;
            boolean $i$f$update = false;
            for (int i = 0; i < attempts$iv; ++i) {
                Map map;
                int it$iv = i;
                boolean bl = false;
                Map $this$makeCell_u24lambda_u243_u24lambda_u242 = old$iv = $this$update_u24default$iv.getValue();
                boolean bl2 = false;
                Pair<ComparableTimeMark, Widget> pair = $this$makeCell_u24lambda_u243_u24lambda_u242.get($i);
                if (this$0.isCacheValid($cell, (ComparableTimeMark)(pair != null ? (ComparableTimeMark)pair.getFirst() : null))) {
                    map = $this$makeCell_u24lambda_u243_u24lambda_u242;
                } else {
                    Widget content = (Widget)$cell.getContent().invoke((Object)$this$ProgressBarCell);
                    map = MapsKt.plus($this$makeCell_u24lambda_u243_u24lambda_u242, (Pair)TuplesKt.to((Object)$i, (Object)TuplesKt.to((Object)this$0.timeSource.markNow(), (Object)content)));
                }
                if (!$this$update_u24default$iv.compareAndSet(old$iv, newValue$iv = map)) {
                    continue;
                }
                break block5;
            }
            throw new ConcurrentModificationException("Failed to update state due to concurrent updates");
        }
        Map map = (Map)TuplesKt.to(old$iv, newValue$iv).component2();
        Object object = (Pair)map.get($i);
        if (object == null || (object = (Widget)object.getSecond()) == null) {
            object = (Widget)$cell.getContent().invoke((Object)$this$ProgressBarCell);
        }
        return object;
    }
}

