/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.ui;

import ch.csnc.extension.ui.DriverTableModel;
import ch.csnc.extension.util.DriverConfiguration;
import com.stackhawk.hste.utils.HsteTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractFrame;

@Deprecated
public class DriversView
extends AbstractFrame {
    private static final long serialVersionUID = -7502331281272992501L;
    private DriverTableModel driverTableModel;
    private JTable driverTable;
    private JButton addButton;
    private JButton browseButton;
    private JButton closeButton;
    private JButton deleteButton;
    private JScrollPane driverScrollPane;
    private JLabel fileLabel;
    private HsteTextField fileTextField;
    private JLabel nameLabel;
    private HsteTextField nameTextField;
    private JLabel slotLabel;
    private HsteTextField slotTextField;
    private JLabel slotListIndexLabel;
    private HsteTextField slotListIndexTextField;

    public DriversView(DriverConfiguration driverConfig) {
        this.driverTableModel = new DriverTableModel(driverConfig);
        this.initComponents();
        this.setVisible(true);
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new HsteTextField();
        this.browseButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new HsteTextField();
        this.slotLabel = new JLabel();
        this.slotTextField = new HsteTextField();
        this.slotListIndexLabel = new JLabel();
        this.slotListIndexTextField = new HsteTextField();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.closeButton = new JButton();
        this.driverScrollPane = new JScrollPane();
        this.driverTable = new JTable();
        this.setTitle(Constant.messages.getString("certificates.pkcs11.drivers.title"));
        this.fileLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.path"));
        this.browseButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriversView.this.browseButtonActionPerformed(evt);
            }
        });
        this.nameLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.name"));
        this.slotLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.slot"));
        this.slotListIndexLabel.setText(Constant.messages.getString("certificates.pkcs11.drivers.label.slotIndex"));
        this.addButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriversView.this.addButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriversView.this.deleteButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText(Constant.messages.getString("certificates.pkcs11.drivers.button.close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriversView.this.closeButtonActionPerformed(evt);
            }
        });
        this.driverTable.setModel(this.driverTableModel);
        this.driverScrollPane.setViewportView(this.driverTable);
        if (!Model.getSingleton().getOptionsParam().getExperimentalFeaturesParam().isExperimentalSliSupportEnabled()) {
            this.slotTextField.setEnabled(false);
        }
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileLabel).addComponent(this.nameLabel).addComponent(this.slotLabel).addComponent(this.slotListIndexLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.nameTextField, GroupLayout.Alignment.LEADING).addComponent(this.slotTextField, GroupLayout.Alignment.LEADING).addComponent(this.slotListIndexTextField, GroupLayout.Alignment.LEADING).addComponent(this.fileTextField, GroupLayout.Alignment.LEADING, -1, 322, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton, -1, 80, Short.MAX_VALUE).addComponent(this.browseButton)))).addContainerGap(165, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(499, 499, 499).addComponent(this.closeButton, -1, 74, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.driverScrollPane, -1, 561, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(499, Short.MAX_VALUE).addComponent(this.deleteButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.browseButton, 0, 0, Short.MAX_VALUE).addComponent(this.fileTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slotLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.slotTextField, -2, -1, -2)).addGap(28, 28, 28).addComponent(this.slotListIndexLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.slotListIndexTextField, -2, -1, -2).addComponent(this.addButton, -2, 19, -2)).addGap(28, 28, 28).addComponent(this.driverScrollPane, -2, 195, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.closeButton, -2, 10, -2).addContainerGap()));
        layout.linkSize(1, this.addButton, this.browseButton, this.closeButton, this.deleteButton, this.fileTextField, this.nameTextField);
        for (int i = 0; i < this.driverTableModel.getColumnCount(); ++i) {
            this.driverTable.getColumnModel().getColumn(i).setPreferredWidth(this.driverTableModel.getPreferredWith(i));
        }
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("DLL/dylib", "dll", "dylib"));
        int state = fc.showOpenDialog(null);
        if (state == 0) {
            this.fileTextField.setText(fc.getSelectedFile().toString());
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String name = this.nameTextField.getText();
        String file = this.fileTextField.getText();
        int slot = -1;
        int slotListindex = -1;
        try {
            slot = Integer.parseInt(this.slotTextField.getText());
        }
        catch (Exception e) {
            this.slotTextField.setText("0");
        }
        try {
            slotListindex = Integer.parseInt(this.slotListIndexTextField.getText());
        }
        catch (Exception e) {
            this.slotListIndexTextField.setText("0");
        }
        if (name != null && name.trim().length() > 0 && file != null && file.trim().length() > 0 && slot > -1 && slotListindex > -1) {
            this.driverTableModel.addDriver(name, file, slot, slotListindex);
            this.nameTextField.setText("");
            this.fileTextField.setText("");
            this.slotTextField.setText("0");
            this.slotListIndexTextField.setText("0");
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int selrow = this.driverTable.getSelectedRow();
        if (selrow > -1) {
            this.driverTableModel.deleteDriver(selrow);
            this.nameTextField.setText("");
            this.fileTextField.setText("");
            this.slotTextField.setText("0");
            this.slotListIndexTextField.setText("0");
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

