/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.util;

import com.stackhawk.hste.utils.HsteXmlConfiguration;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class DriverConfiguration {
    private File file = null;
    private URL url;
    private Vector<String> names;
    private Vector<String> paths;
    private Vector<Integer> slots;
    private Vector<Integer> slotListIndexes;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private EventListenerList eventListeners = new EventListenerList();
    private ChangeEvent changeEvent;

    public DriverConfiguration(URL url) {
        this.url = url;
        this.load();
    }

    public DriverConfiguration(File file) {
        this.file = file;
        this.load();
    }

    private void load() {
        this.names = new Vector();
        this.paths = new Vector();
        this.slots = new Vector();
        this.slotListIndexes = new Vector();
        try {
            HsteXmlConfiguration configuration = this.file != null ? new HsteXmlConfiguration(this.file) : new HsteXmlConfiguration(this.url);
            List drivers = configuration.configurationsAt("driver");
            for (HierarchicalConfiguration driver : drivers) {
                this.names.add(driver.getString("name", ""));
                this.paths.add(driver.getString("path", ""));
                this.slots.add(this.getInt(driver.getString("slot")));
                this.slotListIndexes.add(this.getInt(driver.getString("slotListIndex")));
            }
        }
        catch (ConfigurationException e) {
            this.logger.error("Failed to read the configuration from " + String.valueOf(this.file != null ? this.file : this.url), (Throwable)e);
        }
    }

    private int getInt(String string) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                this.logger.error("Failed to extract an integer from: " + string);
            }
        }
        return 0;
    }

    public void write() {
        if (this.file == null) {
            this.fireStateChanged();
            return;
        }
        HsteXmlConfiguration configuration = new HsteXmlConfiguration();
        configuration.setRootElementName("driverConfiguration");
        for (int i = 0; i < this.names.size(); ++i) {
            String baseKey = "driver(" + i + ").";
            configuration.setProperty(baseKey + "name", this.names.get(i));
            configuration.setProperty(baseKey + "path", this.paths.get(i));
            configuration.setProperty(baseKey + "slot", this.slots.get(i).toString());
            configuration.setProperty(baseKey + "slotListIndex", this.slotListIndexes.get(i).toString());
        }
        try {
            configuration.save(this.file);
        }
        catch (ConfigurationException e) {
            this.logger.error("Failed to save driver configuration to " + String.valueOf(this.file), (Throwable)e);
        }
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public void setNames(Vector<String> names) {
        this.names = names;
    }

    public Vector<String> getPaths() {
        return this.paths;
    }

    public void setPaths(Vector<String> paths) {
        this.paths = paths;
    }

    public Vector<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(Vector<Integer> slots) {
        this.slots = slots;
    }

    public Vector<Integer> getSlotIndexes() {
        return this.slotListIndexes;
    }

    public void setSlotListIndexes(Vector<Integer> slotListIndexes) {
        this.slotListIndexes = slotListIndexes;
    }

    public void addChangeListener(ChangeListener listener) {
        this.eventListeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.eventListeners.remove(ChangeListener.class, listener);
    }
}

