/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.stackhawk.hste.HeadlessBootstrap;
import com.stackhawk.hste.ShutdownRequestedException;
import com.stackhawk.hste.utils.HsteSupportUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.FileAlreadyExistsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;

public class CommandLineBootstrap
extends HeadlessBootstrap {
    private static final Logger LOGGER = LogManager.getLogger(CommandLineBootstrap.class);

    public CommandLineBootstrap(CommandLine cmdLineArgs) {
        super(cmdLineArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start() {
        Control control;
        int rc = super.start();
        if (rc != 0) {
            return rc;
        }
        if (!this.getArgs().isNoStdOutLog()) {
            CommandLineBootstrap.disableStdOutLog();
        }
        LOGGER.info(CommandLineBootstrap.getStartingMessage());
        try {
            this.initModel();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                System.out.println(Constant.messages.getString("start.db.error"));
                System.out.println(e.getLocalizedMessage());
            }
            throw new RuntimeException(e);
        }
        try {
            control = this.initControl();
        }
        catch (IllegalStateException e) {
            System.err.println("Failed to start HSTE. " + e.getMessage());
            return 1;
        }
        this.warnAddOnsAndExtensionsNoLongerRunnable();
        try {
            control.getExtensionLoader().hookCommandLineListener(this.getArgs());
            File sbomFile = this.getArgs().getSaveSbomZip();
            if (this.getArgs().isEnabled("-help") || this.getArgs().isEnabled("-h")) {
                System.out.println(this.getArgs().getHelp());
            } else if (this.getArgs().isReportVersion()) {
                System.out.println(Constant.PROGRAM_VERSION);
            } else if (this.getArgs().isDisplaySupportInfo()) {
                System.out.println(HsteSupportUtils.getAll(false));
            } else if (sbomFile != null) {
                if (sbomFile.exists()) {
                    throw new FileAlreadyExistsException(sbomFile.getAbsolutePath(), null, "File already exists");
                }
                int count = HsteSupportUtils.saveSbomZip(sbomFile);
                if (count == 0) {
                    System.out.println(Constant.messages.getString("support.savesbom.warn.nosboms"));
                } else {
                    System.out.println(Constant.messages.getString("support.savesbom.info.generated", count, sbomFile.getAbsolutePath()));
                }
            } else if (this.handleCmdLineSessionArgsSynchronously(control)) {
                this.recordStartStats();
                control.runCommandLine();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                rc = 1;
            }
        }
        catch (ShutdownRequestedException e) {
            rc = 1;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            System.out.println(e.getMessage());
            System.out.println();
            System.out.println(this.getArgs().getHelp());
            rc = 1;
        }
        finally {
            control.shutdown(Model.getSingleton().getOptionsParam().getDatabaseParam().isCompactDatabase());
            LOGGER.info("{} terminated.", (Object)Constant.PROGRAM_TITLE);
        }
        if (rc == 0) {
            rc = control.getExitStatus();
        }
        return rc;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

