/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.stackhawk.hste.control.ControlOverrides;
import com.stackhawk.hste.utils.Stats;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;

abstract class HsteBootstrap {
    private static final Logger LOGGER = LogManager.getLogger(HsteBootstrap.class);
    private final CommandLine args;
    private final ControlOverrides controlOverrides;

    public HsteBootstrap(CommandLine args) {
        this.args = args;
        this.controlOverrides = new ControlOverrides();
        this.controlOverrides.setOrderedConfigs(this.getArgs().getOrderedConfigs());
        this.controlOverrides.setExperimentalDb(this.getArgs().isExperimentalDb());
    }

    public int start() {
        try {
            Constant.createInstance(this.controlOverrides);
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return 1;
        }
        Constant.setLowMemoryOption(this.getArgs().isLowMem());
        if (this.getArgs().isNoStdOutLog()) {
            HsteBootstrap.disableStdOutLog();
        }
        HsteBootstrap.setLogLevel(this.getArgs().getLogLevel());
        return 0;
    }

    protected static void disableStdOutLog() {
        LoggerContext.getContext().getConfiguration().getRootLogger().removeAppender("stdout");
    }

    private static void setLogLevel(Level level) {
        Configuration config = LoggerContext.getContext().getConfiguration();
        config.getLoggerConfig("org.parosproxy.paros").setLevel(level);
        config.getLoggerConfig("org.zaproxy").setLevel(level);
    }

    protected void initModel() throws Exception {
        Model.getSingleton().init(this.getControlOverrides());
        Model.getSingleton().getOptionsParam().setGUI(this.getArgs().isGUI());
    }

    protected CommandLine getArgs() {
        return this.args;
    }

    protected ControlOverrides getControlOverrides() {
        return this.controlOverrides;
    }

    protected static String getStartingMessage() {
        if ("root".equals(System.getProperty("user.name"))) {
            LOGGER.warn("ZAP is being run using the root user - this is NOT recommended!");
        }
        DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance(3, 2);
        StringBuilder strBuilder = new StringBuilder(200);
        strBuilder.append("HSTE").append(' ').append(Constant.PROGRAM_VERSION);
        strBuilder.append(" started ");
        strBuilder.append(dateFormat.format(new Date()));
        strBuilder.append(" with home: ").append(Constant.getHsteHome());
        strBuilder.append(" cores: ").append(Runtime.getRuntime().availableProcessors());
        strBuilder.append(" maxMemory: ").append(FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory()));
        return strBuilder.toString();
    }

    protected void recordStartStats() {
        this.getControlOverrides().getOrderedConfigs().keySet().forEach(k -> Stats.incCounter("stats.config." + k));
    }
}

