/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste;

import com.stackhawk.hste.GuiBootstrap;
import com.stackhawk.hste.view.AboutDialog;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.View;

class OsXGui {
    private static final Logger LOGGER = LogManager.getLogger(OsXGui.class);

    private OsXGui() {
    }

    public static void setup() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("dock:name", "HSTE");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "HSTE");
        LOGGER.info("Initializing OS X specific settings, despite Apple's best efforts");
        try {
            InvocationHandler invocationHandler = (o, m, args) -> {
                switch (m.getName()) {
                    case "handleAbout": {
                        OsXGui.showAboutDialog();
                        break;
                    }
                    case "handlePreferences": {
                        OsXGui.showOptionsDialog();
                        break;
                    }
                    case "handleQuitRequestWith": {
                        OsXGui.exitHste();
                    }
                }
                return null;
            };
            if (SystemUtils.IS_JAVA_1_8) {
                OsXGui.setupJava8(invocationHandler);
            } else {
                OsXGui.setupJava9Plus(invocationHandler);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to set up all macOS GUI changes:", e);
        }
    }

    private static void setupJava8(InvocationHandler invocationHandler) throws Throwable {
        Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
        Object app = applicationClass.getDeclaredMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        applicationClass.getDeclaredMethod("setDockIconImage", Image.class).invoke(app, OsXGui.createIcon());
        Class<?> aboutHandlerClass = Class.forName("com.apple.eawt.AboutHandler");
        Class<?> preferencesHandlerClass = Class.forName("com.apple.eawt.PreferencesHandler");
        Class<?> quitHandlerClass = Class.forName("com.apple.eawt.QuitHandler");
        Object proxy = Proxy.newProxyInstance(OsXGui.class.getClassLoader(), new Class[]{aboutHandlerClass, preferencesHandlerClass, quitHandlerClass}, invocationHandler);
        applicationClass.getDeclaredMethod("setAboutHandler", aboutHandlerClass).invoke(app, proxy);
        applicationClass.getDeclaredMethod("setPreferencesHandler", preferencesHandlerClass).invoke(app, proxy);
        applicationClass.getDeclaredMethod("setQuitHandler", quitHandlerClass).invoke(app, proxy);
    }

    private static void setupJava9Plus(InvocationHandler invocationHandler) throws Throwable {
        Class<?> taskbarClass = Class.forName("java.awt.Taskbar");
        taskbarClass.getDeclaredMethod("setIconImage", Image.class).invoke(taskbarClass.getDeclaredMethod("getTaskbar", new Class[0]).invoke(null, new Object[0]), OsXGui.createIcon());
        Class<?> aboutHandlerClass = Class.forName("java.awt.desktop.AboutHandler");
        Class<?> preferencesHandlerClass = Class.forName("java.awt.desktop.PreferencesHandler");
        Class<?> quitHandlerClass = Class.forName("java.awt.desktop.QuitHandler");
        Object proxy = Proxy.newProxyInstance(OsXGui.class.getClassLoader(), new Class[]{aboutHandlerClass, preferencesHandlerClass, quitHandlerClass}, invocationHandler);
        Desktop desktop = Desktop.getDesktop();
        Desktop.class.getDeclaredMethod("setAboutHandler", aboutHandlerClass).invoke((Object)desktop, proxy);
        Desktop.class.getDeclaredMethod("setPreferencesHandler", preferencesHandlerClass).invoke((Object)desktop, proxy);
        Desktop.class.getDeclaredMethod("setQuitHandler", quitHandlerClass).invoke((Object)desktop, proxy);
    }

    private static Image createIcon() {
        return Toolkit.getDefaultToolkit().getImage(GuiBootstrap.class.getResource("/resource/hste1024x1024.png"));
    }

    private static void showAboutDialog() {
        AboutDialog dialog = new AboutDialog((Frame)View.getSingleton().getMainFrame(), true);
        dialog.setVisible(true);
    }

    private static void showOptionsDialog() {
        Control.getSingleton().getMenuToolsControl().options();
    }

    private static void exitHste() {
        Control.getSingleton().getMenuFileControl().exit();
    }
}

