/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.control;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class AddOnClassnames {
    public static final AddOnClassnames ALL_ALLOWED = new AddOnClassnames(Collections.emptyList(), Collections.emptyList());
    private final List<String> allowedClassnames;
    private final List<String> restrictedClassnames;

    public AddOnClassnames(List<String> allowedClassnames, List<String> restrictedClassnames) {
        if (allowedClassnames == null) {
            throw new IllegalArgumentException("Parameter allowedClassnames must not be null.");
        }
        if (restrictedClassnames == null) {
            throw new IllegalArgumentException("Parameter restrictedClassnames must not be null.");
        }
        this.allowedClassnames = allowedClassnames;
        this.restrictedClassnames = restrictedClassnames;
    }

    List<String> getAllowedClassnames() {
        return this.allowedClassnames;
    }

    List<String> getRestrictedClassnames() {
        return this.restrictedClassnames;
    }

    public boolean isAllowed(String classname) {
        Objects.requireNonNull(classname);
        if (!this.restrictedClassnames.isEmpty()) {
            for (String restrictedClassname : this.restrictedClassnames) {
                if (!classname.startsWith(restrictedClassname)) continue;
                return false;
            }
        }
        if (!this.allowedClassnames.isEmpty()) {
            for (String allowedClassname : this.allowedClassnames) {
                if (!classname.startsWith(allowedClassname)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

