/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.control;

import com.stackhawk.hste.control.AddOn;
import com.stackhawk.hste.control.AddOnLoader;
import com.stackhawk.hste.control.CoreFunctionality;
import com.stackhawk.hste.extension.ext.ExtensionParam;
import com.stackhawk.hste.extension.pscan.PluginPassiveScanner;
import com.stackhawk.hste.utils.HsteResourceBundleControl;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.function.Supplier;
import org.apache.commons.configuration.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;

public class ExtensionFactory {
    private static final Logger LOGGER = LogManager.getLogger(ExtensionFactory.class);
    private static Vector<Extension> listAllExtension = new Vector();
    private static TreeMap<String, Extension> mapAllExtension = new TreeMap();
    private static Map<Class<? extends Extension>, Extension> mapClassExtension = new HashMap<Class<? extends Extension>, Extension>();
    private static TreeMap<Integer, Extension> mapOrderToExtension = new TreeMap();
    private static List<Extension> unorderedExtensions = new ArrayList<Extension>();
    private static Map<Extension, Boolean> extensionsWithMessages = new HashMap<Extension, Boolean>();
    private static AddOnLoader addOnLoader = null;

    public static AddOnLoader getAddOnLoader(List<File> extraDirs) {
        if (addOnLoader == null) {
            File[] dirs = new File[extraDirs.size() + 2];
            dirs[0] = new File(Constant.getHsteInstall(), "plugin");
            dirs[1] = new File(Constant.getHsteHome(), "plugin");
            for (int i = 0; i < extraDirs.size(); ++i) {
                dirs[2 + i] = extraDirs.get(i);
            }
            addOnLoader = new AddOnLoader(dirs);
            ArrayList<AddOn> sortedAddOns = new ArrayList<AddOn>(addOnLoader.getAddOnCollection().getInstalledAddOns());
            Collections.sort(sortedAddOns, new Comparator<AddOn>(){

                @Override
                public int compare(AddOn addOn, AddOn otherAddOn) {
                    return addOn.getId().compareTo(otherAddOn.getId());
                }
            });
            LOGGER.info("Installed add-ons: {}", sortedAddOns);
        } else {
            LOGGER.error("AddOnLoader initialised without additional directories");
        }
        return addOnLoader;
    }

    public static AddOnLoader getAddOnLoader() {
        if (addOnLoader == null) {
            addOnLoader = new AddOnLoader(new File[]{new File(Constant.getHsteInstall(), "plugin"), new File(Constant.getHsteHome(), "plugin")});
            LOGGER.info("Installed add-ons: {}", addOnLoader.getAddOnCollection().getInstalledAddOns());
        }
        return addOnLoader;
    }

    public static synchronized void loadAllExtension(ExtensionLoader extensionLoader, OptionsParam optionsParam) {
        ExtensionFactory.loadAllExtension(extensionLoader, optionsParam, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadAllExtension(ExtensionLoader extensionLoader, OptionsParam optionsParam, Supplier<Set<Extension>> extensionSupplier) {
        LOGGER.info("Loading extensions");
        ArrayList<Extension> listExts = new ArrayList<Extension>(CoreFunctionality.getBuiltInExtensions());
        boolean localClasspath = false;
        if (extensionSupplier != null) {
            listExts.addAll((Collection<Extension>)extensionSupplier.get());
            localClasspath = true;
        } else {
            listExts.addAll(ExtensionFactory.getAddOnLoader().getExtensions());
        }
        ExtensionParam extParam = optionsParam.getExtensionParam();
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            mapAllExtension.clear();
            mapClassExtension.clear();
            for (int i = 0; i < listExts.size(); ++i) {
                ExtensionFactory.addExtensionImpl((Extension)listExts.get(i), extParam);
            }
            for (Integer order : mapOrderToExtension.keySet()) {
                Extension ext = mapOrderToExtension.get(order);
                if (ext.isEnabled()) {
                    LOGGER.debug("Ordered extension {} {}", (Object)order, (Object)ext.getName());
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
            for (Extension ext : unorderedExtensions) {
                if (ext.isEnabled()) {
                    LOGGER.debug("Unordered extension {}", (Object)ext.getName());
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
            if (localClasspath) {
                for (Extension ext : mapAllExtension.values()) {
                    ExtensionFactory.loadScanRules(ext);
                }
            }
        }
        LOGGER.info("Extensions loaded");
    }

    private static void loadScanRules(Extension ext) {
        ExtensionFactory.loadPscanRules(ext);
        ExtensionFactory.loadAscanRules(ext);
    }

    private static void loadPscanRules(Extension ext) {
        AddOn addOn = ext.getAddOn();
        if (addOn != null && !addOn.getPscanrules().isEmpty()) {
            HashSet<PluginPassiveScanner> scanners = new HashSet<PluginPassiveScanner>();
            for (String clzName : addOn.getPscanrules()) {
                try {
                    Class<?> clz = ExtensionFactory.class.getClassLoader().loadClass(clzName);
                    Constructor<?> constructor = clz.getDeclaredConstructor(new Class[0]);
                    PluginPassiveScanner scanner = (PluginPassiveScanner)constructor.newInstance(new Object[0]);
                    scanners.add(scanner);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Error loading pscan rule class: %s", clzName), (Throwable)e);
                }
            }
            addOn.setLoadedPscanrules(new ArrayList<PluginPassiveScanner>(scanners));
            addOn.setLoadedPscanrulesSet(true);
        }
    }

    private static void loadAscanRules(Extension ext) {
        AddOn addOn = ext.getAddOn();
        if (addOn != null && !addOn.getAscanrules().isEmpty()) {
            HashSet<AbstractPlugin> scanners = new HashSet<AbstractPlugin>();
            for (String clzName : addOn.getAscanrules()) {
                try {
                    Class<?> clz = ExtensionFactory.class.getClassLoader().loadClass(clzName);
                    Constructor<?> constructor = clz.getDeclaredConstructor(new Class[0]);
                    AbstractPlugin scanner = (AbstractPlugin)constructor.newInstance(new Object[0]);
                    scanners.add(scanner);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Error loading ascan rule class: %s", clzName), (Throwable)e);
                }
            }
            addOn.setLoadedAscanrules(new ArrayList<AbstractPlugin>(scanners));
            addOn.setLoadedAscanrulesSet(true);
        }
    }

    private static void loadMessagesAndAddExtension(ExtensionLoader extensionLoader, Extension extension) {
        ExtensionFactory.loadMessages(extension);
        if (!extension.isEnabled()) {
            return;
        }
        if (!ExtensionFactory.canBeLoaded(mapClassExtension, extension)) {
            return;
        }
        if (extension.supportsDb(Model.getSingleton().getDb().getType()) && (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet())) {
            extensionLoader.addExtension(extension);
        } else if (!extension.supportsDb(Model.getSingleton().getDb().getType())) {
            LOGGER.debug("Not loading extension {}: doesn't support {}", (Object)extension.getName(), (Object)Model.getSingleton().getDb().getType());
            extension.setEnabled(false);
        } else if (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet()) {
            LOGGER.debug("Not loading extension {}: doesn't support low memory option", (Object)extension.getName());
            extension.setEnabled(false);
        }
    }

    static boolean canBeLoaded(Map<Class<? extends Extension>, Extension> extensions, Extension extension) {
        return ExtensionFactory.canBeLoaded(extensions, extension, new ArrayList<Extension>());
    }

    private static boolean canBeLoaded(Map<Class<? extends Extension>, Extension> extensions, Extension extension, List<Extension> extsBeingProcessed) {
        if (extsBeingProcessed.contains(extension)) {
            LOGGER.error("Dependency loop with \"{}\" and {}", (Object)extension, extsBeingProcessed);
            return false;
        }
        List<Class<? extends Extension>> dependencies = extension.getDependencies();
        if (dependencies == null || dependencies.isEmpty()) {
            return true;
        }
        extsBeingProcessed.add(extension);
        for (Class<? extends Extension> dependency : dependencies) {
            Extension extDep = extensions.get(dependency);
            if (extDep == null) {
                ExtensionFactory.logUnableToLoadExt(extension, "missing dependency", dependency);
                extension.setEnabled(false);
                return false;
            }
            if (!extDep.isEnabled()) {
                ExtensionFactory.logUnableToLoadExt(extension, "dependency not enabled", dependency);
                extension.setEnabled(false);
                return false;
            }
            if (ExtensionFactory.canBeLoaded(extensions, extDep, extsBeingProcessed)) continue;
            ExtensionFactory.logUnableToLoadExt(extension, "can not load dependency", dependency);
            extension.setEnabled(false);
            return false;
        }
        extsBeingProcessed.remove(extension);
        return true;
    }

    private static void logUnableToLoadExt(Extension extension, String reason, Class<? extends Extension> dependency) {
        LOGGER.warn("Unable to load \"{}\", {}: {}", (Object)extension, (Object)reason, (Object)dependency.getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addAddOnExtension(ExtensionLoader extensionLoader, Configuration config, Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.addExtensionImpl(extension, Model.getSingleton().getOptionsParam().getExtensionParam());
            if (extension.isEnabled()) {
                LOGGER.debug("Adding new extension {}", (Object)extension.getName());
            }
            ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, extension);
        }
    }

    private static void addExtensionImpl(Extension extension, ExtensionParam extensionParam) {
        if (mapAllExtension.containsKey(extension.getName())) {
            if (mapAllExtension.get(extension.getName()).getClass().equals(extension.getClass())) {
                LOGGER.error("Duplicate extension: {} {}", (Object)extension.getName(), (Object)extension.getClass().getCanonicalName());
                extension.setEnabled(false);
                return;
            }
            LOGGER.error("Duplicate extension name: {} {} {}", (Object)extension.getName(), (Object)extension.getClass().getCanonicalName(), (Object)mapAllExtension.get(extension.getName()).getClass().getCanonicalName());
        }
        if (extension.isDepreciated()) {
            LOGGER.debug("Depreciated extension {}", (Object)extension.getName());
            extension.setEnabled(false);
            return;
        }
        AddOn addOn = extension.getAddOn();
        boolean mandatory = addOn != null && addOn.isMandatory();
        extension.setEnabled(mandatory || extensionParam.isExtensionEnabled(extension.getName()));
        listAllExtension.add(extension);
        mapAllExtension.put(extension.getName(), extension);
        mapClassExtension.put(extension.getClass(), extension);
        int order = extension.getOrder();
        if (order == 0) {
            unorderedExtensions.add(extension);
        } else if (mapOrderToExtension.containsKey(order)) {
            LOGGER.error("Duplicate order {} {}/{} already registered, {}/{} will be added as an unordered extension", (Object)order, (Object)mapOrderToExtension.get(order).getName(), (Object)mapOrderToExtension.get(order).getClass().getCanonicalName(), (Object)extension.getName(), (Object)extension.getClass().getCanonicalName());
            unorderedExtensions.add(extension);
        } else {
            mapOrderToExtension.put(order, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<Extension> loadAddOnExtensions(ExtensionLoader extensionLoader, Configuration config, AddOn addOn) {
        List<Extension> listExts = ExtensionFactory.getAddOnLoader().getExtensions(addOn);
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionParam extParam = Model.getSingleton().getOptionsParam().getExtensionParam();
            for (Extension extension : listExts) {
                ExtensionFactory.addExtensionImpl(extension, extParam);
            }
            for (Extension ext : listExts) {
                if (ext.isEnabled()) {
                    LOGGER.debug("Adding new extension {}", (Object)ext.getName());
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, ext);
            }
        }
        return listExts;
    }

    private static void loadMessages(Extension ext) {
        AddOn addOn = ext.getAddOn();
        if (addOn == null) {
            ResourceBundle msg = ExtensionFactory.getExtensionResourceBundle(ext);
            if (msg == null) {
                ext.setMessages(Constant.messages.getCoreResourceBundle());
            } else {
                ext.setMessages(msg);
                extensionsWithMessages.put(ext, Boolean.TRUE);
                Constant.messages.addMessageBundle(ext.getI18nPrefix(), ext.getMessages());
            }
            return;
        }
        ResourceBundle msg = ExtensionFactory.getExtensionResourceBundle(ext);
        if (msg != null) {
            ext.setMessages(msg);
            extensionsWithMessages.put(ext, Boolean.TRUE);
            Constant.messages.addMessageBundle(ext.getI18nPrefix(), ext.getMessages());
        } else if (addOn.getResourceBundle() != null) {
            ext.setMessages(addOn.getResourceBundle());
        } else {
            ext.setMessages(Constant.messages.getCoreResourceBundle());
        }
    }

    private static ResourceBundle getExtensionResourceBundle(Extension ext) {
        Package extPackage = ext.getClass().getPackage();
        String extensionPackage = extPackage != null ? extPackage.getName() + "." : "";
        ClassLoader classLoader = ext.getClass().getClassLoader();
        try {
            String name = extensionPackage + "resources.Messages";
            return ExtensionFactory.getPropertiesResourceBundle(name, classLoader);
        }
        catch (MissingResourceException ignore) {
            String oldLocation = extensionPackage + "Messages";
            try {
                return ExtensionFactory.getPropertiesResourceBundle(oldLocation, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
    }

    private static ResourceBundle getPropertiesResourceBundle(String name, ClassLoader classLoader) throws MissingResourceException {
        return ResourceBundle.getBundle(name, Constant.getLocale(), classLoader, new HsteResourceBundleControl());
    }

    public static List<Extension> getAllExtensions() {
        return listAllExtension;
    }

    public static Extension getExtension(String name) {
        return mapAllExtension.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadAddOnExtension(Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.unloadMessages(extension);
            mapAllExtension.remove(extension.getName());
            mapClassExtension.remove(extension.getClass());
            listAllExtension.remove(extension);
            boolean isUnordered = true;
            Iterator<Extension> it = mapOrderToExtension.values().iterator();
            while (it.hasNext()) {
                if (it.next() != extension) continue;
                it.remove();
                isUnordered = false;
                break;
            }
            if (isUnordered) {
                unorderedExtensions.remove(extension);
            }
        }
    }

    private static void unloadMessages(Extension extension) {
        if (extensionsWithMessages.remove(extension) == null) {
            return;
        }
        ResourceBundle msg = extension.getMessages();
        if (msg != null) {
            Constant.messages.removeMessageBundle(extension.getI18nPrefix());
        }
    }
}

