/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.db.sql;

import com.stackhawk.hste.db.sql.SqlDatabaseServer;
import com.stackhawk.hste.db.sql.SqlPreparedStatementWrapper;
import com.stackhawk.hste.utils.Stats;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.DatabaseUnsupportedException;

public class DbSQL
implements DatabaseListener {
    private static Properties dbProperties = null;
    private static Properties sqlProperties = null;
    private static String dbType = null;
    private static DbSQL singleton = null;
    private static SqlDatabaseServer dbServer = null;
    private static final Logger LOGGER = LogManager.getLogger(DbSQL.class);
    private Map<String, StatementPool> stmtPool = new HashMap<String, StatementPool>();

    public static DbSQL getSingleton() {
        if (singleton == null) {
            singleton = new DbSQL();
        }
        return singleton;
    }

    static void reset() {
        dbProperties = null;
        sqlProperties = null;
        dbType = null;
        singleton = null;
        dbServer = null;
    }

    static void setSqlProperties(Properties properties) {
        sqlProperties = properties;
    }

    protected String getDbUser() {
        if (dbProperties == null) {
            throw new IllegalStateException("Database not initialised");
        }
        return dbProperties.getProperty("db.user");
    }

    protected String getDbPassword() {
        if (dbProperties == null) {
            throw new IllegalStateException("Database not initialised");
        }
        return dbProperties.getProperty("db.password");
    }

    protected String getDbUrl() {
        if (dbProperties == null) {
            throw new IllegalStateException("Database not initialised");
        }
        return dbProperties.getProperty("db.url");
    }

    public static String getDbType() {
        return dbType;
    }

    public synchronized Database initDatabase() throws IllegalStateException, DatabaseException {
        Object dbObj;
        if (dbProperties != null) {
            throw new IllegalStateException("Database already initialised");
        }
        File file = new File(Constant.getHsteHome() + File.separator + "db", "db.properties");
        if (!file.exists()) {
            file = new File(Constant.getHsteInstall() + File.separator + "db", "db.properties");
        }
        if (!file.exists()) {
            throw new DatabaseException("Missing DB properties file: " + file.getAbsolutePath());
        }
        dbProperties = new Properties();
        try (FileReader reader = new FileReader(file);){
            dbProperties.load(reader);
        }
        catch (IOException e) {
            throw new DatabaseException("I/O error while reading DB properties file.", e);
        }
        dbType = dbProperties.getProperty("db.type");
        sqlProperties = new Properties();
        File sqlFile = new File(Constant.getHsteInstall() + File.separator + "db", dbType + ".properties");
        try (FileReader sqlReader = new FileReader(sqlFile);){
            sqlProperties.load(sqlReader);
        }
        catch (Exception e) {
            LOGGER.error("No SQL properties file for db type {}", (Object)sqlFile.getAbsolutePath());
            throw new DatabaseException("Missing SQL properties file: " + sqlFile.getAbsolutePath());
        }
        String className = dbProperties.getProperty("db.class");
        try {
            Class<?> dbClass = Class.forName(className);
            dbObj = dbClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new DatabaseException("Failed to create the instance for: " + className, e);
        }
        if (!(dbObj instanceof Database)) {
            throw new DatabaseException("db.class is not an instance of Database: " + dbObj.getClass().getCanonicalName());
        }
        return (Database)dbObj;
    }

    public static void addSqlProperties(InputStream inStream) throws IOException {
        sqlProperties.load(inStream);
    }

    public static String getSQL(String key) {
        String str = sqlProperties.getProperty(key);
        if (str != null) {
            str = str.trim();
        }
        return str;
    }

    public static String getSQL(String key, Object ... params) {
        String str = MessageFormat.format(DbSQL.getSQL(key), params);
        if (str != null) {
            str = str.trim();
        }
        return str;
    }

    public static void setSetValues(PreparedStatement ps, int startPosition, String ... values) throws SQLException {
        for (int i = startPosition; i < values.length; ++i) {
            ps.setString(i, values[i]);
        }
    }

    public static void setSetValues(PreparedStatement ps, int startPosition, int ... values) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            ps.setInt(startPosition + i, values[i]);
        }
    }

    @Override
    public void databaseOpen(DatabaseServer dbServer) throws DatabaseException, DatabaseUnsupportedException {
        DbSQL.dbServer = (SqlDatabaseServer)dbServer;
        for (Map.Entry<String, StatementPool> entry : this.stmtPool.entrySet()) {
            entry.getValue().clear();
        }
        Stats.clear("sqldb.");
    }

    public synchronized SqlPreparedStatementWrapper getPreparedStatement(String key, int ... params) throws SQLException {
        if (params == null || params.length == 0) {
            return this.getPreparedStatement(key);
        }
        String internalKey = key + Arrays.toString(params);
        return this.getStatementPool(internalKey).getPreparedStatement(internalKey, DbSQL.createSQL(key, params));
    }

    public synchronized SqlPreparedStatementWrapper getPreparedStatement(String key) throws SQLException {
        return this.getStatementPool(key).getPreparedStatement(key, DbSQL.getSQL(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementPool getStatementPool(String key) {
        Stats.incCounter("sqldb." + key + ".calls");
        StatementPool sp = this.stmtPool.get(key);
        if (sp == null) {
            DbSQL dbSQL = this;
            synchronized (dbSQL) {
                if (!this.stmtPool.containsKey(key)) {
                    this.stmtPool.put(key, new StatementPool());
                }
            }
            sp = this.stmtPool.get(key);
        }
        return sp;
    }

    public void releasePreparedStatement(SqlPreparedStatementWrapper psw) {
        if (psw != null) {
            Stats.incCounter("sqldb." + psw.getKey() + ".time", psw.getTimeTaken());
            this.stmtPool.get(psw.getKey()).releasePreparedStatement(psw);
        }
    }

    private static String createSQL(String key, int[] numberOfParams) {
        if (numberOfParams == null || numberOfParams.length == 0) {
            return DbSQL.getSQL(key);
        }
        Object[] parameters = new Object[numberOfParams.length];
        for (int i = 0; i < numberOfParams.length; ++i) {
            parameters[i] = StringUtils.repeat((String)"?", (String)", ", (int)numberOfParams[i]);
        }
        return DbSQL.getSQL(key, parameters);
    }

    private class StatementPool {
        private static final int MAX_FREE_POOL_SIZE = 5;
        private Deque<PreparedStatement> inUsePool = new ConcurrentLinkedDeque<PreparedStatement>();
        private Deque<PreparedStatement> freePool = new ConcurrentLinkedDeque<PreparedStatement>();

        private StatementPool() {
        }

        public SqlPreparedStatementWrapper getPreparedStatement(String key, String sql) throws SQLException {
            PreparedStatement ps = this.freePool.pollFirst();
            if (ps == null) {
                ps = dbServer.getNewConnection().prepareStatement(sql);
                Stats.incCounter("sqldb.conn.openned");
            }
            this.inUsePool.add(ps);
            Stats.setHighwaterMark("sqldb." + key + ".pool", this.inUsePool.size());
            return new SqlPreparedStatementWrapper(key, ps);
        }

        public void releasePreparedStatement(SqlPreparedStatementWrapper ps) {
            if (this.inUsePool.remove(ps.getPs())) {
                if (this.freePool.size() < 5) {
                    this.freePool.add(ps.getPs());
                } else {
                    try {
                        ps.close();
                        Stats.incCounter("sqldb.conn.closed");
                    }
                    catch (SQLException e) {
                        LOGGER.error("Error closing prepared statement", (Throwable)e);
                    }
                }
            } else {
                LOGGER.error("Releasing prepared statement not in a pool", (Throwable)new InvalidParameterException());
            }
        }

        public void clear() {
            Iterator<PreparedStatement> iter = this.inUsePool.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().close();
                }
                catch (SQLException sQLException) {}
            }
            this.inUsePool.clear();
            iter = this.freePool.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().close();
                }
                catch (SQLException sQLException) {}
            }
            this.freePool.clear();
        }
    }
}

