/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.db.sql;

import com.stackhawk.hste.db.sql.HsqldbDatabaseServer;
import com.stackhawk.hste.db.sql.SqlDatabase;
import com.stackhawk.hste.db.sql.SqlDatabaseServer;
import java.io.File;

public class HsqldbDatabase
extends SqlDatabase {
    @Override
    public void deleteSession(String sessionName) {
        super.deleteSession(sessionName);
        this.getLogger().debug("deleteSession {}", (Object)sessionName);
        this.deleteDbFile(new File(sessionName));
        this.deleteDbFile(new File(sessionName + ".data"));
        this.deleteDbFile(new File(sessionName + ".script"));
        this.deleteDbFile(new File(sessionName + ".properties"));
        this.deleteDbFile(new File(sessionName + ".backup"));
        this.deleteDbFile(new File(sessionName + ".lobs"));
    }

    private void deleteDbFile(File file) {
        this.getLogger().debug("Deleting {}", (Object)file.getAbsolutePath());
        if (file.exists() && !file.delete()) {
            this.getLogger().error("Failed to delete {}", (Object)file.getAbsolutePath());
        }
    }

    @Override
    protected SqlDatabaseServer createDatabaseServer(String path) throws Exception {
        return new HsqldbDatabaseServer(path);
    }

    @Override
    public void close(boolean compact, boolean cleanup) {
        this.getLogger().debug("close");
        super.close(compact, cleanup);
        if (this.getDatabaseServer() == null) {
            return;
        }
        try {
            ((HsqldbDatabaseServer)this.getDatabaseServer()).shutdown(compact);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isFileBased() {
        return true;
    }
}

