/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.db.sql;

import com.stackhawk.hste.db.TableAlertTag;
import com.stackhawk.hste.db.sql.DbSQL;
import com.stackhawk.hste.db.sql.SqlDatabaseServer;
import com.stackhawk.hste.db.sql.SqlTableAlert;
import com.stackhawk.hste.db.sql.SqlTableAlertTag;
import com.stackhawk.hste.db.sql.SqlTableContext;
import com.stackhawk.hste.db.sql.SqlTableHistory;
import com.stackhawk.hste.db.sql.SqlTableParam;
import com.stackhawk.hste.db.sql.SqlTableScan;
import com.stackhawk.hste.db.sql.SqlTableSession;
import com.stackhawk.hste.db.sql.SqlTableSessionUrl;
import com.stackhawk.hste.db.sql.SqlTableStructure;
import com.stackhawk.hste.db.sql.SqlTableTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.parosproxy.paros.db.AbstractDatabase;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableContext;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableParam;
import org.parosproxy.paros.db.TableScan;
import org.parosproxy.paros.db.TableSession;
import org.parosproxy.paros.db.TableSessionUrl;
import org.parosproxy.paros.db.TableStructure;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.extension.option.DatabaseParam;

public class SqlDatabase
extends AbstractDatabase {
    private SqlDatabaseServer databaseServer = null;
    private TableHistory tableHistory = null;
    private TableSession tableSession = null;
    private TableAlert tableAlert = null;
    private TableAlertTag tableAlertTag = null;
    private TableScan tableScan = null;
    private TableTag tableTag = null;
    private TableSessionUrl tableSessionUrl = null;
    private TableParam tableParam = null;
    private TableContext tableContext = null;
    private TableStructure tableStructure = null;
    private final List<DatabaseListener> internalDatabaseListeners = new ArrayList<DatabaseListener>();

    public SqlDatabase() {
        this.tableAlert = new SqlTableAlert();
        this.tableAlertTag = new SqlTableAlertTag();
        this.tableContext = new SqlTableContext();
        this.tableHistory = new SqlTableHistory();
        this.tableParam = new SqlTableParam();
        this.tableScan = new SqlTableScan();
        this.tableSession = new SqlTableSession();
        this.tableSessionUrl = new SqlTableSessionUrl();
        this.tableTag = new SqlTableTag();
        this.tableStructure = new SqlTableStructure();
        this.internalDatabaseListeners.add(DbSQL.getSingleton());
        this.internalDatabaseListeners.add(this.tableHistory);
        this.internalDatabaseListeners.add(this.tableSession);
        this.internalDatabaseListeners.add(this.tableAlert);
        this.internalDatabaseListeners.add(this.tableAlertTag);
        this.internalDatabaseListeners.add(this.tableScan);
        this.internalDatabaseListeners.add(this.tableTag);
        this.internalDatabaseListeners.add(this.tableSessionUrl);
        this.internalDatabaseListeners.add(this.tableParam);
        this.internalDatabaseListeners.add(this.tableContext);
        this.internalDatabaseListeners.add(this.tableStructure);
    }

    @Override
    public void setDatabaseOptions(DatabaseParam options) {
        Objects.requireNonNull(options);
        this.tableHistory.setDatabaseOptions(options);
    }

    @Override
    public DatabaseServer getDatabaseServer() {
        return this.databaseServer;
    }

    protected void setDatabaseServer(SqlDatabaseServer databaseServer) {
        this.databaseServer = databaseServer;
    }

    @Override
    public TableHistory getTableHistory() {
        return this.tableHistory;
    }

    @Override
    public TableSession getTableSession() {
        return this.tableSession;
    }

    @Override
    public final void open(String path) throws Exception {
        this.getLogger().debug("open {}", (Object)path);
        this.setDatabaseServer(this.createDatabaseServer(path));
        this.notifyListenersDatabaseOpen(this.internalDatabaseListeners, this.getDatabaseServer());
        this.notifyListenersDatabaseOpen(this.getDatabaseServer());
    }

    protected SqlDatabaseServer createDatabaseServer(String path) throws Exception {
        return new SqlDatabaseServer(path);
    }

    @Override
    public void deleteSession(String sessionName) {
        this.getLogger().debug("deleteSession {}", (Object)sessionName);
        if (this.databaseServer == null) {
            return;
        }
        this.databaseServer = null;
    }

    @Override
    public void close(boolean compact, boolean cleanup) {
        this.getLogger().debug("close");
        if (this.databaseServer == null) {
            return;
        }
        super.close(compact, cleanup);
        try {
            if (cleanup) {
                this.getTableHistory().deleteTemporary();
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isFileBased() {
        return false;
    }

    @Override
    public TableAlert getTableAlert() {
        return this.tableAlert;
    }

    @Override
    public void setTableAlert(TableAlert tableAlert) {
        this.tableAlert = tableAlert;
    }

    @Override
    public TableAlertTag getTableAlertTag() {
        return this.tableAlertTag;
    }

    @Override
    public void setTableAlertTag(TableAlertTag tableAlertTag) {
        this.tableAlertTag = tableAlertTag;
    }

    @Override
    public TableScan getTableScan() {
        return this.tableScan;
    }

    @Override
    public void setTableScan(TableScan tableScan) {
        this.tableScan = tableScan;
    }

    @Override
    public TableTag getTableTag() {
        return this.tableTag;
    }

    @Override
    public void setTableTag(TableTag tableTag) {
        this.tableTag = tableTag;
    }

    @Override
    public TableSessionUrl getTableSessionUrl() {
        return this.tableSessionUrl;
    }

    @Override
    public void setTableSessionUrl(TableSessionUrl tableSessionUrl) {
        this.tableSessionUrl = tableSessionUrl;
    }

    @Override
    public TableParam getTableParam() {
        return this.tableParam;
    }

    @Override
    public TableContext getTableContext() {
        return this.tableContext;
    }

    @Override
    public TableStructure getTableStructure() {
        return this.tableStructure;
    }

    @Override
    public String getType() {
        return DbSQL.getDbType();
    }

    @Override
    public void discardSession(long sessionId) throws DatabaseException {
        if (!this.isFileBased()) {
            this.getTableHistory().deleteHistorySession(sessionId);
        }
    }
}

