/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.db.sql;

import com.stackhawk.hste.db.RecordAlertTag;
import com.stackhawk.hste.db.TableAlertTag;
import com.stackhawk.hste.db.sql.DbSQL;
import com.stackhawk.hste.db.sql.SqlAbstractTable;
import com.stackhawk.hste.db.sql.SqlPreparedStatementWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;

public class SqlTableAlertTag
extends SqlAbstractTable
implements TableAlertTag {
    private static final String TABLE_NAME = DbSQL.getSQL("alerttag.table_name");
    private static final String TAG_ID = DbSQL.getSQL("alerttag.field.tagid");
    private static final String ALERT_ID = DbSQL.getSQL("alerttag.field.alertid");
    private static final String KEY = DbSQL.getSQL("alerttag.field.key");
    private static final String VALUE = DbSQL.getSQL("alerttag.field.value");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, DbSQL.getSQL("alerttag.ps.createtable"));
            }
            if (!DbUtils.hasIndex(conn, "ALERT_TAG", "ALERT_ID_INDEX")) {
                DbUtils.execute(conn, DbSQL.getSQL("alerttag.ps.indexalertid"));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public RecordAlertTag read(long tagId) throws DatabaseException {
        SqlPreparedStatementWrapper psRead = null;
        try {
            RecordAlertTag recordAlertTag;
            block11: {
                psRead = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.readbytagid");
                psRead.getPs().setLong(1, tagId);
                ResultSet rs = psRead.getPs().executeQuery();
                try {
                    recordAlertTag = this.build(rs);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordAlertTag;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psRead);
        }
    }

    @Override
    public RecordAlertTag read(long alertId, String key) throws DatabaseException {
        SqlPreparedStatementWrapper psRead = null;
        try {
            RecordAlertTag recordAlertTag;
            block11: {
                psRead = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.readbyalertidtagkey");
                psRead.getPs().setLong(1, alertId);
                psRead.getPs().setString(2, key);
                ResultSet rs = psRead.getPs().executeQuery();
                try {
                    recordAlertTag = this.build(rs);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordAlertTag;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psRead);
        }
    }

    @Override
    public RecordAlertTag insertOrUpdate(long alertId, String key, String value) throws DatabaseException {
        SqlPreparedStatementWrapper psInsertOrUpdate = null;
        try {
            psInsertOrUpdate = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.insertorupdate");
            psInsertOrUpdate.getPs().setLong(1, alertId);
            psInsertOrUpdate.getPs().setString(2, key);
            psInsertOrUpdate.getPs().setString(3, value);
            psInsertOrUpdate.getPs().executeUpdate();
            RecordAlertTag recordAlertTag = this.read(alertId, key);
            return recordAlertTag;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsertOrUpdate);
        }
    }

    @Override
    public Map<String, String> getAllTags() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllTags = null;
        try {
            psGetAllTags = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.getalltags");
            HashMap<String, String> result = new HashMap<String, String>();
            try (ResultSet rs = psGetAllTags.getPs().executeQuery();){
                while (rs.next()) {
                    result.put(rs.getString(KEY), rs.getString(VALUE));
                }
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllTags);
        }
    }

    @Override
    public List<RecordAlertTag> getAllRecords() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllRecords = null;
        try {
            psGetAllRecords = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.getallrecords");
            ArrayList<RecordAlertTag> result = new ArrayList<RecordAlertTag>();
            try (ResultSet rs = psGetAllRecords.getPs().executeQuery();){
                RecordAlertTag rat;
                while ((rat = this.build(rs)) != null) {
                    result.add(rat);
                }
            }
            ArrayList<RecordAlertTag> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllRecords);
        }
    }

    @Override
    public Map<String, String> getTagsByAlertId(long alertId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetTagsByAlertId = null;
        try {
            psGetTagsByAlertId = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.gettagsbyalertid");
            HashMap<String, String> result = new HashMap<String, String>();
            psGetTagsByAlertId.getPs().setLong(1, alertId);
            try (ResultSet rs = psGetTagsByAlertId.getPs().executeQuery();){
                while (rs.next()) {
                    result.put(rs.getString("key"), rs.getString("value"));
                }
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetTagsByAlertId);
        }
    }

    @Override
    public void delete(long alertId, String key) throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletebyalertidtagkey");
            psDelete.getPs().setLong(1, alertId);
            psDelete.getPs().setString(2, key);
            psDelete.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Override
    public void delete(long tagId) throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletebytagid");
            psDelete.getPs().setLong(1, tagId);
            psDelete.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Override
    public void deleteAllTagsForAlert(long alertId) throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletealltagsforalert");
            psDelete.getPs().setLong(1, alertId);
            psDelete.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    @Override
    public int deleteAllTags() throws DatabaseException {
        SqlPreparedStatementWrapper psDelete = null;
        try {
            psDelete = DbSQL.getSingleton().getPreparedStatement("alerttag.ps.deletealltags");
            int n = psDelete.getPs().executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDelete);
        }
    }

    private RecordAlertTag build(ResultSet rs) throws SQLException {
        RecordAlertTag rat = null;
        if (rs.next()) {
            rat = new RecordAlertTag(rs.getLong(TAG_ID), rs.getLong(ALERT_ID), rs.getString(KEY), rs.getString(VALUE));
        }
        return rat;
    }
}

