/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.db.sql;

import com.stackhawk.hste.db.sql.DbSQL;
import com.stackhawk.hste.db.sql.SqlAbstractTable;
import com.stackhawk.hste.db.sql.SqlPreparedStatementWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.db.TableScan;

public class SqlTableScan
extends SqlAbstractTable
implements TableScan {
    private static final String SCANID = DbSQL.getSQL("scan.field.scanid");
    private static final String SCANNAME = DbSQL.getSQL("scan.field.scanname");
    private static final String SCANTIME = DbSQL.getSQL("scan.field.scantime");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
    }

    @Override
    public synchronized RecordScan getLatestScan() throws DatabaseException {
        SqlPreparedStatementWrapper psGetLatestScan = null;
        try {
            RecordScan recordScan;
            block11: {
                psGetLatestScan = DbSQL.getSingleton().getPreparedStatement("scan.ps.getlatestscan");
                ResultSet rs = psGetLatestScan.getPs().executeQuery();
                try {
                    recordScan = this.build(rs);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordScan;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetLatestScan);
        }
    }

    @Override
    public synchronized RecordScan read(int scanId) throws DatabaseException {
        SqlPreparedStatementWrapper psRead = null;
        try {
            RecordScan recordScan;
            block11: {
                psRead = DbSQL.getSingleton().getPreparedStatement("scan.ps.read");
                psRead.getPs().setInt(1, scanId);
                ResultSet rs = psRead.getPs().executeQuery();
                try {
                    recordScan = this.build(rs);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordScan;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psRead);
        }
    }

    @Override
    public synchronized RecordScan insert(long sessionId, String scanName) throws DatabaseException {
        SqlPreparedStatementWrapper psInsert = null;
        try {
            int id;
            psInsert = DbSQL.getSingleton().getPreparedStatement("scan.ps.insert");
            psInsert.getPs().setLong(1, sessionId);
            psInsert.getPs().setString(2, scanName);
            psInsert.getPs().executeUpdate();
            try (ResultSet rs = psInsert.getLastInsertedId();){
                rs.next();
                id = rs.getInt(1);
            }
            RecordScan recordScan = this.read(id);
            return recordScan;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsert);
        }
    }

    private RecordScan build(ResultSet rs) throws DatabaseException {
        try {
            RecordScan scan = null;
            if (rs.next()) {
                scan = new RecordScan(rs.getInt(SCANID), rs.getString(SCANNAME), rs.getDate(SCANTIME));
            }
            rs.close();
            return scan;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

