/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.db.sql;

import com.stackhawk.hste.db.sql.DbSQL;
import com.stackhawk.hste.db.sql.SqlAbstractTable;
import com.stackhawk.hste.db.sql.SqlPreparedStatementWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.db.TableSession;

public class SqlTableSession
extends SqlAbstractTable
implements TableSession {
    private static final String SESSIONID = DbSQL.getSQL("session.field.sessionid");
    private static final String SESSIONNAME = DbSQL.getSQL("session.field.sessionname");
    private static final String LASTACCESS = DbSQL.getSQL("session.field.lastaccess");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
    }

    @Override
    public synchronized void insert(long sessionId, String sessionName) throws DatabaseException {
        SqlPreparedStatementWrapper psInsert = null;
        try {
            psInsert = DbSQL.getSingleton().getPreparedStatement("session.ps.insert");
            psInsert.getPs().setLong(1, sessionId);
            psInsert.getPs().setString(2, sessionName);
            psInsert.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsert);
        }
    }

    @Override
    public synchronized void update(long sessionId, String sessionName) throws DatabaseException {
        SqlPreparedStatementWrapper psUpdate = null;
        try {
            psUpdate = DbSQL.getSingleton().getPreparedStatement("session.ps.update");
            psUpdate.getPs().setLong(2, sessionId);
            psUpdate.getPs().setString(1, sessionName);
            psUpdate.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psUpdate);
        }
    }

    @Override
    public List<RecordSession> listSessions() throws DatabaseException {
        SqlPreparedStatementWrapper psList = null;
        try {
            psList = DbSQL.getSingleton().getPreparedStatement("session.ps.list");
            ArrayList<RecordSession> result = new ArrayList<RecordSession>();
            try (ResultSet rs = psList.getPs().executeQuery();){
                RecordSession ra = this.build(rs);
                while (ra != null) {
                    result.add(ra);
                    ra = this.build(rs);
                }
            }
            ArrayList<RecordSession> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psList);
        }
    }

    private RecordSession build(ResultSet rs) throws DatabaseException {
        try {
            RecordSession session = null;
            if (rs.next()) {
                session = new RecordSession(rs.getLong(SESSIONID), rs.getString(SESSIONNAME), rs.getDate(LASTACCESS));
            }
            return session;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

