/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.db.sql;

import com.stackhawk.hste.db.sql.DbSQL;
import com.stackhawk.hste.db.sql.SqlAbstractTable;
import com.stackhawk.hste.db.sql.SqlPreparedStatementWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordSessionUrl;
import org.parosproxy.paros.db.TableSessionUrl;

public class SqlTableSessionUrl
extends SqlAbstractTable
implements TableSessionUrl {
    private static final String TABLE_NAME = DbSQL.getSQL("sessionurl.table_name");
    private static final String URLID = DbSQL.getSQL("sessionurl.field.urlid");
    private static final String TYPE = DbSQL.getSQL("sessionurl.field.type");
    private static final String URL = DbSQL.getSQL("sessionurl.field.url");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, DbSQL.getSQL("sessionurl.ps.createtable"));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordSessionUrl read(long urlId) throws DatabaseException {
        SqlPreparedStatementWrapper psRead = null;
        try {
            RecordSessionUrl recordSessionUrl;
            block11: {
                psRead = DbSQL.getSingleton().getPreparedStatement("sessionurl.ps.read");
                psRead.getPs().setLong(1, urlId);
                ResultSet rs = psRead.getPs().executeQuery();
                try {
                    recordSessionUrl = this.build(rs);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordSessionUrl;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psRead);
        }
    }

    @Override
    public synchronized RecordSessionUrl insert(int type, String url) throws DatabaseException {
        SqlPreparedStatementWrapper psInsert = null;
        try {
            long id;
            psInsert = DbSQL.getSingleton().getPreparedStatement("sessionurl.ps.insert");
            psInsert.getPs().setInt(1, type);
            psInsert.getPs().setString(2, url);
            psInsert.getPs().executeUpdate();
            try (ResultSet rs = psInsert.getLastInsertedId();){
                rs.next();
                id = rs.getLong(1);
            }
            RecordSessionUrl recordSessionUrl = this.read(id);
            return recordSessionUrl;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsert);
        }
    }

    @Override
    public synchronized void delete(int type, String url) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteUrls = null;
        try {
            psDeleteUrls = DbSQL.getSingleton().getPreparedStatement("sessionurl.ps.deleteurls");
            psDeleteUrls.getPs().setInt(1, type);
            psDeleteUrls.getPs().setString(2, url);
            psDeleteUrls.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteUrls);
        }
    }

    @Override
    public synchronized void deleteAllUrlsForType(int type) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteAllUrlsForType = null;
        try {
            psDeleteAllUrlsForType = DbSQL.getSingleton().getPreparedStatement("sessionurl.ps.deleteurlsfortype");
            psDeleteAllUrlsForType.getPs().setInt(1, type);
            psDeleteAllUrlsForType.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteAllUrlsForType);
        }
    }

    @Override
    public List<RecordSessionUrl> getUrlsForType(int type) throws DatabaseException {
        SqlPreparedStatementWrapper psGetAlluRLSForType = null;
        try {
            ArrayList<RecordSessionUrl> arrayList;
            block12: {
                psGetAlluRLSForType = DbSQL.getSingleton().getPreparedStatement("sessionurl.ps.geturlsfortype");
                psGetAlluRLSForType.getPs().setInt(1, type);
                ResultSet rs = psGetAlluRLSForType.getPs().executeQuery();
                try {
                    ArrayList<RecordSessionUrl> result = new ArrayList<RecordSessionUrl>();
                    while (rs.next()) {
                        result.add(new RecordSessionUrl(rs.getLong(URLID), rs.getInt(TYPE), rs.getString(URL)));
                    }
                    arrayList = result;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return arrayList;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAlluRLSForType);
        }
    }

    private RecordSessionUrl build(ResultSet rs) throws DatabaseException {
        try {
            RecordSessionUrl rt = null;
            if (rs.next()) {
                rt = new RecordSessionUrl(rs.getLong(URLID), rs.getInt(TYPE), rs.getString(URL));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setUrls(int type, List<String> urls) throws DatabaseException {
        this.deleteAllUrlsForType(type);
        for (String url : urls) {
            this.insert(type, url);
        }
    }
}

