/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.alert;

import com.stackhawk.hste.extension.alert.AlertViewPanel;
import com.stackhawk.hste.extension.alert.ExtensionAlert;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;

public class AlertAddDialog
extends AbstractDialog {
    private static final Logger LOGGER = LogManager.getLogger(AlertAddDialog.class);
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private HistoryReference historyRef;
    private int historyType;
    private HttpMessage httpMessage;
    private AlertViewPanel alertViewPanel = null;

    public AlertAddDialog() throws HeadlessException {
        this.initialize();
    }

    public AlertAddDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("alert.add.title"));
        this.setContentPane(this.getJPanel());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(407, 657);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                AlertAddDialog.this.btnCancel.doClick();
            }
        });
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            JLabel jLabel2 = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(new Dimension(450, 650));
            this.jPanel.setMinimumSize(new Dimension(450, 650));
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 13;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 10);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 5;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.insets = new Insets(2, 10, 2, 5);
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints15.gridwidth = 3;
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 2;
            gridBagConstraints15.anchor = 18;
            gridBagConstraints15.ipadx = 0;
            gridBagConstraints15.ipady = 10;
            this.jPanel.add((Component)this.getAlertViewPanel(), gridBagConstraints15);
            this.jPanel.add((Component)jLabel2, gridBagConstraints13);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnOk(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText(Constant.messages.getString("alert.add.button.save"));
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Alert alert = AlertAddDialog.this.alertViewPanel.getAlert();
                    try {
                        ExtensionAlert extAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
                        if (alert.getAlertId() >= 0) {
                            extAlert.updateAlert(alert);
                        } else {
                            if (AlertAddDialog.this.httpMessage != null) {
                                AlertAddDialog.this.historyRef = new HistoryReference(Model.getSingleton().getSession(), AlertAddDialog.this.historyType, AlertAddDialog.this.httpMessage);
                            }
                            alert.setSource(Alert.Source.MANUAL);
                            extAlert.alertFound(alert, AlertAddDialog.this.historyRef);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                    }
                    AlertAddDialog.this.clearAndCloseDialog();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("alert.add.button.cancel"));
            this.btnCancel.setEnabled(true);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlertAddDialog.this.clearAndCloseDialog();
                }
            });
        }
        return this.btnCancel;
    }

    private void clearAndCloseDialog() {
        this.getAlertViewPanel().clearAlert();
        this.historyRef = null;
        this.httpMessage = null;
        this.dispose();
    }

    private AlertViewPanel getAlertViewPanel() {
        if (this.alertViewPanel == null) {
            this.alertViewPanel = new AlertViewPanel(true);
        }
        return this.alertViewPanel;
    }

    public void setAlert(Alert alert) {
        this.getAlertViewPanel().displayAlert(alert);
        if (alert.getHistoryRef() != null) {
            this.setHistoryRef(alert.getHistoryRef());
        } else {
            this.setHistoryRef(alert.getMessage().getHistoryRef());
        }
        this.setTitle(Constant.messages.getString("alert.edit.title"));
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyRef) {
        this.historyRef = historyRef;
        this.httpMessage = null;
        this.alertViewPanel.setHistoryRef(historyRef);
    }

    public void setHttpMessage(HttpMessage httpMessage, int historyType) {
        this.historyRef = null;
        this.httpMessage = httpMessage;
        this.historyType = historyType;
        this.alertViewPanel.setHttpMessage(httpMessage);
    }
}

