/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.alert;

import com.stackhawk.hste.extension.alert.ExtensionAlert;
import com.stackhawk.hste.view.messagecontainer.http.HttpMessageContainer;
import com.stackhawk.hste.view.popup.PopupMenuItemHistoryReferenceContainer;
import com.stackhawk.hste.view.popup.PopupMenuItemHttpMessageContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class PopupMenuAlert
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuAlert.class);
    private final ExtensionAlert extension;

    public PopupMenuAlert(String label, ExtensionAlert extension) {
        super(label);
        this.extension = extension;
    }

    @Override
    public void performAction(HistoryReference href) {
        PopupMenuItemHttpMessageContainer.Invoker invoker = this.getInvoker();
        if (invoker == PopupMenuItemHttpMessageContainer.Invoker.ACTIVE_SCANNER_PANEL) {
            try {
                this.extension.showAlertAddDialog(href.getHttpMessage(), 3);
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else if (invoker == PopupMenuItemHttpMessageContainer.Invoker.FUZZER_PANEL) {
            try {
                this.extension.showAlertAddDialog(href.getHttpMessage(), 8);
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.extension.showAlertAddDialog(href);
        }
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        switch (invoker) {
            case ALERTS_PANEL: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isButtonEnabledForHistoryReference(HistoryReference href) {
        if (href != null) {
            switch (this.getInvoker()) {
                case ACTIVE_SCANNER_PANEL: 
                case FUZZER_PANEL: {
                    return true;
                }
            }
            return href.getHistoryType() != 0;
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

