/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.alert;

import com.stackhawk.hste.extension.alert.ExtensionAlert;
import com.stackhawk.hste.extension.alert.PopupMenuShowAlert;
import com.stackhawk.hste.view.messagecontainer.http.HttpMessageContainer;
import com.stackhawk.hste.view.popup.ExtensionPopupMenuComponent;
import com.stackhawk.hste.view.popup.PopupMenuHistoryReferenceContainer;
import com.stackhawk.hste.view.popup.PopupMenuHttpMessageContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;

public class PopupMenuShowAlerts
extends PopupMenuHistoryReferenceContainer {
    private static final long serialVersionUID = 1L;
    private final ExtensionAlert extension;

    public PopupMenuShowAlerts(String label, ExtensionAlert extension) {
        super(label);
        this.extension = extension;
        this.setProcessExtensionPopupChildren(false);
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        switch (invoker) {
            case SITES_PANEL: 
            case SPIDER_PANEL: 
            case HISTORY_PANEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isButtonEnabledForHistoryReference(HistoryReference href) {
        List<Alert> alerts = href.getSiteNode() != null ? href.getSiteNode().getAlerts() : href.getAlerts();
        URI hrefURI = href.getURI();
        ArrayList<PopupMenuShowAlert> alertList = new ArrayList<PopupMenuShowAlert>(alerts.size());
        for (Alert alert : alerts) {
            if (hrefURI != null && !alert.getUri().equals(hrefURI.toString())) continue;
            PopupMenuShowAlert menuItem = new PopupMenuShowAlert(alert.getName(), this.extension, alert);
            menuItem.setIcon(alert.getIcon());
            alertList.add(menuItem);
        }
        Collections.sort(alertList);
        for (PopupMenuShowAlert pmsa : alertList) {
            this.add(pmsa);
        }
        return alertList.size() > 0;
    }

    @Override
    public void dismissed(ExtensionPopupMenuComponent selectedMenuComponent) {
        if (this.getMenuComponentCount() > 0) {
            this.removeAll();
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

