/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.anticsrf;

import com.stackhawk.hste.extension.anticsrf.AntiCsrfToken;
import com.stackhawk.hste.extension.anticsrf.ExtensionAntiCSRF;
import com.stackhawk.hste.extension.pscan.PassiveScanTaskHelper;
import com.stackhawk.hste.extension.pscan.PassiveScanner;
import com.stackhawk.hste.extension.pscan.PluginPassiveScanner;
import com.stackhawk.hste.model.SessionStructure;
import com.stackhawk.hste.utils.Stats;
import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.network.HttpMessage;

public class AntiCsrfDetectScanner
implements PassiveScanner {
    public static final String ACSRF_STATS_PREFIX = "stats.acsrf.";
    private final ExtensionAntiCSRF extAntiCSRF;
    private PassiveScanTaskHelper helper;

    public AntiCsrfDetectScanner(ExtensionAntiCSRF extAntiCSRF) {
        this.extAntiCSRF = extAntiCSRF;
    }

    @Override
    public void setTaskHelper(PassiveScanTaskHelper helper) {
        this.helper = helper;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage msg, int id) {
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage msg, int id, Source source) {
        List<AntiCsrfToken> list = this.extAntiCSRF.getTokensFromResponse(msg, source);
        for (AntiCsrfToken token : list) {
            if (this.registerToken(msg.getHistoryRef().getHistoryType())) {
                if (this.helper != null) {
                    this.helper.addHistoryTag(msg.getHistoryRef(), "AntiCSRF");
                }
                this.extAntiCSRF.registerAntiCsrfToken(token);
            }
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), ACSRF_STATS_PREFIX + token.getName());
            }
            catch (URIException uRIException) {}
        }
    }

    @Override
    public String getName() {
        return "Anti CSRF Token Detection";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    private boolean registerToken(int historyType) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(historyType);
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return true;
    }
}

