/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.api;

import com.stackhawk.hste.network.DomainMatcher;
import com.stackhawk.hste.utils.HsteTextField;
import com.stackhawk.hste.view.AbstractFormDialog;
import java.awt.Dialog;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;

class DialogAddPermittedAddress
extends AbstractFormDialog {
    private static final long serialVersionUID = -7356390753317082681L;
    private static final String DIALOG_TITLE = Constant.messages.getString("api.options.addr.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("api.options.addr.add.button.confirm");
    private static final String DOMAIN_FIELD_LABEL = Constant.messages.getString("api.options.addr.field.label.domain");
    private static final String REGEX_FIELD_LABEL = Constant.messages.getString("api.options.addr.field.label.regex");
    private static final String ENABLED_FIELD_LABEL = Constant.messages.getString("api.options.addr.field.label.enabled");
    private static final String TITLE_INVALID_REGEX_DIALOG = Constant.messages.getString("api.options.addr.warning.invalid.regex.title");
    private static final String TEXT_INVALID_REGEX_DIALOG = Constant.messages.getString("api.options.addr.warning.invalid.regex.text");
    private HsteTextField addressTextField;
    private JCheckBox regexCheckBox;
    private JCheckBox enabledCheckBox;
    protected DomainMatcher address;
    private ConfirmButtonValidatorDocListener confirmButtonValidatorDocListener;

    public DialogAddPermittedAddress(Dialog owner) {
        super(owner, DIALOG_TITLE);
    }

    protected DialogAddPermittedAddress(Dialog owner, String title) {
        super(owner, title);
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel fieldsPanel = new JPanel();
        GroupLayout layout = new GroupLayout(fieldsPanel);
        fieldsPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel domainLabel = new JLabel(DOMAIN_FIELD_LABEL);
        JLabel regexLabel = new JLabel(REGEX_FIELD_LABEL);
        JLabel enabledLabel = new JLabel(ENABLED_FIELD_LABEL);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(domainLabel).addComponent(enabledLabel).addComponent(regexLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getAddressTextField()).addComponent(this.getEnabledCheckBox()).addComponent(this.getRegexCheckBox())));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(domainLabel).addComponent(this.getAddressTextField())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(regexLabel).addComponent(this.getRegexCheckBox())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(enabledLabel).addComponent(this.getEnabledCheckBox())));
        return fieldsPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getAddressTextField().setText("");
        this.getRegexCheckBox().setSelected(false);
        this.getEnabledCheckBox().setSelected(true);
        this.address = null;
    }

    @Override
    protected boolean validateFields() {
        if (this.getRegexCheckBox().isSelected()) {
            try {
                DomainMatcher.createPattern(this.getAddressTextField().getText());
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, TEXT_INVALID_REGEX_DIALOG, TITLE_INVALID_REGEX_DIALOG, 1);
                this.getAddressTextField().requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    @Override
    protected void performAction() {
        String value = this.getAddressTextField().getText();
        if (this.getRegexCheckBox().isSelected()) {
            Pattern pattern = DomainMatcher.createPattern(value);
            this.address = new DomainMatcher(pattern);
        } else {
            this.address = new DomainMatcher(value);
        }
        this.address.setEnabled(this.getEnabledCheckBox().isSelected());
    }

    @Override
    protected void clearFields() {
        this.getAddressTextField().setText("");
        this.getAddressTextField().discardAllEdits();
    }

    public DomainMatcher getAddress() {
        return this.address;
    }

    protected HsteTextField getAddressTextField() {
        if (this.addressTextField == null) {
            this.addressTextField = new HsteTextField(25);
            this.addressTextField.getDocument().addDocumentListener(this.getConfirmButtonValidatorDocListener());
        }
        return this.addressTextField;
    }

    protected JCheckBox getRegexCheckBox() {
        if (this.regexCheckBox == null) {
            this.regexCheckBox = new JCheckBox();
        }
        return this.regexCheckBox;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
        }
        return this.enabledCheckBox;
    }

    public void clear() {
        this.address = null;
    }

    private ConfirmButtonValidatorDocListener getConfirmButtonValidatorDocListener() {
        if (this.confirmButtonValidatorDocListener == null) {
            this.confirmButtonValidatorDocListener = new ConfirmButtonValidatorDocListener();
        }
        return this.confirmButtonValidatorDocListener;
    }

    private class ConfirmButtonValidatorDocListener
    implements DocumentListener {
        private ConfirmButtonValidatorDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkAndEnableConfirmButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkAndEnableConfirmButton();
        }

        private void checkAndEnableConfirmButton() {
            boolean enabled = DialogAddPermittedAddress.this.getAddressTextField().getDocument().getLength() > 0;
            DialogAddPermittedAddress.this.setConfirmButtonEnabled(enabled);
        }
    }
}

