/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import com.stackhawk.hste.extension.alert.ExtensionAlert;
import com.stackhawk.hste.extension.ascan.ActiveScan;
import com.stackhawk.hste.extension.ascan.ExtensionActiveScan;
import com.stackhawk.hste.extension.ascan.ScanPolicy;
import com.stackhawk.hste.extension.ascan.filters.ScanFilter;
import com.stackhawk.hste.extension.ruleconfig.ExtensionRuleConfig;
import com.stackhawk.hste.extension.ruleconfig.RuleConfigParam;
import com.stackhawk.hste.extension.script.ScriptCollection;
import com.stackhawk.hste.model.ScanController;
import com.stackhawk.hste.model.Target;
import com.stackhawk.hste.model.TechSet;
import com.stackhawk.hste.users.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.model.Session;

public class ActiveScanController
implements ScanController<ActiveScan> {
    private ExtensionActiveScan extension;
    private static final Logger LOGGER = LogManager.getLogger(ActiveScanController.class);
    private ExtensionAlert extAlert = null;
    private final Lock activeScansLock = new ReentrantLock();
    private int scanIdCounter;
    private Map<Integer, ActiveScan> activeScanMap;
    private List<ActiveScan> activeScanList;

    public ActiveScanController(ExtensionActiveScan extension) {
        this.extension = extension;
        this.activeScanMap = new HashMap<Integer, ActiveScan>();
        this.activeScanList = new ArrayList<ActiveScan>();
    }

    public void setExtAlert(ExtensionAlert extAlert) {
        this.extAlert = extAlert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startScan(String name, Target target, User user, Object[] contextSpecificObjects) {
        this.activeScansLock.lock();
        try {
            int id = this.scanIdCounter++;
            RuleConfigParam ruleConfigParam = null;
            ExtensionRuleConfig extRC = Control.getSingleton().getExtensionLoader().getExtension(ExtensionRuleConfig.class);
            if (extRC != null) {
                ruleConfigParam = extRC.getRuleConfigParam();
            }
            ActiveScan ascan = new ActiveScan(name, this.extension.getScannerParam(), null, ruleConfigParam){

                @Override
                public void alertFound(Alert alert) {
                    alert.setSource(Alert.Source.ACTIVE);
                    if (ActiveScanController.this.extAlert != null) {
                        ActiveScanController.this.extAlert.alertFound(alert, null);
                    }
                    super.alertFound(alert);
                }
            };
            Session session = this.extension.getModel().getSession();
            ArrayList<String> excludeList = new ArrayList<String>();
            excludeList.addAll(this.extension.getExcludeList());
            excludeList.addAll(session.getExcludeFromScanRegexs());
            excludeList.addAll(session.getGlobalExcludeURLRegexs());
            ascan.setExcludeList(excludeList);
            ScanPolicy policy = null;
            ascan.setId(id);
            ascan.setUser(user);
            boolean techOverridden = false;
            if (contextSpecificObjects != null) {
                for (Object obj : contextSpecificObjects) {
                    if (obj instanceof ScannerParam) {
                        LOGGER.debug("Setting custom scanner params");
                        ascan.setScannerParam((ScannerParam)obj);
                        continue;
                    }
                    if (obj instanceof ScanPolicy) {
                        policy = (ScanPolicy)obj;
                        LOGGER.debug("Setting custom policy {}", (Object)policy.getName());
                        ascan.setScanPolicy(policy);
                        continue;
                    }
                    if (obj instanceof TechSet) {
                        ascan.setTechSet((TechSet)obj);
                        techOverridden = true;
                        continue;
                    }
                    if (obj instanceof ScriptCollection) {
                        ascan.addScriptCollection((ScriptCollection)obj);
                        continue;
                    }
                    if (obj instanceof ScanFilter) {
                        ascan.addScanFilter((ScanFilter)obj);
                        continue;
                    }
                    LOGGER.error("Unexpected contextSpecificObject: {}", (Object)obj.getClass().getCanonicalName());
                }
            }
            if (policy == null) {
                policy = this.extension.getPolicyManager().getDefaultScanPolicy();
                LOGGER.debug("Setting default policy {}", (Object)policy.getName());
                ascan.setScanPolicy(policy);
            }
            if (!techOverridden && target.getContext() != null) {
                ascan.setTechSet(target.getContext().getTechSet());
            }
            this.activeScanMap.put(id, ascan);
            this.activeScanList.add(ascan);
            ascan.start(target);
            int n = id;
            return n;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerScan(ActiveScan ascan) {
        this.activeScansLock.lock();
        try {
            int id = this.scanIdCounter++;
            ascan.setScanId(id);
            this.activeScanMap.put(id, ascan);
            this.activeScanList.add(ascan);
            int n = id;
            return n;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    @Override
    public ActiveScan getScan(int id) {
        return this.activeScanMap.get(id);
    }

    @Override
    public ActiveScan getLastScan() {
        this.activeScansLock.lock();
        try {
            if (this.activeScanList.isEmpty()) {
                ActiveScan activeScan = null;
                return activeScan;
            }
            ActiveScan activeScan = this.activeScanList.get(this.activeScanList.size() - 1);
            return activeScan;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActiveScan> getAllScans() {
        ArrayList<ActiveScan> list = new ArrayList<ActiveScan>();
        this.activeScansLock.lock();
        try {
            for (ActiveScan scan : this.activeScanList) {
                list.add(scan);
            }
            ArrayList<ActiveScan> arrayList = list;
            return arrayList;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActiveScan> getActiveScans() {
        ArrayList<ActiveScan> list = new ArrayList<ActiveScan>();
        this.activeScansLock.lock();
        try {
            for (ActiveScan scan : this.activeScanList) {
                if (scan.isStopped()) continue;
                list.add(scan);
            }
            ArrayList<ActiveScan> arrayList = list;
            return arrayList;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveScan removeScan(int id) {
        this.activeScansLock.lock();
        try {
            ActiveScan ascan = this.activeScanMap.get(id);
            if (!this.activeScanMap.containsKey(id)) {
                ActiveScan activeScan = null;
                return activeScan;
            }
            ascan.stopScan();
            this.activeScanMap.remove(id);
            this.activeScanList.remove(ascan);
            ActiveScan activeScan = ascan;
            return activeScan;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    public int getTotalNumberScans() {
        return this.activeScanMap.size();
    }

    @Override
    public void stopAllScans() {
        this.activeScansLock.lock();
        try {
            for (ActiveScan scan : this.activeScanMap.values()) {
                scan.stopScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    @Override
    public void pauseAllScans() {
        this.activeScansLock.lock();
        try {
            for (ActiveScan scan : this.activeScanMap.values()) {
                scan.pauseScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    @Override
    public void resumeAllScans() {
        this.activeScansLock.lock();
        try {
            for (ActiveScan scan : this.activeScanMap.values()) {
                scan.resumeScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllScans() {
        this.activeScansLock.lock();
        try {
            int count = 0;
            Iterator<ActiveScan> it = this.activeScanMap.values().iterator();
            while (it.hasNext()) {
                ActiveScan ascan = it.next();
                ascan.stopScan();
                it.remove();
                this.activeScanList.remove(ascan);
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeFinishedScans() {
        this.activeScansLock.lock();
        try {
            int count = 0;
            Iterator<ActiveScan> it = this.activeScanMap.values().iterator();
            while (it.hasNext()) {
                ActiveScan ascan = it.next();
                if (!ascan.isStopped()) continue;
                ascan.stopScan();
                it.remove();
                this.activeScanList.remove(ascan);
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    @Override
    public void stopScan(int id) {
        this.activeScansLock.lock();
        try {
            if (this.activeScanMap.containsKey(id)) {
                this.activeScanMap.get(id).stopScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    @Override
    public void pauseScan(int id) {
        this.activeScansLock.lock();
        try {
            if (this.activeScanMap.containsKey(id)) {
                this.activeScanMap.get(id).pauseScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    @Override
    public void resumeScan(int id) {
        this.activeScansLock.lock();
        try {
            if (this.activeScanMap.containsKey(id)) {
                this.activeScanMap.get(id).resumeScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    public void reset() {
        this.removeAllScans();
        this.activeScansLock.lock();
        try {
            this.scanIdCounter = 0;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }
}

