/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.hste.extension.ascan;

import com.stackhawk.hste.view.StatusUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.view.View;

public class CategoryTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private Map<String, String> i18nToStr = null;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.policy.table.testname"), Constant.messages.getString("ascan.policy.table.threshold"), Constant.messages.getString("ascan.policy.table.strength"), Constant.messages.getString("ascan.policy.table.status")};
    private static final int STATUS_COLUMN_IDX = 3;
    private List<PluginWrapper> listTestCategory;
    private PluginFactory pluginFactory;
    private int category;
    private Plugin.AlertThreshold defaultThreshold;

    public void setTable(int category, PluginFactory pluginFactory, Plugin.AlertThreshold defaultThreshold) {
        this.listTestCategory.clear();
        this.pluginFactory = pluginFactory;
        this.category = category;
        this.defaultThreshold = defaultThreshold;
        for (Plugin test : pluginFactory.getAllPlugin()) {
            if (test.getCategory() != category) continue;
            this.listTestCategory.add(new PluginWrapper(test, View.getSingleton().getStatusUI(test.getStatus())));
        }
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 3) {
            return StatusUI.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Plugin test = this.listTestCategory.get(row).getPlugin();
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                boolean enable;
                Plugin.AlertThreshold af = Plugin.AlertThreshold.valueOf(this.i18nToStr((String)value));
                boolean bl = enable = !Plugin.AlertThreshold.OFF.equals((Object)af);
                if (test.isEnabled() != enable) {
                    if (enable) {
                        String[] dependencies = test.getDependency();
                        if (dependencies != null && dependencies.length != 0) {
                            ArrayList<Plugin> allDeps = new ArrayList<Plugin>(dependencies.length);
                            if (!this.pluginFactory.addAllDependencies(test, allDeps)) {
                                View.getSingleton().showWarningDialog(Constant.messages.getString("ascan.policy.unfulfilled.dependencies"));
                                return;
                            }
                            ArrayList<Plugin> disabledDependencies = new ArrayList<Plugin>();
                            for (Plugin plugin : allDeps) {
                                if (plugin.isEnabled()) continue;
                                disabledDependencies.add(plugin);
                            }
                            if (!disabledDependencies.isEmpty()) {
                                this.setPluginsEnabled(disabledDependencies, true);
                            }
                        }
                    } else {
                        ArrayList<Plugin> enabledDependents = new ArrayList<Plugin>();
                        for (Plugin plugin : this.pluginFactory.getDependentPlugins(test)) {
                            if (!plugin.isEnabled()) continue;
                            enabledDependents.add(plugin);
                        }
                        if (!enabledDependents.isEmpty()) {
                            this.setPluginsEnabled(enabledDependents, false);
                        }
                    }
                }
                test.setAlertThreshold(af);
                test.setEnabled(enable);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 2: {
                test.setAttackStrength(Plugin.AttackStrength.valueOf(this.i18nToStr((String)value)));
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    private void setPluginsEnabled(List<Plugin> plugins, boolean enabled) {
        Plugin.AlertThreshold alertThreshold = enabled ? this.defaultThreshold : Plugin.AlertThreshold.OFF;
        for (Plugin plugin : plugins) {
            int rowDep;
            plugin.setEnabled(enabled);
            plugin.setAlertThreshold(alertThreshold);
            if (plugin.getCategory() != this.category || (rowDep = this.getPluginRow(plugin)) == -1) continue;
            this.fireTableCellUpdated(rowDep, 1);
        }
    }

    private int getPluginRow(Plugin plugin) {
        for (int i = 0; i < this.listTestCategory.size(); ++i) {
            if (!plugin.equals(this.listTestCategory.get(i).getPlugin())) continue;
            return i;
        }
        return -1;
    }

    private String strToI18n(String str) {
        return Constant.messages.getString("ascan.policy.level." + str.toLowerCase(Locale.ROOT));
    }

    private String i18nToStr(String str) {
        if (this.i18nToStr == null) {
            this.i18nToStr = new HashMap<String, String>();
            for (Plugin.AlertThreshold alertThreshold : Plugin.AlertThreshold.values()) {
                this.i18nToStr.put(this.strToI18n(alertThreshold.name()), alertThreshold.name());
            }
            for (Enum enum_ : Plugin.AttackStrength.values()) {
                this.i18nToStr.put(this.strToI18n(enum_.name()), enum_.name());
            }
        }
        return this.i18nToStr.get(str);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.getTestList().size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        PluginWrapper wrapper = this.listTestCategory.get(row);
        switch (col) {
            case 0: {
                return wrapper.getPlugin().getDisplayName();
            }
            case 1: {
                if (!wrapper.getPlugin().isEnabled()) {
                    return Plugin.AlertThreshold.OFF;
                }
                return this.strToI18n(wrapper.getPlugin().getAlertThreshold(true).name());
            }
            case 2: {
                return this.strToI18n(wrapper.getPlugin().getAttackStrength(true).name());
            }
            case 3: {
                return wrapper.getStatus();
            }
        }
        return "";
    }

    private List<PluginWrapper> getTestList() {
        if (this.listTestCategory == null) {
            this.listTestCategory = new ArrayList<PluginWrapper>();
        }
        return this.listTestCategory;
    }

    private static class PluginWrapper {
        private final Plugin plugin;
        private final StatusUI status;

        public PluginWrapper(Plugin plugin, StatusUI status) {
            this.plugin = plugin;
            this.status = status;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public StatusUI getStatus() {
            return this.status;
        }
    }
}

